/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.JCheckBoxJList;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ViewPropertiesPane
extends JPanePlugin {
    private static final long serialVersionUID = 2554693130978453347L;
    private DefaultListModel defaultListModel = new DefaultListModel();
    private JLabel permissionCountLabel = null;
    private JCheckBoxJList permissionsJList = null;
    private Account account;
    private Permission permission = new Permission();
    private JScrollPane permissionsScrollPane = null;
    private JPanel buttonPane = null;
    private JButton closeButton = null;

    public ViewPropertiesPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(396, 208));
        this.add((Component)this.getPermissionsScrollPane(), "Center");
        this.add((Component)this.getButtonPane(), "South");
    }

    public String getPluginTitle() {
        return "View Properties Pane";
    }

    private JList getPermissionsJList() {
        if (this.permissionsJList == null) {
            this.permissionsJList = new JCheckBoxJList();
            this.permissionsJList.setModel(this.defaultListModel);
            this.permissionsJList.addPropertyChangeListener("change", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ViewPropertiesPane.this.showPermissionCount(ViewPropertiesPane.this.permissionsJList.getSelectedIndices().length + " permissions selected");
                }
            });
        }
        return this.permissionsJList;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.account = inContest.getAccount(inContest.getClientId());
        this.populatePermissions(this.account);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setTitle("Permissions/Abilities for " + inContest.getClientId());
        }
    }

    private void populatePermissions(Account inAccount) {
        this.defaultListModel.removeAllElements();
        if (inAccount == null) {
            for (String name : this.getPermissionDescriptions()) {
                JCheckBox checkBox = new JCheckBox(name);
                this.defaultListModel.addElement(checkBox);
            }
            this.getPermissionsJList().setSelectedIndex(-1);
        } else {
            int count = 0;
            for (Permission.Type type : Permission.Type.values()) {
                if (!this.account.isAllowed(type)) continue;
                ++count;
            }
            if (count > 0) {
                int[] indexes = new int[count];
                count = 0;
                int idx = 0;
                for (Permission.Type type : Permission.Type.values()) {
                    JCheckBox checkBox = new JCheckBox(this.permission.getDescription(type));
                    this.defaultListModel.addElement(checkBox);
                    if (this.account.isAllowed(type)) {
                        indexes[count] = idx;
                        ++count;
                    }
                    ++idx;
                }
                this.getPermissionsJList().setSelectedIndices(indexes);
                this.getPermissionsJList().ensureIndexIsVisible(0);
            } else {
                for (Permission.Type type : Permission.Type.values()) {
                    JCheckBox checkBox = new JCheckBox(this.permission.getDescription(type));
                    this.defaultListModel.addElement(checkBox);
                }
            }
        }
        this.showPermissionCount(this.getPermissionsJList().getSelectedIndices().length + " permissions selected");
    }

    private String[] getPermissionDescriptions() {
        Object[] permissionListNames = new String[Permission.Type.values().length];
        int i = 0;
        for (Permission.Type type : Permission.Type.values()) {
            permissionListNames[i] = this.permission.getDescription(type);
            ++i;
        }
        Arrays.sort(permissionListNames);
        return permissionListNames;
    }

    public void showPermissionCount(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ViewPropertiesPane.this.permissionCountLabel.setText(message);
            }
        });
    }

    private JScrollPane getPermissionsScrollPane() {
        if (this.permissionsScrollPane == null) {
            this.permissionsScrollPane = new JScrollPane();
            this.permissionsScrollPane.setViewportView(this.getPermissionsJList());
        }
        return this.permissionsScrollPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new FlowLayout());
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewPropertiesPane.this.closeWindow();
                }
            });
        }
        return this.closeButton;
    }

    protected void closeWindow() {
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }
}

