/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import edu.csus.ecs.pc2.ui.ViewJudgementsPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ViewJudgementsFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 3591229492456973289L;
    private IInternalContest contest;
    private IInternalController controller;
    private Run run = null;
    private JPanel mainPanel = null;
    private JPanel buttonPanel = null;
    private ViewJudgementsPane viewJudgementsPane = null;
    private JButton closeButton = null;

    public ViewJudgementsFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(700, 329));
        this.setContentPane(this.getMainPanel());
        this.setDefaultCloseOperation(0);
        this.setTitle("Run Judgements");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ViewJudgementsFrame.this.dispose();
            }
        });
        FrameUtilities.centerFrame(this);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.viewJudgementsPane.setContestAndController(this.contest, this.controller);
        this.contest.addRunListener(new RunListenerImplementation());
    }

    public void setRun(Run theRun) {
        if (theRun == null) {
            this.setTitle("View Run Judgments");
        } else {
            this.setTitle("Run Judgements for " + theRun.getNumber() + " (Site " + theRun.getSiteNumber() + ")");
            this.run = theRun;
        }
        this.viewJudgementsPane.setRun(theRun);
    }

    public String getPluginTitle() {
        return "Edit Run Frame";
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getViewJudgementsPane(), "Center");
            this.mainPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.mainPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setPreferredSize(new Dimension(35, 35));
            this.buttonPanel.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPanel;
    }

    private ViewJudgementsPane getViewJudgementsPane() {
        if (this.viewJudgementsPane == null) {
            this.viewJudgementsPane = new ViewJudgementsPane();
        }
        return this.viewJudgementsPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setMnemonic(67);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewJudgementsFrame.this.dispose();
                }
            });
        }
        return this.closeButton;
    }

    public class RunListenerImplementation
    implements IRunListener {
        public void runAdded(RunEvent event) {
        }

        public void refreshRuns(RunEvent event) {
        }

        public void runChanged(RunEvent event) {
            if (ViewJudgementsFrame.this.run != null && event.getRun().getElementId().equals(ViewJudgementsFrame.this.run.getElementId())) {
                ViewJudgementsFrame.this.viewJudgementsPane.setRun(event.getRun());
            }
        }

        public void runRemoved(RunEvent event) {
        }
    }
}

