/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.ProfileChangeStatusList;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IMessageListener;
import edu.csus.ecs.pc2.core.model.IProfileListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.MessageEvent;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileChangeStatus;
import edu.csus.ecs.pc2.core.model.ProfileEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.ui.AccountColumnComparator;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SwitchProfileStatusPane
extends JPanePlugin {
    private static final long serialVersionUID = -1443775801105676210L;
    private JPanel buttonPanel = null;
    private MCLB siteListBox = null;
    private ProfileChangeStatusList profileStatusList = new ProfileChangeStatusList();
    private JButton switchNowButton = null;
    private JButton refreshButton = null;
    private JButton cancelButton = null;
    private Profile targetProfile;
    private String newContestPassword;
    private String currentContestPassword;
    private SimpleDateFormat formatter = new SimpleDateFormat(" HH:mm:ss MM-dd");

    public SwitchProfileStatusPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(433, 206));
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)((Object)this.getSiteListBox()), "Center");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.resetProfileStatusList();
        this.currentContestPassword = inContest.getContestPassword();
        this.updateCurrentSiteStatus();
        this.getContest().addSiteListener(new SiteListenerImplementation());
        this.getContest().addLoginListener(new LoginListenerImplementation());
        this.getContest().addMessageListener(new MessageListenerImplementation());
        this.getContest().addProfileListener(new ProfileListenerImplementation());
    }

    private void reloadListBox() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProfileChangeStatus[] list;
                SwitchProfileStatusPane.this.siteListBox.removeAllRows();
                for (ProfileChangeStatus status : list = SwitchProfileStatusPane.this.profileStatusList.getList()) {
                    SwitchProfileStatusPane.this.updateRow(status);
                }
            }
        });
    }

    public void updateRow(ProfileChangeStatus status) {
        this.updateStatusRow(status);
    }

    private void updateStatusRow(ProfileChangeStatus status) {
        Integer key = new Integer(status.getSiteNumber());
        int row = this.siteListBox.getIndexByKey(key);
        if (row == -1) {
            Object[] objects = this.buildSiteStatusRow(status);
            this.siteListBox.addRow(objects, key);
        } else {
            Object[] objects = this.buildSiteStatusRow(status);
            this.siteListBox.replaceRow(objects, row);
        }
        this.siteListBox.autoSizeAllColumns();
        this.siteListBox.sort();
        this.enableGoButton();
    }

    public String getPluginTitle() {
        return "Switch Profile Status Pane";
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getSwitchNowButton(), null);
            this.buttonPanel.add((Component)this.getRefreshButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private void enableGoButton() {
        int numberReady = 0;
        int numberConnected = 0;
        for (ProfileChangeStatus status : this.profileStatusList.getList()) {
            if (!this.isLocalLoggedIn(status.getSiteNumber()) && !this.isThisSite(status.getSiteNumber())) continue;
            ++numberConnected;
            if (!status.getStatus().equals((Object)ProfileChangeStatus.Status.READY_TO_SWITCH)) continue;
            ++numberReady;
        }
        this.getSwitchNowButton().setEnabled(numberReady == numberConnected);
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.getContest().getSiteNumber();
    }

    private MCLB getSiteListBox() {
        if (this.siteListBox == null) {
            this.siteListBox = new MCLB();
            Object[] cols = new Object[]{"Site", "Title", "Status", "Changed", "Profile", "Logged In", "Since"};
            this.siteListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            HeapSorter accountNameSorter = new HeapSorter();
            accountNameSorter.setComparator((Comparator)new AccountColumnComparator());
            int idx = 0;
            this.siteListBox.setColumnSorter(idx++, numericStringSorter, 1);
            this.siteListBox.setColumnSorter(idx++, accountNameSorter, 2);
            this.siteListBox.setColumnSorter(idx++, sorter, 3);
            this.siteListBox.setColumnSorter(idx++, sorter, 4);
            this.siteListBox.setColumnSorter(idx++, sorter, 5);
            this.siteListBox.setColumnSorter(idx++, sorter, 6);
            this.siteListBox.setColumnSorter(idx++, sorter, 7);
            this.siteListBox.setMultipleSelections(true);
        }
        return this.siteListBox;
    }

    private JButton getSwitchNowButton() {
        if (this.switchNowButton == null) {
            this.switchNowButton = new JButton();
            this.switchNowButton.setText("Complete");
            this.switchNowButton.setMnemonic(84);
            this.switchNowButton.setToolTipText("Complete last step for switch, sync submissions");
            this.switchNowButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwitchProfileStatusPane.this.startProfileServerSync();
                }
            });
        }
        return this.switchNowButton;
    }

    protected void closeWindow() {
        this.getParentFrame().setVisible(false);
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setText("Refresh");
            this.refreshButton.setMnemonic(82);
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwitchProfileStatusPane.this.requestStatusFromSelectedSite();
                }
            });
        }
        return this.refreshButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwitchProfileStatusPane.this.revertToPreviousProfile();
                }
            });
        }
        return this.cancelButton;
    }

    private Object[] buildSiteStatusRow(ProfileChangeStatus status) {
        Object[] obj = new Object[this.siteListBox.getColumnCount()];
        Site site = status.getSite();
        obj[0] = site.getSiteNumber();
        obj[1] = site.getDisplayName();
        JLabel label = new JLabel(status.getStatus().toString());
        Color newColor = Color.RED;
        switch (status.getStatus()) {
            case SWITCHED: {
                newColor = Color.GREEN;
                break;
            }
            case READY_TO_SWITCH: {
                newColor = Color.GREEN;
                break;
            }
            default: {
                newColor = Color.RED;
            }
        }
        label.setForeground(newColor);
        obj[2] = label;
        Date date = status.getModifiedDate();
        obj[3] = date == null ? "" : this.formatter.format(date);
        Profile theProfile = status.getProfile();
        obj[4] = theProfile != null ? theProfile.getName() + " (" + theProfile.getDescription() + ")" : "";
        try {
            ClientId serverId = new ClientId(site.getSiteNumber(), ClientType.Type.SERVER, 0);
            if (this.isThisSite(site.getSiteNumber())) {
                obj[5] = "N/A";
                obj[6] = "";
            } else if (this.getContest().isLocalLoggedIn(serverId)) {
                obj[5] = "YES";
                obj[6] = this.formatter.format(this.getContest().getLocalLoggedInDate(serverId));
            } else if (this.getContest().isRemoteLoggedIn(serverId)) {
                obj[5] = "YES";
                obj[6] = "";
            }
        }
        catch (Exception e) {
            obj[5] = "??";
            obj[6] = "";
            this.getController().getLog().log(Log.WARNING, "Exception updating Contest Time for site " + site.getSiteNumber(), e);
        }
        return obj;
    }

    public void setProfile(Profile profile) {
        this.targetProfile = profile;
    }

    public void setNewContestPassword(String newContestPassword) {
        this.newContestPassword = newContestPassword;
    }

    public void setCurrentContestPassword(String currentContestPassword) {
        this.currentContestPassword = currentContestPassword;
    }

    protected void startProfileServerSync() {
        this.getController().syncProfileSubmissions(this.targetProfile);
        this.closeWindow();
    }

    protected void revertToPreviousProfile() {
        JOptionPane.showMessageDialog(this, "debug 22 Would have reverted to profile '" + this.getContest().getProfile().getName() + "' with contest pass = '" + this.currentContestPassword + "'");
        this.closeWindow();
    }

    protected void requestStatusFromSelectedSite() {
        int[] selectedSites = this.siteListBox.getSelectedIndexes();
        if (selectedSites.length == 0) {
            JOptionPane.showMessageDialog(this, "Select a site", "Must select a site to request", 1);
            return;
        }
        if (selectedSites.length == 1) {
            Integer siteNumber = (Integer)this.siteListBox.getKeys()[selectedSites[0]];
            if (this.isThisSite(siteNumber)) {
                this.updateCurrentSiteStatus();
                this.updateStatusRow(siteNumber);
                return;
            }
            if (!this.isLocalLoggedIn(siteNumber)) {
                JOptionPane.showMessageDialog(this, "Site " + siteNumber + " not available/logged in", "Can not refresh", 1);
                return;
            }
        }
        for (int i : selectedSites) {
            Integer siteNumber = (Integer)this.siteListBox.getKeys()[i];
            if (this.isThisSite(siteNumber)) {
                this.updateCurrentSiteStatus();
                this.updateStatusRow(siteNumber);
                continue;
            }
            try {
                ClientId remoteServerId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
                Packet packet = PacketFactory.createRequestServerStatusPacket(this.getContest().getClientId(), remoteServerId, this.targetProfile);
                this.getController().sendToLocalServer(packet);
            }
            catch (Exception e) {
                this.getController().getLog().log(Level.WARNING, "Unable to send request status packet to server " + i, e);
            }
        }
    }

    private boolean isLocalLoggedIn(int siteNumber) {
        ClientId serverId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
        return this.getContest().isLocalLoggedIn(serverId);
    }

    private void updateStatusRow(int siteNumber) {
        Site currentSite = this.getContest().getSite(this.getContest().getSiteNumber());
        if (currentSite != null) {
            ProfileChangeStatus profileStatus = this.profileStatusList.get(currentSite);
            this.updateStatusRow(profileStatus);
        }
    }

    private void updateCurrentSiteStatus() {
        Site currentSite = this.getContest().getSite(this.getContest().getSiteNumber());
        if (currentSite != null) {
            ProfileChangeStatus profileStatus = this.profileStatusList.get(currentSite);
            profileStatus.setStatus(ProfileChangeStatus.Status.NOTREADY);
            if (this.getContest().getProfile().equals(this.targetProfile)) {
                profileStatus.setStatus(ProfileChangeStatus.Status.READY_TO_SWITCH);
            }
            profileStatus.setProfile(this.getContest().getProfile());
        }
    }

    public void resetProfileStatusList() {
        this.profileStatusList = new ProfileChangeStatusList();
        for (Site site : this.getContest().getSites()) {
            ProfileChangeStatus status = new ProfileChangeStatus(site);
            if (this.isLocalLoggedIn(site.getSiteNumber())) {
                status.setStatus(ProfileChangeStatus.Status.NOTREADY);
            }
            this.profileStatusList.add(status);
        }
        this.updateCurrentSiteStatus();
        this.reloadListBox();
    }

    protected class ProfileListenerImplementation
    implements IProfileListener {
        protected ProfileListenerImplementation() {
        }

        public void profileAdded(ProfileEvent event) {
        }

        public void profileChanged(ProfileEvent event) {
            SwitchProfileStatusPane.this.reloadListBox();
        }

        public void profileRemoved(ProfileEvent event) {
        }

        public void profileRefreshAll(ProfileEvent profileEvent) {
            SwitchProfileStatusPane.this.updateCurrentSiteStatus();
        }
    }

    class MessageListenerImplementation
    implements IMessageListener {
        MessageListenerImplementation() {
        }

        public void messageAdded(MessageEvent event) {
            String message;
            if (event.getArea().equals((Object)MessageEvent.Area.PROFILES) && (message = event.getMessage()).toLowerCase().indexOf("contest password") > -1) {
                JOptionPane.showMessageDialog(null, message, "Switch Profile Message for Site " + SwitchProfileStatusPane.this.getContest().getSiteNumber(), 1);
            }
            SwitchProfileStatusPane.this.getController().getLog().warning(event.getMessage());
        }

        public void messageRemoved(MessageEvent event) {
        }
    }

    public class LoginListenerImplementation
    implements ILoginListener {
        public void loginAdded(LoginEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwitchProfileStatusPane.this.reloadListBox();
                }
            });
        }

        public void loginRemoved(LoginEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwitchProfileStatusPane.this.reloadListBox();
                }
            });
        }

        public void loginDenied(LoginEvent event) {
        }

        public void loginRefreshAll(LoginEvent event) {
        }
    }

    protected class SiteListenerImplementation
    implements ISiteListener {
        protected SiteListenerImplementation() {
        }

        public void siteProfileStatusChanged(SiteEvent event) {
            ProfileChangeStatus profileChangeStatus = SwitchProfileStatusPane.this.profileStatusList.get(event.getSite());
            profileChangeStatus.setStatus(event.getProfileStatus());
            profileChangeStatus.setProfile(event.getProfile());
            SwitchProfileStatusPane.this.profileStatusList.update(profileChangeStatus);
            final ProfileChangeStatus status = profileChangeStatus;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwitchProfileStatusPane.this.updateRow(status);
                    SwitchProfileStatusPane.this.enableGoButton();
                }
            });
        }

        public void siteAdded(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwitchProfileStatusPane.this.reloadListBox();
                }
            });
        }

        public void siteRemoved(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwitchProfileStatusPane.this.reloadListBox();
                }
            });
        }

        public void siteChanged(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwitchProfileStatusPane.this.reloadListBox();
                }
            });
        }

        public void siteLoggedOn(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwitchProfileStatusPane.this.reloadListBox();
                }
            });
        }

        public void siteLoggedOff(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwitchProfileStatusPane.this.reloadListBox();
                }
            });
        }

        public void sitesRefreshAll(SiteEvent siteEvent) {
        }
    }
}

