/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.Executable;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILanguageListener;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageEvent;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IFileViewer;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SubmitRunPane
extends JPanePlugin {
    private static final long serialVersionUID = 5700304771581849261L;
    private String lastOpenedFile = null;
    private JPanel mainViewPane = null;
    private JButton submitRunButton = null;
    private JComboBox problemComboBox = null;
    private JComboBox languageComboBox = null;
    private JButton pickFileButton = null;
    private JPanel filenamePane = null;
    private JLabel fileNameLabel = null;
    private Log log = null;
    private JPanel problemPane = null;
    private JPanel languagePane = null;
    private JButton testButton = null;
    private Executable executable = null;
    private PermissionList permissionList = new PermissionList();
    private JPanel additionalFilesPane = null;
    private JPanel additonalFilesButtonPane = null;
    private JButton addAdditionalFilesButton = null;
    private JButton removeAdditionalFilesButton = null;
    private MCLB additionalFilesMCLB = null;

    public SubmitRunPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(486, 410));
        this.add((Component)this.getMainViewPane(), "Center");
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    private void reloadProblems() {
        this.getProblemComboBox().removeAllItems();
        Problem problemN = new Problem("Select Problem");
        this.getProblemComboBox().addItem(problemN);
        for (Problem problem : this.getContest().getProblems()) {
            if (!problem.isActive()) continue;
            this.getProblemComboBox().addItem(problem);
        }
    }

    private void reloadLanguages() {
        this.getLanguageComboBox().removeAllItems();
        Language languageN = new Language("Select Language");
        this.getLanguageComboBox().addItem(languageN);
        for (Language language : this.getContest().getLanguages()) {
            if (!language.isActive()) continue;
            this.getLanguageComboBox().addItem(language);
        }
    }

    private void populateGUI() {
        this.reloadProblems();
        this.reloadLanguages();
        this.setButtonsActive(this.getContest().getContestTime().isContestRunning());
        if (!this.isTeam()) {
            this.setButtonsActive(true);
        }
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.getContest().getSiteNumber();
    }

    protected boolean isTeam(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.TEAM);
    }

    protected boolean isTeam() {
        return this.isTeam(this.getContest().getClientId());
    }

    private void setButtonsActive(final boolean turnButtonsOn) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SubmitRunPane.this.isTeam()) {
                    SubmitRunPane.this.getSubmitRunButton().setEnabled(turnButtonsOn);
                    SubmitRunPane.this.getPickFileButton().setEnabled(turnButtonsOn);
                    SubmitRunPane.this.getTestButton().setEnabled(turnButtonsOn);
                    SubmitRunPane.this.getAddAdditionalFilesButton().setEnabled(turnButtonsOn);
                    SubmitRunPane.this.getRemoveAdditionalFilesButton().setEnabled(turnButtonsOn);
                }
            }
        });
        FrameUtilities.regularCursor(this);
    }

    protected void autoPopulate() {
        String filename;
        String matchProblemString = "umit";
        for (int i = 0; i < this.problemComboBox.getItemCount(); ++i) {
            Problem problem = (Problem)this.problemComboBox.getItemAt(i);
            int idx = problem.toString().indexOf(matchProblemString);
            if (idx <= -1) continue;
            this.problemComboBox.setSelectedIndex(i);
        }
        String matchLanguageString = "Java";
        for (int i = 0; i < this.languageComboBox.getItemCount(); ++i) {
            Language language = (Language)this.languageComboBox.getItemAt(i);
            int idx = language.toString().indexOf(matchLanguageString);
            if (idx <= -1) continue;
            this.languageComboBox.setSelectedIndex(i);
        }
        try {
            filename = "Sumit.java";
            File file = new File(filename);
            if (file.exists()) {
                this.fileNameLabel.setText(filename);
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
        }
        try {
            filename = "samps/Sumit.java";
            File file = new File(filename);
            if (file.exists()) {
                this.fileNameLabel.setText(filename);
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
        }
        try {
            filename = "/pc2/samps/sumit.java";
            File file = new File(filename);
            if (file.exists()) {
                this.fileNameLabel.setText(filename);
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
        }
        try {
            filename = "/usr/pc2/samps/sumit.java";
            File file = new File(filename);
            if (file.exists()) {
                this.fileNameLabel.setText(filename);
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
        }
    }

    private JPanel getMainViewPane() {
        if (this.mainViewPane == null) {
            this.mainViewPane = new JPanel();
            this.mainViewPane.setLayout(null);
            this.mainViewPane.add((Component)this.getFilenamePane(), null);
            this.mainViewPane.add((Component)this.getSubmitRunButton(), null);
            this.mainViewPane.add((Component)this.getProblemPane(), null);
            this.mainViewPane.add((Component)this.getLanguagePane(), null);
            this.mainViewPane.add((Component)this.getTestButton(), null);
            this.mainViewPane.add((Component)this.getAdditionalFilesPane(), null);
        }
        return this.mainViewPane;
    }

    private JButton getSubmitRunButton() {
        if (this.submitRunButton == null) {
            this.submitRunButton = new JButton();
            this.submitRunButton.setEnabled(true);
            this.submitRunButton.setLocation(new Point(356, 350));
            this.submitRunButton.setSize(new Dimension(100, 26));
            this.submitRunButton.setPreferredSize(new Dimension(100, 26));
            this.submitRunButton.setMnemonic(83);
            this.submitRunButton.setToolTipText("Submit run to judges");
            this.submitRunButton.setText("Submit");
            this.submitRunButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SubmitRunPane.this.testOrSubmitRun(true);
                }
            });
        }
        return this.submitRunButton;
    }

    private boolean fileExists(String fileName) {
        File file = new File(fileName);
        return file.isFile();
    }

    protected void testOrSubmitRun(boolean submitTheRun) {
        Problem problem = (Problem)this.getProblemComboBox().getSelectedItem();
        Language language = (Language)this.getLanguageComboBox().getSelectedItem();
        SerializedFile[] otherFiles = null;
        if (this.getProblemComboBox().getSelectedIndex() < 1) {
            this.showMessage("Please select problem");
            return;
        }
        if (this.getLanguageComboBox().getSelectedIndex() < 1) {
            this.showMessage("Please select language");
            return;
        }
        String filename = this.fileNameLabel.getText();
        if (this.fileNameLabel.getText().equals("")) {
            this.showMessage("Please select a Main file");
            return;
        }
        if (!this.fileExists(filename)) {
            File curdir = new File(".");
            String message = filename + " not found";
            try {
                message = message + " in " + curdir.getCanonicalPath();
            }
            catch (Exception e) {
                message = message + "";
            }
            this.showMessage(message);
            return;
        }
        if (this.additionalFilesMCLB.getRowCount() > 0) {
            try {
                otherFiles = this.getAdditionalSerializedFiles();
            }
            catch (Exception e) {
                this.showMessage(e.getMessage());
                this.log.log(Log.WARNING, "Exception logged ", e);
            }
        }
        if (submitTheRun) {
            try {
                String confirmQuestion = "<HTML><FONT SIZE=+1>Do you wish to submit run for<BR><BR>Problem:  <FONT COLOR=BLUE>" + Utilities.forHTML(problem.toString()) + "</FONT><BR><BR>" + "Language:  <FONT COLOR=BLUE>" + Utilities.forHTML(language.toString()) + "</FONT><BR><BR>" + "File: <FONT COLOR=BLUE>" + Utilities.forHTML(filename) + "</FONT><BR><BR></FONT>";
                int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), confirmQuestion, "Confirm Submission");
                if (result == 0) {
                    this.log.info("submitRun for " + problem + " " + language + " file: " + filename);
                    this.getController().submitRun(problem, language, filename, otherFiles);
                }
            }
            catch (Exception e) {
                this.showMessage("Exception " + e.getMessage());
            }
        } else {
            this.testRun(problem, language, filename, otherFiles);
        }
    }

    private SerializedFile[] getAdditionalSerializedFiles() throws Exception {
        SerializedFile[] files = new SerializedFile[this.additionalFilesMCLB.getRowCount()];
        for (int i = 0; i < this.additionalFilesMCLB.getRowCount(); ++i) {
            String filename = (String)this.additionalFilesMCLB.getRow(i)[0];
            SerializedFile file = new SerializedFile(filename);
            if (file.getBuffer() == null) {
                throw new Exception("Could not find/read file: " + filename);
            }
            files[i] = file;
        }
        return files;
    }

    private void testRun(Problem problem, Language language, String filename, SerializedFile[] additionalFiles) {
        String dataFileName = problem.getDataFileName();
        String message = "";
        boolean needsData = false;
        if (dataFileName != null && dataFileName.trim().length() > 0 && !problem.isReadInputDataFromSTDIN()) {
            File sourceFile = new File(filename);
            File dataFile = new File(sourceFile.getParent() + File.separator + dataFileName);
            if (dataFile.exists()) {
                if (dataFile.isFile()) {
                    if (!dataFile.canRead()) {
                        message = "Cannot read file.";
                        needsData = true;
                    }
                } else {
                    message = "Is not a file";
                    needsData = true;
                }
            } else {
                message = "Cannot find file in " + sourceFile.getParent();
                needsData = true;
            }
            if (needsData) {
                JOptionPane.showMessageDialog(this.getParent(), "Problem with data file: " + dataFileName + "\n\n" + message, "Problem with data file", 0);
                return;
            }
        }
        this.setButtonsActive(false);
        try {
            IFileViewer fileViewer;
            this.log.info("test run for " + problem + " " + language + " file: " + filename);
            Run run = new Run(this.getContest().getClientId(), language, problem);
            RunFiles runFiles = new RunFiles(run, new SerializedFile(filename), additionalFiles);
            this.executable = new Executable(this.getContest(), this.getController(), run, runFiles);
            if (!this.isTeam()) {
                this.executable.setExecuteDirectoryNameSuffix("SR");
            }
            this.executable.setTestRunOnly(true);
            final IFileViewer finalViewer = fileViewer = this.executable.execute();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    finalViewer.setTitle("Test Program Output");
                    finalViewer.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.log.log(Log.SEVERE, "Exception during test run ", e);
        }
        this.setButtonsActive(true);
    }

    private JComboBox getProblemComboBox() {
        if (this.problemComboBox == null) {
            this.problemComboBox = new JComboBox();
            this.problemComboBox.setBounds(new Rectangle(38, 42, 221, 28));
            this.problemComboBox.addItem(new Problem("Select Problem"));
        }
        return this.problemComboBox;
    }

    private JComboBox getLanguageComboBox() {
        if (this.languageComboBox == null) {
            this.languageComboBox = new JComboBox();
            this.languageComboBox.setBounds(new Rectangle(49, 97, 221, 28));
            this.languageComboBox.addItem(new Language("Select Language"));
        }
        return this.languageComboBox;
    }

    private JButton getPickFileButton() {
        if (this.pickFileButton == null) {
            this.pickFileButton = new JButton();
            this.pickFileButton.setEnabled(true);
            this.pickFileButton.setMnemonic(76);
            this.pickFileButton.setToolTipText("Select main file");
            this.pickFileButton.setText("Select");
            this.pickFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SubmitRunPane.this.selectMainFile();
                }
            });
        }
        return this.pickFileButton;
    }

    private void selectMainFile() {
        JFileChooser chooser = new JFileChooser(this.lastOpenedFile);
        try {
            chooser.setDialogTitle("Open Source Code File");
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File newFile = chooser.getSelectedFile().getCanonicalFile();
                boolean newFileProblem = true;
                if (newFile.exists() && newFile.isFile() && newFile.canRead()) {
                    this.lastOpenedFile = chooser.getCurrentDirectory().toString();
                    this.fileNameLabel.setText(newFile.getCanonicalFile().toString());
                    this.fileNameLabel.setToolTipText(newFile.getCanonicalFile().toString());
                    newFileProblem = false;
                }
                if (newFileProblem) {
                    this.log.warning("Problem reading new main file selection " + newFile.getCanonicalPath() + ", main file not changed");
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Main file not changed, could not open file " + newFile, "Warning", 2);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error getting selected file, try again.");
            e.printStackTrace(System.err);
        }
        chooser = null;
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void updateGUIperPermissions() {
        this.submitRunButton.setVisible(this.isAllowed(Permission.Type.SUBMIT_RUN));
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getContest().addContestTimeListener(new ContestTimeListenerImplementation());
        this.getContest().addLanguageListener(new LanguageListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SubmitRunPane.this.populateGUI();
                SubmitRunPane.this.updateGUIperPermissions();
                SubmitRunPane.this.setVisible(true);
            }
        });
    }

    public String getPluginTitle() {
        return "Submit Run Pane ";
    }

    private JPanel getFilenamePane() {
        if (this.filenamePane == null) {
            this.fileNameLabel = new JLabel();
            this.fileNameLabel.setText("");
            this.fileNameLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1 && e.isShiftDown()) {
                        SubmitRunPane.this.autoPopulate();
                    }
                }
            });
            this.filenamePane = new JPanel();
            this.filenamePane.setLayout(new BorderLayout());
            this.filenamePane.setBorder(BorderFactory.createTitledBorder(null, "Main File", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.filenamePane.setLocation(new Point(19, 144));
            this.filenamePane.setSize(new Dimension(435, 55));
            this.filenamePane.add((Component)this.getPickFileButton(), "East");
            this.filenamePane.add((Component)this.fileNameLabel, "Center");
        }
        return this.filenamePane;
    }

    private JPanel getProblemPane() {
        if (this.problemPane == null) {
            this.problemPane = new JPanel();
            this.problemPane.setLayout(new BorderLayout());
            this.problemPane.setBorder(BorderFactory.createTitledBorder(null, "Problem", 0, 0, null, null));
            this.problemPane.setLocation(new Point(19, 17));
            this.problemPane.setSize(new Dimension(435, 50));
            this.problemPane.add((Component)this.getProblemComboBox(), "Center");
        }
        return this.problemPane;
    }

    private JPanel getLanguagePane() {
        if (this.languagePane == null) {
            this.languagePane = new JPanel();
            this.languagePane.setLayout(new BorderLayout());
            this.languagePane.setBorder(BorderFactory.createTitledBorder(null, "Language", 0, 0, null, null));
            this.languagePane.setLocation(new Point(21, 81));
            this.languagePane.setSize(new Dimension(332, 50));
            this.languagePane.add((Component)this.getLanguageComboBox(), "Center");
        }
        return this.languagePane;
    }

    private JButton getTestButton() {
        if (this.testButton == null) {
            this.testButton = new JButton();
            this.testButton.setText("Test");
            this.testButton.setEnabled(true);
            this.testButton.setLocation(new Point(21, 350));
            this.testButton.setSize(new Dimension(100, 26));
            this.testButton.setPreferredSize(new Dimension(100, 26));
            this.testButton.setMnemonic(84);
            this.testButton.setToolTipText("Test run");
            this.testButton.setVisible(true);
            this.testButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new Thread(new Runnable(){

                        public void run() {
                            SubmitRunPane.this.testOrSubmitRun(false);
                        }
                    }).start();
                }
            });
        }
        return this.testButton;
    }

    private JPanel getAdditionalFilesPane() {
        if (this.additionalFilesPane == null) {
            this.additionalFilesPane = new JPanel();
            this.additionalFilesPane.setLayout(new BorderLayout());
            this.additionalFilesPane.setBounds(new Rectangle(20, 217, 438, 117));
            this.additionalFilesPane.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.additionalFilesPane.add((Component)this.getAdditonalFilesButtonPane(), "South");
            this.additionalFilesPane.add((Component)((Object)this.getAdditionalFilesMCLB()), "Center");
        }
        return this.additionalFilesPane;
    }

    private JPanel getAdditonalFilesButtonPane() {
        if (this.additonalFilesButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(100);
            this.additonalFilesButtonPane = new JPanel();
            this.additonalFilesButtonPane.setLayout(flowLayout);
            this.additonalFilesButtonPane.add((Component)this.getAddAdditionalFilesButton(), null);
            this.additonalFilesButtonPane.add((Component)this.getRemoveAdditionalFilesButton(), null);
        }
        return this.additonalFilesButtonPane;
    }

    private JButton getAddAdditionalFilesButton() {
        if (this.addAdditionalFilesButton == null) {
            this.addAdditionalFilesButton = new JButton();
            this.addAdditionalFilesButton.setText("Add");
            this.addAdditionalFilesButton.setPreferredSize(new Dimension(100, 26));
            this.addAdditionalFilesButton.setToolTipText("Add an additional file");
            this.addAdditionalFilesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SubmitRunPane.this.addFile();
                }
            });
        }
        return this.addAdditionalFilesButton;
    }

    protected void addFile() {
        JFileChooser chooser = new JFileChooser(this.lastOpenedFile);
        try {
            chooser.setDialogTitle("Open Additional Source Code File");
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File newFile = chooser.getSelectedFile().getCanonicalFile();
                boolean newFileProblem = true;
                if (newFile.exists() && newFile.isFile() && newFile.canRead()) {
                    this.lastOpenedFile = chooser.getCurrentDirectory().toString();
                    Object[] cols = new String[]{newFile.getCanonicalFile().toString()};
                    this.additionalFilesMCLB.addRow(cols);
                    this.additionalFilesMCLB.autoSizeAllColumns();
                    newFileProblem = false;
                }
                if (newFileProblem) {
                    this.log.warning("Problem reading additional file selection " + newFile.getCanonicalPath() + ", file not added");
                    JOptionPane.showMessageDialog(this.getParentFrame(), "File not added, could not open file " + newFile, "Warning", 2);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error getting selected file, try again.");
            e.printStackTrace(System.err);
        }
        chooser = null;
    }

    private JButton getRemoveAdditionalFilesButton() {
        if (this.removeAdditionalFilesButton == null) {
            this.removeAdditionalFilesButton = new JButton();
            this.removeAdditionalFilesButton.setText("Remove");
            this.removeAdditionalFilesButton.setPreferredSize(new Dimension(100, 26));
            this.removeAdditionalFilesButton.setToolTipText("remove selected additional file");
            this.removeAdditionalFilesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SubmitRunPane.this.removeSelectedAdditionalFile();
                }
            });
        }
        return this.removeAdditionalFilesButton;
    }

    protected void removeSelectedAdditionalFile() {
        int selectedIndex = this.additionalFilesMCLB.getSelectedIndex();
        if (this.additionalFilesMCLB.getRowCount() < 0) {
            this.showMessage("No files to remove");
            return;
        }
        if (selectedIndex < 0) {
            this.showMessage("Select a file to remove");
            return;
        }
        this.additionalFilesMCLB.removeRow(selectedIndex);
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(SubmitRunPane.this.getParentFrame(), string);
            }
        });
    }

    private MCLB getAdditionalFilesMCLB() {
        if (this.additionalFilesMCLB == null) {
            this.additionalFilesMCLB = new MCLB();
            Object[] cols = new String[]{"Additional Files"};
            this.additionalFilesMCLB.addColumns(cols);
            cols = null;
            this.additionalFilesMCLB.getColumnInfo(0).setWidth(400);
        }
        return this.additionalFilesMCLB;
    }

    protected class AccountListenerImplementation
    implements IAccountListener {
        protected AccountListenerImplementation() {
        }

        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (SubmitRunPane.this.getContest().getClientId().equals(account.getClientId())) {
                SubmitRunPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SubmitRunPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                if (!SubmitRunPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                SubmitRunPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SubmitRunPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            this.accountsModified(accountEvent);
        }
    }

    private class LanguageListenerImplementation
    implements ILanguageListener {
        private LanguageListenerImplementation() {
        }

        public void languageAdded(final LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubmitRunPane.this.getLanguageComboBox().addItem(event.getLanguage());
                }
            });
        }

        public void languageChanged(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int selectedIndex = SubmitRunPane.this.getLanguageComboBox().getSelectedIndex();
                    SubmitRunPane.this.reloadLanguages();
                    if (selectedIndex > -1 && selectedIndex < SubmitRunPane.this.getLanguageComboBox().getItemCount()) {
                        SubmitRunPane.this.getLanguageComboBox().setSelectedIndex(selectedIndex);
                    }
                }
            });
        }

        public void languageRemoved(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubmitRunPane.this.reloadLanguages();
                }
            });
        }

        public void languageRefreshAll(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubmitRunPane.this.reloadLanguages();
                }
            });
        }
    }

    private class ProblemListenerImplementation
    implements IProblemListener {
        private ProblemListenerImplementation() {
        }

        public void problemAdded(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubmitRunPane.this.getProblemComboBox().addItem(event.getProblem());
                }
            });
        }

        public void problemChanged(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int selectedIndex = SubmitRunPane.this.getProblemComboBox().getSelectedIndex();
                    SubmitRunPane.this.reloadProblems();
                    if (selectedIndex > -1) {
                        SubmitRunPane.this.getProblemComboBox().setSelectedIndex(selectedIndex);
                    }
                }
            });
        }

        public void problemRemoved(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubmitRunPane.this.reloadProblems();
                }
            });
        }

        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubmitRunPane.this.reloadProblems();
                }
            });
        }
    }

    private class ContestTimeListenerImplementation
    implements IContestTimeListener {
        private ContestTimeListenerImplementation() {
        }

        public void contestTimeAdded(ContestTimeEvent event) {
            if (SubmitRunPane.this.isThisSite(event.getSiteNumber())) {
                SubmitRunPane.this.setButtonsActive(event.getContestTime().isContestRunning());
            }
        }

        public void contestTimeRemoved(ContestTimeEvent event) {
        }

        public void contestTimeChanged(ContestTimeEvent event) {
        }

        public void contestStarted(ContestTimeEvent event) {
            if (SubmitRunPane.this.isThisSite(event.getSiteNumber())) {
                SubmitRunPane.this.setButtonsActive(event.getContestTime().isContestRunning());
            }
        }

        public void contestStopped(ContestTimeEvent event) {
            if (SubmitRunPane.this.isThisSite(event.getSiteNumber())) {
                SubmitRunPane.this.setButtonsActive(event.getContestTime().isContestRunning());
            }
        }

        public void refreshAll(ContestTimeEvent event) {
            if (SubmitRunPane.this.isThisSite(event.getSiteNumber())) {
                SubmitRunPane.this.setButtonsActive(event.getContestTime().isContestRunning());
            }
        }
    }
}

