/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClarificationEvent;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SubmissionBiffPane
extends JPanePlugin {
    private static final long serialVersionUID = -1652565796449008642L;
    private JLabel runAndClarCountsLabel = null;
    private int unjudgedRunsCount = 0;
    private int unansweredClarificationsCount = 0;
    private Filter newSubmissionFilter = new Filter();
    private boolean showNoRunsTitle = false;

    public SubmissionBiffPane() {
        this.initialize();
    }

    private void initialize() {
        this.runAndClarCountsLabel = new JLabel();
        this.runAndClarCountsLabel.setText("XXX Runs YYY Clars");
        this.runAndClarCountsLabel.setHorizontalAlignment(0);
        this.runAndClarCountsLabel.setForeground(Color.red);
        this.runAndClarCountsLabel.setFont(new Font("Dialog", 1, 24));
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(504, 57));
        this.add((Component)this.runAndClarCountsLabel, "Center");
    }

    public void updateCountDisplay() {
        String updateString = "";
        if (this.unjudgedRunsCount == 1) {
            updateString = this.unjudgedRunsCount + " Run";
        } else if (this.unjudgedRunsCount > 1) {
            updateString = this.unjudgedRunsCount + " Runs";
        }
        if (this.unansweredClarificationsCount == 1) {
            updateString = updateString + "   " + this.unansweredClarificationsCount + " Clar";
        } else if (this.unansweredClarificationsCount > 1) {
            updateString = updateString + "   " + this.unansweredClarificationsCount + " Clars";
        }
        if (updateString.trim().length() == 0 && this.showNoRunsTitle) {
            updateString = "-";
        }
        this.updateMessage(updateString);
    }

    private void updateMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SubmissionBiffPane.this.runAndClarCountsLabel.setText(string);
            }
        });
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addRunListener(new RunListenerImplementation());
        this.getContest().addClarificationListener(new ClarificationListenerImplementation());
        this.newSubmissionFilter.addClarificationState(Clarification.ClarificationStates.NEW);
        this.newSubmissionFilter.addRunState(Run.RunStates.NEW);
        this.newSubmissionFilter.addRunState(Run.RunStates.MANUAL_REVIEW);
        this.unansweredClarificationsCount = this.getNewClarificationsCount();
        this.unjudgedRunsCount = this.getNewRunsCount();
        this.updateCountDisplay();
    }

    public String getPluginTitle() {
        return "Submission Biff Pane";
    }

    int getNewClarificationsCount() {
        Clarification[] clarifications;
        int counter = 0;
        for (Clarification clarification : clarifications = this.getContest().getClarifications()) {
            if (!this.newSubmissionFilter.matches(clarification)) continue;
            ++counter;
        }
        return counter;
    }

    public void updateClarificationCounts(ClarificationEvent event) {
        this.unansweredClarificationsCount = this.getNewClarificationsCount();
        this.updateCountDisplay();
    }

    int getNewRunsCount() {
        Run[] runs;
        int counter = 0;
        for (Run run : runs = this.getContest().getRuns()) {
            if (!this.newSubmissionFilter.matches(run)) continue;
            ++counter;
        }
        return counter;
    }

    public void updateRunCount(RunEvent event) {
        this.unjudgedRunsCount = this.getNewRunsCount();
        this.updateCountDisplay();
    }

    public void setFontSize(int pointSize) {
        this.runAndClarCountsLabel.setFont(new Font("Dialog", 1, pointSize));
    }

    public boolean isShowNoRunsTitle() {
        return this.showNoRunsTitle;
    }

    public void setShowNoRunsTitle(boolean showNoRunsTitle) {
        this.showNoRunsTitle = showNoRunsTitle;
    }

    class ClarificationListenerImplementation
    implements IClarificationListener {
        ClarificationListenerImplementation() {
        }

        public void clarificationAdded(ClarificationEvent event) {
            SubmissionBiffPane.this.updateClarificationCounts(event);
        }

        public void refreshClarfications(ClarificationEvent event) {
            SubmissionBiffPane.this.updateClarificationCounts(event);
        }

        public void clarificationChanged(ClarificationEvent event) {
            SubmissionBiffPane.this.updateClarificationCounts(event);
        }

        public void clarificationRemoved(ClarificationEvent event) {
            SubmissionBiffPane.this.updateClarificationCounts(event);
        }
    }

    class RunListenerImplementation
    implements IRunListener {
        RunListenerImplementation() {
        }

        public void runAdded(RunEvent event) {
            SubmissionBiffPane.this.updateRunCount(event);
        }

        public void refreshRuns(RunEvent event) {
            SubmissionBiffPane.this.updateRunCount(event);
        }

        public void runChanged(RunEvent event) {
            SubmissionBiffPane.this.updateRunCount(event);
        }

        public void runRemoved(RunEvent event) {
            SubmissionBiffPane.this.updateRunCount(event);
        }
    }
}

