/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.MultiColumnListbox;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.BalloonSettingsEvent;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StandingsPane
extends JPanePlugin {
    private static final long serialVersionUID = 5947564887534500596L;
    private MCLB standingsListbox = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private Log log;
    private String currentXMLString = "";

    public StandingsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(470, 243));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getStandingsListbox(), "Center");
    }

    public String getPluginTitle() {
        return "Standings Plugin";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addRunListener(new RunListenerImplementation());
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
        this.getContest().addBalloonSettingsListener(new BalloonSettingsListenerImplementation());
        this.refreshStandings();
    }

    private String[] fetchStanding(Node node) {
        String[] outArray = new String[4];
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node standingNode = attributes.item(i);
            String value = standingNode.getNodeValue();
            String name = standingNode.getNodeName();
            if (name.equals("rank")) {
                outArray[0] = value;
                continue;
            }
            if (name.equals("teamName")) {
                outArray[1] = value;
                continue;
            }
            if (name.equals("solved")) {
                outArray[2] = value;
                continue;
            }
            if (!name.equals("points")) continue;
            outArray[3] = value;
        }
        return outArray;
    }

    protected void parseAndDisplay() {
        this.standingsListbox.removeAllRows();
        Document document = null;
        String xmlString = null;
        try {
            DefaultScoringAlgorithm defaultScoringAlgorithm = new DefaultScoringAlgorithm();
            Properties properties = this.getScoringProperties();
            xmlString = defaultScoringAlgorithm.getStandings(this.getContest(), properties, this.getController().getLog());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Trouble creating or parsing SA XML ", e);
            this.showMessage("Problem updating scoreboard (parse error), check log");
            return;
        }
        try {
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (!name.equals("teamStanding")) continue;
                try {
                    String[] standingsRow = this.fetchStanding(node);
                    this.updateStandingsRow(standingsRow);
                    continue;
                }
                catch (Exception e) {
                    this.log.log(Log.WARNING, "Exception while adding row ", e);
                }
            }
            this.showMessage("Last update " + new Date());
            this.firePropertyChange("standings", this.currentXMLString, xmlString);
            this.currentXMLString = xmlString;
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Trouble parsing XML ", e);
            this.showMessage("Problem updating scoreboard, check log");
        }
    }

    protected void refreshStandings() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StandingsPane.this.parseAndDisplay();
            }
        });
    }

    private void updateStandingsRow(String[] values) {
        Object[] objects = this.buildSiteRow(values);
        this.standingsListbox.addRow(objects);
        this.standingsListbox.autoSizeAllColumns();
    }

    private MultiColumnListbox getStandingsListbox() {
        if (this.standingsListbox == null) {
            this.standingsListbox = new MCLB();
            Object[] cols = new Object[]{"Rank", "Name", "Solved", "Points"};
            this.standingsListbox.addColumns(cols);
        }
        return this.standingsListbox;
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StandingsPane.this.messageLabel.setText(string);
            }
        });
    }

    private Object[] buildSiteRow(String[] fields) {
        Object[] obj = new Object[this.standingsListbox.getColumnCount()];
        obj[0] = fields[0];
        obj[1] = fields[1];
        obj[2] = fields[2];
        obj[3] = fields[3];
        return obj;
    }

    protected Properties getScoringProperties() {
        String[] keys;
        Properties properties = this.getContest().getContestInformation().getScoringProperties();
        Properties defProperties = DefaultScoringAlgorithm.getDefaultProperties();
        for (String key : keys = defProperties.keySet().toArray(new String[defProperties.keySet().size()])) {
            if (properties.containsKey(key)) continue;
            properties.put(key, defProperties.get(key));
        }
        return properties;
    }

    class ContestInformationListenerImplementation
    implements IContestInformationListener {
        ContestInformationListenerImplementation() {
        }

        public void contestInformationAdded(ContestInformationEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void contestInformationChanged(ContestInformationEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void contestInformationRemoved(ContestInformationEvent event) {
        }

        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
            StandingsPane.this.refreshStandings();
        }

        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
            StandingsPane.this.refreshStandings();
        }
    }

    public class BalloonSettingsListenerImplementation
    implements IBalloonSettingsListener {
        public void balloonSettingsAdded(BalloonSettingsEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void balloonSettingsChanged(BalloonSettingsEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void balloonSettingsRemoved(BalloonSettingsEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void balloonSettingsRefreshAll(BalloonSettingsEvent balloonSettingsEvent) {
            StandingsPane.this.refreshStandings();
        }
    }

    public class RunListenerImplementation
    implements IRunListener {
        public void runAdded(RunEvent event) {
        }

        public void refreshRuns(RunEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void runChanged(RunEvent event) {
            if (event.getAction().equals((Object)RunEvent.Action.CHANGED)) {
                StandingsPane.this.refreshStandings();
            }
        }

        public void runRemoved(RunEvent event) {
            StandingsPane.this.refreshStandings();
        }
    }

    public class ProblemListenerImplementation
    implements IProblemListener {
        public void problemAdded(ProblemEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void problemChanged(ProblemEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void problemRemoved(ProblemEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void problemRefreshAll(ProblemEvent event) {
            StandingsPane.this.refreshStandings();
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
            StandingsPane.this.refreshStandings();
        }

        public void accountModified(AccountEvent event) {
            StandingsPane.this.refreshStandings();
        }

        public void accountsAdded(AccountEvent accountEvent) {
            StandingsPane.this.refreshStandings();
        }

        public void accountsModified(AccountEvent accountEvent) {
            StandingsPane.this.refreshStandings();
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            StandingsPane.this.refreshStandings();
        }
    }
}

