/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.BalloonSettingsEvent;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.IScoringAlgorithm;
import edu.csus.ecs.pc2.core.util.XSLTransformer;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;

public class StandingsHTMLPane
extends JPanePlugin {
    private static final long serialVersionUID = -1570509469246188861L;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private Log log;
    private IScoringAlgorithm scoringAlgorithm = new DefaultScoringAlgorithm();
    private JTextPane textArea = null;
    private String styleSheetFileName;
    private String styleSheetDirectoryName = null;
    private JButton refreshButton = null;
    private JScrollPane scrollPane = null;

    private StandingsHTMLPane() {
        this.initialize();
    }

    public StandingsHTMLPane(String styleSheetFileName) {
        this();
        this.setStyleSheetFileName(styleSheetFileName);
    }

    public StandingsHTMLPane(String styleSheetFileName, String styleSheetDirectoryName) {
        this();
        this.setStyleSheetFileName(styleSheetFileName);
        this.setStyleSheetDirectoryName(styleSheetDirectoryName);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(470, 243));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getScrollPane(), "Center");
    }

    public String getPluginTitle() {
        return "Standings HTML Plugin";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addRunListener(new RunListenerImplementation());
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
        this.getContest().addBalloonSettingsListener(new BalloonSettingsListenerImplementation());
        this.refreshStandings();
    }

    private String getDefaultSyleSheetDirectoryName() {
        String xslDir = "data" + File.separator + "xsl";
        File xslDirFile = new File(xslDir);
        if (!xslDirFile.canRead() || !xslDirFile.isDirectory()) {
            VersionInfo versionInfo = new VersionInfo();
            xslDir = versionInfo.locateHome() + File.separator + xslDir;
        }
        return xslDir;
    }

    public void refreshStandings() {
        if (this.styleSheetFileName == null) {
            this.showMessage("Internal error - Style Sheet not defined in StandingsHTMLPane");
            this.log.log(Log.WARNING, "Style sheet not defined", new Exception("Programmer error - did not define stylesheet filename."));
            return;
        }
        this.showMessage("");
        try {
            Properties scoringProperties = this.getScoringProperties();
            String xmlString = this.scoringAlgorithm.getStandings(this.getContest(), scoringProperties, this.log);
            this.transformAndDisplay(xmlString, this.styleSheetFileName);
            this.showMessage("Last update " + new Date());
        }
        catch (IllegalContestState e) {
            this.log.log(Log.WARNING, "Exception refreshing a standings display", e);
            this.showMessage("Unable to update, check logs");
        }
    }

    protected Properties getScoringProperties() {
        String[] keys;
        Properties properties = this.getContest().getContestInformation().getScoringProperties();
        if (properties == null) {
            properties = new Properties();
        }
        Properties defProperties = DefaultScoringAlgorithm.getDefaultProperties();
        for (String key : keys = defProperties.keySet().toArray(new String[defProperties.keySet().size()])) {
            if (properties.containsKey(key)) continue;
            properties.put(key, defProperties.get(key));
        }
        return properties;
    }

    private void transformAndDisplay(String xmlString, String xsltFileName) {
        String xslDir = this.getStyleSheetDirectoryName();
        File inputDir = new File(xslDir);
        if (!inputDir.isDirectory()) {
            this.showMessage("Can not find xslt dir: " + xslDir);
            return;
        }
        try {
            XSLTransformer xslTransformer = new XSLTransformer();
            String fullPathFileName = xslDir + File.separator + xsltFileName;
            File xslFile = new File(fullPathFileName);
            String htmlString = xslTransformer.transformToString(xslFile, xmlString);
            this.viewHTML(htmlString);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Error generating web/html display ", e);
            this.showMessage("Error generating web/html display, check logs");
        }
    }

    private void viewHTML(String htmlString) {
        try {
            File tmpFile = File.createTempFile("__t", ".htm");
            tmpFile.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(tmpFile));
            out.write(htmlString);
            out.close();
            out = null;
            final URL tmpURL = tmpFile.toURI().toURL();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        StandingsHTMLPane.this.getTextArea().setPage(tmpURL);
                    }
                    catch (Exception e) {
                        StandingsHTMLPane.this.log.log(Log.WARNING, "Could not display HTML", e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "In View HTML ", e);
        }
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
            this.messagePane.add((Component)this.getRefreshButton(), "East");
        }
        return this.messagePane;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StandingsHTMLPane.this.messageLabel.setText(string);
            }
        });
    }

    private JTextPane getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextPane();
            this.textArea.setEditorKit(new HTMLEditorKit());
            this.textArea.setEditable(false);
        }
        return this.textArea;
    }

    public String getStyleSheetFileName() {
        return this.styleSheetFileName;
    }

    public void setStyleSheetFileName(String styleSheetFileName) {
        this.styleSheetFileName = styleSheetFileName;
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setText("Refresh");
            this.refreshButton.setToolTipText("Refresh display");
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StandingsHTMLPane.this.refreshStandings();
                }
            });
        }
        return this.refreshButton;
    }

    public String getStyleSheetDirectoryName() {
        if (this.styleSheetDirectoryName == null) {
            this.styleSheetDirectoryName = this.getDefaultSyleSheetDirectoryName();
        }
        return this.styleSheetDirectoryName;
    }

    public void setStyleSheetDirectoryName(String styleSheetDirectoryName) {
        this.styleSheetDirectoryName = styleSheetDirectoryName;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getTextArea());
        }
        return this.scrollPane;
    }

    public class BalloonSettingsListenerImplementation
    implements IBalloonSettingsListener {
        public void balloonSettingsAdded(BalloonSettingsEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void balloonSettingsChanged(BalloonSettingsEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void balloonSettingsRemoved(BalloonSettingsEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void balloonSettingsRefreshAll(BalloonSettingsEvent balloonSettingsEvent) {
            StandingsHTMLPane.this.refreshStandings();
        }
    }

    class ContestInformationListenerImplementation
    implements IContestInformationListener {
        ContestInformationListenerImplementation() {
        }

        public void contestInformationAdded(ContestInformationEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void contestInformationChanged(ContestInformationEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void contestInformationRemoved(ContestInformationEvent event) {
        }

        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
            StandingsHTMLPane.this.refreshStandings();
        }
    }

    public class RunListenerImplementation
    implements IRunListener {
        public void runAdded(RunEvent event) {
        }

        public void refreshRuns(RunEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void runChanged(RunEvent event) {
            if (event.getAction().equals((Object)RunEvent.Action.CHANGED)) {
                StandingsHTMLPane.this.refreshStandings();
            }
        }

        public void runRemoved(RunEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }
    }

    public class ProblemListenerImplementation
    implements IProblemListener {
        public void problemAdded(ProblemEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void problemChanged(ProblemEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void problemRemoved(ProblemEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void problemRefreshAll(ProblemEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void accountModified(AccountEvent event) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void accountsAdded(AccountEvent accountEvent) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void accountsModified(AccountEvent accountEvent) {
            StandingsHTMLPane.this.refreshStandings();
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            StandingsHTMLPane.this.refreshStandings();
        }
    }
}

