/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.core.model.SiteList;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SitesPanel
extends JPanePlugin {
    private static final long serialVersionUID = 8567214090568964720L;
    private JPanel siteButtonPanel = null;
    private MCLB siteListBox = null;
    private JButton addSiteButton = null;
    private JButton updateSiteButton = null;
    private JButton cancelSiteEditButton = null;
    private SiteList siteList = new SiteList();
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private JButton reconnectButton = null;
    public static final int DEFAULT_LISTENING_PORT = 50002;
    private PermissionList permissionList = new PermissionList();
    private JButton shutdownButton = null;

    public SitesPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(536, 217));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getSiteButtonPanel(), "South");
        this.add((Component)((Object)this.getSiteListBox()), "Center");
    }

    public String getPluginTitle() {
        return "Sites Panel";
    }

    private JPanel getSiteButtonPanel() {
        if (this.siteButtonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            flowLayout.setVgap(5);
            this.siteButtonPanel = new JPanel();
            this.siteButtonPanel.setLayout(flowLayout);
            this.siteButtonPanel.setPreferredSize(new Dimension(35, 35));
            this.siteButtonPanel.add((Component)this.getAddSiteButton(), null);
            this.siteButtonPanel.add((Component)this.getUpdateSiteButton(), null);
            this.siteButtonPanel.add((Component)this.getCancelSiteEditButton(), null);
            this.siteButtonPanel.add((Component)this.getReconnectButton(), null);
            this.siteButtonPanel.add((Component)this.getShutdownButton(), null);
            this.siteButtonPanel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.isShiftDown()) {
                        SitesPanel.this.addNewTestSite();
                    }
                }
            });
        }
        return this.siteButtonPanel;
    }

    private MCLB getSiteListBox() {
        if (this.siteListBox == null) {
            this.siteListBox = new MCLB();
            Object[] cols = new Object[]{"Site Number", "Site Title", "Password", "IP", "Port"};
            this.siteListBox.addColumns(cols);
            this.siteListBox.autoSizeAllColumns();
        }
        return this.siteListBox;
    }

    private JButton getAddSiteButton() {
        if (this.addSiteButton == null) {
            this.addSiteButton = new JButton();
            this.addSiteButton.setText("Add Site");
            this.addSiteButton.setMnemonic(65);
            this.addSiteButton.setToolTipText("Add a new Site");
            this.addSiteButton.setText("Add Site");
            this.addSiteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SitesPanel.this.addNewSite();
                }
            });
        }
        return this.addSiteButton;
    }

    protected void addNewTestSite() {
        int nextSiteNumber = this.siteListBox.getRowCount() + 1;
        int port = 50002 + (nextSiteNumber - 1) * 1000;
        Site newSite = this.createSite(nextSiteNumber, "localhost", port);
        this.addSiteRow(newSite);
        this.enableUpdateButtons(true);
    }

    protected void addNewSite() {
        int nextSiteNumber = this.siteListBox.getRowCount() + 1;
        int port = 50002;
        Site newSite = this.createSite(nextSiteNumber, "", port);
        this.addSiteRow(newSite);
        this.enableUpdateButtons(true);
    }

    private JButton getUpdateSiteButton() {
        if (this.updateSiteButton == null) {
            this.updateSiteButton = new JButton();
            this.updateSiteButton.setText("Apply");
            this.updateSiteButton.setMnemonic(80);
            this.updateSiteButton.setToolTipText("Apply all site changes");
            this.updateSiteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SitesPanel.this.updateSitesData();
                }
            });
            this.updateSiteButton.setText("Update Site");
        }
        return this.updateSiteButton;
    }

    protected void updateSitesData() {
        this.showMessage("");
        String message = this.validateSiteListBox();
        if (message == null) {
            Site[] sites = this.getContest().getSites();
            for (int i = 0; i < this.siteListBox.getRowCount(); ++i) {
                Site newSite = this.createSiteFromRow(i);
                if (i >= sites.length) {
                    this.getController().addNewSite(newSite);
                    continue;
                }
                if (newSite.isSameAs(this.getContest().getSite(newSite.getSiteNumber()))) continue;
                this.getController().updateSite(newSite);
            }
            this.enableUpdateButtons(false);
        } else {
            this.showMessage(message);
        }
    }

    private boolean validPort(String portString) {
        int portNum = 0;
        try {
            portNum = Integer.parseInt(portString);
        }
        catch (Exception e) {
            StaticLog.getLog().log(Log.DEBUG, "validPort: ", e);
            return false;
        }
        return portNum > 0 && portNum < 65536;
    }

    private String validateSites(SiteList inSiteList) {
        if (inSiteList.size() > 1) {
            Site[] sites = inSiteList.getList();
            for (int s1 = 0; s1 < sites.length - 1; ++s1) {
                Site site1 = sites[s1];
                for (int s2 = s1 + 1; s2 < sites.length; ++s2) {
                    Site site2 = sites[s2];
                    if (site1.getPassword().equals(site2.getPassword())) {
                        return "Duplicate passwords not allowed, " + site1.getPassword() + ", for " + site1 + " and " + site2;
                    }
                    if (site1.toString().equals(site2.toString())) {
                        return "Duplicate site names not allowed, name is: " + site1;
                    }
                    String ip1 = site1.getConnectionInfo().getProperty("IP_KEY");
                    String port1 = site1.getConnectionInfo().getProperty("PORT_KEY");
                    String ip2 = site2.getConnectionInfo().getProperty("IP_KEY");
                    String port2 = site2.getConnectionInfo().getProperty("PORT_KEY");
                    if (ip1 == null || ip1.trim().length() == 0) {
                        return "Please enter an IP for Site " + site1;
                    }
                    if (port1 == null || port1.trim().length() == 0) {
                        return "Please enter a port number for: " + site1;
                    }
                    if (!this.validPort(port1)) {
                        return "Invalid port, must be numeric, " + port1 + ") for: " + site1;
                    }
                    if (ip2 == null || ip2.trim().length() == 0) {
                        return "Please enter an IP for Site " + site2;
                    }
                    if (port2 == null || port2.trim().length() == 0) {
                        return "Please enter a port number for: " + site2;
                    }
                    if (!this.validPort(port2)) {
                        return "Invalid port, must be numeric, " + port2 + ") for: " + site2;
                    }
                    String conInfo1 = ip1 + ":" + port1;
                    String conInfo2 = ip2 + ":" + port2;
                    if (!conInfo1.trim().equals(conInfo2.trim())) continue;
                    return "Duplicate IP and port values are not allowed, for " + site1 + " and " + site2;
                }
            }
        }
        return null;
    }

    private String validateSiteListBox() {
        SiteList siteListToValidate = new SiteList();
        for (int i = 0; i < this.siteListBox.getRowCount(); ++i) {
            Site newSite = this.createSiteFromRow(i);
            siteListToValidate.add(newSite);
        }
        return this.validateSites(siteListToValidate);
    }

    private Site createSiteFromRow(int i) {
        Object[] objects = this.siteListBox.getRow(i);
        String siteTitle = ((JTextField)objects[1]).getText();
        String password = ((JTextField)objects[2]).getText();
        String hostName = ((JTextField)objects[3]).getText();
        String portString = ((JTextField)objects[4]).getText();
        int port = Integer.parseInt(portString);
        ElementId siteId = (ElementId)this.siteListBox.getKeys()[i];
        Site site = (Site)this.siteList.get(siteId);
        site.setDisplayName(siteTitle);
        site.setPassword(password);
        Properties props = new Properties();
        props.put("IP_KEY", hostName);
        props.put("PORT_KEY", "" + port);
        site.setConnectionInfo(props);
        return site;
    }

    private JButton getCancelSiteEditButton() {
        if (this.cancelSiteEditButton == null) {
            this.cancelSiteEditButton = new JButton();
            this.cancelSiteEditButton.setText("Cancel");
            this.cancelSiteEditButton.setMnemonic(67);
            this.cancelSiteEditButton.setToolTipText("Undo changes");
            this.cancelSiteEditButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SitesPanel.this.undoEdit();
                }
            });
        }
        return this.cancelSiteEditButton;
    }

    private Object[] buildSiteRow(Site site) {
        Object[] obj = new Object[this.siteListBox.getColumnCount()];
        obj[0] = site.getSiteNumber();
        obj[1] = this.createJTextField(site.toString(), false);
        obj[2] = this.createJTextField(site.getPassword(), false);
        String hostName = site.getConnectionInfo().getProperty("IP_KEY");
        obj[3] = this.createJTextField(hostName, false);
        String port = site.getConnectionInfo().getProperty("PORT_KEY");
        JTextField textField = this.createJTextField(port, false);
        textField.setDocument(new IntegerDocument());
        textField.setText(port);
        obj[4] = textField;
        return obj;
    }

    private void reloadListBox() {
        this.siteListBox.removeAllRows();
        this.siteList = new SiteList();
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        for (Site site : sites) {
            Site siteClone = site.clone();
            this.addSiteRow(siteClone);
        }
        this.enableUpdateButtons(false);
    }

    protected void enableButtons() {
        boolean enableButtons = false;
        Site[] sites = this.getContest().getSites();
        if (this.getSiteListBox().getRowCount() > sites.length) {
            enableButtons = true;
        } else {
            for (int i = 0; i < this.siteListBox.getRowCount(); ++i) {
                Site newSite = this.createSiteFromRow(i);
                if (newSite.isSameAs(this.getContest().getSite(newSite.getSiteNumber()))) continue;
                enableButtons = true;
                break;
            }
        }
        this.enableUpdateButtons(enableButtons);
    }

    private void enableUpdateButtons(boolean enableButtons) {
        this.updateSiteButton.setEnabled(enableButtons);
        this.cancelSiteEditButton.setEnabled(enableButtons);
    }

    private JTextField createJTextField(String text, boolean passwordField) {
        JTextField textField = new JTextField();
        textField.setText(text);
        textField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SitesPanel.this.siteListBox.autoSizeAllColumns();
                SitesPanel.this.enableButtons();
            }
        });
        return textField;
    }

    private Site createSite(int nextSiteNumber, String hostName, int port) {
        Site site = new Site("Site " + nextSiteNumber, nextSiteNumber);
        Properties props = new Properties();
        props.put("IP_KEY", hostName);
        props.put("PORT_KEY", "" + port);
        site.setConnectionInfo(props);
        site.setPassword("site" + nextSiteNumber);
        return site;
    }

    private void updateSiteRow(Site site) {
        int row = this.siteListBox.getIndexByKey(site.getElementId());
        if (row == -1) {
            Object[] objects = this.buildSiteRow(site);
            this.siteListBox.addRow(objects, site.getElementId());
            this.siteList.add(site);
        } else {
            Object[] objects = this.buildSiteRow(site);
            this.siteListBox.replaceRow(objects, row);
            this.siteList.update(site);
        }
        this.siteListBox.autoSizeAllColumns();
    }

    private void addSiteRow(Site site) {
        this.updateSiteRow(site);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addSiteListener(new SiteListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SitesPanel.this.reloadListBox();
                SitesPanel.this.updateGUIperPermissions();
            }
        });
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.addSiteButton.setVisible(this.isAllowed(Permission.Type.ADD_SITE));
        this.updateSiteButton.setVisible(this.isAllowed(Permission.Type.EDIT_SITE));
        this.cancelSiteEditButton.setVisible(this.isAllowed(Permission.Type.EDIT_SITE));
        this.reconnectButton.setVisible(this.isAllowed(Permission.Type.EDIT_SITE));
        this.reconnectButton.setVisible(this.isAllowed(Permission.Type.EDIT_SITE));
        this.shutdownButton.setVisible(this.isAllowed(Permission.Type.SHUTDOWN_SERVER) || this.isAllowed(Permission.Type.SHUTDOWN_ALL_SERVERS));
    }

    protected void undoEdit() {
        this.showMessage("");
        this.reloadListBox();
    }

    public void updateSiteList(Site site) {
        final Site siteClone = site.clone();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SitesPanel.this.updateSiteRow(siteClone);
            }
        });
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.setText("");
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SitesPanel.this.messageLabel.setText(message);
                SitesPanel.this.messageLabel.setToolTipText(message);
            }
        });
    }

    private void showInfoMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(SitesPanel.this.getParentFrame(), message, "Info", 1);
            }
        });
    }

    private JButton getReconnectButton() {
        if (this.reconnectButton == null) {
            this.reconnectButton = new JButton();
            this.reconnectButton.setText("Reconnect");
            this.reconnectButton.setMnemonic(82);
            this.reconnectButton.setToolTipText("Reconnect the selected site");
            this.reconnectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SitesPanel.this.reconnectToSelectedSite();
                }
            });
        }
        return this.reconnectButton;
    }

    protected void reconnectToSelectedSite() {
        int selectedSite = this.getSiteListBox().getSelectedIndex();
        if (selectedSite == -1) {
            this.showInfoMessage("Select a site to reconnect to");
            return;
        }
        try {
            Site site = this.createSiteFromRow(selectedSite);
            if (this.getContest().getSite(site.getSiteNumber()) == null) {
                this.showInfoMessage("Can not connect to site " + site.getSiteNumber() + ", Update Site first");
                return;
            }
            this.getController().sendServerLoginRequest(site.getSiteNumber());
        }
        catch (Exception e) {
            this.showInfoMessage("Unable to reconnect site, check log");
            this.getController().getLog().log(Log.WARNING, "Exception attempting to reconnect to site ", e);
        }
    }

    private JButton getShutdownButton() {
        if (this.shutdownButton == null) {
            this.shutdownButton = new JButton();
            this.shutdownButton.setText("Shutdown");
            this.shutdownButton.setMnemonic(83);
            this.shutdownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SitesPanel.this.handleShutdownAction();
                }
            });
        }
        return this.shutdownButton;
    }

    private boolean isServer(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    protected void handleShutdownAction() {
        boolean shutdownAll = false;
        if (this.isAllowed(Permission.Type.SHUTDOWN_ALL_SERVERS)) {
            int result = FrameUtilities.yesNoCancelDialog(this, "Do you want to shutdown all servers?", "Shutdown All?");
            if (result == 0) {
                shutdownAll = true;
            } else if (result == 2) {
                return;
            }
        }
        if (shutdownAll) {
            if (this.isServer()) {
                this.getController().shutdownRemoteServers(this.getContest().getClientId());
                this.getController().shutdownServer(this.getContest().getClientId());
            } else {
                this.getController().sendShutdownAllSites();
            }
        } else {
            int siteNumber = this.getSiteListBox().getSelectedIndex();
            if (siteNumber == -1) {
                this.showInfoMessage("No site selected - select a site to shutdown");
                return;
            }
            Site site = this.getContest().getSite(++siteNumber);
            String siteName = site.getDisplayName();
            int result = FrameUtilities.yesNoCancelDialog(this, "Shutdown Site " + siteNumber + " (" + siteName + ") ?", "Shutdown Site?");
            if (result == 0) {
                if (this.isServer()) {
                    this.getController().shutdownServer(this.getContest().getClientId(), siteNumber);
                } else {
                    this.getController().sendShutdownSite(siteNumber);
                }
            }
        }
    }

    private boolean isServer() {
        return this.isServer(this.getContest().getClientId());
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (SitesPanel.this.getContest().getClientId().equals(account.getClientId())) {
                SitesPanel.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SitesPanel.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                if (!SitesPanel.this.getContest().getClientId().equals(account.getClientId())) continue;
                SitesPanel.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SitesPanel.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            SitesPanel.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SitesPanel.this.updateGUIperPermissions();
                }
            });
        }
    }

    public class SiteListenerImplementation
    implements ISiteListener {
        public void siteProfileStatusChanged(SiteEvent event) {
        }

        public void siteAdded(SiteEvent event) {
            StaticLog.unclassified("Site " + (Object)((Object)event.getAction()) + " " + event.getSite());
            SitesPanel.this.updateSiteList(event.getSite());
        }

        public void siteRemoved(SiteEvent event) {
            StaticLog.unclassified("Site " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteLoggedOn(SiteEvent event) {
            StaticLog.unclassified("Site " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteLoggedOff(SiteEvent event) {
            StaticLog.unclassified("Site " + (Object)((Object)event.getAction()) + " " + event.getSite());
        }

        public void siteChanged(SiteEvent event) {
            StaticLog.unclassified("Site " + (Object)((Object)event.getAction()) + " " + event.getSite());
            SitesPanel.this.updateSiteList(event.getSite());
        }

        public void sitesRefreshAll(SiteEvent siteEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SitesPanel.this.reloadListBox();
                }
            });
        }
    }
}

