/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.Executable;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.DisplayTeamName;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IJudgementListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementEvent;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IFileViewer;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import edu.csus.ecs.pc2.ui.judge.JudgeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SelectJudgementPaneNew
extends JPanePlugin {
    private static final long serialVersionUID = 4560827389735037513L;
    private JPanel messagePanel = null;
    private JPanel buttonPanel = null;
    private JButton acceptChosenSelectionButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private Run run = null;
    private RunFiles runFiles = null;
    private RunResultFiles[] runResultFiles = null;
    private JPanel runInfoPanel = null;
    private Log log = null;
    private JButton executeButton = null;
    private JButton viewSourceButton = null;
    private JButton extractButton = null;
    private Executable executable;
    private JComboBox judgementComboBox = null;
    private JLabel statusLabel = null;
    private JLabel statusTitleLabel = null;
    private JLabel problemTitleLabel = null;
    private JLabel languageTitleLabel = null;
    private JLabel elapsedTitleLabel = null;
    private IFileViewer sourceViewer;
    private IFileViewer answerFileViewer;
    private IFileViewer dataFileViewer;
    private boolean populatingGUI = true;
    private JLabel problemNameLabel = null;
    private JLabel languageNameLabel = null;
    private JLabel elapsedTimeLabel = null;
    private JCheckBox notifyTeamCheckBox = null;
    private PermissionList permissionList = new PermissionList();
    private JButton acceptValidatorJudgementButton = null;
    private JButton viewDataFileButton = null;
    private JButton viewAnswerFileButton = null;
    private JButton shellButton = null;
    private DisplayTeamName displayTeamName = null;
    private IFileViewer executableFileViewer;
    private JPanel mainPanel = null;
    private JPanel assignJudgementPanel = null;
    private JLabel runInfoLabel = null;
    private JButton detailsButton = null;
    private JLabel validatorAnswerLabel = null;
    private JLabel validatorAnswer = null;
    private JLabel selectJudgementCheckboxLabel = null;
    private JButton viewOutputsButton = null;
    private GregorianCalendar startTimeCalendar;

    public SelectJudgementPaneNew() {
        this.initialize();
    }

    private void initialize() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(800, 400));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setMinimumSize(new Dimension(800, 100));
        this.setPreferredSize(new Dimension(800, 400));
        this.add((Component)this.getMessagePanel(), "North");
        this.add((Component)this.getMainPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.displayTeamName = new DisplayTeamName();
        this.displayTeamName.setContestAndController(inContest, inController);
        this.initializePermissions();
        this.getContest().addJudgementListener(new JudgementListenerImplementation());
    }

    public String getPluginTitle() {
        return "Select Judgement Pane";
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.setPreferredSize(new Dimension(25, 25));
            this.messagePanel.add((Component)this.messageLabel, "Center");
        }
        return this.messagePanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            flowLayout.setVgap(20);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getExtractButton(), null);
            this.buttonPanel.add((Component)this.getViewSourceButton(), null);
            this.buttonPanel.add((Component)this.getViewOutputsButton(), null);
            this.buttonPanel.add((Component)this.getViewDataFileButton(), null);
            this.buttonPanel.add((Component)this.getViewAnswerFileButton(), null);
            this.buttonPanel.add((Component)this.getDetailsButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private Run getRunFromFields() {
        return this.run;
    }

    private JButton getAcceptChosenSelectionButton() {
        if (this.acceptChosenSelectionButton == null) {
            this.acceptChosenSelectionButton = new JButton();
            this.acceptChosenSelectionButton.setText("Accept Selected");
            this.acceptChosenSelectionButton.setEnabled(false);
            this.acceptChosenSelectionButton.setActionCommand("Ok");
            this.acceptChosenSelectionButton.setBounds(new Rectangle(480, 120, 152, 26));
            this.acceptChosenSelectionButton.setLocation(new Point(555, 98));
            this.acceptChosenSelectionButton.setSize(new Dimension(165, 37));
            this.acceptChosenSelectionButton.setMnemonic(79);
            this.acceptChosenSelectionButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SelectJudgementPaneNew.this.confirmInconsistentJudgements()) {
                        SelectJudgementPaneNew.this.updateRun();
                    }
                }
            });
        }
        return this.acceptChosenSelectionButton;
    }

    private void cancelRun() {
        this.enableUpdateButtons(false);
        this.closeViewerWindows();
        Run newRun = this.getRunFromFields();
        JudgeView.setAlreadyJudgingRun(false);
        if (this.runFiles != null) {
            this.getController().cancelRun(newRun);
        }
    }

    private boolean confirmInconsistentJudgements() {
        if (this.getAcceptValidatorJudgementButton().isVisible()) {
            String message;
            int result;
            Judgement autoJudgement;
            ElementId elementId = this.getValidatorResultElementID(this.validatorAnswer.getText());
            Judgement manualJudgement = (Judgement)this.getJudgementComboBox().getSelectedItem();
            if (!manualJudgement.equals(autoJudgement = this.getContest().getJudgement(elementId)) && (result = JOptionPane.showConfirmDialog(this, message = "You selected '" + manualJudgement + "'\n but the validator returned '" + this.validatorAnswer.getText() + "'." + "\nDid you intend to assign a different result than the validator?" + "\n(Click Yes to accept your selection; click No to cancel)")) != 0) {
                return false;
            }
        }
        return true;
    }

    private void closeViewerWindows() {
        this.closeViewer(this.dataFileViewer);
        this.closeViewer(this.answerFileViewer);
        this.closeViewer(this.sourceViewer);
        this.closeViewer(this.executableFileViewer);
    }

    private void closeViewer(IFileViewer fileViewer) {
        if (fileViewer != null) {
            fileViewer.dispose();
        }
    }

    protected void updateRun() {
        Run newRun = this.getRunFromFields();
        this.enableUpdateButtons(false);
        this.closeViewerWindows();
        JudgementRecord judgementRecord = null;
        RunResultFiles newRunResultFiles = null;
        if (this.judgementChanged()) {
            newRun.setStatus(Run.RunStates.JUDGED);
            boolean solved = this.getJudgementComboBox().getSelectedIndex() == 0;
            Judgement judgement = (Judgement)this.getJudgementComboBox().getSelectedItem();
            judgementRecord = new JudgementRecord(judgement.getElementId(), this.getContest().getClientId(), solved, false);
            judgementRecord.setSendToTeam(this.getNotifyTeamCheckBox().isSelected());
            TimeZone tz = TimeZone.getTimeZone("GMT");
            GregorianCalendar cal = new GregorianCalendar(tz);
            long milliDiff = cal.getTime().getTime() - this.startTimeCalendar.getTime().getTime();
            long totalSeconds = milliDiff / 1000L;
            judgementRecord.setHowLongToJudgeInSeconds(totalSeconds);
        }
        JudgeView.setAlreadyJudgingRun(false);
        ExecutionData executionData = null;
        if (this.executable != null) {
            executionData = this.executable.getExecutionData();
        }
        newRunResultFiles = new RunResultFiles(newRun, newRun.getProblemId(), judgementRecord, executionData);
        this.getController().submitRunJudgement(newRun, judgementRecord, newRunResultFiles);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPaneNew.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    public void handleCancelButton() {
        if (this.runFiles == null) {
            JudgeView.setAlreadyJudgingRun(false);
            if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
            return;
        }
        if (this.getAcceptChosenSelectionButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Run modified, save changes?", "Confirm Choice");
            if (result == 0 && this.confirmInconsistentJudgements()) {
                this.updateRun();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            }
            if (result == 1) {
                this.cancelRun();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            }
        } else {
            this.cancelRun();
            if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        }
    }

    public Run getRun() {
        return this.run;
    }

    public void setRun(final Run run) {
        ContestInformation contestInformation = this.getContest().getContestInformation();
        this.displayTeamName.setTeamDisplayMask(contestInformation.getTeamDisplayMode());
        this.run = run;
        this.startTimeCalendar = null;
        this.showMessage("Waiting for run...");
        FrameUtilities.waitCursor(this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectJudgementPaneNew.this.populateGUI(run);
                SelectJudgementPaneNew.this.enableUpdateButtons(false);
                SelectJudgementPaneNew.this.executableFileViewer = null;
                SelectJudgementPaneNew.this.enableOutputsButton(false);
                SelectJudgementPaneNew.this.showValidatorControls(false);
            }
        });
    }

    private void populateGUI(Run theRun) {
        this.populatingGUI = true;
        if (theRun != null) {
            this.getAcceptChosenSelectionButton().setVisible(true);
            String teamName = this.getTeamDisplayName(theRun.getSubmitter());
            this.runInfoLabel.setText("Run " + theRun.getNumber() + " (Site " + theRun.getSiteNumber() + ") from " + teamName);
            this.statusLabel.setText(this.run.getStatus().toString());
            this.elapsedTimeLabel.setText(new Long(this.run.getElapsedMins()).toString());
            this.problemNameLabel.setText(this.getContest().getProblem(this.run.getProblemId()).toString());
            this.languageNameLabel.setText(this.getContest().getLanguage(this.run.getLanguageId()).toString());
            boolean showFile = this.getProblemDataFiles() != null && this.getProblemDataFiles().getJudgesAnswerFile() != null;
            this.getViewAnswerFileButton().setVisible(showFile);
            showFile = this.getProblemDataFiles() != null && this.getProblemDataFiles().getJudgesDataFile() != null;
            this.getViewDataFileButton().setVisible(showFile);
            this.getViewSourceButton().setVisible(true);
            JudgementRecord computerJudgement = theRun.getComputerJudgementRecord();
            RunResultFiles matchingResult = null;
            if (computerJudgement != null && this.runResultFiles != null) {
                for (int i = 0; i < this.runResultFiles.length; ++i) {
                    if (!this.runResultFiles[i].getJudgementId().equals(computerJudgement.getJudgementId())) continue;
                    matchingResult = this.runResultFiles[i];
                    this.buildFileViewer(matchingResult);
                    break;
                }
            }
            if (matchingResult != null) {
                String judgement = computerJudgement.getValidatorResultString();
                String oJudgement = this.getContest().getJudgement(matchingResult.getJudgementId()).toString();
                if (judgement == null || judgement.trim().equals("")) {
                    judgement = oJudgement;
                }
                this.validatorAnswer.setText(judgement);
                this.showValidatorControls(true, computerJudgement);
            } else {
                this.showValidatorControls(false);
            }
        } else {
            this.getAcceptChosenSelectionButton().setVisible(false);
            this.runInfoLabel.setText("Could not get run");
            this.statusLabel.setText("");
            this.elapsedTimeLabel.setText("");
            this.problemNameLabel.setText("");
            this.languageNameLabel.setText("");
            this.getViewAnswerFileButton().setVisible(false);
            this.getViewDataFileButton().setVisible(false);
            this.getViewSourceButton().setVisible(false);
            this.showValidatorControls(false);
        }
        this.reloadComboBoxes();
        this.populatingGUI = false;
    }

    private void buildFileViewer(RunResultFiles files) {
        MultipleFileViewer mfv = new MultipleFileViewer(this.log, "Executable");
        boolean showOutput = false;
        showOutput |= this.addFilePane(mfv, "Compiler stdout", files.getCompilerStdoutFile());
        showOutput |= this.addFilePane(mfv, "Compiler stderr", files.getCompilerStderrFile());
        showOutput |= this.addFilePane(mfv, "Program stdout", files.getExecuteStdoutFile());
        showOutput |= this.addFilePane(mfv, "Program stderr", files.getExecuteStderrFile());
        showOutput |= this.addFilePane(mfv, "Validator stdout", files.getValidatorStdoutFile());
        showOutput |= this.addFilePane(mfv, "Validator stderr", files.getValidatorStderrFile());
        long code = files.getExecutionResultCode();
        if (code != 0L) {
            long returnValue = code << 32 >>> 32;
            mfv.setInformationLabelText("<html><font size='+1' color='red'>Team program exit code = 0x" + Long.toHexString(returnValue).toUpperCase() + "</font>");
            showOutput = true;
        } else {
            mfv.setInformationLabelText("");
        }
        this.executableFileViewer = mfv;
        this.enableOutputsButton(showOutput);
    }

    private boolean addFilePane(MultipleFileViewer mfv, String title, SerializedFile inFile) {
        boolean success = false;
        if (inFile != null) {
            success = mfv.addFilePane(title, inFile);
        }
        return success;
    }

    protected void regularCursor() {
        FrameUtilities.regularCursor(this);
    }

    private void reloadComboBoxes() {
        int selectedIndex = -1;
        int index = 0;
        this.getJudgementComboBox().removeAllItems();
        if (this.run == null) {
            return;
        }
        selectedIndex = -1;
        index = 0;
        ElementId judgementId = null;
        if (this.run.isJudged()) {
            judgementId = this.run.getJudgementRecord().getJudgementId();
        }
        for (Judgement judgement : this.getContest().getJudgements()) {
            if (!judgement.isActive()) continue;
            this.getJudgementComboBox().addItem(judgement);
            if (judgement.getElementId().equals(judgementId)) {
                selectedIndex = index;
            }
            ++index;
        }
        this.getJudgementComboBox().setSelectedIndex(selectedIndex);
    }

    public void setEnabledButtonStatus(boolean b) {
        this.getExecuteButton().setEnabled(b && this.runFiles != null);
        this.getJudgementComboBox().setEnabled(b && this.runFiles != null);
        this.getCancelButton().setEnabled(b);
        this.getAcceptValidatorJudgementButton().setEnabled(b);
        this.getViewOutputsButton().setEnabled(b);
        this.getAcceptChosenSelectionButton().setEnabled(b && this.getJudgementComboBox().getSelectedIndex() != -1);
    }

    public void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        this.getExecuteButton().setEnabled(this.runFiles != null);
        this.getViewSourceButton().setEnabled(this.runFiles != null);
        this.getJudgementComboBox().setEnabled(this.runFiles != null);
        this.getNotifyTeamCheckBox().setEnabled(this.runFiles != null);
        this.getAcceptChosenSelectionButton().setEnabled(editedText);
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.run != null) {
            enableButton |= this.judgementChanged();
        }
        this.enableUpdateButtons(enableButton);
    }

    private void enableOutputsButton(boolean b) {
        this.getViewOutputsButton().setEnabled(b);
    }

    private boolean judgementChanged() {
        if (this.run.isJudged()) {
            Judgement judgement = (Judgement)this.getJudgementComboBox().getSelectedItem();
            if (judgement != null) {
                return !this.run.getJudgementRecord().getJudgementId().equals(judgement.getElementId());
            }
        } else if (this.getJudgementComboBox().getSelectedIndex() > -1) {
            return true;
        }
        return false;
    }

    private JPanel getRunInfoPanel() {
        if (this.runInfoPanel == null) {
            TitledBorder titledBorder1 = BorderFactory.createTitledBorder(null, "Run Information", 0, 0, new Font("Dialog", 1, 18), new Color(51, 51, 51));
            titledBorder1.setBorder(BorderFactory.createEtchedBorder(0));
            titledBorder1.setTitleFont(new Font("Dialog", 1, 16));
            this.runInfoLabel = new JLabel();
            this.runInfoLabel.setBounds(new Rectangle(146, 21, 330, 20));
            this.runInfoLabel.setFont(new Font("Dialog", 1, 14));
            this.runInfoLabel.setText("            ");
            this.elapsedTimeLabel = new JLabel();
            this.elapsedTimeLabel.setText("<unknown>");
            this.elapsedTimeLabel.setSize(new Dimension(180, 19));
            this.elapsedTimeLabel.setLocation(new Point(95, 75));
            this.elapsedTimeLabel.setBounds(new Rectangle(473, 52, 102, 25));
            this.elapsedTimeLabel.setFont(new Font("Dialog", 1, 14));
            this.elapsedTimeLabel.setHorizontalAlignment(2);
            this.languageNameLabel = new JLabel();
            this.languageNameLabel.setText("<unknown>");
            this.languageNameLabel.setSize(new Dimension(211, 19));
            this.languageNameLabel.setLocation(new Point(385, 75));
            this.languageNameLabel.setBounds(new Rectangle(177, 82, 199, 26));
            this.languageNameLabel.setFont(new Font("Dialog", 1, 14));
            this.languageNameLabel.setHorizontalAlignment(2);
            this.problemNameLabel = new JLabel();
            this.problemNameLabel.setText("<unknown>");
            this.problemNameLabel.setSize(new Dimension(212, 19));
            this.problemNameLabel.setLocation(new Point(385, 45));
            this.problemNameLabel.setBounds(new Rectangle(177, 51, 215, 26));
            this.problemNameLabel.setFont(new Font("Dialog", 1, 14));
            this.problemNameLabel.setHorizontalAlignment(2);
            this.elapsedTitleLabel = new JLabel();
            this.elapsedTitleLabel.setText("Time: ");
            this.elapsedTitleLabel.setLocation(new Point(25, 75));
            this.elapsedTitleLabel.setSize(new Dimension(58, 19));
            this.elapsedTitleLabel.setBounds(new Rectangle(404, 52, 58, 26));
            this.elapsedTitleLabel.setFont(new Font("Dialog", 1, 14));
            this.elapsedTitleLabel.setHorizontalAlignment(4);
            this.languageTitleLabel = new JLabel();
            this.languageTitleLabel.setText("Language: ");
            this.languageTitleLabel.setLocation(new Point(295, 75));
            this.languageTitleLabel.setSize(new Dimension(77, 19));
            this.languageTitleLabel.setBounds(new Rectangle(83, 81, 90, 28));
            this.languageTitleLabel.setFont(new Font("Dialog", 1, 14));
            this.languageTitleLabel.setHorizontalAlignment(4);
            this.problemTitleLabel = new JLabel();
            this.problemTitleLabel.setText("Problem: ");
            this.problemTitleLabel.setLocation(new Point(295, 45));
            this.problemTitleLabel.setSize(new Dimension(80, 19));
            this.problemTitleLabel.setBounds(new Rectangle(82, 52, 90, 23));
            this.problemTitleLabel.setFont(new Font("Dialog", 1, 14));
            this.problemTitleLabel.setHorizontalAlignment(4);
            this.statusTitleLabel = new JLabel();
            this.statusTitleLabel.setHorizontalAlignment(4);
            this.statusTitleLabel.setLocation(new Point(11, 43));
            this.statusTitleLabel.setSize(new Dimension(75, 23));
            this.statusTitleLabel.setBounds(new Rectangle(399, 85, 62, 26));
            this.statusTitleLabel.setFont(new Font("Dialog", 1, 14));
            this.statusTitleLabel.setText("Status: ");
            this.statusLabel = new JLabel();
            this.statusLabel.setHorizontalAlignment(2);
            this.statusLabel.setSize(new Dimension(191, 21));
            this.statusLabel.setLocation(new Point(95, 45));
            this.statusLabel.setBounds(new Rectangle(472, 85, 219, 25));
            this.statusLabel.setFont(new Font("Dialog", 1, 14));
            this.statusLabel.setText("<unknown>");
            this.runInfoPanel = new JPanel();
            this.runInfoPanel.setLayout(null);
            this.runInfoPanel.setPreferredSize(new Dimension(250, 125));
            this.runInfoPanel.setBorder(titledBorder1);
            this.runInfoPanel.add((Component)this.runInfoLabel, null);
            this.runInfoPanel.add((Component)this.statusLabel, null);
            this.runInfoPanel.add((Component)this.statusTitleLabel, null);
            this.runInfoPanel.add((Component)this.problemTitleLabel, null);
            this.runInfoPanel.add((Component)this.languageTitleLabel, null);
            this.runInfoPanel.add((Component)this.elapsedTitleLabel, null);
            this.runInfoPanel.add((Component)this.problemNameLabel, null);
            this.runInfoPanel.add((Component)this.languageNameLabel, null);
            this.runInfoPanel.add((Component)this.elapsedTimeLabel, null);
            this.runInfoPanel.add((Component)this.getShellButton(), null);
        }
        return this.runInfoPanel;
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectJudgementPaneNew.this.messageLabel.setText(message);
            }
        });
    }

    public JButton getExecuteButton() {
        if (this.executeButton == null) {
            this.executeButton = new JButton();
            this.executeButton.setText("Execute Run");
            this.executeButton.setActionCommand("Execute");
            this.executeButton.setBounds(new Rectangle(60, 120, 129, 26));
            this.executeButton.setLocation(new Point(60, 99));
            this.executeButton.setSize(new Dimension(131, 36));
            this.executeButton.setHorizontalTextPosition(0);
            this.executeButton.setMnemonic(88);
            this.executeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new Thread(new Runnable(){

                        public void run() {
                            SelectJudgementPaneNew.this.executeRun();
                        }
                    }).start();
                }
            });
        }
        return this.executeButton;
    }

    private JButton getViewSourceButton() {
        if (this.viewSourceButton == null) {
            this.viewSourceButton = new JButton();
            this.viewSourceButton.setText("View Source");
            this.viewSourceButton.setMnemonic(86);
            this.viewSourceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPaneNew.this.viewSourceFile();
                }
            });
        }
        return this.viewSourceButton;
    }

    private JButton getExtractButton() {
        if (this.extractButton == null) {
            this.extractButton = new JButton();
            this.extractButton.setText("Extract");
            this.extractButton.setMnemonic(84);
            this.extractButton.setVisible(false);
            this.extractButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPaneNew.this.extractRun();
                }
            });
        }
        return this.extractButton;
    }

    protected void extractRun() {
        this.showMessage("Would have extracted run");
    }

    protected void executeRun() {
        ExecutionData eData;
        ElementId elementId;
        System.gc();
        this.executable = new Executable(this.getContest(), this.getController(), this.run, this.runFiles);
        if (this.executableFileViewer != null) {
            this.executableFileViewer.dispose();
        }
        this.setEnabledButtonStatus(false);
        this.executableFileViewer = this.executable.execute();
        JudgementRecord judgementRecord = null;
        this.showValidatorControls(false);
        if (this.executable.isValidationSuccess()) {
            String results = this.executable.getValidationResults();
            if (results != null && results.trim().length() > 1) {
                if (results.equalsIgnoreCase("accepted") || results.equalsIgnoreCase("yes")) {
                    results = this.getContest().getJudgements()[0].getDisplayName();
                }
                this.validatorAnswer.setText(results);
                boolean solved = false;
                elementId = this.getValidatorResultElementID(results);
                Judgement yesJudgement = this.getContest().getJudgements()[0];
                if (yesJudgement.getElementId().equals(elementId)) {
                    solved = true;
                }
                judgementRecord = new JudgementRecord(elementId, this.run.getSubmitter(), solved, true);
                judgementRecord.setValidatorResultString(results);
                judgementRecord.setSendToTeam(this.getNotifyTeamCheckBox().isSelected());
                this.showValidatorControls(true, judgementRecord);
            } else {
                this.log.warning("execute indicated validator success but getValidationResults returns \"\" or null");
            }
        }
        if ((eData = this.executable.getExecutionData()) != null && !eData.isCompileSuccess()) {
            String results = "No - Compilation Error";
            this.validatorAnswer.setText(results);
            this.showValidatorControls(true);
            elementId = this.getValidatorResultElementID(results);
            judgementRecord = new JudgementRecord(elementId, this.run.getSubmitter(), false, true);
            judgementRecord.setValidatorResultString(results);
            judgementRecord.setSendToTeam(this.getNotifyTeamCheckBox().isSelected());
        }
        if (!this.getContest().getProblem(this.run.getProblemId()).isHideOutputWindow()) {
            this.executableFileViewer.setVisible(true);
        }
        this.enableOutputsButton(true);
        this.setEnabledButtonStatus(true);
    }

    private void showValidatorControls(boolean b, JudgementRecord judgementRecord) {
        this.showValidatorControls(b);
        String toolTip = "";
        if (b) {
            String oJudgement;
            Color color = Color.RED;
            boolean enableButton = true;
            String judgement = judgementRecord.getValidatorResultString();
            if (!judgement.equals(oJudgement = this.getContest().getJudgement(judgementRecord.getJudgementId()).toString())) {
                enableButton = false;
                color = Color.BLACK;
                toolTip = "NOTE: This response does not match any defined Judgements.";
            } else if (judgementRecord.isSolved()) {
                color = Color.green;
            }
            this.validatorAnswer.setForeground(color);
            this.getAcceptValidatorJudgementButton().setEnabled(enableButton);
        }
        this.validatorAnswer.setToolTipText(toolTip);
    }

    public void setRunAndFiles(Run theRun, RunFiles runFiles2, RunResultFiles[] theRunResultFiles) {
        FrameUtilities.regularCursor(this);
        this.showMessage("");
        this.log.info("Fetched run " + theRun + " to edit");
        TimeZone tz = TimeZone.getTimeZone("GMT");
        this.startTimeCalendar = new GregorianCalendar(tz);
        this.run = theRun;
        this.runFiles = runFiles2;
        this.runResultFiles = theRunResultFiles;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectJudgementPaneNew.this.populateGUI(SelectJudgementPaneNew.this.run);
                SelectJudgementPaneNew.this.enableUpdateButtons(false);
            }
        });
    }

    private JComboBox getJudgementComboBox() {
        if (this.judgementComboBox == null) {
            this.judgementComboBox = new JComboBox();
            this.judgementComboBox.setMinimumSize(new Dimension(150, 25));
            this.judgementComboBox.setBounds(new Rectangle(225, 120, 225, 25));
            this.judgementComboBox.setLocation(new Point(225, 101));
            this.judgementComboBox.setSize(new Dimension(271, 33));
            this.judgementComboBox.setPreferredSize(new Dimension(150, 25));
            this.judgementComboBox.setMaximumRowCount(15);
            this.judgementComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPaneNew.this.enableUpdateButton();
                }
            });
        }
        return this.judgementComboBox;
    }

    private String getExecuteDirectoryName() {
        Executable tempEexecutable = new Executable(this.getContest(), this.getController(), this.run, this.runFiles);
        return tempEexecutable.getExecuteDirectoryName();
    }

    private void createAndViewFile(IFileViewer fileViewer, SerializedFile file, String title, boolean visible) {
        String targetDirectory = this.getExecuteDirectoryName();
        Utilities.insureDir(targetDirectory);
        String targetFileName = targetDirectory + File.separator + file.getName();
        try {
            file.writeFile(targetFileName);
            if (new File(targetFileName).isFile()) {
                fileViewer.addFilePane(title, targetFileName);
            } else {
                fileViewer.addTextPane(title, "Could not create file at " + targetFileName);
            }
        }
        catch (IOException e) {
            fileViewer.addTextPane(title, "Could not create file at " + targetFileName + "Exception " + e.getMessage());
        }
        if (visible) {
            fileViewer.setVisible(true);
        }
    }

    private JCheckBox getNotifyTeamCheckBox() {
        if (this.notifyTeamCheckBox == null) {
            this.notifyTeamCheckBox = new JCheckBox();
            this.notifyTeamCheckBox.setSelected(true);
            this.notifyTeamCheckBox.setBounds(new Rectangle(578, 65, 119, 30));
            this.notifyTeamCheckBox.setText("Notify Team");
        }
        return this.notifyTeamCheckBox;
    }

    private String getTeamDisplayName(ClientId clientId) {
        if (this.isJudge() && this.isTeam(clientId)) {
            return this.displayTeamName.getDisplayName(clientId);
        }
        return clientId.getName();
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private boolean isTeam(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.TEAM);
    }

    private boolean isJudge(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    private boolean isJudge() {
        return this.isJudge(this.getContest().getClientId());
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.extractButton.setVisible(this.isAllowed(Permission.Type.EXTRACT_RUNS));
    }

    private JButton getAcceptValidatorJudgementButton() {
        if (this.acceptValidatorJudgementButton == null) {
            this.acceptValidatorJudgementButton = new JButton();
            this.acceptValidatorJudgementButton.setText("Accept Validator");
            this.acceptValidatorJudgementButton.setPreferredSize(new Dimension(150, 26));
            this.acceptValidatorJudgementButton.setBounds(new Rectangle(479, 46, 150, 26));
            this.acceptValidatorJudgementButton.setSize(new Dimension(167, 34));
            this.acceptValidatorJudgementButton.setLocation(new Point(554, 27));
            this.acceptValidatorJudgementButton.setForeground(Color.BLUE);
            this.acceptValidatorJudgementButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPaneNew.this.acceptValidatorJudgement();
                }
            });
        }
        return this.acceptValidatorJudgementButton;
    }

    private void showValidatorControls(boolean showControls) {
        this.validatorAnswerLabel.setVisible(showControls);
        this.validatorAnswer.setVisible(showControls);
        this.getAcceptValidatorJudgementButton().setVisible(showControls);
    }

    private ElementId getValidatorResultElementID(String results) {
        ElementId elementId = this.getContest().getJudgements()[1].getElementId();
        for (Judgement judgement : this.getContest().getJudgements()) {
            if (!judgement.getDisplayName().equals(results)) continue;
            elementId = judgement.getElementId();
        }
        Judgement yesJudgement = this.getContest().getJudgements()[0];
        if (yesJudgement.getDisplayName().equalsIgnoreCase(results)) {
            elementId = yesJudgement.getElementId();
        }
        return elementId;
    }

    protected void acceptValidatorJudgement() {
        String message;
        int result;
        Judgement autoJudgement;
        Judgement manualJudgement;
        Run newRun = this.getRunFromFields();
        this.enableUpdateButtons(false);
        this.closeViewerWindows();
        RunResultFiles newRunResultFiles = null;
        JudgementRecord judgementRecord = null;
        String results = this.validatorAnswer.getText();
        boolean solved = false;
        ElementId elementId = this.getValidatorResultElementID(results);
        Judgement yesJudgement = this.getContest().getJudgements()[0];
        if (yesJudgement.getElementId().equals(elementId)) {
            solved = true;
        }
        if (this.getJudgementComboBox().getSelectedIndex() > -1 && !(manualJudgement = (Judgement)this.getJudgementComboBox().getSelectedItem()).equals(autoJudgement = this.getContest().getJudgement(elementId)) && (result = JOptionPane.showConfirmDialog(this, message = "You selected 'Accept Validator' but have manually selected '" + manualJudgement + "'.  Did you intend to accept '" + results + "'?")) != 0) {
            this.enableUpdateButtons(true);
            return;
        }
        newRun.setStatus(Run.RunStates.JUDGED);
        judgementRecord = new JudgementRecord(elementId, this.getContest().getClientId(), solved, true);
        judgementRecord.setValidatorResultString(results);
        judgementRecord.setSendToTeam(this.getNotifyTeamCheckBox().isSelected());
        TimeZone tz = TimeZone.getTimeZone("GMT");
        GregorianCalendar cal = new GregorianCalendar(tz);
        long milliDiff = cal.getTime().getTime() - this.startTimeCalendar.getTime().getTime();
        long totalSeconds = milliDiff / 1000L;
        judgementRecord.setHowLongToJudgeInSeconds(totalSeconds);
        JudgeView.setAlreadyJudgingRun(false);
        ExecutionData executionData = null;
        if (this.executable != null) {
            executionData = this.executable.getExecutionData();
        }
        newRunResultFiles = new RunResultFiles(newRun, newRun.getProblemId(), judgementRecord, executionData);
        this.getController().submitRunJudgement(newRun, judgementRecord, newRunResultFiles);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getViewDataFileButton() {
        if (this.viewDataFileButton == null) {
            this.viewDataFileButton = new JButton();
            this.viewDataFileButton.setText("View Data File");
            this.viewDataFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPaneNew.this.viewDataFile();
                }
            });
        }
        return this.viewDataFileButton;
    }

    private JButton getViewAnswerFileButton() {
        if (this.viewAnswerFileButton == null) {
            this.viewAnswerFileButton = new JButton();
            this.viewAnswerFileButton.setText("View Answer File");
            this.viewAnswerFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPaneNew.this.viewAnswerFile();
                }
            });
        }
        return this.viewAnswerFileButton;
    }

    private ProblemDataFiles getProblemDataFiles() {
        Problem problem = this.getContest().getProblem(this.run.getProblemId());
        return this.getContest().getProblemDataFile(problem);
    }

    protected void viewSourceFile() {
        if (this.sourceViewer != null) {
            this.sourceViewer.dispose();
        }
        this.sourceViewer = new MultipleFileViewer(this.getController().getLog());
        this.createAndViewFiles(this.sourceViewer, this.runFiles.getMainFile(), "Main File (" + this.runFiles.getMainFile().getName() + ")", this.runFiles.getOtherFiles());
    }

    private void createAndViewFiles(IFileViewer fileViewer, SerializedFile file, String title, SerializedFile[] otherFiles) {
        if (otherFiles != null && otherFiles.length > 0) {
            for (int i = otherFiles.length; i > 0; --i) {
                this.createAndViewFile(fileViewer, otherFiles[i - 1], otherFiles[i - 1].getName(), false);
            }
        }
        this.createAndViewFile(fileViewer, file, title, false);
        fileViewer.setSelectedIndex(0);
        fileViewer.setVisible(true);
    }

    protected void viewDataFile() {
        if (this.getProblemDataFiles() != null) {
            if (this.getProblemDataFiles().getJudgesDataFile() != null) {
                if (this.dataFileViewer != null) {
                    this.dataFileViewer.dispose();
                }
                this.dataFileViewer = new MultipleFileViewer(this.getController().getLog());
                this.createAndViewFile(this.dataFileViewer, this.getProblemDataFiles().getJudgesDataFile(), "Judge's data file", true);
            } else {
                JOptionPane.showMessageDialog(this, "No data file defined");
            }
        } else {
            JOptionPane.showMessageDialog(this, "No data file defined");
        }
    }

    protected void viewAnswerFile() {
        if (this.getProblemDataFiles() != null) {
            if (this.getProblemDataFiles().getJudgesAnswerFile() != null) {
                if (this.answerFileViewer != null) {
                    this.answerFileViewer.dispose();
                }
                this.answerFileViewer = new MultipleFileViewer(this.getController().getLog());
                this.createAndViewFile(this.answerFileViewer, this.getProblemDataFiles().getJudgesAnswerFile(), "Judge's answer file", true);
            } else {
                JOptionPane.showMessageDialog(this, "No Answer File defined");
            }
        } else {
            JOptionPane.showMessageDialog(this, "No Answer File defined");
        }
    }

    protected void viewOutputs() {
        if (this.executableFileViewer != null) {
            this.executableFileViewer.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "No output yet!");
        }
    }

    private JButton getShellButton() {
        if (this.shellButton == null) {
            this.shellButton = new JButton();
            this.shellButton.setText("Shell ");
            this.shellButton.setBounds(new Rectangle(509, 93, 65, 20));
            this.shellButton.setVisible(false);
            this.shellButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPaneNew.this.shellToExecuteDirectory();
                }
            });
        }
        return this.shellButton;
    }

    protected void shellToExecuteDirectory() {
        String executeDir = this.getExecuteDirectoryName();
        File runDir = new File(executeDir);
        Utilities.insureDir(executeDir);
        String fs = File.separator;
        String[] env = null;
        if (fs.equals("\\")) {
            System.out.println("win debug " + executeDir);
            try {
                Runtime.getRuntime().exec("cmd /C start cmd", env, runDir);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to run command cmd.exe " + e.getMessage());
                e.printStackTrace();
            }
        } else if (fs.equals("/")) {
            System.out.println("unix debug to " + executeDir);
            try {
                Runtime.getRuntime().exec("/bin/sh", env, runDir);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to run command /bin/sh " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("missed it " + fs);
        }
    }

    protected void setRunFiles(RunFiles inRunFiles) {
        this.runFiles = inRunFiles;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setPreferredSize(new Dimension(700, 300));
            this.mainPanel.add((Component)this.getRunInfoPanel(), "North");
            this.mainPanel.add((Component)this.getAssignJudgementPanel(), "Center");
        }
        return this.mainPanel;
    }

    private JPanel getAssignJudgementPanel() {
        if (this.assignJudgementPanel == null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.blue, 2), "Assign Judgement", 0, 0, new Font("Dialog", 1, 16), new Color(51, 51, 51));
            titledBorder.setBorder(BorderFactory.createLineBorder(Color.blue, 1));
            this.selectJudgementCheckboxLabel = new JLabel();
            this.selectJudgementCheckboxLabel.setBounds(new Rectangle(252, 75, 212, 19));
            this.selectJudgementCheckboxLabel.setHorizontalAlignment(0);
            this.selectJudgementCheckboxLabel.setText("Select Judgement");
            this.validatorAnswer = new JLabel();
            this.validatorAnswer.setBounds(new Rectangle(299, 30, 196, 31));
            this.validatorAnswer.setFont(new Font("Dialog", 1, 14));
            this.validatorAnswer.setForeground(Color.RED);
            this.validatorAnswer.setText("<unknown>");
            this.validatorAnswerLabel = new JLabel();
            this.validatorAnswerLabel.setBounds(new Rectangle(75, 30, 211, 30));
            this.validatorAnswerLabel.setHorizontalAlignment(11);
            this.validatorAnswerLabel.setFont(new Font("Dialog", 1, 14));
            this.validatorAnswerLabel.setText("Validator Recommends: ");
            this.validatorAnswerLabel.setHorizontalAlignment(0);
            this.assignJudgementPanel = new JPanel();
            this.assignJudgementPanel.setLayout(null);
            this.assignJudgementPanel.setPreferredSize(new Dimension(700, 300));
            this.assignJudgementPanel.setMaximumSize(new Dimension(1280, 1280));
            this.assignJudgementPanel.setBorder(titledBorder);
            this.assignJudgementPanel.add((Component)this.getExecuteButton(), null);
            this.assignJudgementPanel.add((Component)this.getJudgementComboBox(), null);
            this.assignJudgementPanel.add((Component)this.getAcceptChosenSelectionButton(), null);
            this.assignJudgementPanel.add((Component)this.getAcceptValidatorJudgementButton(), null);
            this.assignJudgementPanel.add((Component)this.getNotifyTeamCheckBox(), null);
            this.assignJudgementPanel.add((Component)this.validatorAnswerLabel, null);
            this.assignJudgementPanel.add((Component)this.validatorAnswer, null);
            this.assignJudgementPanel.add((Component)this.selectJudgementCheckboxLabel, null);
        }
        return this.assignJudgementPanel;
    }

    private JButton getDetailsButton() {
        if (this.detailsButton == null) {
            this.detailsButton = new JButton();
            this.detailsButton.setText("Details...");
            this.detailsButton.setEnabled(false);
            this.detailsButton.setVisible(false);
        }
        return this.detailsButton;
    }

    private JButton getViewOutputsButton() {
        if (this.viewOutputsButton == null) {
            this.viewOutputsButton = new JButton();
            this.viewOutputsButton.setActionCommand("View Outputs");
            this.viewOutputsButton.setEnabled(false);
            this.viewOutputsButton.setToolTipText("Show compiler/execution/validator stdout/err where available");
            this.viewOutputsButton.setText("View Outputs");
            this.viewOutputsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SelectJudgementPaneNew.this.viewOutputs();
                }
            });
        }
        return this.viewOutputsButton;
    }

    private class JudgementListenerImplementation
    implements IJudgementListener {
        private JudgementListenerImplementation() {
        }

        public void judgementAdded(JudgementEvent event) {
            SelectJudgementPaneNew.this.reloadComboBoxes();
        }

        public void judgementChanged(JudgementEvent event) {
            SelectJudgementPaneNew.this.reloadComboBoxes();
        }

        public void judgementRemoved(JudgementEvent event) {
            SelectJudgementPaneNew.this.reloadComboBoxes();
        }

        public void judgementRefreshAll(JudgementEvent judgementEvent) {
            SelectJudgementPaneNew.this.reloadComboBoxes();
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SelectJudgementPaneNew.this.initializePermissions();
                    SelectJudgementPaneNew.this.updateGUIperPermissions();
                }
            });
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SelectJudgementPaneNew.this.initializePermissions();
                    SelectJudgementPaneNew.this.updateGUIperPermissions();
                }
            });
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SelectJudgementPaneNew.this.initializePermissions();
                    SelectJudgementPaneNew.this.updateGUIperPermissions();
                }
            });
        }
    }
}

