/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.event.ListboxEvent;
import com.ibm.webrunner.j2mclb.event.ListboxListener;
import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.BalloonSettingsEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.DisplayTeamName;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILanguageListener;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageEvent;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.RunUtilities;
import edu.csus.ecs.pc2.core.report.ExtractRuns;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.AccountColumnComparator;
import edu.csus.ecs.pc2.ui.AutoJudgingMonitor;
import edu.csus.ecs.pc2.ui.EditFilterFrame;
import edu.csus.ecs.pc2.ui.EditFilterPane;
import edu.csus.ecs.pc2.ui.EditRunFrame;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.SelectJudgementFrame;
import edu.csus.ecs.pc2.ui.ViewJudgementsFrame;
import edu.csus.ecs.pc2.ui.judge.JudgeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class RunsPanel
extends JPanePlugin {
    private static final long serialVersionUID = 114647004580210428L;
    private MCLB runListBox = null;
    private JPanel messagePanel = null;
    private JPanel buttonPanel = null;
    private JButton requestRunButton = null;
    private JButton filterButton = null;
    private JButton editRunButton = null;
    private JButton extractButton = null;
    private JButton giveButton = null;
    private JButton takeButton = null;
    private JButton rejudgeRunButton = null;
    private JButton viewJudgementsButton = null;
    private PermissionList permissionList = new PermissionList();
    private EditRunFrame editRunFrame = null;
    private ViewJudgementsFrame viewJudgementsFrame = null;
    private SelectJudgementFrame selectJudgementFrame = null;
    private JLabel messageLabel = null;
    private Log log = null;
    private JLabel rowCountLabel = null;
    private boolean showNewRunsOnly = false;
    private Filter requiredFilter = new Filter();
    private boolean showJudgesInfo = true;
    private Filter filter = new Filter();
    private JButton autoJudgeButton = null;
    private AutoJudgingMonitor autoJudgingMonitor = new AutoJudgingMonitor();
    private boolean usingTeamColumns = false;
    private boolean usingFullColumns = false;
    private DisplayTeamName displayTeamName = null;
    private boolean makeSoundOnOneRun = false;
    private boolean bUseAutoJudgemonitor = true;
    private EditFilterFrame editFilterFrame = null;
    private String filterFrameTitle = "Run filter";
    private ExtractRuns extractRuns = null;
    private boolean teamClient = true;
    private JudgementNotificationsList judgementNotificationsList = null;
    private boolean displayConfirmation = true;

    public RunsPanel() {
        this.initialize();
    }

    public RunsPanel(boolean useAutoJudgeMonitor) {
        this.bUseAutoJudgemonitor = useAutoJudgeMonitor;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(744, 216));
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)((Object)this.getRunsListBox()), "Center");
        this.add((Component)this.getMessagePanel(), "North");
        this.editRunFrame = new EditRunFrame();
        this.viewJudgementsFrame = new ViewJudgementsFrame();
        this.selectJudgementFrame = new SelectJudgementFrame();
    }

    public String getPluginTitle() {
        return "Runs Panel";
    }

    protected Object[] buildRunRow(Run run, ClientId judgeId) {
        try {
            boolean autoJudgedRun = this.isAutoJudgedRun(run);
            int cols = this.runListBox.getColumnCount();
            Object[] s = new String[cols];
            int idx = 0;
            if (this.usingFullColumns) {
                s[idx++] = this.getSiteTitle("" + run.getSubmitter().getSiteNumber());
                s[idx++] = this.getTeamDisplayName(run);
                s[idx++] = new Long(run.getNumber()).toString();
                s[idx++] = new Long(run.getElapsedMins()).toString();
                s[idx++] = this.getJudgementResultString(run);
                s[idx++] = this.isJudgementSuppressed(run);
                s[idx++] = this.getProblemTitle(run.getProblemId());
                s[idx++] = this.getJudgesTitle(run, judgeId, this.showJudgesInfo, autoJudgedRun);
                s[idx++] = this.getBalloonColor(run);
                s[idx++] = this.getLanguageTitle(run.getLanguageId());
                s[idx++] = run.getSystemOS();
            } else if (this.showJudgesInfo) {
                s[idx++] = this.getSiteTitle("" + run.getSubmitter().getSiteNumber());
                s[idx++] = this.getTeamDisplayName(run);
                s[idx++] = new Long(run.getNumber()).toString();
                s[idx++] = new Long(run.getElapsedMins()).toString();
                s[idx++] = this.getJudgementResultString(run);
                s[idx++] = this.getProblemTitle(run.getProblemId());
                s[idx++] = this.getBalloonColor(run);
                s[idx++] = this.getLanguageTitle(run.getLanguageId());
                s[idx++] = run.getSystemOS();
            } else if (this.usingTeamColumns) {
                s[idx++] = this.getSiteTitle("" + run.getSubmitter().getSiteNumber());
                s[idx++] = new Long(run.getNumber()).toString();
                s[idx++] = this.getProblemTitle(run.getProblemId());
                s[idx++] = new Long(run.getElapsedMins()).toString();
                s[idx++] = this.getJudgementResultString(run);
                s[idx++] = this.getBalloonColor(run);
                s[idx++] = this.getLanguageTitle(run.getLanguageId());
            } else {
                this.log.log(Log.INFO, "In RunPanes no mclb columns set");
            }
            return s;
        }
        catch (Exception exception) {
            StaticLog.getLog().log(Log.INFO, "Exception in buildRunRow()", exception);
            return null;
        }
    }

    private String getBalloonColor(Run run) {
        String colorName;
        BalloonSettings balloonSettings;
        if (run.isSolved() && (balloonSettings = this.getContest().getBalloonSettings(run.getSiteNumber())) != null && (colorName = balloonSettings.getColor(run.getProblemId())) != null) {
            return colorName;
        }
        return "";
    }

    private String isJudgementSuppressed(Run run) {
        String result = "";
        if (run.isJudged()) {
            Problem prob;
            if (!run.getJudgementRecord().isSendToTeam()) {
                result = "Yes";
            } else if (RunUtilities.supppressJudgement(this.judgementNotificationsList, run, this.getContest().getContestTime())) {
                result = "Yes (EOC)";
            } else if (run.getJudgementRecord().isPreliminaryJudgement() && !(prob = this.getContest().getProblem(run.getProblemId())).isPrelimaryNotification()) {
                result = "Yes";
            }
        }
        return result;
    }

    private String getJudgesTitle(Run run, ClientId judgeId, boolean showJudgesInfo2, boolean autoJudgedRun) {
        String result = "";
        if (this.showJudgesInfo) {
            if (judgeId != null) {
                result = judgeId.equals(this.getContest().getClientId()) ? "Me" : judgeId.getName() + " S" + judgeId.getSiteNumber();
                if (autoJudgedRun) {
                    result = result + "/AJ";
                }
            } else {
                result = "";
            }
        }
        return result;
    }

    private boolean isAutoJudgedRun(Run run) {
        JudgementRecord judgementRecord;
        if (run.isJudged() && !run.isSolved() && (judgementRecord = run.getJudgementRecord()) != null && judgementRecord.getJudgementId() != null) {
            return judgementRecord.isUsedValidator();
        }
        return false;
    }

    protected String getJudgementResultString(Run run) {
        String result = "";
        if (run.isJudged()) {
            if (run.isSolved()) {
                result = "Yes";
                if (run.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW)) {
                    result = !this.isTeam(this.getContest().getClientId()) ? (Object)((Object)Run.RunStates.MANUAL_REVIEW) + " (" + result + ")" : (this.showPreliminaryJudgementToTeam(run) ? "PRELIMINARY (" + result + ")" : Run.RunStates.NEW.toString());
                }
                if (this.isTeam(this.getContest().getClientId()) && !run.getJudgementRecord().isSendToTeam()) {
                    result = Run.RunStates.NEW.toString();
                }
            } else {
                result = "No";
                JudgementRecord judgementRecord = run.getJudgementRecord();
                if (judgementRecord != null && judgementRecord.getJudgementId() != null) {
                    if (judgementRecord.isUsedValidator() && judgementRecord.getValidatorResultString() != null) {
                        result = judgementRecord.getValidatorResultString();
                    } else {
                        Judgement judgement = this.getContest().getJudgement(judgementRecord.getJudgementId());
                        if (judgement != null) {
                            result = judgement.toString();
                        }
                    }
                    if (run.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW)) {
                        result = !this.isTeam(this.getContest().getClientId()) ? (Object)((Object)Run.RunStates.MANUAL_REVIEW) + " (" + result + ")" : (this.showPreliminaryJudgementToTeam(run) ? "PRELIMINARY (" + result + ")" : Run.RunStates.NEW.toString());
                    }
                    if (this.isTeam(this.getContest().getClientId())) {
                        if (!judgementRecord.isSendToTeam()) {
                            result = Run.RunStates.NEW.toString();
                        }
                    } else if (run.getStatus().equals((Object)Run.RunStates.BEING_RE_JUDGED)) {
                        result = Run.RunStates.BEING_RE_JUDGED.toString();
                    }
                }
            }
            if ((this.teamClient || this.isAllowed(Permission.Type.RESPECT_EOC_SUPPRESSION)) && RunUtilities.supppressJudgement(this.judgementNotificationsList, run, this.getContest().getContestTime())) {
                result = Run.RunStates.NEW.toString();
            }
        } else {
            result = this.showJudgesInfo ? run.getStatus().toString() : Run.RunStates.NEW.toString();
        }
        if (run.isDeleted()) {
            result = "DEL " + result;
        }
        return result;
    }

    private boolean showPreliminaryJudgementToTeam(Run run) {
        try {
            Problem problem = this.getContest().getProblem(run.getProblemId());
            return problem.isPrelimaryNotification();
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception trying to get Problem  ", e);
            return false;
        }
    }

    private boolean isTeam(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.TEAM);
    }

    private boolean isJudge(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    private boolean isJudge() {
        return this.isJudge(this.getContest().getClientId());
    }

    private String getLanguageTitle(ElementId languageId) {
        for (Language language : this.getContest().getLanguages()) {
            if (!language.getElementId().equals(languageId)) continue;
            return language.toString();
        }
        return "Language ?";
    }

    private String getProblemTitle(ElementId problemId) {
        Problem problem = this.getContest().getProblem(problemId);
        if (problem != null) {
            return problem.toString();
        }
        return "Problem ?";
    }

    private String getSiteTitle(String string) {
        return "Site " + string;
    }

    private String getTeamDisplayName(Run run) {
        if (this.isJudge() && this.isTeam(run.getSubmitter())) {
            return this.displayTeamName.getDisplayName(run.getSubmitter());
        }
        return run.getSubmitter().getName();
    }

    private MCLB getRunsListBox() {
        if (this.runListBox == null) {
            this.runListBox = new MCLB();
            this.runListBox.addListboxListener(new ListboxListener(){

                public void rowSelected(ListboxEvent e) {
                    if (RunsPanel.this.isAllowed(Permission.Type.JUDGE_RUN) && e.getClickCount() >= 2) {
                        RunsPanel.this.requestSelectedRun();
                    }
                }

                public void rowDeselected(ListboxEvent e) {
                }
            });
        }
        return this.runListBox;
    }

    public void clearAllRuns() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RunsPanel.this.runListBox.removeAllRows();
            }
        });
    }

    private void resetRunsListBoxColumns() {
        this.runListBox.removeAllRows();
        this.runListBox.removeAllColumns();
        Object[] fullColumns = new Object[]{"Site", "Team", "Run Id", "Time", "Status", "Suppressed", "Problem", "Judge", "Balloon", "Language", "OS"};
        Object[] fullColumnsNoJudge = new Object[]{"Site", "Team", "Run Id", "Time", "Status", "Problem", "Balloon", "Language", "OS"};
        Object[] teamColumns = new Object[]{"Site", "Run Id", "Problem", "Time", "Status", "Balloon", "Language"};
        this.usingTeamColumns = false;
        this.usingFullColumns = false;
        if (this.isTeam(this.getContest().getClientId())) {
            this.usingTeamColumns = true;
            this.runListBox.addColumns(teamColumns);
        } else if (!this.showJudgesInfo) {
            this.runListBox.addColumns(fullColumnsNoJudge);
        } else {
            this.usingFullColumns = true;
            this.runListBox.addColumns(fullColumns);
        }
        HeapSorter sorter = new HeapSorter();
        HeapSorter numericStringSorter = new HeapSorter();
        numericStringSorter.setComparator((Comparator)new NumericStringComparator());
        HeapSorter accountNameSorter = new HeapSorter();
        accountNameSorter.setComparator((Comparator)new AccountColumnComparator());
        int idx = 0;
        if (this.isTeam(this.getContest().getClientId())) {
            this.runListBox.setColumnSorter(idx++, sorter, 3);
            this.runListBox.setColumnSorter(idx++, numericStringSorter, 2);
            this.runListBox.setColumnSorter(idx++, sorter, 4);
            this.runListBox.setColumnSorter(idx++, numericStringSorter, 1);
            this.runListBox.setColumnSorter(idx++, sorter, 5);
            this.runListBox.setColumnSorter(idx++, sorter, 6);
            this.runListBox.setColumnSorter(idx++, sorter, 7);
        } else if (this.showJudgesInfo) {
            this.runListBox.setColumnSorter(idx++, sorter, 3);
            this.runListBox.setColumnSorter(idx++, accountNameSorter, 2);
            this.runListBox.setColumnSorter(idx++, numericStringSorter, 1);
            this.runListBox.setColumnSorter(idx++, numericStringSorter, 4);
            this.runListBox.setColumnSorter(idx++, sorter, 5);
            this.runListBox.setColumnSorter(idx++, sorter, 6);
            this.runListBox.setColumnSorter(idx++, accountNameSorter, 7);
            this.runListBox.setColumnSorter(idx++, sorter, 8);
            this.runListBox.setColumnSorter(idx++, sorter, 9);
            this.runListBox.setColumnSorter(idx++, sorter, 10);
        } else {
            this.runListBox.setColumnSorter(idx++, sorter, 2);
            this.runListBox.setColumnSorter(idx++, sorter, 3);
            this.runListBox.setColumnSorter(idx++, numericStringSorter, 1);
            this.runListBox.setColumnSorter(idx++, numericStringSorter, 4);
            this.runListBox.setColumnSorter(idx++, sorter, 5);
            this.runListBox.setColumnSorter(idx++, sorter, 6);
            this.runListBox.setColumnSorter(idx++, sorter, 7);
            this.runListBox.setColumnSorter(idx++, sorter, 8);
            this.runListBox.setColumnSorter(idx++, sorter, 9);
        }
        this.runListBox.autoSizeAllColumns();
    }

    private void removeRunRow(final Run run) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int rowNumber = RunsPanel.this.runListBox.getIndexByKey(run.getElementId());
                if (rowNumber != -1) {
                    RunsPanel.this.runListBox.removeRow(rowNumber);
                    RunsPanel.this.updateRowCount();
                }
            }
        });
    }

    private void updateRowCount() {
        if (this.filter.isFilterOn()) {
            int totalRuns = this.getContest().getRuns().length;
            this.rowCountLabel.setText(this.runListBox.getRowCount() + " of " + totalRuns);
            this.rowCountLabel.setToolTipText(this.runListBox.getRowCount() + " filtered runs");
        } else {
            this.rowCountLabel.setText("" + this.runListBox.getRowCount());
            this.rowCountLabel.setToolTipText(this.runListBox.getRowCount() + " runs");
        }
    }

    public void updateRunRow(final Run run, final ClientId whoModifiedId, final boolean autoSizeAndSort) {
        if (this.filter != null && !this.filter.matches(run)) {
            this.removeRunRow(run);
            return;
        }
        if (this.requiredFilter != null && !this.requiredFilter.matches(run)) {
            this.removeRunRow(run);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JudgementRecord judgementRecord;
                ClientId whoJudgedId = whoModifiedId;
                if (run.isJudged() && (judgementRecord = run.getJudgementRecord()) != null) {
                    whoJudgedId = judgementRecord.getJudgerClientId();
                }
                Object[] objects = RunsPanel.this.buildRunRow(run, whoJudgedId);
                int rowNumber = RunsPanel.this.runListBox.getIndexByKey(run.getElementId());
                if (rowNumber == -1) {
                    RunsPanel.this.runListBox.addRow(objects, run.getElementId());
                } else {
                    RunsPanel.this.runListBox.replaceRow(objects, rowNumber);
                }
                if (RunsPanel.this.isAllowed(Permission.Type.JUDGE_RUN) && RunsPanel.this.runListBox.getRowCount() == 1) {
                    RunsPanel.this.emitSound();
                }
                if (autoSizeAndSort) {
                    RunsPanel.this.updateRowCount();
                    RunsPanel.this.runListBox.autoSizeAllColumns();
                    RunsPanel.this.runListBox.sort();
                }
            }
        });
    }

    public void reloadRunList() {
        Run[] runs = this.getContest().getRuns();
        ContestInformation contestInformation = this.getContest().getContestInformation();
        this.judgementNotificationsList = contestInformation.getJudgementNotificationsList();
        if (this.isJudge()) {
            this.displayTeamName.setTeamDisplayMask(contestInformation.getTeamDisplayMode());
        }
        if (this.filter.isFilterOn()) {
            this.getFilterButton().setForeground(Color.BLUE);
            this.getFilterButton().setToolTipText("Edit filter - filter ON");
            this.rowCountLabel.setForeground(Color.BLUE);
        } else {
            this.getFilterButton().setForeground(Color.BLACK);
            this.getFilterButton().setToolTipText("Edit filter");
            this.rowCountLabel.setForeground(Color.BLACK);
        }
        for (Run run : runs) {
            JudgementRecord judgementRecord;
            if (this.requiredFilter != null && !this.requiredFilter.matches(run)) {
                this.removeRunRow(run);
                continue;
            }
            if (this.filter != null && !this.filter.matches(run)) {
                this.removeRunRow(run);
                continue;
            }
            ClientId clientId = null;
            Run.RunStates runStates = run.getStatus();
            if (!runStates.equals((Object)Run.RunStates.NEW) && !run.isDeleted() && (judgementRecord = run.getJudgementRecord()) != null) {
                clientId = judgementRecord.getJudgerClientId();
            }
            this.updateRunRow(run, clientId, false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RunsPanel.this.updateRowCount();
                RunsPanel.this.runListBox.autoSizeAllColumns();
                RunsPanel.this.runListBox.sort();
            }
        });
    }

    private void emitSound() {
        if (this.isMakeSoundOnOneRun()) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        if (this.showNewRunsOnly) {
            this.requestRunButton.setVisible(true);
            this.requestRunButton.setEnabled(this.isAllowed(Permission.Type.JUDGE_RUN));
            this.editRunButton.setVisible(false);
            this.extractButton.setVisible(false);
            this.giveButton.setVisible(false);
            this.takeButton.setVisible(false);
            this.rejudgeRunButton.setVisible(false);
            this.viewJudgementsButton.setVisible(false);
            this.autoJudgeButton.setVisible(false);
        } else {
            this.requestRunButton.setVisible(this.isAllowed(Permission.Type.JUDGE_RUN));
            this.editRunButton.setVisible(this.isAllowed(Permission.Type.EDIT_RUN));
            this.extractButton.setVisible(this.isAllowed(Permission.Type.EXTRACT_RUNS));
            this.giveButton.setVisible(this.isAllowed(Permission.Type.GIVE_RUN));
            this.takeButton.setVisible(false);
            this.rejudgeRunButton.setVisible(this.isAllowed(Permission.Type.REJUDGE_RUN));
            this.viewJudgementsButton.setVisible(this.isAllowed(Permission.Type.VIEW_RUN_JUDGEMENT_HISTORIES));
            this.autoJudgeButton.setVisible(this.isAllowed(Permission.Type.ALLOWED_TO_AUTO_JUDGE));
        }
        this.filterButton.setVisible(true);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.displayTeamName = new DisplayTeamName();
        this.displayTeamName.setContestAndController(inContest, inController);
        this.teamClient = this.isTeam(inContest.getClientId());
        ContestInformation contestInformation = this.getContest().getContestInformation();
        this.judgementNotificationsList = contestInformation.getJudgementNotificationsList();
        this.initializePermissions();
        this.extractRuns = new ExtractRuns(inContest);
        this.getContest().addRunListener(new RunListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addLanguageListener(new LanguageListenerImplementation());
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
        this.getContest().addBalloonSettingsListener(new BalloonSettingsListenerImplementation());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RunsPanel.this.editRunFrame.setContestAndController(RunsPanel.this.getContest(), RunsPanel.this.getController());
                RunsPanel.this.viewJudgementsFrame.setContestAndController(RunsPanel.this.getContest(), RunsPanel.this.getController());
                if (RunsPanel.this.isAllowed(Permission.Type.JUDGE_RUN)) {
                    RunsPanel.this.selectJudgementFrame.setContestAndController(RunsPanel.this.getContest(), RunsPanel.this.getController());
                }
                if (RunsPanel.this.bUseAutoJudgemonitor) {
                    RunsPanel.this.autoJudgingMonitor.setContestAndController(RunsPanel.this.getContest(), RunsPanel.this.getController());
                }
                RunsPanel.this.getEditFilterFrame().setContestAndController(RunsPanel.this.getContest(), RunsPanel.this.getController());
                RunsPanel.this.updateGUIperPermissions();
                RunsPanel.this.resetRunsListBoxColumns();
                RunsPanel.this.reloadRunList();
                if (RunsPanel.this.isAllowed(Permission.Type.EXTRACT_RUNS)) {
                    RunsPanel.this.getRunsListBox().setMultipleSelections(true);
                }
                if (RunsPanel.this.isAutoJudgingEnabled()) {
                    RunsPanel.this.startAutoJudging();
                }
            }
        });
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.rowCountLabel = new JLabel();
            this.rowCountLabel.setText("### of ###");
            this.rowCountLabel.setHorizontalAlignment(4);
            this.rowCountLabel.setPreferredSize(new Dimension(100, 16));
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setFont(new Font("Dialog", 1, 14));
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.setPreferredSize(new Dimension(30, 30));
            this.messagePanel.add((Component)this.messageLabel, "Center");
            this.messagePanel.add((Component)this.rowCountLabel, "East");
        }
        return this.messagePanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(5);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.setPreferredSize(new Dimension(35, 35));
            this.buttonPanel.add((Component)this.getGiveButton(), null);
            this.buttonPanel.add((Component)this.getTakeButton(), null);
            this.buttonPanel.add((Component)this.getEditRunButton(), null);
            this.buttonPanel.add((Component)this.getViewJudgementsButton(), null);
            this.buttonPanel.add((Component)this.getRequestRunButton(), null);
            this.buttonPanel.add((Component)this.getRejudgeRunButton(), null);
            this.buttonPanel.add((Component)this.getFilterButton(), null);
            this.buttonPanel.add((Component)this.getAutoJudgeButton(), null);
            this.buttonPanel.add((Component)this.getExtractButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getRequestRunButton() {
        if (this.requestRunButton == null) {
            this.requestRunButton = new JButton();
            this.requestRunButton.setText("Request Run");
            this.requestRunButton.setToolTipText("Request the selected Run for Judging");
            this.requestRunButton.setMnemonic(82);
            this.requestRunButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RunsPanel.this.requestSelectedRun();
                }
            });
        }
        return this.requestRunButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSelectedRun() {
        Boolean alreadyJudgingRun;
        if (!this.isAllowed(Permission.Type.JUDGE_RUN)) {
            this.log.log(Log.WARNING, "Account does not have permission to JUDGE_RUN, cannot requestSelectedRun.");
            this.showMessage("Unable to request run, check log");
            return;
        }
        int[] selectedIndexes = this.runListBox.getSelectedIndexes();
        if (selectedIndexes.length < 1) {
            this.showMessage("Please select a run ");
            return;
        }
        Boolean bl = alreadyJudgingRun = JudgeView.getAlreadyJudgingRun();
        synchronized (bl) {
            if (JudgeView.isAlreadyJudgingRun()) {
                JOptionPane.showMessageDialog(this, "Already judging run");
                return;
            }
            JudgeView.setAlreadyJudgingRun(true);
        }
        try {
            ElementId elementId = (ElementId)this.runListBox.getKeys()[selectedIndexes[0]];
            Run runToEdit = this.getContest().getRun(elementId);
            if (!runToEdit.getStatus().equals((Object)Run.RunStates.NEW) && !runToEdit.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW) || runToEdit.isDeleted()) {
                this.showMessage("Not allowed to request run (run not status NEW) ");
                JudgeView.setAlreadyJudgingRun(false);
                return;
            }
            this.selectJudgementFrame.setRun(runToEdit, false);
            this.selectJudgementFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to request run, check log");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rejudgeSelectedRun() {
        int[] selectedIndexes = this.runListBox.getSelectedIndexes();
        if (selectedIndexes.length < 1) {
            this.showMessage("Please select a run ");
            return;
        }
        try {
            Boolean alreadyJudgingRun;
            ElementId elementId = (ElementId)this.runListBox.getKeys()[selectedIndexes[0]];
            Run runToEdit = this.getContest().getRun(elementId);
            if (!runToEdit.isJudged()) {
                this.showMessage("Judge run before attempting to re-judge run");
                return;
            }
            if (runToEdit.isDeleted()) {
                this.showMessage("Not allowed to rejudge deleted run ");
                return;
            }
            Boolean bl = alreadyJudgingRun = JudgeView.getAlreadyJudgingRun();
            synchronized (bl) {
                if (JudgeView.isAlreadyJudgingRun()) {
                    JOptionPane.showMessageDialog(this, "Already judging run");
                    return;
                }
                JudgeView.setAlreadyJudgingRun(true);
            }
            this.selectJudgementFrame.setRun(runToEdit, true);
            this.selectJudgementFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to rejudge run, check log");
        }
    }

    private JButton getFilterButton() {
        if (this.filterButton == null) {
            this.filterButton = new JButton();
            this.filterButton.setText("Filter");
            this.filterButton.setToolTipText("Edit Filter");
            this.filterButton.setMnemonic(70);
            this.filterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RunsPanel.this.showFilterRunsFrame();
                }
            });
        }
        return this.filterButton;
    }

    protected void showFilterRunsFrame() {
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.PROBLEMS);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.JUDGEMENTS);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.LANGUAGES);
        if (!this.usingTeamColumns) {
            this.getEditFilterFrame().addList(EditFilterPane.ListNames.TEAM_ACCOUNTS);
            this.getEditFilterFrame().addList(EditFilterPane.ListNames.RUN_STATES);
        }
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.SITES);
        this.getEditFilterFrame().setFilter(this.filter);
        this.getEditFilterFrame().validate();
        this.getEditFilterFrame().setVisible(true);
    }

    private JButton getEditRunButton() {
        if (this.editRunButton == null) {
            this.editRunButton = new JButton();
            this.editRunButton.setText("Edit");
            this.editRunButton.setToolTipText("Edit the selected Run");
            this.editRunButton.setMnemonic(69);
            this.editRunButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RunsPanel.this.editSelectedRun();
                }
            });
        }
        return this.editRunButton;
    }

    protected void editSelectedRun() {
        int[] selectedIndexes = this.runListBox.getSelectedIndexes();
        if (selectedIndexes.length < 1) {
            this.showMessage("Please select a run ");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.runListBox.getKeys()[selectedIndexes[0]];
            Run runToEdit = this.getContest().getRun(elementId);
            this.editRunFrame.setRun(runToEdit);
            this.editRunFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit run, check log");
        }
    }

    private JButton getExtractButton() {
        if (this.extractButton == null) {
            this.extractButton = new JButton();
            this.extractButton.setText("Extract");
            this.extractButton.setMnemonic(88);
            this.extractButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RunsPanel.this.extractRuns(RunsPanel.this.getRunsListBox());
                }
            });
        }
        return this.extractButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractRuns(MCLB runsListBox) {
        if (this.runListBox.getRowCount() < 1) {
            this.showMessageToUser("No runs to extract");
            return;
        }
        int[] selectedRows = this.runListBox.getSelectedIndexes();
        try {
            if (selectedRows.length < 1) {
                int numRuns = runsListBox.getRowCount();
                String confirmMessage = "Extract ALL (" + numRuns + ") runs listed?";
                int response = FrameUtilities.yesNoCancelDialog(this, confirmMessage, "Extract Runs");
                if (response == 0) {
                    FrameUtilities.waitCursor(this);
                    int numberRuns = runsListBox.getRowCount();
                    int numExtracted = this.extractSelectedRuns(runsListBox, this.getRunKeys(runsListBox));
                    FrameUtilities.regularCursor(this);
                    this.showMessageToUser("Extracted " + numExtracted + " of " + numberRuns + " runs to \"" + this.extractRuns.getExtractDirectory() + "\" dir.");
                }
            } else {
                String confirmMsg = "Extract " + selectedRows.length + " runs?";
                int response = JOptionPane.showConfirmDialog(this, confirmMsg);
                if (response == 0) {
                    FrameUtilities.waitCursor(this);
                    int numExtracted = this.extractSelectedRuns(runsListBox, this.getRunKeys(runsListBox, selectedRows));
                    FrameUtilities.regularCursor(this);
                    this.showMessageToUser("Extracted " + numExtracted + " of " + selectedRows.length + " runs to \"" + this.extractRuns.getExtractDirectory() + "\" dir.");
                }
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
        }
        finally {
            FrameUtilities.regularCursor(this);
        }
    }

    private ElementId[] getRunKeys(MCLB runsListBox) {
        Vector<ElementId> vector = new Vector<ElementId>();
        int totalRows = runsListBox.getRowCount();
        for (int rowNumber = 0; rowNumber < totalRows; ++rowNumber) {
            vector.addElement((ElementId)runsListBox.getRowKey(rowNumber));
        }
        return vector.toArray(new ElementId[vector.size()]);
    }

    private ElementId[] getRunKeys(MCLB runsListBox, int[] selectedRows) {
        Vector<ElementId> vector = new Vector<ElementId>();
        for (int rowNumber : selectedRows) {
            vector.addElement((ElementId)runsListBox.getRowKey(rowNumber));
        }
        return vector.toArray(new ElementId[vector.size()]);
    }

    private int extractSelectedRuns(MCLB runsListBox, ElementId[] runKeys) {
        int extractCount = 0;
        int totalRows = runKeys.length;
        for (int i = 0; i < runKeys.length; ++i) {
            try {
                boolean extracted = this.extractRuns.extractRun(runKeys[i]);
                if (extracted) {
                    ++extractCount;
                }
                this.updateRunCount(extractCount, totalRows);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (FileSecurityException e) {
                e.printStackTrace();
            }
        }
        return extractCount;
    }

    private void updateRunCount(int extractCount, int totalRows) {
        System.out.println("Extracted " + extractCount + " of " + totalRows);
    }

    private void showMessageToUser(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private JButton getGiveButton() {
        if (this.giveButton == null) {
            this.giveButton = new JButton();
            this.giveButton.setText("Give");
            this.giveButton.setToolTipText("Give the selected Run back to Judges");
            this.giveButton.setMnemonic(71);
            this.giveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RunsPanel.this.giveSelectedRun();
                }
            });
        }
        return this.giveButton;
    }

    protected void giveSelectedRun() {
        int[] selectedIndexes = this.runListBox.getSelectedIndexes();
        if (selectedIndexes.length < 1) {
            this.showMessage("Please select a run ");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.runListBox.getKeys()[selectedIndexes[0]];
            Run runToEdit = this.getContest().getRun(elementId);
            if (runToEdit.getStatus().equals((Object)Run.RunStates.BEING_JUDGED) || runToEdit.getStatus().equals((Object)Run.RunStates.NEW) || runToEdit.getStatus().equals((Object)Run.RunStates.BEING_RE_JUDGED)) {
                this.getController().cancelRun(runToEdit);
                this.showMessage("Gave run " + runToEdit);
            } else {
                this.showMessage("Can not give run with state: " + (Object)((Object)runToEdit.getStatus()));
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to give run, check log");
        }
    }

    private JButton getTakeButton() {
        if (this.takeButton == null) {
            this.takeButton = new JButton();
            this.takeButton.setText("Take");
            this.takeButton.setToolTipText("Take the selected Run from the Judges");
            this.takeButton.setMnemonic(84);
            this.takeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("TODO Take actionPerformed()");
                }
            });
        }
        return this.takeButton;
    }

    private JButton getRejudgeRunButton() {
        if (this.rejudgeRunButton == null) {
            this.rejudgeRunButton = new JButton();
            this.rejudgeRunButton.setText("Rejudge");
            this.rejudgeRunButton.setToolTipText("Rejudge the selected Run");
            this.rejudgeRunButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RunsPanel.this.rejudgeSelectedRun();
                }
            });
        }
        return this.rejudgeRunButton;
    }

    private JButton getViewJudgementsButton() {
        if (this.viewJudgementsButton == null) {
            this.viewJudgementsButton = new JButton();
            this.viewJudgementsButton.setText("View Judgements");
            this.viewJudgementsButton.setToolTipText("View Judgements for the selected Run");
            this.viewJudgementsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RunsPanel.this.viewSelectedRunJudgements();
                }
            });
        }
        return this.viewJudgementsButton;
    }

    protected void viewSelectedRunJudgements() {
        int[] selectedIndexes = this.runListBox.getSelectedIndexes();
        if (selectedIndexes.length < 1) {
            this.showMessage("Please select a run ");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.runListBox.getKeys()[selectedIndexes[0]];
            Run theRun = this.getContest().getRun(elementId);
            if (theRun != null) {
                this.viewJudgementsFrame.setRun(theRun);
                this.viewJudgementsFrame.setVisible(true);
            } else {
                this.showMessage("Can not display judgements for Run");
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to view run, check log");
        }
    }

    public boolean isDisplayConfirmation() {
        return this.displayConfirmation;
    }

    public void setDisplayConfirmation(boolean displayConfirmation) {
        this.displayConfirmation = displayConfirmation;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RunsPanel.this.messageLabel.setText(string);
                RunsPanel.this.messageLabel.setToolTipText(string);
            }
        });
    }

    public boolean isShowNewRunsOnly() {
        return this.showNewRunsOnly;
    }

    public void setShowNewRunsOnly(boolean showNewRunsOnly) {
        this.showNewRunsOnly = showNewRunsOnly;
        if (showNewRunsOnly) {
            if (this.requiredFilter == null) {
                this.requiredFilter = new Filter();
            }
            this.requiredFilter.addRunState(Run.RunStates.NEW);
            this.requiredFilter.addRunState(Run.RunStates.MANUAL_REVIEW);
        } else {
            this.requiredFilter = new Filter();
        }
    }

    public boolean isShowJudgesInfo() {
        return this.showJudgesInfo;
    }

    public void setShowJudgesInfo(boolean showJudgesInfo) {
        this.showJudgesInfo = showJudgesInfo;
    }

    private JButton getAutoJudgeButton() {
        if (this.autoJudgeButton == null) {
            this.autoJudgeButton = new JButton();
            this.autoJudgeButton.setText("Auto Judge");
            this.autoJudgeButton.setToolTipText("Enable Auto Judging");
            this.autoJudgeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!RunsPanel.this.bUseAutoJudgemonitor) {
                        RunsPanel.this.log.info("Can not show Auto Judge Monitor, not enabled");
                        return;
                    }
                    RunsPanel.this.log.info("Starting Auto Judge monitor");
                    RunsPanel.this.autoJudgingMonitor.setAutoJudgeDisabledLocally(false);
                    RunsPanel.this.startAutoJudging();
                }
            });
        }
        return this.autoJudgeButton;
    }

    private boolean isAutoJudgingEnabled() {
        ClientSettings clientSettings = this.getContest().getClientSettings();
        return clientSettings != null && clientSettings.isAutoJudging();
    }

    protected void startAutoJudging() {
        if (!this.bUseAutoJudgemonitor) {
            return;
        }
        if (this.isAutoJudgingEnabled()) {
            new Thread(new Runnable(){

                public void run() {
                    RunsPanel.this.autoJudgingMonitor.startAutoJudging();
                }
            }).start();
        } else {
            this.showMessage("Administrator has turned off Auto Judging");
        }
    }

    public boolean isMakeSoundOnOneRun() {
        return this.makeSoundOnOneRun;
    }

    public void setMakeSoundOnOneRun(boolean makeSoundOnOneRun) {
        this.makeSoundOnOneRun = makeSoundOnOneRun;
    }

    public EditFilterFrame getEditFilterFrame() {
        if (this.editFilterFrame == null) {
            Runnable callback = new Runnable(){

                public void run() {
                    RunsPanel.this.reloadRunList();
                }
            };
            this.editFilterFrame = new EditFilterFrame(this.filter, this.filterFrameTitle, callback);
            if (this.displayTeamName != null) {
                this.editFilterFrame.setDisplayTeamName(this.displayTeamName);
            }
        }
        return this.editFilterFrame;
    }

    public void setFilterFrameTitle(String title) {
        this.filterFrameTitle = title;
        if (this.editFilterFrame != null) {
            this.editFilterFrame.setTitle(title);
        }
    }

    public class BalloonSettingsListenerImplementation
    implements IBalloonSettingsListener {
        public void balloonSettingsAdded(BalloonSettingsEvent event) {
            RunsPanel.this.reloadRunList();
        }

        public void balloonSettingsChanged(BalloonSettingsEvent event) {
            RunsPanel.this.reloadRunList();
        }

        public void balloonSettingsRemoved(BalloonSettingsEvent event) {
            RunsPanel.this.reloadRunList();
        }

        public void balloonSettingsRefreshAll(BalloonSettingsEvent balloonSettingsEvent) {
            RunsPanel.this.reloadRunList();
        }
    }

    public class ContestInformationListenerImplementation
    implements IContestInformationListener {
        public void contestInformationAdded(ContestInformationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RunsPanel.this.reloadRunList();
                }
            });
        }

        public void contestInformationChanged(ContestInformationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RunsPanel.this.reloadRunList();
                }
            });
        }

        public void contestInformationRemoved(ContestInformationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RunsPanel.this.reloadRunList();
                }
            });
        }

        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RunsPanel.this.reloadRunList();
                }
            });
        }

        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
        }
    }

    public class LanguageListenerImplementation
    implements ILanguageListener {
        public void languageAdded(LanguageEvent event) {
        }

        public void languageChanged(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RunsPanel.this.reloadRunList();
                }
            });
        }

        public void languageRemoved(LanguageEvent event) {
        }

        public void languageRefreshAll(LanguageEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RunsPanel.this.reloadRunList();
                }
            });
        }
    }

    public class ProblemListenerImplementation
    implements IProblemListener {
        public void problemAdded(ProblemEvent event) {
        }

        public void problemChanged(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RunsPanel.this.reloadRunList();
                }
            });
        }

        public void problemRemoved(ProblemEvent event) {
        }

        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RunsPanel.this.reloadRunList();
                }
            });
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (RunsPanel.this.getContest().getClientId().equals(account.getClientId())) {
                RunsPanel.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RunsPanel.this.updateGUIperPermissions();
                        RunsPanel.this.reloadRunList();
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RunsPanel.this.reloadRunList();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            boolean theyModifiedUs = false;
            for (Account account : accountEvent.getAccounts()) {
                if (!RunsPanel.this.getContest().getClientId().equals(account.getClientId())) continue;
                theyModifiedUs = true;
                RunsPanel.this.initializePermissions();
            }
            final boolean finalTheyModifiedUs = theyModifiedUs;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (finalTheyModifiedUs) {
                        RunsPanel.this.updateGUIperPermissions();
                    }
                    RunsPanel.this.reloadRunList();
                }
            });
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            this.accountsModified(accountEvent);
        }
    }

    public class RunListenerImplementation
    implements IRunListener {
        public void runAdded(RunEvent event) {
            RunsPanel.this.updateRunRow(event.getRun(), event.getWhoModifiedRun(), true);
            if (RunsPanel.this.getContest().getClientId().getClientType() == ClientType.Type.TEAM) {
                this.showResponseToTeam(event);
            }
        }

        public void refreshRuns(RunEvent event) {
            RunsPanel.this.reloadRunList();
        }

        public void runChanged(RunEvent event) {
            RunsPanel.this.updateRunRow(event.getRun(), event.getWhoModifiedRun(), true);
            if (RunsPanel.this.getContest().getClientId().getClientType() == ClientType.Type.TEAM) {
                this.showResponseToTeam(event);
            }
        }

        public void runRemoved(RunEvent event) {
            RunsPanel.this.updateRunRow(event.getRun(), event.getWhoModifiedRun(), true);
        }

        private void showResponseToTeam(RunEvent event) {
            if (!RunsPanel.this.displayConfirmation) {
                return;
            }
            Run theRun = event.getRun();
            String problemName = RunsPanel.this.getContest().getProblem(theRun.getProblemId()).toString();
            String languageName = RunsPanel.this.getContest().getLanguage(theRun.getLanguageId()).toString();
            int runId = theRun.getNumber();
            String responseFormat = "";
            if (theRun.isJudged() && !theRun.isDeleted()) {
                JudgementRecord judgementRecord = theRun.getJudgementRecord();
                if (judgementRecord != null) {
                    if (!judgementRecord.isSendToTeam()) {
                        return;
                    }
                    boolean isActive = judgementRecord.isActive();
                    if (isActive) {
                        String response = RunsPanel.this.getContest().getJudgement(judgementRecord.getJudgementId()).toString();
                        if (judgementRecord.isSolved()) {
                            responseFormat = responseFormat + "<FONT COLOR=\"00FF00\" SIZE=+2>";
                        } else {
                            responseFormat = responseFormat + "<FONT COLOR=RED>";
                            String validatorJudgementName = judgementRecord.getValidatorResultString();
                            if (judgementRecord.isUsedValidator() && validatorJudgementName != null) {
                                if (validatorJudgementName.trim().length() == 0) {
                                    validatorJudgementName = "undetermined";
                                }
                                response = validatorJudgementName;
                            }
                        }
                        String judgeComment = theRun.getCommentsForTeam();
                        try {
                            String displayString = "<HTML><FONT SIZE=+1>Judge's Response<BR><BR>Problem: <FONT COLOR=BLUE>" + Utilities.forHTML(problemName) + "</FONT><BR><BR>" + "Language: <FONT COLOR=BLUE>" + Utilities.forHTML(languageName) + "</FONT><BR><BR>" + "Run Id: <FONT COLOR=BLUE>" + runId + "</FONT><BR><BR><BR>" + "Judge's Response: " + responseFormat + Utilities.forHTML(response) + "</FONT><BR><BR><BR>";
                            if (theRun.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW)) {
                                displayString = displayString + "<FONT SIZE='+2'>NOTE: This is a <FONT COLOR='RED'>Preliminary</FONT> Judgement</FONT><BR><BR><BR>";
                            }
                            if (judgeComment != null && judgeComment.length() > 0) {
                                displayString = displayString + "Judge's Comment: " + Utilities.forHTML(judgeComment) + "<BR><BR><BR>";
                            }
                            displayString = displayString + "</FONT></HTML>";
                            FrameUtilities.showMessage(RunsPanel.this.getParentFrame(), "Run Judgement Received", displayString);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(RunsPanel.this.getParentFrame(), "Exception handling Run Response: " + e.getMessage());
                            RunsPanel.this.log.warning("Exception handling Run Response: " + e.getMessage());
                        }
                    }
                }
            } else if (!theRun.isDeleted()) {
                try {
                    String displayString = "<HTML><FONT SIZE=+1>Confirmation of Run Receipt<BR><BR>Problem: <FONT COLOR=BLUE>" + Utilities.forHTML(problemName) + "</FONT><BR><BR>" + "Language: <FONT COLOR=BLUE>" + Utilities.forHTML(languageName) + "</FONT><BR><BR>" + "Run Id: <FONT COLOR=BLUE>" + runId + "</FONT><BR><BR><BR>";
                    displayString = displayString + "</FONT></HTML>";
                    FrameUtilities.showMessage(RunsPanel.this.getParentFrame(), "Run Received", displayString);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(RunsPanel.this.getParentFrame(), "Exception handling Run Confirmation: " + e.getMessage());
                    RunsPanel.this.log.warning("Exception handling Run Confirmation: " + e.getMessage());
                }
            }
        }
    }
}

