/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.ProfileChangeStatusList;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IProfileListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.ProfileChangeStatus;
import edu.csus.ecs.pc2.core.model.ProfileEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.ui.AccountColumnComparator;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ProfilesStatusPane
extends JPanePlugin {
    private static final long serialVersionUID = 3089291613784484371L;
    private JPanel buttonPane = null;
    private MCLB profilesListBox = null;
    private ProfileChangeStatusList profileStatusList = new ProfileChangeStatusList();

    public ProfilesStatusPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(457, 199));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)((Object)this.getProfilesListBox()), "Center");
    }

    public String getPluginTitle() {
        return "Profile Status Pane";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new GridBagLayout());
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
        }
        return this.buttonPane;
    }

    private MCLB getProfilesListBox() {
        if (this.profilesListBox == null) {
            this.profilesListBox = new MCLB();
            String[] cols = new String[]{"Site", "Name", "Status", "Description", "When"};
            this.profilesListBox.addColumn(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            HeapSorter accountNameSorter = new HeapSorter();
            accountNameSorter.setComparator((Comparator)new AccountColumnComparator());
            int idx = 0;
            this.profilesListBox.setColumnSorter(idx++, numericStringSorter, 1);
            this.profilesListBox.setColumnSorter(idx++, sorter, 2);
            this.profilesListBox.setColumnSorter(idx++, sorter, 3);
            this.profilesListBox.setColumnSorter(idx++, sorter, 4);
            this.profilesListBox.setColumnSorter(idx++, sorter, 5);
        }
        return this.profilesListBox;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addSiteListener(new SiteListenerImplementation());
        this.getContest().addLoginListener(new LoginListenerImplementation());
        this.getContest().addProfileListener(new ProfileListenerImplementation());
    }

    protected void reloadListBox() {
        for (Site site : this.getContest().getSites()) {
            this.updateRow(site);
        }
    }

    private Object[] buildProfileRow(Site site) {
        int numberColumns = this.profilesListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        return c;
    }

    private void updateRow(Site site) {
        int row = this.profilesListBox.getIndexByKey(site.getElementId());
        if (row == -1) {
            Object[] objects = this.buildProfileRow(site);
            this.profilesListBox.addRow(objects, site.getElementId());
        } else {
            Object[] objects = this.buildProfileRow(site);
            this.profilesListBox.replaceRow(objects, row);
        }
        this.profilesListBox.autoSizeAllColumns();
    }

    protected void updateRow(ProfileChangeStatus status) {
        Site site = this.getContest().getSite(status.getSiteNumber());
        this.updateRow(site);
    }

    protected class SiteListenerImplementation
    implements ISiteListener {
        protected SiteListenerImplementation() {
        }

        public void siteProfileStatusChanged(SiteEvent event) {
            ProfileChangeStatus profileChangeStatus = ProfilesStatusPane.this.profileStatusList.get(event.getSite());
            profileChangeStatus.setStatus(event.getProfileStatus());
            profileChangeStatus.setProfile(event.getProfile());
            ProfilesStatusPane.this.profileStatusList.update(profileChangeStatus);
            final ProfileChangeStatus status = profileChangeStatus;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.updateRow(status);
                }
            });
        }

        public void siteAdded(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.reloadListBox();
                }
            });
        }

        public void siteRemoved(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.reloadListBox();
                }
            });
        }

        public void siteChanged(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.reloadListBox();
                }
            });
        }

        public void siteLoggedOn(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.reloadListBox();
                }
            });
        }

        public void siteLoggedOff(SiteEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.reloadListBox();
                }
            });
        }

        public void sitesRefreshAll(SiteEvent siteEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.reloadListBox();
                }
            });
        }
    }

    protected class ProfileListenerImplementation
    implements IProfileListener {
        protected ProfileListenerImplementation() {
        }

        public void profileAdded(ProfileEvent event) {
        }

        public void profileChanged(ProfileEvent event) {
            ProfilesStatusPane.this.reloadListBox();
        }

        public void profileRemoved(ProfileEvent event) {
        }

        public void profileRefreshAll(ProfileEvent profileEvent) {
            ProfilesStatusPane.this.reloadListBox();
        }
    }

    public class LoginListenerImplementation
    implements ILoginListener {
        public void loginAdded(LoginEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.reloadListBox();
                }
            });
        }

        public void loginRemoved(LoginEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.reloadListBox();
                }
            });
        }

        public void loginDenied(LoginEvent event) {
        }

        public void loginRefreshAll(LoginEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesStatusPane.this.reloadListBox();
                }
            });
        }
    }
}

