/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.HeapSorter;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ContestTimeComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProfileListener;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageAutoFill;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.ProfileCloneSettingsReport;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.ProfileSaveFrame;
import edu.csus.ecs.pc2.ui.ResetContestFrame;
import edu.csus.ecs.pc2.ui.SwitchProfileConfirmFrame;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ProfilesPane
extends JPanePlugin {
    private static final long serialVersionUID = 9075523788534575300L;
    private ProfileSaveFrame profileSaveFrame = null;
    private JLabel profileNameLabel = null;
    private JButton switchButton = null;
    private JButton setButton = null;
    private JTextField profileTextField = null;
    private JPanel centerPane = null;
    private JPanel buttonPane = null;
    private JButton newButton = null;
    private JButton exportButton = null;
    private JButton cloneButton = null;
    private JButton resetContestButton = null;
    private ResetContestFrame resetContestFrame = null;
    private JTextField profileDescriptionTextField = null;
    private JLabel profileDescriptionLabel = null;
    private JPanel topPanel = null;
    private MCLB profilesListBox = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private JButton reportButton = null;
    private PermissionList permissionList = new PermissionList();
    private SwitchProfileConfirmFrame switchFrame = null;
    private boolean usingExtraColumns = false;
    private boolean showHidden = false;
    private JCheckBox showHiddenProfilesCheckbox = null;
    private JButton loadButton = null;

    public ProfilesPane() {
        this.initialize();
    }

    private void initialize() {
        this.usingExtraColumns = Utilities.isDebugMode();
        this.profileNameLabel = new JLabel();
        this.profileNameLabel.setHorizontalAlignment(4);
        this.profileNameLabel.setBounds(new Rectangle(51, 29, 189, 23));
        this.profileNameLabel.setText("Active Profile Name");
        this.profileNameLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && e.isControlDown() && e.isShiftDown()) {
                    Profile profile = ProfilesPane.this.getContest().getProfile();
                    String message = "Contest Id " + profile.getContestId();
                    JOptionPane.showMessageDialog(null, message);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(843, 319));
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getTopPanel(), "North");
        FrameUtilities.centerFrame(this);
    }

    public String getPluginTitle() {
        return "Profiles Pane";
    }

    private JButton getSwitchButton() {
        if (this.switchButton == null) {
            this.switchButton = new JButton();
            this.switchButton.setEnabled(true);
            this.switchButton.setMnemonic(87);
            this.switchButton.setPreferredSize(new Dimension(100, 26));
            this.switchButton.setSelected(false);
            this.switchButton.setText("Switch");
            this.switchButton.setToolTipText("Switch to the selected profile");
            this.switchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.switchSelectedProfile();
                }
            });
        }
        return this.switchButton;
    }

    private JButton getSetButton() {
        if (this.setButton == null) {
            this.setButton = new JButton();
            this.setButton.setEnabled(false);
            this.setButton.setMnemonic(83);
            this.setButton.setBounds(new Rectangle(556, 54, 100, 26));
            this.setButton.setText("Set");
            this.setButton.setToolTipText("Update the profile name and description");
            this.setButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.renameProfile();
                }
            });
        }
        return this.setButton;
    }

    private JTextField getProfileTextField() {
        if (this.profileTextField == null) {
            this.profileTextField = new JTextField();
            this.profileTextField.setBounds(new Rectangle(257, 25, 248, 30));
            this.profileTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ProfilesPane.this.enableSetButton();
                }
            });
        }
        return this.profileTextField;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.profileDescriptionLabel = new JLabel();
            this.profileDescriptionLabel.setText("Active Profile Description");
            this.profileDescriptionLabel.setBounds(new Rectangle(51, 78, 189, 23));
            this.profileDescriptionLabel.setHorizontalAlignment(4);
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)((Object)this.getProfilesListBox()), "Center");
        }
        return this.centerPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getNewButton(), null);
            this.buttonPane.add((Component)this.getCloneButton(), null);
            this.buttonPane.add((Component)this.getSwitchButton(), null);
            this.buttonPane.add((Component)this.getResetContestButton(), null);
            this.buttonPane.add((Component)this.getExportButton(), null);
            this.buttonPane.add((Component)this.getReportButton(), null);
            this.buttonPane.add((Component)this.getLoadButton(), null);
            this.buttonPane.add((Component)this.getShowHiddenProfilesCheckbox(), null);
        }
        return this.buttonPane;
    }

    private JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButton.setText("New");
            this.newButton.setMnemonic(78);
            this.newButton.setEnabled(true);
            this.newButton.setToolTipText("Create a new (blank) profile");
            this.newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.newProfile();
                }
            });
        }
        return this.newButton;
    }

    private JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton();
            this.exportButton.setText("Export");
            this.exportButton.setMnemonic(88);
            this.exportButton.setEnabled(false);
            this.exportButton.setToolTipText("Export profile information");
            this.exportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.exportProfile();
                }
            });
        }
        return this.exportButton;
    }

    private JButton getCloneButton() {
        if (this.cloneButton == null) {
            this.cloneButton = new JButton();
            this.cloneButton.setText("Clone");
            this.cloneButton.setMnemonic(67);
            this.cloneButton.setEnabled(true);
            this.cloneButton.setToolTipText("Create a copy of the active profile");
            this.cloneButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.cloneProfile();
                }
            });
        }
        return this.cloneButton;
    }

    private String getProfileName() {
        return this.getContest().getProfile().getName();
    }

    private String getProfileDescription() {
        return this.getContest().getProfile().getDescription();
    }

    protected void newProfile() {
        this.getProfileSaveFrame().setTitle("Create new profile");
        this.getProfileSaveFrame().setSaveButtonName("Ok");
        this.getProfileSaveFrame().setVisible(true);
    }

    protected void exportProfile() {
        this.getProfileSaveFrame().setTitle("Export settings " + this.getProfileName());
        this.getProfileSaveFrame().setSaveButtonName("Export");
        this.getProfileSaveFrame().setVisible(true);
    }

    public SwitchProfileConfirmFrame getSwitchFrame() {
        if (this.switchFrame == null) {
            this.switchFrame = new SwitchProfileConfirmFrame();
        }
        return this.switchFrame;
    }

    protected void switchSelectedProfile() {
        int selectedIndex = this.getProfilesListBox().getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("No profile selected");
            return;
        }
        if (this.getContest().getContestTime().isContestRunning()) {
            this.showMessage("Contest Clock/Time must be stopped");
            return;
        }
        String profilePath = (String)this.getProfilesListBox().getKeys()[selectedIndex];
        Profile selectedProfile = this.getProfile(profilePath);
        if (selectedProfile.equals(this.getContest().getProfile())) {
            this.showMessage("Currently using profile '" + selectedProfile.getName() + "' (no need to switch)");
            return;
        }
        this.getSwitchFrame().setProfile(selectedProfile);
        this.getSwitchFrame().setVisible(true);
    }

    private Profile getProfile(String profilePath) {
        for (Profile profile : this.getContest().getProfiles()) {
            if (!profile.getProfilePath().equals(profilePath)) continue;
            return profile;
        }
        return null;
    }

    protected void renameProfile() {
        if (this.getProfileTextField() == null || this.getProfileTextField().getText().trim().length() < 1) {
            this.showMessage("No profile name specified");
            return;
        }
        String newProfileName = this.getProfileTextField().getText().trim();
        String description = this.getProfileDescriptionTextField().getText().trim() + "";
        Profile profile = this.getContest().getProfile();
        profile.setName(newProfileName);
        profile.setDescription(description);
        this.getController().updateProfile(profile);
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public ProfileSaveFrame getProfileSaveFrame() {
        if (this.profileSaveFrame == null) {
            this.profileSaveFrame = new ProfileSaveFrame();
        }
        return this.profileSaveFrame;
    }

    private JButton getResetContestButton() {
        if (this.resetContestButton == null) {
            this.resetContestButton = new JButton();
            this.resetContestButton.setMnemonic(83);
            this.resetContestButton.setText("Reset");
            this.resetContestButton.setToolTipText("Reset the active contest profile - clear runs, clars, reset contest time");
            this.resetContestButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.resetContest();
                }
            });
        }
        return this.resetContestButton;
    }

    protected void resetContest() {
        String siteContestClockRunning = "";
        ContestTime[] contestTimes = this.getContest().getContestTimes();
        Arrays.sort(contestTimes, new ContestTimeComparator());
        int numberSites = 0;
        for (ContestTime contestTime : contestTimes) {
            if (!contestTime.isContestRunning() || !this.siteConnected(contestTime.getSiteNumber())) continue;
            Site site = this.getContest().getSite(contestTime.getSiteNumber());
            siteContestClockRunning = siteContestClockRunning + ", " + site.format("%L");
            ++numberSites;
        }
        if (numberSites != 0) {
            siteContestClockRunning = siteContestClockRunning.substring(2);
            String sitePhrase = "a site";
            if (numberSites > 1) {
                sitePhrase = numberSites + " sites";
            }
            JOptionPane.showMessageDialog(this, "Contest Clock not stopped at " + sitePhrase + " (" + siteContestClockRunning + ")\n All contest clocks must be stopped", "Unable to reset", 0);
        } else {
            this.showResetDialog();
        }
    }

    private boolean siteConnected(int siteNumber) {
        ClientId serverId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
        return this.getContest().isLocalLoggedIn(serverId) || this.isThisSite(siteNumber);
    }

    private boolean isThisSite(int siteNumber) {
        return this.getContest().getSiteNumber() == siteNumber;
    }

    private void showResetDialog() {
        if (this.resetContestFrame == null) {
            this.resetContestFrame = new ResetContestFrame();
            this.resetContestFrame.setContestAndController(this.getContest(), this.getController());
        }
        this.resetContestFrame.setVisible(true);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.initializePermissions();
        this.getProfileSaveFrame().setContestAndController(inContest, inController);
        this.getSwitchFrame().setContestAndController(this.getContest(), this.getController());
        Profile profile = this.getContest().getProfile();
        this.updateProfileInformation(profile);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProfilesPane.this.refreshProfilesList();
                ProfilesPane.this.updateGUIperPermissions();
            }
        });
        inContest.addProfileListener(new ProfileListenerImplementation());
        inContest.addAccountListener(new AccountListenerImplementation());
    }

    private void updateGUIperPermissions() {
        this.switchButton.setVisible(this.isAllowed(Permission.Type.SWITCH_PROFILE));
        this.setButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE));
        this.newButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE));
        this.exportButton.setVisible(this.isAllowed(Permission.Type.EXPORT_PROFILE));
        this.cloneButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE));
        this.resetContestButton.setVisible(this.isAllowed(Permission.Type.RESET_CONTEST));
        this.reportButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE));
        this.loadButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE) && Utilities.isDebugMode());
    }

    protected void refreshProfilesList() {
        try {
            Profile[] profiles = this.getContest().getProfiles();
            this.getProfilesListBox().removeAllRows();
            this.getSwitchButton().setEnabled(false);
            if (profiles.length > 0) {
                for (Profile profile : profiles) {
                    boolean showit;
                    boolean bl = showit = this.showHidden || profile.isActive();
                    if (!showit) continue;
                    Object[] objects = this.buildProfileRow(profile);
                    this.getProfilesListBox().addRow(objects, profile.getProfilePath());
                }
                this.getProfilesListBox().autoSizeAllColumns();
                this.getSwitchButton().setEnabled(true);
            }
            this.updateProfileInformation(this.getContest().getProfile());
        }
        catch (Exception e) {
            this.getController().getLog().log(Log.DEBUG, "Exception refreshing profile list", e);
        }
    }

    private Object[] buildProfileRow(Profile profile) {
        int numberColumns = this.profilesListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = profile.getName();
        if (profile.equals(this.getContest().getProfile())) {
            c[0] = "(Active) " + profile.getName();
        }
        c[1] = profile.getDescription();
        c[2] = this.formatter.format(profile.getCreateDate());
        if (this.usingExtraColumns) {
            c[3] = profile.getContestId();
            c[4] = profile.getProfilePath();
        }
        return c;
    }

    private void updateProfileInformation(final Profile profile) {
        if (profile != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesPane.this.getProfileTextField().setText(profile.getName());
                    ProfilesPane.this.profileNameLabel.setToolTipText("Contest Profile Name " + profile.getContestId());
                    ProfilesPane.this.getProfileDescriptionTextField().setText(profile.getDescription());
                    ProfilesPane.this.enableSetButton();
                }
            });
        }
    }

    private JTextField getProfileDescriptionTextField() {
        if (this.profileDescriptionTextField == null) {
            this.profileDescriptionTextField = new JTextField();
            this.profileDescriptionTextField.setBounds(new Rectangle(257, 75, 248, 29));
            this.profileDescriptionTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ProfilesPane.this.enableSetButton();
                }
            });
        }
        return this.profileDescriptionTextField;
    }

    protected void enableSetButton() {
        Profile profile = this.getContest().getProfile();
        String name = this.getProfileTextField().getText();
        String description = this.getProfileDescriptionTextField().getText();
        boolean enable = !profile.getName().equals(name) || !profile.getDescription().equals(description);
        this.getSetButton().setEnabled(enable);
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(null);
            this.topPanel.setPreferredSize(new Dimension(120, 120));
            this.topPanel.add((Component)this.profileNameLabel, null);
            this.topPanel.add((Component)this.profileDescriptionLabel, null);
            this.topPanel.add((Component)this.getProfileTextField(), null);
            this.topPanel.add((Component)this.getProfileDescriptionTextField(), null);
            this.topPanel.add((Component)this.getSetButton(), null);
        }
        return this.topPanel;
    }

    private MCLB getProfilesListBox() {
        if (this.profilesListBox == null) {
            this.profilesListBox = new MCLB();
            Object[] defaultColumns = new Object[]{"Name", "Description", "Create Date"};
            Object[] fullColumns = new Object[]{"Name", "Description", "Create Date", "Contest ID", "Path"};
            Object[] cols = defaultColumns;
            if (this.usingExtraColumns) {
                cols = fullColumns;
            }
            this.profilesListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            int idx = 0;
            this.profilesListBox.setColumnSorter(idx++, sorter, 1);
            this.profilesListBox.setColumnSorter(idx++, sorter, 2);
            this.profilesListBox.setColumnSorter(idx++, sorter, 3);
            if (this.usingExtraColumns) {
                this.profilesListBox.setColumnSorter(idx++, sorter, 4);
                this.profilesListBox.setColumnSorter(idx++, sorter, 5);
            }
        }
        return this.profilesListBox;
    }

    private void removeProfilesRow(final Profile profile) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int rowNumber = ProfilesPane.this.profilesListBox.getIndexByKey(profile.getProfilePath());
                if (rowNumber != -1) {
                    ProfilesPane.this.profilesListBox.removeRow(rowNumber);
                }
            }
        });
    }

    public void updateProfileRow(final Profile profile) {
        if (!profile.isActive() && !this.isShowHidden()) {
            this.removeProfilesRow(profile);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object[] objects = ProfilesPane.this.buildProfileRow(profile);
                    int rowNumber = ProfilesPane.this.profilesListBox.getIndexByKey(profile.getProfilePath());
                    if (rowNumber == -1) {
                        ProfilesPane.this.profilesListBox.addRow(objects, profile.getProfilePath());
                    } else {
                        ProfilesPane.this.profilesListBox.replaceRow(objects, rowNumber);
                    }
                    ProfilesPane.this.profilesListBox.autoSizeAllColumns();
                    ProfilesPane.this.profilesListBox.sort();
                }
            });
        }
    }

    private JButton getReportButton() {
        if (this.reportButton == null) {
            this.reportButton = new JButton();
            this.reportButton.setText("Report");
            this.reportButton.setMnemonic(82);
            this.reportButton.setToolTipText("Display Profiles Report");
            this.reportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.createReport(new ProfileCloneSettingsReport());
                }
            });
        }
        return this.reportButton;
    }

    protected void createReport(IReport report) {
        report.setContestAndController(this.getContest(), this.getController());
        try {
            this.createAndViewReportFile(report, new Filter(), this.getController().getLog());
        }
        catch (IOException e) {
            StaticLog.log("Exception creating report", e);
            JOptionPane.showMessageDialog(this, "Exception in report " + e.getLocalizedMessage());
        }
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    private JCheckBox getShowHiddenProfilesCheckbox() {
        if (this.showHiddenProfilesCheckbox == null) {
            this.showHiddenProfilesCheckbox = new JCheckBox();
            this.showHiddenProfilesCheckbox.setText("Show Backups");
            this.showHiddenProfilesCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.toggleShowHiddenProfiles();
                }
            });
        }
        return this.showHiddenProfilesCheckbox;
    }

    protected void toggleShowHiddenProfiles() {
        this.showHidden = this.getShowHiddenProfilesCheckbox().isSelected();
        this.refreshProfilesList();
    }

    protected void cloneProfile() {
        this.getProfileSaveFrame().setTitle("Clone active profile: " + this.getProfileName() + " (" + this.getProfileDescription() + ")");
        this.getProfileSaveFrame().setSaveButtonName("Clone");
        this.getProfileSaveFrame().setVisible(true);
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("Load");
            this.loadButton.setMnemonic(76);
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.quickLoad();
                }
            });
        }
        return this.loadButton;
    }

    protected boolean isAdministrator(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR);
    }

    protected void quickLoad() {
        if (!this.isAdministrator(this.getContest().getClientId())) {
            JOptionPane.showMessageDialog(this, "You must be an admin to use this feature");
            return;
        }
        QuickLoad load = new QuickLoad();
        load.setContestAndController(this.getContest(), this.getController());
        load = null;
        JOptionPane.showMessageDialog(this, "Contest quick loaded");
    }

    class QuickLoad
    implements UIPlugin {
        private static final long serialVersionUID = -4248229783309059230L;
        private IInternalContest contest;
        private IInternalController controller;

        QuickLoad() {
        }

        public void setContestAndController(IInternalContest inContest, IInternalController inController) {
            this.contest = inContest;
            this.controller = inController;
            this.loadContest();
        }

        private void loadContest() {
            if (this.contest.getLanguages().length == 0) {
                Language language = this.createLanguage("Java");
                if (language != null) {
                    this.controller.addNewLanguage(language);
                }
                System.out.println("quickLoad: add " + language);
                language = this.createLanguage("GNU C++ (Unix / Windows)");
                if (language != null) {
                    this.controller.addNewLanguage(language);
                }
                System.out.println("quickLoad: add " + language);
                language = this.createLanguage("Perl");
                if (language != null) {
                    this.controller.addNewLanguage(language);
                }
                System.out.println("quickLoad: add " + language);
            }
            if (this.contest.getProblems().length == 0) {
                Problem problem = new Problem("Sumit");
                Problem problem2 = new Problem("Hello");
                ProblemDataFiles files = new ProblemDataFiles(problem);
                this.controller.addNewProblem(problem, files);
                System.out.println("quickLoad: add " + problem);
                files = new ProblemDataFiles(problem2);
                this.controller.addNewProblem(problem2, files);
                System.out.println("quickLoad: add " + problem);
            }
            if (this.siteLoggedIn(1)) {
                this.generateAccounts(1, ClientType.Type.TEAM, 22);
                this.generateAccounts(1, ClientType.Type.JUDGE, 12);
                this.generateAccounts(1, ClientType.Type.SCOREBOARD, 12);
            }
            if (this.siteLoggedIn(2)) {
                this.generateAccounts(2, ClientType.Type.TEAM, 22);
                this.generateAccounts(2, ClientType.Type.JUDGE, 2);
            }
            if (this.siteLoggedIn(3)) {
                this.generateAccounts(3, ClientType.Type.TEAM, 33);
            }
        }

        private Language createLanguage(String languageName) {
            for (String langName : LanguageAutoFill.getLanguageList()) {
                if (!langName.equals(languageName)) continue;
                String[] values = LanguageAutoFill.getAutoFillValues(langName);
                Language language = new Language(langName);
                language.setCompileCommandLine(values[1]);
                language.setExecutableIdentifierMask(values[2]);
                language.setProgramExecuteCommandLine(values[3]);
                return language;
            }
            return null;
        }

        private boolean siteLoggedIn(int siteNumber) {
            if (siteNumber == ProfilesPane.this.getContest().getSiteNumber()) {
                return true;
            }
            ClientId remoteServerId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
            return ProfilesPane.this.getContest().isLocalLoggedIn(remoteServerId) || ProfilesPane.this.getContest().isRemoteLoggedIn(remoteServerId);
        }

        private void generateAccounts(int siteNumber, ClientType.Type type, int count) {
            Vector<Account> accounts = ProfilesPane.this.getContest().getAccounts(type, siteNumber);
            int numToGenerate = count - accounts.size();
            if (numToGenerate > 0) {
                System.out.println("quickLoad: added " + numToGenerate + " " + type.toString() + " at site " + siteNumber);
                ProfilesPane.this.getController().generateNewAccounts(type.toString(), siteNumber, numToGenerate, 1, true);
            }
        }

        public String getPluginTitle() {
            return "Quick Load Contest";
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (ProfilesPane.this.getContest().getClientId().equals(account.getClientId())) {
                ProfilesPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProfilesPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            for (Account account : accountEvent.getAccounts()) {
                if (!ProfilesPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProfilesPane.this.initializePermissions();
                        ProfilesPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            this.accountsModified(accountEvent);
        }
    }

    protected class ProfileListenerImplementation
    implements IProfileListener {
        protected ProfileListenerImplementation() {
        }

        public void profileAdded(ProfileEvent event) {
            ProfilesPane.this.updateProfileRow(event.getProfile());
        }

        public void profileChanged(ProfileEvent event) {
            ProfilesPane.this.updateProfileRow(event.getProfile());
            Profile profile = ProfilesPane.this.getContest().getProfile();
            ProfilesPane.this.updateProfileInformation(profile);
        }

        public void profileRemoved(ProfileEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesPane.this.refreshProfilesList();
                }
            });
        }

        public void profileRefreshAll(ProfileEvent profileEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProfilesPane.this.refreshProfilesList();
                }
            });
        }
    }
}

