/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.EditProblemFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ProblemsPane
extends JPanePlugin {
    private static final long serialVersionUID = -7483784815760107250L;
    private JPanel problemButtonPane = null;
    private MCLB problemListBox = null;
    private JButton addButton = null;
    private JButton copyButton = null;
    private JButton editButton = null;
    private JPanel messagePanel = null;
    private JLabel messageLabel = null;
    private Log log = null;
    private EditProblemFrame editProblemFrame = null;
    private PermissionList permissionList = new PermissionList();

    public ProblemsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(564, 229));
        this.add((Component)this.getMessagePanel(), "North");
        this.add((Component)((Object)this.getProblemListBox()), "Center");
        this.add((Component)this.getProblemButtonPane(), "South");
        this.editProblemFrame = new EditProblemFrame();
    }

    public String getPluginTitle() {
        return "Problems Pane";
    }

    private JPanel getProblemButtonPane() {
        if (this.problemButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.problemButtonPane = new JPanel();
            this.problemButtonPane.setLayout(flowLayout);
            this.problemButtonPane.setPreferredSize(new Dimension(35, 35));
            this.problemButtonPane.add((Component)this.getAddButton(), null);
            this.problemButtonPane.add((Component)this.getCopyButton(), null);
            this.problemButtonPane.add((Component)this.getEditButton(), null);
        }
        return this.problemButtonPane;
    }

    private MCLB getProblemListBox() {
        if (this.problemListBox == null) {
            this.problemListBox = new MCLB();
            Object[] cols = new Object[]{"Problem Name", "Data File", "Answer File", "Input Method", "Judging Type", "Time Limit", "SVTJ", "Validator"};
            this.problemListBox.addColumns(cols);
            this.problemListBox.autoSizeAllColumns();
        }
        return this.problemListBox;
    }

    public void updateProblemRow(final Problem problem) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objects = ProblemsPane.this.buildProblemRow(problem);
                int rowNumber = ProblemsPane.this.problemListBox.getIndexByKey(problem.getElementId());
                if (rowNumber == -1) {
                    ProblemsPane.this.problemListBox.addRow(objects, problem.getElementId());
                } else {
                    ProblemsPane.this.problemListBox.replaceRow(objects, rowNumber);
                }
                ProblemsPane.this.problemListBox.autoSizeAllColumns();
            }
        });
    }

    private String yesNoString(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    protected Object[] buildProblemRow(Problem problem) {
        int numberColumns = this.problemListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        int i = 0;
        String name = problem.getDisplayName();
        if (!problem.isActive()) {
            name = "[HIDDEN] " + name;
        }
        c[i++] = name;
        c[i++] = problem.getDataFileName();
        c[i++] = problem.getAnswerFileName();
        String inputMethod = "";
        inputMethod = problem.isReadInputDataFromSTDIN() ? "STDIN" : (problem.getDataFileName() != null ? "File I/O" : "(none)");
        c[i++] = inputMethod;
        String judgingType = "";
        if (problem.isComputerJudged()) {
            judgingType = "Computer";
            if (problem.isManualReview()) {
                judgingType = "Computer+Manual";
                if (problem.isPrelimaryNotification()) {
                    judgingType = "Computer+Manual/Notify";
                }
            }
        } else {
            judgingType = problem.isValidatedProblem() ? "Manual w/Val." : "Manual";
        }
        c[i++] = judgingType;
        c[i++] = Integer.toString(problem.getTimeOutInSeconds());
        c[i++] = this.yesNoString(problem.isShowValidationToJudges());
        c[i++] = problem.getValidatorProgramName();
        return c;
    }

    protected void copySelectedProblem() {
        int selectedIndex = this.problemListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a problem to copy");
            return;
        }
        try {
            this.problemListBox.deselectAllRows();
            ElementId elementId = (ElementId)this.problemListBox.getKeys()[selectedIndex];
            Problem sourceProblem = this.getContest().getProblem(elementId);
            String newProblemName = this.promptForProblemName(sourceProblem.getDisplayName());
            if (newProblemName == null || newProblemName.trim().length() == 0) {
                this.showMessage("Copy Aborted.");
            } else {
                Problem newProblem = sourceProblem.copy(newProblemName);
                ProblemDataFiles pdf = this.getController().getProblemDataFiles(sourceProblem);
                ProblemDataFiles newProblemDataFiles = null;
                if (pdf != null) {
                    newProblemDataFiles = pdf.copy(newProblem);
                }
                this.editProblemFrame.setProblem(newProblem, newProblemDataFiles);
                this.editProblemFrame.setVisible(true);
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to clone problem, check log (" + e.getMessage() + ")");
        }
    }

    private String promptForProblemName(String problemName) {
        String s = (String)JOptionPane.showInputDialog(this, "Enter new name:\n", "Copying problem '" + problemName + "'", 3, null, null, null);
        return s;
    }

    private void reloadListBox() {
        Problem[] problems;
        this.problemListBox.removeAllRows();
        for (Problem problem : problems = this.getContest().getProblems()) {
            this.addProblemRow(problem);
        }
    }

    private void addProblemRow(Problem problem) {
        Object[] objects = this.buildProblemRow(problem);
        this.problemListBox.addRow(objects, problem.getElementId());
        this.problemListBox.autoSizeAllColumns();
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.editProblemFrame.setContestAndController(inContest, inController);
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProblemsPane.this.updateGUIperPermissions();
                ProblemsPane.this.reloadListBox();
            }
        });
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.addButton.setVisible(this.isAllowed(Permission.Type.ADD_PROBLEM));
        this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_PROBLEM));
        this.copyButton.setVisible(this.isAllowed(Permission.Type.EDIT_PROBLEM));
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.setToolTipText("Add new Problem definition");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemsPane.this.addProblem();
                }
            });
        }
        return this.addButton;
    }

    protected void addProblem() {
        this.editProblemFrame.setProblem(null);
        this.editProblemFrame.setVisible(true);
    }

    private JButton getCopyButton() {
        if (this.copyButton == null) {
            this.copyButton = new JButton();
            this.copyButton.setText("Copy");
            this.copyButton.setMnemonic(67);
            this.copyButton.setToolTipText("Copy settings from an existing problem to a new problem");
            this.copyButton.setActionCommand("Copy");
            this.copyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemsPane.this.copySelectedProblem();
                }
            });
        }
        return this.copyButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setMnemonic(69);
            this.editButton.setToolTipText("Edit existing Problem definition");
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemsPane.this.editSelectedProblem();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedProblem() {
        int selectedIndex = this.problemListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a problem to edit");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.problemListBox.getKeys()[selectedIndex];
            Problem problemToEdit = this.getContest().getProblem(elementId);
            this.editProblemFrame.setProblem(problemToEdit);
            this.editProblemFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit problem, check log (" + e.getMessage() + ")");
        }
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.setPreferredSize(new Dimension(25, 25));
            this.messagePanel.add((Component)this.messageLabel, "Center");
        }
        return this.messagePanel;
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Problems pane message", 1);
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (ProblemsPane.this.getContest().getClientId().equals(account.getClientId())) {
                ProblemsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProblemsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                if (!ProblemsPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                ProblemsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProblemsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            ProblemsPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProblemsPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    private class ProblemListenerImplementation
    implements IProblemListener {
        private ProblemListenerImplementation() {
        }

        public void problemAdded(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProblemsPane.this.updateProblemRow(event.getProblem());
                }
            });
        }

        public void problemChanged(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProblemsPane.this.updateProblemRow(event.getProblem());
                }
            });
        }

        public void problemRemoved(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProblemsPane.this.reloadListBox();
                }
            });
        }

        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProblemsPane.this.reloadListBox();
                }
            });
        }
    }
}

