/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ProblemPane
extends JPanePlugin {
    public static final String DEFAULT_INTERNATIONAL_VALIDATOR_COMMAND = "{:validator} {:infile} {:outfile} {:ansfile} {:resfile} ";
    private static final long serialVersionUID = -1060536964672397704L;
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private Problem problem = null;
    private JTabbedPane mainTabbedPane = null;
    private JPanel generalPane = null;
    private JPanel judgingTypePane = null;
    private JTextField problemNameTextField = null;
    private JTextField timeOutSecondTextField = null;
    private JCheckBox problemRequiresDataCheckBox = null;
    private JPanel dataProblemPane = null;
    private JPanel readsFromPane = null;
    private JPanel inputDataFilePane = null;
    private JRadioButton stdinRadioButton = null;
    private JRadioButton fileRadioButton = null;
    private JPanel fileNamePane = null;
    private JButton selectFileButton = null;
    private JCheckBox judgesHaveAnswerFiles = null;
    private JPanel answerFilePane = null;
    private JPanel answerFilenamePane = null;
    private JButton answerBrowseButton = null;
    private JLabel inputDataFileLabel = null;
    private JLabel answerFileNameLabel = null;
    private JLabel problemNameLabel = null;
    private JLabel timeoutLabel = null;
    private Log log = null;
    private boolean populatingGUI = true;
    private String lastDirectory;
    private ProblemDataFiles newProblemDataFiles;
    private ButtonGroup teamReadsFrombuttonGroup = null;
    private ButtonGroup judgingTypeGroup = null;
    private JPanel validatorPane = null;
    private JRadioButton useNOValidatatorRadioButton = null;
    private JRadioButton usePC2ValidatorRadioButton = null;
    private JRadioButton useExternalValidatorRadioButton = null;
    private JCheckBox showValidatorToJudges = null;
    private JPanel pc2ValidatorFrame = null;
    private JPanel externalValidatorFrame = null;
    private JLabel validatorOptionsLabel = null;
    private JComboBox pc2ValidatorOptionComboBox = null;
    private JCheckBox ignoreCaseCheckBox = null;
    private JLabel validatorProgramLabel = null;
    private JPanel externalValidatorPane = null;
    private JButton validatorProgramJButton = null;
    private JLabel jLabel = null;
    private JTextField validatorCommandLineTextBox = null;
    private JLabel externalValidatorLabel = null;
    private JCheckBox showCompareCheckBox = null;
    private JCheckBox doShowOutputWindowCheckBox = null;
    private ButtonGroup validatorChoiceButtonGroup = null;
    private static final String NL = System.getProperty("line.separator");
    private JRadioButton computerJudging = null;
    private JRadioButton manualJudging = null;
    private JCheckBox manualReview = null;
    private JCheckBox prelimaryNotification = null;
    private JCheckBox deleteProblemCheckBox = null;
    private boolean listenersAdded = false;

    public ProblemPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(539, 511));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMainTabbedPane(), "Center");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.addWindowListeners();
    }

    private void addWindowListeners() {
        if (this.listenersAdded) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ProblemPane.this.getParentFrame() != null) {
                    ProblemPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            ProblemPane.this.handleCancelButton();
                        }

                        public void windowOpened(WindowEvent e) {
                            ProblemPane.this.getProblemNameTextField().requestFocus();
                        }

                        public void windowActivated(WindowEvent e) {
                            ProblemPane.this.getProblemNameTextField().requestFocus();
                        }
                    });
                    ProblemPane.this.listenersAdded = true;
                }
            }
        });
    }

    public String getPluginTitle() {
        return "Edit Problem Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.addProblem();
                }
            });
        }
        return this.addButton;
    }

    protected void addProblem() {
        if (this.problemNameTextField.getText().trim().length() < 1) {
            this.showMessage("Enter a problem name");
            return;
        }
        if (!this.validateProblemFields()) {
            return;
        }
        Problem newProblem = null;
        try {
            newProblem = this.getProblemFromFields(null);
            SerializedFile sFile = this.newProblemDataFiles.getJudgesDataFile();
            if (sFile != null) {
                this.checkFileFormat(sFile);
                if (this.checkFileFormat(sFile)) {
                    this.newProblemDataFiles.setJudgesDataFile(sFile);
                }
            }
            if ((sFile = this.newProblemDataFiles.getJudgesAnswerFile()) != null && this.checkFileFormat(sFile)) {
                this.newProblemDataFiles.setJudgesAnswerFile(sFile);
            }
            if ((sFile = this.newProblemDataFiles.getValidatorFile()) != null && this.checkFileFormat(sFile)) {
                this.newProblemDataFiles.setValidatorFile(sFile);
            }
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        this.getController().addNewProblem(newProblem, this.newProblemDataFiles);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void enableUpdateButton() {
        String updateToolTip;
        boolean enableButton;
        block14: {
            if (this.populatingGUI) {
                return;
            }
            enableButton = false;
            updateToolTip = "";
            if (this.problem != null) {
                try {
                    ProblemDataFiles pdf;
                    Problem changedProblem = this.getProblemFromFields(null);
                    if (!this.problem.isSameAs(changedProblem)) {
                        enableButton = true;
                        updateToolTip = "Problem changed";
                    }
                    if ((pdf = this.getContest().getProblemDataFile(this.problem)) != null) {
                        int fileChanged = 0;
                        String fileName = changedProblem.getDataFileName();
                        if (fileName != null && fileName.length() > 0 && !this.fileSameAs(pdf.getJudgesDataFile(), changedProblem.getDataFileName())) {
                            enableButton = true;
                            ++fileChanged;
                            updateToolTip = updateToolTip.equals("") ? "Judges data" : ", Judges data";
                        }
                        if ((fileName = changedProblem.getAnswerFileName()) != null && fileName.length() > 0 && !this.fileSameAs(pdf.getJudgesAnswerFile(), changedProblem.getAnswerFileName())) {
                            enableButton = true;
                            ++fileChanged;
                            updateToolTip = updateToolTip.equals("") ? "Judges answer" : updateToolTip + ", Judges answer";
                        }
                        fileName = changedProblem.getValidatorProgramName();
                        if (!this.problem.isUsingPC2Validator() && fileName != null && fileName.length() > 0 && !this.fileSameAs(pdf.getValidatorFile(), changedProblem.getValidatorProgramName())) {
                            enableButton = true;
                            ++fileChanged;
                            updateToolTip = updateToolTip.equals("") ? "Validator" : updateToolTip + ", Validator";
                        }
                        if (fileChanged > 0) {
                            updateToolTip = fileChanged == 1 ? updateToolTip + " file changed" : updateToolTip + " files changed";
                        }
                        break block14;
                    }
                    this.getController().getLog().log(Log.DEBUG, "No ProblemDataFiles for " + this.problem);
                }
                catch (InvalidFieldValue e) {
                    this.getController().getLog().log(Log.DEBUG, "Input Problem (but not saving) ", e);
                    enableButton = true;
                }
            } else if (this.getAddButton().isVisible()) {
                enableButton = true;
            }
        }
        if (updateToolTip.equals("")) {
            this.getUpdateButton().setToolTipText(null);
        } else {
            this.getUpdateButton().setToolTipText(updateToolTip);
        }
        this.enableUpdateButtons(enableButton);
    }

    private boolean fileSameAs(SerializedFile file, String fileName) {
        if (fileName != null && !fileName.trim().equals("")) {
            if (file != null && !fileName.equals(file.getName())) {
                return true;
            }
            return !this.needsFreshening(file, fileName);
        }
        return true;
    }

    public Problem getProblemFromFields(Problem checkProblem) throws InvalidFieldValue {
        SerializedFile serializedFile;
        String fileName;
        boolean isAdding = true;
        if (checkProblem == null) {
            checkProblem = new Problem(this.problemNameTextField.getText());
            isAdding = true;
            this.newProblemDataFiles = new ProblemDataFiles(checkProblem);
        } else {
            this.newProblemDataFiles = new ProblemDataFiles(checkProblem);
            checkProblem.setDisplayName(this.problemNameTextField.getText());
            isAdding = false;
        }
        int secs = this.getIntegerValue(this.timeOutSecondTextField.getText());
        checkProblem.setTimeOutInSeconds(secs);
        boolean deleted = this.getDeleteProblemCheckBox().isSelected();
        checkProblem.setActive(!deleted);
        if (this.problemRequiresDataCheckBox.isSelected()) {
            fileName = this.inputDataFileLabel.getText();
            if (fileName == null || fileName.trim().length() == 0) {
                throw new InvalidFieldValue("Problem Requires Input Data checked, select a file ");
            }
            if (fileName.trim().length() != this.inputDataFileLabel.getToolTipText().length()) {
                fileName = this.inputDataFileLabel.getToolTipText() + "";
            }
            if (isAdding) {
                serializedFile = new SerializedFile(fileName);
                if (serializedFile.getBuffer() == null) {
                    throw new InvalidFieldValue("Unable to read file " + fileName + " choose data file again (adding)");
                }
                checkProblem.setDataFileName(serializedFile.getName());
                this.newProblemDataFiles.setJudgesDataFile(serializedFile);
            } else {
                serializedFile = this.getController().getProblemDataFiles(checkProblem).getJudgesDataFile();
                if (serializedFile == null || !serializedFile.getAbsolutePath().equals(fileName)) {
                    serializedFile = new SerializedFile(fileName);
                    this.checkFileFormat(serializedFile);
                } else {
                    serializedFile = this.freshenIfNeeded(serializedFile, fileName);
                }
                this.newProblemDataFiles.setJudgesDataFile(serializedFile);
                checkProblem.setDataFileName(serializedFile.getName());
            }
        } else {
            checkProblem.setDataFileName(null);
        }
        if (this.judgesHaveAnswerFiles.isSelected()) {
            fileName = this.answerFileNameLabel.getText();
            if (fileName == null || fileName.trim().length() == 0) {
                throw new InvalidFieldValue("Judges Have Provided Answer File checked, select a file");
            }
            if (fileName.trim().length() != this.answerFileNameLabel.getToolTipText().length()) {
                fileName = this.answerFileNameLabel.getToolTipText() + "";
            }
            if (isAdding) {
                serializedFile = new SerializedFile(fileName);
                if (serializedFile.getBuffer() == null) {
                    throw new InvalidFieldValue("Unable to read file " + fileName + " choose answer file again (adding)");
                }
                checkProblem.setAnswerFileName(serializedFile.getName());
                this.newProblemDataFiles.setJudgesAnswerFile(serializedFile);
            } else {
                serializedFile = this.getController().getProblemDataFiles(checkProblem).getJudgesAnswerFile();
                if (serializedFile == null || !serializedFile.getAbsolutePath().equals(fileName)) {
                    serializedFile = new SerializedFile(fileName);
                    this.checkFileFormat(serializedFile);
                } else {
                    serializedFile = this.freshenIfNeeded(serializedFile, fileName);
                }
                this.newProblemDataFiles.setJudgesAnswerFile(serializedFile);
                checkProblem.setAnswerFileName(serializedFile.getName());
            }
        } else {
            checkProblem.setAnswerFileName(null);
        }
        if (this.stdinRadioButton.isSelected() && this.fileRadioButton.isSelected()) {
            throw new InvalidFieldValue("Pick just one radio button");
        }
        if (this.fileRadioButton.isSelected()) {
            checkProblem.setReadInputDataFromSTDIN(false);
        } else if (this.stdinRadioButton.isSelected()) {
            checkProblem.setReadInputDataFromSTDIN(true);
        }
        checkProblem.setValidatedProblem(!this.useNOValidatatorRadioButton.isSelected());
        if (checkProblem.isValidatedProblem()) {
            checkProblem.setUsingPC2Validator(this.usePC2ValidatorRadioButton.isSelected());
        }
        checkProblem.setValidatorCommandLine(this.validatorCommandLineTextBox.getText());
        checkProblem.setWhichPC2Validator(0);
        checkProblem.setIgnoreSpacesOnValidation(false);
        checkProblem.setValidatorProgramName(null);
        if (checkProblem.isUsingPC2Validator()) {
            checkProblem.setWhichPC2Validator(this.getPc2ValidatorComboBox().getSelectedIndex());
            checkProblem.setIgnoreSpacesOnValidation(this.getIgnoreCaseCheckBox().isSelected());
            checkProblem.setValidatorCommandLine("{:validator} {:infile} {:outfile} {:ansfile} {:resfile}  -pc2 " + checkProblem.getWhichPC2Validator() + " " + checkProblem.isIgnoreSpacesOnValidation());
            checkProblem.setValidatorProgramName("pc2.jar edu.csus.ecs.pc2.validator.Validator");
        }
        checkProblem.setShowValidationToJudges(this.showValidatorToJudges.isSelected());
        checkProblem.setHideOutputWindow(!this.getDoShowOutputWindowCheckBox().isSelected());
        checkProblem.setShowCompareWindow(this.getShowCompareCheckBox().isSelected());
        String fileNameVal = this.externalValidatorLabel.getText();
        fileNameVal = fileNameVal != null ? fileNameVal.trim() : "";
        if (this.useExternalValidatorRadioButton.isSelected() && fileNameVal.length() > 0) {
            String fileName2 = fileNameVal;
            if (fileName2.length() != this.externalValidatorLabel.getToolTipText().length()) {
                fileName2 = this.externalValidatorLabel.getToolTipText() + "";
            }
            if (isAdding) {
                SerializedFile serializedFile2 = new SerializedFile(fileName2);
                if (serializedFile2.getBuffer() == null) {
                    throw new InvalidFieldValue("Unable to read file " + fileName2 + " choose validator file again (adding)");
                }
                checkProblem.setValidatorProgramName(serializedFile2.getName());
                this.newProblemDataFiles.setValidatorFile(serializedFile2);
            } else {
                SerializedFile serializedFile3 = this.getController().getProblemDataFiles(checkProblem).getValidatorFile();
                if (serializedFile3 == null || !serializedFile3.getAbsolutePath().equals(fileName2)) {
                    serializedFile3 = new SerializedFile(fileName2);
                    this.checkFileFormat(serializedFile3);
                } else {
                    serializedFile3 = this.freshenIfNeeded(serializedFile3, fileName2);
                }
                this.newProblemDataFiles.setValidatorFile(serializedFile3);
                checkProblem.setValidatorProgramName(serializedFile3.getName());
            }
        }
        checkProblem.setComputerJudged(this.computerJudging.isSelected());
        if (this.computerJudging.isSelected()) {
            checkProblem.setManualReview(this.manualReview.isSelected());
            if (this.manualReview.isSelected()) {
                checkProblem.setPrelimaryNotification(this.prelimaryNotification.isSelected());
            } else {
                checkProblem.setPrelimaryNotification(false);
            }
        } else {
            checkProblem.setManualReview(false);
            checkProblem.setPrelimaryNotification(false);
        }
        return checkProblem;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.updateProblem();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateProblem() {
        if (!this.validateProblemFields()) {
            return;
        }
        Problem newProblem = null;
        try {
            newProblem = this.getProblemFromFields(this.problem);
        }
        catch (InvalidFieldValue e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        this.getController().updateProblem(newProblem, this.newProblemDataFiles);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private boolean validateProblemFields() {
        if (this.problemNameTextField.getText().trim().length() < 1) {
            this.showMessage("Enter a problem name");
            return false;
        }
        if (this.getUsePC2ValidatorRadioButton().isSelected() && this.pc2ValidatorOptionComboBox.getSelectedIndex() < 1) {
            this.showMessage("Select a Validator option");
            return false;
        }
        if (this.getProblemRequiresDataCheckBox().isSelected()) {
            String fileName = this.inputDataFileLabel.getText();
            if (fileName == null || fileName.trim().length() == 0) {
                this.showMessage("Problem Requires Input Data checked, select a file ");
                return false;
            }
            if (fileName.trim().length() != this.inputDataFileLabel.getToolTipText().length()) {
                fileName = this.inputDataFileLabel.getToolTipText() + "";
            }
            if (!this.checkFile(fileName)) {
                return false;
            }
        }
        if (this.getJudgesHaveAnswerFiles().isSelected()) {
            String answerFileName = this.answerFileNameLabel.getText();
            if (answerFileName == null || answerFileName.trim().length() == 0) {
                this.showMessage("Problem Requires Judges' Answer File checked, select a file ");
                return false;
            }
            if (answerFileName.trim().length() != this.answerFileNameLabel.getToolTipText().length()) {
                answerFileName = this.answerFileNameLabel.getToolTipText() + "";
            }
            if (!this.checkFile(answerFileName)) {
                return false;
            }
        }
        if (this.getComputerJudging().isSelected() && this.useNOValidatatorRadioButton.isSelected()) {
            this.showMessage("Computer Judging selected, must select a validator");
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isFile()) {
                if (file.canRead()) return true;
                this.showMessage("Could not read file " + fileName);
                return false;
            }
            this.showMessage(fileName + " is not a file");
            return false;
        }
        this.showMessage(fileName + " does not exist");
        return false;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Problem modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addProblem();
                } else {
                    this.updateProblem();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    public Problem getProblem() {
        return this.problem;
    }

    public void setProblem(final Problem inProblem, final ProblemDataFiles problemDataFiles) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProblemPane.this.populatingGUI = true;
                ProblemPane.this.setForm(inProblem, problemDataFiles);
                ProblemPane.this.getAddButton().setVisible(true);
                ProblemPane.this.getUpdateButton().setVisible(false);
                ProblemPane.this.enableUpdateButtons(true);
                ProblemPane.this.enableValidatorComponents();
                ProblemPane.this.enableRequiresInputDataComponents(ProblemPane.this.problemRequiresDataCheckBox.isSelected());
                ProblemPane.this.enableProvideAnswerFileComponents(ProblemPane.this.judgesHaveAnswerFiles.isSelected());
                ProblemPane.this.getMainTabbedPane().setSelectedIndex(0);
                ProblemPane.this.populatingGUI = false;
            }
        });
    }

    public void setProblem(final Problem problem) {
        this.problem = problem;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProblemPane.this.populateGUI(problem);
                if (problem == null) {
                    ProblemPane.this.enableUpdateButtons(false);
                } else {
                    ProblemPane.this.enableUpdateButton();
                }
            }
        });
    }

    private void populateGUI(Problem inProblem) {
        this.populatingGUI = true;
        if (inProblem != null) {
            this.getAddButton().setVisible(false);
            this.getUpdateButton().setVisible(true);
            this.setForm(inProblem, this.getController().getProblemDataFiles(inProblem));
            try {
                Problem changedProblem = this.getProblemFromFields(inProblem);
            }
            catch (InvalidFieldValue e) {
                e.printStackTrace();
            }
        } else {
            this.clearForm();
        }
        this.enableValidatorComponents();
        this.enableRequiresInputDataComponents(this.problemRequiresDataCheckBox.isSelected());
        this.enableProvideAnswerFileComponents(this.judgesHaveAnswerFiles.isSelected());
        this.getMainTabbedPane().setSelectedIndex(0);
        this.populatingGUI = false;
    }

    private void setForm(Problem inProblem, ProblemDataFiles problemDataFiles) {
        this.problemNameTextField.setText(inProblem.getDisplayName());
        this.timeOutSecondTextField.setText(inProblem.getTimeOutInSeconds() + "");
        this.inputDataFileLabel.setText(inProblem.getDataFileName());
        SerializedFile sFile = problemDataFiles.getJudgesDataFile();
        if (sFile != null) {
            this.inputDataFileLabel.setToolTipText(sFile.getAbsolutePath());
        } else {
            this.inputDataFileLabel.setToolTipText("");
        }
        this.answerFileNameLabel.setText(inProblem.getAnswerFileName());
        sFile = problemDataFiles.getJudgesAnswerFile();
        if (sFile != null) {
            this.answerFileNameLabel.setToolTipText(sFile.getAbsolutePath());
        } else {
            this.answerFileNameLabel.setToolTipText("");
        }
        this.judgesHaveAnswerFiles.setSelected(inProblem.getAnswerFileName() != null);
        this.problemRequiresDataCheckBox.setSelected(inProblem.getDataFileName() != null);
        if (inProblem.isReadInputDataFromSTDIN()) {
            this.fileRadioButton.setSelected(false);
            this.stdinRadioButton.setSelected(true);
        } else {
            this.fileRadioButton.setSelected(true);
            this.stdinRadioButton.setSelected(false);
        }
        this.getPc2ValidatorComboBox().setSelectedIndex(0);
        this.getIgnoreCaseCheckBox().setSelected(true);
        this.externalValidatorLabel.setText("");
        this.externalValidatorLabel.setToolTipText("");
        this.ignoreCaseCheckBox.setSelected(false);
        if (inProblem.isValidatedProblem()) {
            if (inProblem.isUsingPC2Validator()) {
                this.getValidatorCommandLineTextBox().setText(DEFAULT_INTERNATIONAL_VALIDATOR_COMMAND);
                this.usePC2ValidatorRadioButton.setSelected(true);
                this.pc2ValidatorOptionComboBox.setSelectedIndex(inProblem.getWhichPC2Validator());
                this.ignoreCaseCheckBox.setSelected(inProblem.isIgnoreSpacesOnValidation());
            } else {
                this.getValidatorCommandLineTextBox().setText(inProblem.getValidatorCommandLine());
                this.useExternalValidatorRadioButton.setSelected(true);
                this.externalValidatorLabel.setText(inProblem.getValidatorProgramName());
                this.externalValidatorLabel.setToolTipText(inProblem.getValidatorProgramName());
                sFile = problemDataFiles.getValidatorFile();
                if (sFile != null) {
                    this.externalValidatorLabel.setToolTipText(sFile.getAbsolutePath());
                } else {
                    this.externalValidatorLabel.setToolTipText("");
                }
            }
        } else {
            this.getValidatorCommandLineTextBox().setText(DEFAULT_INTERNATIONAL_VALIDATOR_COMMAND);
            this.useNOValidatatorRadioButton.setSelected(true);
        }
        this.getShowValidatorToJudges().setSelected(inProblem.isShowValidationToJudges());
        this.getDoShowOutputWindowCheckBox().setSelected(!inProblem.isHideOutputWindow());
        this.getShowCompareCheckBox().setSelected(inProblem.isShowCompareWindow());
        this.getShowCompareCheckBox().setEnabled(this.getDoShowOutputWindowCheckBox().isSelected());
        this.getDeleteProblemCheckBox().setSelected(!inProblem.isActive());
        this.populateJudging(inProblem);
    }

    private void populateJudging(Problem inProblem) {
        if (inProblem != null && inProblem.isComputerJudged()) {
            this.computerJudging.setSelected(true);
            this.manualReview.setSelected(inProblem.isManualReview());
            this.manualReview.setEnabled(true);
            this.prelimaryNotification.setSelected(inProblem.isPrelimaryNotification());
            if (this.manualReview.isSelected()) {
                this.prelimaryNotification.setEnabled(true);
            } else {
                this.prelimaryNotification.setEnabled(false);
            }
        } else {
            this.computerJudging.setSelected(false);
            this.manualJudging.setSelected(true);
            if (inProblem == null) {
                this.manualReview.setSelected(false);
                this.prelimaryNotification.setSelected(false);
            } else {
                this.manualReview.setSelected(inProblem.isManualReview());
                this.prelimaryNotification.setSelected(inProblem.isPrelimaryNotification());
            }
            this.manualReview.setEnabled(false);
            this.prelimaryNotification.setEnabled(false);
        }
    }

    protected void enableUpdateButtons(boolean fieldsChanged) {
        if (fieldsChanged) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        if (this.getUpdateButton().isVisible()) {
            this.getUpdateButton().setEnabled(fieldsChanged);
        } else {
            this.getAddButton().setEnabled(fieldsChanged);
        }
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
            this.mainTabbedPane.setPreferredSize(new Dimension(400, 400));
            this.mainTabbedPane.addTab("General", null, this.getGeneralPane(), null);
            this.mainTabbedPane.addTab("Judging Type", null, this.getJudgingTypePanel(), null);
            this.mainTabbedPane.addTab("Validator", null, this.getValidatorPane(), null);
        }
        return this.mainTabbedPane;
    }

    private JPanel getJudgingTypePanel() {
        if (this.judgingTypePane == null) {
            this.judgingTypePane = new JPanel();
            this.judgingTypePane.setLayout(null);
            this.judgingTypePane.add((Component)this.getComputerJudging(), null);
            this.judgingTypePane.add((Component)this.getManualJudging(), null);
            this.judgingTypePane.add((Component)this.getManualReview(), null);
            this.judgingTypePane.add((Component)this.getPrelimaryNotification(), null);
            this.getJudgingTypeGroup().setSelected(this.getManualJudging().getModel(), true);
        }
        return this.judgingTypePane;
    }

    private JPanel getGeneralPane() {
        if (this.generalPane == null) {
            this.timeoutLabel = new JLabel();
            this.timeoutLabel.setBounds(new Rectangle(23, 46, 175, 16));
            this.timeoutLabel.setText("Run Timeout Limit (Secs)");
            this.problemNameLabel = new JLabel();
            this.problemNameLabel.setBounds(new Rectangle(23, 14, 179, 16));
            this.problemNameLabel.setText("Problem name");
            this.generalPane = new JPanel();
            this.generalPane.setLayout(null);
            this.generalPane.add((Component)this.getProblemNameTextField(), null);
            this.generalPane.add((Component)this.getJTextField(), null);
            this.generalPane.add((Component)this.getProblemRequiresDataCheckBox(), null);
            this.generalPane.add((Component)this.getDataProblemPane(), null);
            this.generalPane.add((Component)this.getJudgesHaveAnswerFiles(), null);
            this.generalPane.add((Component)this.getAnswerFilePane(), null);
            this.generalPane.add((Component)this.problemNameLabel, null);
            this.generalPane.add((Component)this.timeoutLabel, null);
            this.generalPane.add((Component)this.getShowCompareCheckBox(), null);
            this.generalPane.add((Component)this.getDoShowOutputWindowCheckBox(), null);
            this.generalPane.add((Component)this.getDeleteProblemCheckBox(), null);
        }
        return this.generalPane;
    }

    protected JTextField getProblemNameTextField() {
        if (this.problemNameTextField == null) {
            this.problemNameTextField = new JTextField();
            this.problemNameTextField.setPreferredSize(new Dimension(120, 20));
            this.problemNameTextField.setSize(new Dimension(273, 20));
            this.problemNameTextField.setLocation(new Point(220, 12));
            this.problemNameTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.problemNameTextField;
    }

    private JTextField getJTextField() {
        if (this.timeOutSecondTextField == null) {
            this.timeOutSecondTextField = new JTextField();
            this.timeOutSecondTextField.setBounds(new Rectangle(220, 44, 120, 20));
            this.timeOutSecondTextField.setPreferredSize(new Dimension(120, 20));
            this.timeOutSecondTextField.setDocument(new IntegerDocument());
            this.timeOutSecondTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.timeOutSecondTextField;
    }

    private JCheckBox getProblemRequiresDataCheckBox() {
        if (this.problemRequiresDataCheckBox == null) {
            this.problemRequiresDataCheckBox = new JCheckBox();
            this.problemRequiresDataCheckBox.setBounds(new Rectangle(23, 76, 257, 26));
            this.problemRequiresDataCheckBox.setText("Problem Requires Input Data");
            this.problemRequiresDataCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableRequiresInputDataComponents(ProblemPane.this.problemRequiresDataCheckBox.isSelected());
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.problemRequiresDataCheckBox;
    }

    protected void enableRequiresInputDataComponents(boolean enableButtons) {
        this.getInputDataFilePane().setEnabled(enableButtons);
        this.getFileRadioButton().setEnabled(enableButtons);
        this.getStdinRadioButton().setEnabled(enableButtons);
        this.getReadsFromPane().setEnabled(enableButtons);
        this.getSelectFileButton().setEnabled(enableButtons);
        this.getInputDataFilePane().setEnabled(enableButtons);
        this.getFileNamePane().setEnabled(enableButtons);
        this.getInputDataFilePane().setEnabled(enableButtons);
        this.getFileNamePane().setEnabled(enableButtons);
    }

    private JPanel getDataProblemPane() {
        if (this.dataProblemPane == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setHgap(5);
            gridLayout.setVgap(6);
            this.dataProblemPane = new JPanel();
            this.dataProblemPane.setLayout(gridLayout);
            this.dataProblemPane.setBounds(new Rectangle(53, 114, 423, 113));
            this.dataProblemPane.add((Component)this.getReadsFromPane(), null);
            this.dataProblemPane.add((Component)this.getInputDataFilePane(), null);
        }
        return this.dataProblemPane;
    }

    private JPanel getReadsFromPane() {
        if (this.readsFromPane == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setHgap(35);
            flowLayout1.setAlignment(0);
            flowLayout1.setVgap(0);
            this.readsFromPane = new JPanel();
            this.readsFromPane.setLayout(flowLayout1);
            this.readsFromPane.setBorder(BorderFactory.createTitledBorder(null, "Team Reads From", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.readsFromPane.add((Component)this.getFileRadioButton(), null);
            this.readsFromPane.add((Component)this.getStdinRadioButton(), null);
            this.getTeamReadsFrombuttonGroup().setSelected(this.getFileRadioButton().getModel(), true);
            this.getValidatorChoiceButtonGroup().setSelected(this.getUseNOValidatatorRadioButton().getModel(), true);
        }
        return this.readsFromPane;
    }

    private JPanel getInputDataFilePane() {
        if (this.inputDataFilePane == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(15);
            borderLayout.setVgap(5);
            this.inputDataFilePane = new JPanel();
            this.inputDataFilePane.setLayout(borderLayout);
            this.inputDataFilePane.setBorder(BorderFactory.createTitledBorder(null, "Input Data File", 0, 0, null, null));
            this.inputDataFilePane.setPreferredSize(new Dimension(98, 45));
            this.inputDataFilePane.add((Component)this.getFileNamePane(), "Center");
            this.inputDataFilePane.add((Component)this.getSelectFileButton(), "East");
        }
        return this.inputDataFilePane;
    }

    private JRadioButton getStdinRadioButton() {
        if (this.stdinRadioButton == null) {
            this.stdinRadioButton = new JRadioButton();
            this.stdinRadioButton.setText("Stdin");
            this.stdinRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.stdinRadioButton;
    }

    private JRadioButton getFileRadioButton() {
        if (this.fileRadioButton == null) {
            this.fileRadioButton = new JRadioButton();
            this.fileRadioButton.setText("File");
            this.fileRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.fileRadioButton;
    }

    private JPanel getFileNamePane() {
        if (this.fileNamePane == null) {
            this.inputDataFileLabel = new JLabel();
            this.inputDataFileLabel.setText("");
            this.fileNamePane = new JPanel();
            this.fileNamePane.setLayout(new BorderLayout());
            this.fileNamePane.add((Component)this.inputDataFileLabel, "Center");
        }
        return this.fileNamePane;
    }

    private JButton getSelectFileButton() {
        if (this.selectFileButton == null) {
            this.selectFileButton = new JButton();
            this.selectFileButton.setText("Browse");
            this.selectFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ProblemPane.this.selectFile(ProblemPane.this.inputDataFileLabel)) {
                        ProblemPane.this.inputDataFileLabel.setToolTipText(ProblemPane.this.inputDataFileLabel.getText());
                    }
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.selectFileButton;
    }

    private JCheckBox getJudgesHaveAnswerFiles() {
        if (this.judgesHaveAnswerFiles == null) {
            this.judgesHaveAnswerFiles = new JCheckBox();
            this.judgesHaveAnswerFiles.setBounds(new Rectangle(23, 239, 302, 24));
            this.judgesHaveAnswerFiles.setText("Judges Have Provided Answer File");
            this.judgesHaveAnswerFiles.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableProvideAnswerFileComponents(ProblemPane.this.judgesHaveAnswerFiles.isSelected());
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.judgesHaveAnswerFiles;
    }

    protected void enableProvideAnswerFileComponents(boolean enableComponents) {
        this.getAnswerFilenamePane().setEnabled(enableComponents);
        this.getAnswerBrowseButton().setEnabled(enableComponents);
        this.answerFileNameLabel.setEnabled(enableComponents);
    }

    private JPanel getAnswerFilePane() {
        if (this.answerFilePane == null) {
            BorderLayout borderLayout1 = new BorderLayout();
            borderLayout1.setHgap(15);
            borderLayout1.setVgap(5);
            this.answerFilePane = new JPanel();
            this.answerFilePane.setLayout(borderLayout1);
            this.answerFilePane.setBounds(new Rectangle(53, 275, 423, 52));
            this.answerFilePane.setBorder(BorderFactory.createTitledBorder(null, "Answer File", 0, 0, null, null));
            this.answerFilePane.add((Component)this.getAnswerFilenamePane(), "Center");
            this.answerFilePane.add((Component)this.getAnswerBrowseButton(), "East");
        }
        return this.answerFilePane;
    }

    private JPanel getAnswerFilenamePane() {
        if (this.answerFilenamePane == null) {
            this.answerFileNameLabel = new JLabel();
            this.answerFileNameLabel.setText("");
            this.answerFilenamePane = new JPanel();
            this.answerFilenamePane.setLayout(new BorderLayout());
            this.answerFilenamePane.add((Component)this.answerFileNameLabel, "Center");
        }
        return this.answerFilenamePane;
    }

    private JButton getAnswerBrowseButton() {
        if (this.answerBrowseButton == null) {
            this.answerBrowseButton = new JButton();
            this.answerBrowseButton.setText("Browse");
            this.answerBrowseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ProblemPane.this.selectFile(ProblemPane.this.answerFileNameLabel)) {
                        ProblemPane.this.answerFileNameLabel.setToolTipText(ProblemPane.this.answerFileNameLabel.getText());
                    }
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.answerBrowseButton;
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, message);
            }
        });
    }

    private boolean selectFile(JLabel label) {
        boolean result = false;
        String oldFile = label.getToolTipText();
        String startDir = oldFile.equalsIgnoreCase("") ? this.lastDirectory : oldFile;
        JFileChooser chooser = new JFileChooser(startDir);
        try {
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.lastDirectory = chooser.getCurrentDirectory().toString();
                label.setText(chooser.getSelectedFile().getCanonicalFile().toString());
                result = true;
            }
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Error getting selected file, try again.", e);
            result = false;
        }
        chooser = null;
        return result;
    }

    private ButtonGroup getTeamReadsFrombuttonGroup() {
        if (this.teamReadsFrombuttonGroup == null) {
            this.teamReadsFrombuttonGroup = new ButtonGroup();
            this.teamReadsFrombuttonGroup.add(this.getStdinRadioButton());
            this.teamReadsFrombuttonGroup.add(this.getFileRadioButton());
        }
        return this.teamReadsFrombuttonGroup;
    }

    private ButtonGroup getJudgingTypeGroup() {
        if (this.judgingTypeGroup == null) {
            this.judgingTypeGroup = new ButtonGroup();
            this.judgingTypeGroup.add(this.getComputerJudging());
            this.judgingTypeGroup.add(this.getManualJudging());
        }
        return this.judgingTypeGroup;
    }

    private JPanel getValidatorPane() {
        if (this.validatorPane == null) {
            this.validatorPane = new JPanel();
            this.validatorPane.setLayout(null);
            this.validatorPane.add((Component)this.getUseNOValidatatorRadioButton(), null);
            this.validatorPane.add((Component)this.getUsePC2ValidatorRadioButton(), null);
            this.validatorPane.add((Component)this.getUseExternalValidatorRadioButton(), null);
            this.validatorPane.add((Component)this.getShowValidatorToJudges(), null);
            this.validatorPane.add((Component)this.getPc2ValidatorFrame(), null);
            this.validatorPane.add((Component)this.getExternalValidatorFrame(), null);
        }
        return this.validatorPane;
    }

    private JRadioButton getUseNOValidatatorRadioButton() {
        if (this.useNOValidatatorRadioButton == null) {
            this.useNOValidatatorRadioButton = new JRadioButton();
            this.useNOValidatatorRadioButton.setBounds(new Rectangle(20, 15, 246, 23));
            this.useNOValidatatorRadioButton.setText("Do not use Validator");
            this.useNOValidatatorRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableValidatorComponents();
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.useNOValidatatorRadioButton;
    }

    protected void enableValidatorComponents() {
        if (this.usePC2ValidatorRadioButton.isSelected()) {
            this.enablePC2ValidatorComponents(true);
            this.enableExternalValidatorComponents(false);
            this.getShowValidatorToJudges().setEnabled(true);
        } else if (this.useExternalValidatorRadioButton.isSelected()) {
            this.enablePC2ValidatorComponents(false);
            this.enableExternalValidatorComponents(true);
            this.getShowValidatorToJudges().setEnabled(true);
        } else {
            this.enablePC2ValidatorComponents(false);
            this.enableExternalValidatorComponents(false);
            this.getShowValidatorToJudges().setEnabled(false);
        }
    }

    private JRadioButton getUsePC2ValidatorRadioButton() {
        if (this.usePC2ValidatorRadioButton == null) {
            this.usePC2ValidatorRadioButton = new JRadioButton();
            this.usePC2ValidatorRadioButton.setBounds(new Rectangle(21, 49, 246, 23));
            this.usePC2ValidatorRadioButton.setText("Use PC^2 Validator");
            this.usePC2ValidatorRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableValidatorComponents();
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.usePC2ValidatorRadioButton;
    }

    protected void enableExternalValidatorComponents(boolean enableComponents) {
        this.getExternalValidatorFrame().setEnabled(enableComponents);
        this.getValidatorProgramJButton().setEnabled(enableComponents);
        this.getValidatorCommandLineTextBox().setEnabled(enableComponents);
    }

    protected void enablePC2ValidatorComponents(boolean enableComponents) {
        this.ignoreCaseCheckBox.setEnabled(enableComponents);
        this.pc2ValidatorOptionComboBox.setEnabled(enableComponents);
    }

    private JRadioButton getUseExternalValidatorRadioButton() {
        if (this.useExternalValidatorRadioButton == null) {
            this.useExternalValidatorRadioButton = new JRadioButton();
            this.useExternalValidatorRadioButton.setBounds(new Rectangle(17, 196, 246, 23));
            this.useExternalValidatorRadioButton.setText("Use External Validator");
            this.useExternalValidatorRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableValidatorComponents();
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.useExternalValidatorRadioButton;
    }

    private JCheckBox getShowValidatorToJudges() {
        if (this.showValidatorToJudges == null) {
            this.showValidatorToJudges = new JCheckBox();
            this.showValidatorToJudges.setBounds(new Rectangle(38, 368, 306, 24));
            this.showValidatorToJudges.setText("Show Validator To Judges (SVTJ)");
            this.showValidatorToJudges.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.showValidatorToJudges;
    }

    private JPanel getPc2ValidatorFrame() {
        if (this.pc2ValidatorFrame == null) {
            this.validatorOptionsLabel = new JLabel();
            this.validatorOptionsLabel.setText("Validator Option");
            this.validatorOptionsLabel.setBounds(new Rectangle(22, 26, 123, 23));
            this.pc2ValidatorFrame = new JPanel();
            this.pc2ValidatorFrame.setLayout(null);
            this.pc2ValidatorFrame.setBounds(new Rectangle(40, 80, 471, 108));
            this.pc2ValidatorFrame.setBorder(BorderFactory.createTitledBorder(null, "PC^2 Validator", 0, 0, null, null));
            this.pc2ValidatorFrame.add((Component)this.validatorOptionsLabel, null);
            this.pc2ValidatorFrame.add((Component)this.getPc2ValidatorComboBox(), null);
            this.pc2ValidatorFrame.add((Component)this.getIgnoreCaseCheckBox(), null);
        }
        return this.pc2ValidatorFrame;
    }

    private JPanel getExternalValidatorFrame() {
        if (this.externalValidatorFrame == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(14, 53, 177, 16));
            this.jLabel.setText("Validator Command Line");
            this.validatorProgramLabel = new JLabel();
            this.validatorProgramLabel.setText("Validator Program");
            this.validatorProgramLabel.setBounds(new Rectangle(13, 26, 121, 16));
            this.externalValidatorFrame = new JPanel();
            this.externalValidatorFrame.setLayout(null);
            this.externalValidatorFrame.setBounds(new Rectangle(39, 231, 470, 127));
            this.externalValidatorFrame.setBorder(BorderFactory.createTitledBorder(null, "External Validator", 0, 0, null, null));
            this.externalValidatorFrame.add((Component)this.validatorProgramLabel, null);
            this.externalValidatorFrame.add((Component)this.getExternalValidatorPane(), null);
            this.externalValidatorFrame.add((Component)this.getValidatorProgramJButton(), null);
            this.externalValidatorFrame.add((Component)this.jLabel, null);
            this.externalValidatorFrame.add((Component)this.getValidatorCommandLineTextBox(), null);
        }
        return this.externalValidatorFrame;
    }

    private JComboBox getPc2ValidatorComboBox() {
        if (this.pc2ValidatorOptionComboBox == null) {
            this.pc2ValidatorOptionComboBox = new JComboBox();
            this.pc2ValidatorOptionComboBox.setBounds(new Rectangle(158, 24, 255, 26));
            this.pc2ValidatorOptionComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
            this.pc2ValidatorOptionComboBox.addItem("None Selected");
            this.pc2ValidatorOptionComboBox.addItem("1 - diff");
            this.pc2ValidatorOptionComboBox.addItem("2 - ignore whitespace at start of file");
            this.pc2ValidatorOptionComboBox.addItem("3 - ignore leading whitespace on lines");
            this.pc2ValidatorOptionComboBox.addItem("4 - ignore all whitespace on lines");
            this.pc2ValidatorOptionComboBox.addItem("5 - ignore empty lines");
        }
        return this.pc2ValidatorOptionComboBox;
    }

    private JCheckBox getIgnoreCaseCheckBox() {
        if (this.ignoreCaseCheckBox == null) {
            this.ignoreCaseCheckBox = new JCheckBox();
            this.ignoreCaseCheckBox.setBounds(new Rectangle(27, 62, 263, 24));
            this.ignoreCaseCheckBox.setText("Ignore Case In Output");
            this.ignoreCaseCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.ignoreCaseCheckBox;
    }

    private JPanel getExternalValidatorPane() {
        if (this.externalValidatorLabel == null) {
            this.externalValidatorLabel = new JLabel();
            this.externalValidatorLabel.setText("");
            this.externalValidatorLabel.setToolTipText("");
            this.externalValidatorPane = new JPanel();
            this.externalValidatorPane.setLayout(new BorderLayout());
            this.externalValidatorPane.setBounds(new Rectangle(140, 21, 267, 22));
            this.externalValidatorPane.add((Component)this.externalValidatorLabel, "Center");
        }
        return this.externalValidatorPane;
    }

    private JButton getValidatorProgramJButton() {
        if (this.validatorProgramJButton == null) {
            this.validatorProgramJButton = new JButton();
            this.validatorProgramJButton.setBounds(new Rectangle(425, 21, 34, 25));
            this.validatorProgramJButton.setText("...");
            this.validatorProgramJButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ProblemPane.this.selectFile(ProblemPane.this.externalValidatorLabel)) {
                        ProblemPane.this.externalValidatorLabel.setToolTipText(ProblemPane.this.externalValidatorLabel.getText());
                        ProblemPane.this.enableUpdateButton();
                    }
                }
            });
        }
        return this.validatorProgramJButton;
    }

    private JTextField getValidatorCommandLineTextBox() {
        if (this.validatorCommandLineTextBox == null) {
            this.validatorCommandLineTextBox = new JTextField();
            this.validatorCommandLineTextBox.setBounds(new Rectangle(17, 78, 432, 29));
            this.validatorCommandLineTextBox.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.validatorCommandLineTextBox;
    }

    private JCheckBox getShowCompareCheckBox() {
        if (this.showCompareCheckBox == null) {
            this.showCompareCheckBox = new JCheckBox();
            this.showCompareCheckBox.setBounds(new Rectangle(44, 372, 207, 21));
            this.showCompareCheckBox.setText("Show Compare");
            this.showCompareCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.showCompareCheckBox;
    }

    private JCheckBox getDoShowOutputWindowCheckBox() {
        if (this.doShowOutputWindowCheckBox == null) {
            this.doShowOutputWindowCheckBox = new JCheckBox();
            this.doShowOutputWindowCheckBox.setBounds(new Rectangle(23, 338, 303, 24));
            this.doShowOutputWindowCheckBox.setSelected(true);
            this.doShowOutputWindowCheckBox.setText("Show the output window");
            this.doShowOutputWindowCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableUpdateButton();
                    ProblemPane.this.getShowCompareCheckBox().setEnabled(ProblemPane.this.getDoShowOutputWindowCheckBox().isSelected());
                }
            });
        }
        return this.doShowOutputWindowCheckBox;
    }

    private ButtonGroup getValidatorChoiceButtonGroup() {
        if (this.validatorChoiceButtonGroup == null) {
            this.validatorChoiceButtonGroup = new ButtonGroup();
            this.validatorChoiceButtonGroup.add(this.getUseNOValidatatorRadioButton());
            this.validatorChoiceButtonGroup.add(this.getUsePC2ValidatorRadioButton());
            this.validatorChoiceButtonGroup.add(this.getUseExternalValidatorRadioButton());
        }
        return this.validatorChoiceButtonGroup;
    }

    private SerializedFile freshenIfNeeded(SerializedFile serializedFile, String fileName) throws InvalidFieldValue {
        if (serializedFile == null) {
            return null;
        }
        if (serializedFile.getBuffer() == null) {
            throw new InvalidFieldValue("Unable to read file " + fileName + " choose file again (updating)");
        }
        if (fileName != null && fileName.equals(serializedFile.getAbsolutePath())) {
            if (!this.populatingGUI && this.needsFreshening(serializedFile, fileName)) {
                int result = JOptionPane.showConfirmDialog(this, "File (" + fileName + ") has changed; reload from disk?", "Freshen file " + serializedFile.getAbsolutePath() + "?", 0, 3);
                if (result == 0) {
                    serializedFile = new SerializedFile(serializedFile.getAbsolutePath());
                    this.checkFileFormat(serializedFile);
                    return serializedFile;
                }
                if (result == 2) {
                    throw new InvalidFieldValue("Update cancelled");
                }
            }
        } else if (fileName != null) {
            serializedFile = new SerializedFile(fileName);
        }
        this.checkFileFormat(serializedFile);
        return serializedFile;
    }

    public boolean needsFreshening(SerializedFile serializedFile, String fileName) {
        if (serializedFile == null) {
            return false;
        }
        try {
            File f = new File(serializedFile.getAbsolutePath());
            if (f.exists()) {
                SerializedFile newSerializedFile = new SerializedFile(f.getAbsolutePath());
                return !serializedFile.getSHA1sum().equals(newSerializedFile.getSHA1sum());
            }
        }
        catch (Exception ex99) {
            this.getController().getLog().log(Log.DEBUG, "Exception ", ex99);
        }
        return false;
    }

    public boolean checkFileFormat(SerializedFile newFile) throws InvalidFieldValue {
        int currentOS = 0;
        if (NL.length() == 2) {
            currentOS = 2;
        } else if (NL.charAt(0) == '\n') {
            currentOS = 8;
        } else if (NL.charAt(0) == '\r') {
            currentOS = 4;
        }
        if (currentOS != newFile.getFileType() && newFile.getFileType() != 1 && newFile.getFileType() != 16 && newFile.getFileType() != 32) {
            String fileName = newFile.getName();
            String question = "The file (" + fileName + ") you are loading appears to be of type '";
            if (newFile.getFileType() == 1) {
                question = question + "Binary";
            } else if (newFile.getFileType() == 2) {
                question = question + "DOS";
            } else if (newFile.getFileType() == 4) {
                question = question + "Apple";
            } else if (newFile.getFileType() == 8) {
                question = question + "Unix";
            } else if (newFile.getFileType() == 16) {
                question = question + "ASCII_Generic";
            } else if (newFile.getFileType() == 32) {
                question = question + "ASCII_Other";
            }
            question = question + "'." + NL + NL;
            question = question + "The Current OS is '" + System.getProperty("os.name", "?");
            question = question + "'." + NL + NL;
            question = question + "Do you want the file converted to the current OS file format as it is loaded into PC^2?";
            int answer = JOptionPane.showConfirmDialog(this, question, "File Format Mismatch", 1, 2);
            if (answer == 0) {
                newFile.convertFile(currentOS);
                return true;
            }
            if (answer == 2) {
                throw new InvalidFieldValue("Update canceled");
            }
        }
        return false;
    }

    void clearForm() {
        this.getAddButton().setVisible(true);
        this.getUpdateButton().setVisible(false);
        this.addButton.setEnabled(true);
        this.updateButton.setEnabled(false);
        this.problemNameTextField.setText("");
        this.timeOutSecondTextField.setText("120");
        this.judgesHaveAnswerFiles.setSelected(false);
        this.problemRequiresDataCheckBox.setSelected(false);
        this.inputDataFileLabel.setText("");
        this.inputDataFileLabel.setToolTipText("");
        this.answerFileNameLabel.setText("");
        this.answerFileNameLabel.setToolTipText("");
        this.fileRadioButton.setSelected(false);
        this.stdinRadioButton.setSelected(false);
        this.useNOValidatatorRadioButton.setSelected(true);
        this.pc2ValidatorOptionComboBox.setSelectedIndex(0);
        this.ignoreCaseCheckBox.setSelected(false);
        this.externalValidatorLabel.setText("");
        this.externalValidatorLabel.setToolTipText("");
        this.getValidatorCommandLineTextBox().setText(DEFAULT_INTERNATIONAL_VALIDATOR_COMMAND);
        this.getShowValidatorToJudges().setSelected(true);
        this.getDoShowOutputWindowCheckBox().setSelected(true);
        this.getShowCompareCheckBox().setSelected(true);
        this.getShowCompareCheckBox().setEnabled(this.getDoShowOutputWindowCheckBox().isSelected());
        this.getDeleteProblemCheckBox().setSelected(false);
        this.populateJudging(null);
    }

    private JRadioButton getComputerJudging() {
        if (this.computerJudging == null) {
            this.computerJudging = new JRadioButton();
            this.computerJudging.setBounds(new Rectangle(100, 56, 173, 21));
            this.computerJudging.setText("Computer Judging");
            this.computerJudging.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.manualReview.setEnabled(true);
                    ProblemPane.this.prelimaryNotification.setEnabled(ProblemPane.this.manualReview.isSelected());
                    ProblemPane.this.prelimaryNotification.setEnabled(ProblemPane.this.manualReview.isSelected());
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.computerJudging;
    }

    private JRadioButton getManualJudging() {
        if (this.manualJudging == null) {
            this.manualJudging = new JRadioButton();
            this.manualJudging.setBounds(new Rectangle(100, 174, 156, 21));
            this.manualJudging.setText("Manual Judging");
            this.manualJudging.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.manualReview.setEnabled(false);
                    ProblemPane.this.prelimaryNotification.setEnabled(false);
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.manualJudging;
    }

    private JCheckBox getManualReview() {
        if (this.manualReview == null) {
            this.manualReview = new JCheckBox();
            this.manualReview.setBounds(new Rectangle(125, 89, 186, 21));
            this.manualReview.setText("Manual Review");
            this.manualReview.setEnabled(false);
            this.manualReview.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.prelimaryNotification.setEnabled(ProblemPane.this.manualReview.isSelected());
                    ProblemPane.this.prelimaryNotification.setEnabled(ProblemPane.this.manualReview.isSelected());
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.manualReview;
    }

    private JCheckBox getPrelimaryNotification() {
        if (this.prelimaryNotification == null) {
            this.prelimaryNotification = new JCheckBox();
            this.prelimaryNotification.setBounds(new Rectangle(168, 122, 328, 21));
            this.prelimaryNotification.setText("Send Preliminary Notification to the team");
            this.prelimaryNotification.setEnabled(false);
            this.prelimaryNotification.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.prelimaryNotification;
    }

    private JCheckBox getDeleteProblemCheckBox() {
        if (this.deleteProblemCheckBox == null) {
            this.deleteProblemCheckBox = new JCheckBox();
            this.deleteProblemCheckBox.setBounds(new Rectangle(324, 372, 182, 21));
            this.deleteProblemCheckBox.setText("Hide Problem");
            this.deleteProblemCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProblemPane.this.enableUpdateButton();
                }
            });
        }
        return this.deleteProblemCheckBox;
    }
}

