/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.JPluginPaneNameComparator;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.AccountsPane;
import edu.csus.ecs.pc2.ui.BalloonColorListPane;
import edu.csus.ecs.pc2.ui.ClarificationsPane;
import edu.csus.ecs.pc2.ui.ConnectionsPane;
import edu.csus.ecs.pc2.ui.ContestClockPane;
import edu.csus.ecs.pc2.ui.ContestTimesPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.GroupsPane;
import edu.csus.ecs.pc2.ui.InfoPane;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.JudgementsPanel;
import edu.csus.ecs.pc2.ui.LanguagesPane;
import edu.csus.ecs.pc2.ui.LoadContestPane;
import edu.csus.ecs.pc2.ui.LoginsPane;
import edu.csus.ecs.pc2.ui.MessageMonitorPane;
import edu.csus.ecs.pc2.ui.OptionsPanel;
import edu.csus.ecs.pc2.ui.PacketExplorerPane;
import edu.csus.ecs.pc2.ui.PacketMonitorPane;
import edu.csus.ecs.pc2.ui.PlaybackPane;
import edu.csus.ecs.pc2.ui.ProblemsPane;
import edu.csus.ecs.pc2.ui.ProfilesPane;
import edu.csus.ecs.pc2.ui.ReportPane;
import edu.csus.ecs.pc2.ui.RunsPanel;
import edu.csus.ecs.pc2.ui.SitesPanel;
import edu.csus.ecs.pc2.ui.StandingsPane;
import edu.csus.ecs.pc2.ui.SubmissionBiffPane;
import edu.csus.ecs.pc2.ui.TeamStatusPane;
import edu.csus.ecs.pc2.ui.ViewPropertiesPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class PluginLoadPane
extends JPanePlugin {
    private static final long serialVersionUID = -1303011559658754807L;
    private JComboBox pluginComboBox = null;
    private JButton openNewPluginButton = null;
    private JButton addPluginInNewWindow = null;
    private JTabbedPane parentTabbedPane = null;

    public JTabbedPane getParentTabbedPane() {
        return this.parentTabbedPane;
    }

    public void setParentTabbedPane(JTabbedPane parentTabbedPane) {
        this.parentTabbedPane = parentTabbedPane;
    }

    public PluginLoadPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setSize(new Dimension(536, 240));
        this.add((Component)this.getPluginComboBox(), null);
        this.add((Component)this.getOpenNewPluginButton(), null);
        this.add((Component)this.getAddPluginInNewWindow(), null);
    }

    public String getPluginTitle() {
        return "Plugin Load";
    }

    private JComboBox getPluginComboBox() {
        if (this.pluginComboBox == null) {
            this.pluginComboBox = new JComboBox();
            this.pluginComboBox.setBounds(new Rectangle(41, 57, 458, 33));
        }
        return this.pluginComboBox;
    }

    private JButton getOpenNewPluginButton() {
        if (this.openNewPluginButton == null) {
            this.openNewPluginButton = new JButton();
            this.openNewPluginButton.setBounds(new Rectangle(41, 147, 134, 36));
            this.openNewPluginButton.setText("Add Tab");
            this.openNewPluginButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PluginLoadPane.this.addNewTab();
                }
            });
        }
        return this.openNewPluginButton;
    }

    protected void addNewTab() {
        if (this.parentTabbedPane != null) {
            PluginWrapper wrapper = (PluginWrapper)this.getPluginComboBox().getSelectedItem();
            this.getController().register(wrapper.getPlugin());
            wrapper.getPlugin().setContestAndController(this.getContest(), this.getController());
            this.parentTabbedPane.add((Component)wrapper.getPlugin(), wrapper.getPlugin().getPluginTitle());
        } else {
            JOptionPane.showMessageDialog(this, "Programming error: no tab specified");
        }
    }

    private JButton getAddPluginInNewWindow() {
        if (this.addPluginInNewWindow == null) {
            this.addPluginInNewWindow = new JButton();
            this.addPluginInNewWindow.setBounds(new Rectangle(317, 147, 182, 36));
            this.addPluginInNewWindow.setText("Open in new Window");
            this.addPluginInNewWindow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PluginLoadPane.this.addNewPluginWindow();
                }
            });
        }
        return this.addPluginInNewWindow;
    }

    protected void addNewPluginWindow() {
        PluginWrapper wrapper = (PluginWrapper)this.getPluginComboBox().getSelectedItem();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        JPanePlugin plugin = wrapper.getPlugin();
        frame.setContentPane(plugin);
        frame.setTitle(wrapper.getPlugin().getPluginTitle());
        plugin.setParentFrame(frame);
        plugin.setContestAndController(this.getContest(), this.getController());
        frame.pack();
        frame.setBounds(new Rectangle(0, 0, 500, 350));
        FrameUtilities.centerFrame(frame);
        frame.setVisible(true);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.loadPluginList();
    }

    private JPanePlugin[] getPluginList() {
        Vector<JPanePlugin> plugins = new Vector<JPanePlugin>();
        plugins.add(new AccountsPane());
        plugins.add(new BalloonColorListPane());
        plugins.add(new ClarificationsPane());
        plugins.add(new ConnectionsPane());
        plugins.add(new ContestClockPane());
        plugins.add(new ContestTimesPane());
        plugins.add(new GroupsPane());
        plugins.add(new InfoPane());
        plugins.add(new JudgementsPanel());
        plugins.add(new LanguagesPane());
        plugins.add(new LoadContestPane());
        plugins.add(new LoginsPane());
        plugins.add(new OptionsPanel());
        plugins.add(new PacketExplorerPane());
        plugins.add(new PlaybackPane());
        plugins.add(new ProblemsPane());
        plugins.add(new ProfilesPane());
        plugins.add(new ReportPane());
        plugins.add(new RunsPanel());
        plugins.add(new SitesPanel());
        plugins.add(new StandingsPane());
        plugins.add(new SubmissionBiffPane());
        plugins.add(new TeamStatusPane());
        plugins.add(new ViewPropertiesPane());
        plugins.add(new PacketMonitorPane());
        plugins.add(new MessageMonitorPane());
        JPanePlugin[] pluginList = plugins.toArray(new JPanePlugin[plugins.size()]);
        Arrays.sort(pluginList, new JPluginPaneNameComparator());
        return pluginList;
    }

    private void loadPluginList() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginLoadPane.this.pluginComboBox.removeAllItems();
                for (JPanePlugin plugin : PluginLoadPane.this.getPluginList()) {
                    PluginWrapper wrapper = new PluginWrapper(plugin);
                    PluginLoadPane.this.pluginComboBox.addItem(wrapper);
                }
            }
        });
    }

    protected class PluginWrapper {
        private JPanePlugin plugin = null;

        public PluginWrapper(JPanePlugin plugin) {
            this.plugin = plugin;
        }

        public String toString() {
            return this.plugin.getPluginTitle();
        }

        public JPanePlugin getPlugin() {
            return this.plugin;
        }
    }
}

