/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.playback.PlaybackEvent;
import edu.csus.ecs.pc2.core.model.playback.PlaybackManager;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PlaybackPane
extends JPanePlugin {
    private static final long serialVersionUID = -1344873174060871842L;
    private JPanel centerPane = null;
    private JPanel buttonPane = null;
    private MCLB eventsListBox = null;
    private JButton startButton = null;
    private JButton stopButton = null;
    private JButton resetButton = null;
    private JPanel topPane = null;
    private JTextField timeWarpTextField = null;
    private JLabel msLabel = null;
    private JLabel stopAtLabel = null;
    private JTextField stopEventNumberTextField = null;
    private JRadioButton everyMSEventPacing = null;
    private ButtonGroup timeWarpButtonGroup = null;
    private JButton stepButton = null;
    private JButton loadButton = null;
    private PlaybackManager playbackManager = new PlaybackManager();
    private JLabel currentEventLabel = null;

    public PlaybackPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(594, 282));
        this.add((Component)this.getCenterPane(), "West");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getTopPane(), "North");
        this.add((Component)((Object)this.getEventsListBox()), "Center");
        this.currentEventLabel.setText("At (start)");
    }

    public String getPluginTitle() {
        return "Contest Playback";
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new GridBagLayout());
        }
        return this.centerPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getStartButton(), null);
            this.buttonPane.add((Component)this.getStopButton(), null);
            this.buttonPane.add((Component)this.getResetButton(), null);
            this.buttonPane.add((Component)this.getLoadButton(), null);
        }
        return this.buttonPane;
    }

    private MCLB getEventsListBox() {
        if (this.eventsListBox == null) {
            this.eventsListBox = new MCLB();
            Object[] cols = new Object[]{"Seq", "Who", "Event", "Id", "When", "State", "Details"};
            this.eventsListBox.addColumns(cols);
            Object var1_1 = null;
        }
        return this.eventsListBox;
    }

    public String[] buildPlayBackRow(PlaybackEvent playbackEvent) {
        String[] strings = new String[7];
        if (playbackEvent.getAction().equals((Object)PlaybackEvent.Action.RUN_SUBMIT)) {
            strings[0] = "" + playbackEvent.getSequenceId();
            strings[1] = playbackEvent.getClientId().getName();
            strings[2] = playbackEvent.getAction().toString();
            strings[3] = "" + playbackEvent.getId();
            strings[4] = "" + playbackEvent.getEventTime();
            strings[5] = "" + (Object)((Object)playbackEvent.getEventStatus());
        } else if (playbackEvent.getAction().equals((Object)PlaybackEvent.Action.RUN_JUDGEMENT)) {
            strings[0] = "" + playbackEvent.getSequenceId();
            strings[1] = playbackEvent.getClientId().getName();
            strings[2] = playbackEvent.getAction().toString();
            strings[3] = "" + playbackEvent.getId();
            strings[4] = "" + playbackEvent.getEventTime();
            strings[5] = "" + (Object)((Object)playbackEvent.getEventStatus());
            JudgementRecord judgementRecord = playbackEvent.getJudgementRecord();
            ElementId id = judgementRecord.getJudgementId();
            if (id != null) {
                Judgement judgement = this.getContest().getJudgement(id);
                strings[6] = judgement.getDisplayName();
            } else {
                strings[6] = "Undefined judgement: " + id;
            }
        } else {
            strings[0] = "" + playbackEvent.getSequenceId();
            strings[1] = "";
            strings[2] = PlaybackEvent.Action.UNDEFINED.toString();
            strings[3] = "";
            strings[4] = "";
            strings[5] = "";
        }
        return strings;
    }

    public void addSampleEventRows() {
        ClientId clientId = new ClientId(2, ClientType.Type.TEAM, 22);
        PlaybackEvent playbackEvent = new PlaybackEvent(PlaybackEvent.Action.UNDEFINED, clientId);
        playbackEvent.setSequenceId(this.eventsListBox.getRowCount());
        Object[] row = this.buildPlayBackRow(playbackEvent);
        this.eventsListBox.addRow(row);
        for (int i = 0; i < this.eventsListBox.getColumnCount(); ++i) {
            this.eventsListBox.autoSizeColumn(i);
        }
    }

    private void autoSizeColumns() {
        for (int i = 0; i < this.eventsListBox.getColumnCount(); ++i) {
            this.eventsListBox.autoSizeColumn(i);
        }
    }

    public void addSampleEventRows2() {
        String[][] cols;
        for (Object[] objectArray : cols = new String[][]{{"1", "team 2", "RUN SUBMIT", "1", "12", "DONE"}, {"2", "judge 4", "RUN JUDGEMENT", "1", "22", "DONE"}, {"3", "team 2", "RUN SUBMIT", "2", "24", "PENDING"}, {"4", "team 6", "MYSTERY 101", "2", "32", "PENDING"}, {"5", "team 4", "RUN SUBMIT", "3", "42", "PENDING"}}) {
            this.eventsListBox.addRow(objectArray);
        }
        for (int i = 0; i < this.eventsListBox.getColumnCount(); ++i) {
            this.eventsListBox.autoSizeColumn(i);
        }
    }

    private JButton getStartButton() {
        if (this.startButton == null) {
            this.startButton = new JButton();
            this.startButton.setText("Start");
            this.startButton.setMnemonic(83);
            this.startButton.setToolTipText("Start running events");
            this.startButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.startRunningEvents();
                }
            });
        }
        return this.startButton;
    }

    protected void startRunningEvents() {
        if (this.eventsListBox.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No events defined");
            return;
        }
        final int currentEventNumber = this.playbackManager.getSequenceNumber();
        if (currentEventNumber > this.eventsListBox.getRowCount()) {
            JOptionPane.showMessageDialog(this, "All events executed");
            return;
        }
        int lastEventToRunTo = Integer.parseInt(this.getStopEventNumberTextField().getText());
        if (currentEventNumber == lastEventToRunTo) {
            JOptionPane.showMessageDialog(this, "Already before event " + lastEventToRunTo);
            return;
        }
        if (currentEventNumber > lastEventToRunTo) {
            JOptionPane.showMessageDialog(this, "Way after event " + lastEventToRunTo + " dude (at event " + (currentEventNumber - 1) + ")");
            return;
        }
        final int waitTime = Integer.parseInt(this.getTimeWarpTextField().getText());
        if (lastEventToRunTo > this.getEventsListBox().getRowCount()) {
            lastEventToRunTo = this.getEventsListBox().getRowCount();
        }
        final int runToStep = lastEventToRunTo;
        new Thread(new Runnable(){

            public void run() {
                for (int i = currentEventNumber; i < runToStep; ++i) {
                    PlaybackEvent playbackEvent = (PlaybackEvent)PlaybackPane.this.eventsListBox.getKeys()[i - 1];
                    try {
                        PlaybackPane.this.currentEventLabel.setText("At event " + PlaybackPane.this.playbackManager.getSequenceNumber());
                        PlaybackPane.this.playbackManager.executeEvent(playbackEvent, PlaybackPane.this.getContest(), PlaybackPane.this.getController());
                        final String[] row = PlaybackPane.this.buildPlayBackRow(playbackEvent);
                        final int rowNumber = i;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                PlaybackPane.this.getEventsListBox().replaceRow(row, rowNumber - 1);
                                PlaybackPane.this.autoSizeColumns();
                            }
                        });
                        if (waitTime <= 0) continue;
                        Thread.sleep(waitTime);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setText("Stop");
            this.stopButton.setEnabled(false);
            this.stopButton.setMnemonic(0);
            this.stopButton.setToolTipText("Stop running events");
        }
        return this.stopButton;
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton();
            this.resetButton.setText("Reset");
            this.resetButton.setEnabled(false);
            this.resetButton.setToolTipText("Reset (erase) runs");
            this.resetButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.deleteAllRuns();
                }
            });
        }
        return this.resetButton;
    }

    protected void deleteAllRuns() {
    }

    private JPanel getTopPane() {
        if (this.topPane == null) {
            this.currentEventLabel = new JLabel();
            this.currentEventLabel.setBounds(new Rectangle(297, 24, 115, 38));
            this.currentEventLabel.setHorizontalAlignment(0);
            this.currentEventLabel.setFont(new Font("Dialog", 1, 16));
            this.currentEventLabel.setText("At ###");
            this.stopAtLabel = new JLabel();
            this.stopAtLabel.setBounds(new Rectangle(26, 46, 146, 24));
            this.stopAtLabel.setHorizontalAlignment(4);
            this.stopAtLabel.setText("Stop before event");
            this.msLabel = new JLabel();
            this.msLabel.setBounds(new Rectangle(248, 13, 32, 24));
            this.msLabel.setText("ms");
            this.topPane = new JPanel();
            this.topPane.setLayout(null);
            this.topPane.setPreferredSize(new Dimension(120, 120));
            this.topPane.add((Component)this.getTimeWarpTextField(), null);
            this.topPane.add((Component)this.msLabel, null);
            this.topPane.add((Component)this.stopAtLabel, null);
            this.topPane.add((Component)this.getStopEventNumberTextField(), null);
            this.topPane.add((Component)this.getEveryMSEventPacing(), null);
            this.topPane.add((Component)this.getStepButton(), null);
            this.topPane.add((Component)this.currentEventLabel, null);
        }
        return this.topPane;
    }

    private JTextField getTimeWarpTextField() {
        if (this.timeWarpTextField == null) {
            this.timeWarpTextField = new JTextField();
            this.timeWarpTextField.setBounds(new Rectangle(190, 13, 38, 24));
            this.timeWarpTextField.setText("1000");
        }
        return this.timeWarpTextField;
    }

    private JTextField getStopEventNumberTextField() {
        if (this.stopEventNumberTextField == null) {
            this.stopEventNumberTextField = new JTextField();
            this.stopEventNumberTextField.setBounds(new Rectangle(190, 44, 38, 24));
            this.stopEventNumberTextField.setText("99");
        }
        return this.stopEventNumberTextField;
    }

    private JRadioButton getEveryMSEventPacing() {
        if (this.everyMSEventPacing == null) {
            this.everyMSEventPacing = new JRadioButton();
            this.everyMSEventPacing.setBounds(new Rectangle(15, 13, 163, 24));
            this.everyMSEventPacing.setSelected(true);
            this.everyMSEventPacing.setText("Execute each event");
        }
        return this.everyMSEventPacing;
    }

    public ButtonGroup getTimeWarpButtonGroup() {
        if (this.timeWarpButtonGroup == null) {
            this.timeWarpButtonGroup = new ButtonGroup();
            this.timeWarpButtonGroup.add(this.getEveryMSEventPacing());
        }
        return this.timeWarpButtonGroup;
    }

    private JButton getStepButton() {
        if (this.stepButton == null) {
            this.stepButton = new JButton();
            this.stepButton.setBounds(new Rectangle(187, 81, 141, 25));
            this.stepButton.setMnemonic(82);
            this.stepButton.setText("Run one event");
            this.stepButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.executeNextStep();
                }
            });
        }
        return this.stepButton;
    }

    protected void executeNextStep() {
        if (this.eventsListBox.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No events defined");
            return;
        }
        int currentEventNumber = this.playbackManager.getSequenceNumber();
        if (currentEventNumber > this.eventsListBox.getRowCount()) {
            JOptionPane.showMessageDialog(this, "All events executed");
            return;
        }
        PlaybackEvent playbackEvent = (PlaybackEvent)this.eventsListBox.getKeys()[currentEventNumber - 1];
        try {
            this.currentEventLabel.setText("At event " + this.playbackManager.getSequenceNumber());
            this.playbackManager.executeEvent(playbackEvent, this.getContest(), this.getController());
            Object[] row = this.buildPlayBackRow(playbackEvent);
            this.getEventsListBox().replaceRow(row, currentEventNumber - 1);
            this.autoSizeColumns();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("Load");
            this.loadButton.setMnemonic(76);
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlaybackPane.this.selectAndloadEventFile();
                }
            });
        }
        return this.loadButton;
    }

    protected void selectAndloadEventFile() {
        String filename = null;
        try {
            filename = this.getFileName();
            if (filename != null) {
                PlaybackEvent[] playbackEvents = this.playbackManager.loadPlayback(filename, this.getContest());
                if (playbackEvents == null || playbackEvents.length == 0) {
                    JOptionPane.showMessageDialog(this, "No events found in " + filename);
                } else {
                    for (PlaybackEvent playbackEvent : playbackEvents) {
                        playbackEvent.setSequenceId(this.eventsListBox.getRowCount() + 1);
                        Object[] row = this.buildPlayBackRow(playbackEvent);
                        this.getEventsListBox().addRow(row, playbackEvent);
                    }
                    this.autoSizeColumns();
                    JOptionPane.showMessageDialog(this, "Loaded " + playbackEvents.length + " events from " + filename);
                }
            }
        }
        catch (FileNotFoundException notFound) {
            JOptionPane.showMessageDialog(this, "No such file: " + filename);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to load file: " + filename + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String getFileName() throws IOException {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            return chooser.getSelectedFile().getCanonicalFile().toString();
        }
        chooser = null;
        return null;
    }
}

