/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.archive.PacketFormatter;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProfileListener;
import edu.csus.ecs.pc2.core.model.ProfileEvent;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class PacketViewerFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -3020304335848475659L;
    private Packet packet;
    private JPanel mainPane = null;
    private JPanel buttonPane = null;
    private JButton closeButton = null;
    private JPanel topPane = null;
    private JLabel topLabel = null;
    private JScrollPane scrollPane = null;
    private JTree tree = null;

    public PacketViewerFrame(Packet packet, JScrollPane pane) {
        this.initialize();
        this.packet = packet;
        this.showPacketInfo(pane);
    }

    public PacketViewerFrame(Packet packet) {
        this(packet, PacketViewerFrame.getPacketTree(packet));
    }

    public static final JScrollPane getPacketTree(Packet packet) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Packet " + (Object)((Object)packet.getType()));
        PacketFormatter.buildContentTree(top, packet);
        JTree jTree = new JTree(top, true);
        jTree.getSelectionModel().setSelectionMode(1);
        JScrollPane treeView = new JScrollPane(jTree);
        treeView.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        return treeView;
    }

    protected Object getClientName(ClientId clientId) {
        if (clientId == null) {
            return "<null>";
        }
        if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
            if (clientId.equals(PacketFactory.ALL_SERVERS)) {
                return "All Servers";
            }
            return "Site " + clientId.getSiteNumber();
        }
        return clientId.getName();
    }

    private void showPacketInfo(JScrollPane pane) {
        this.setTitle("Packet Viewer " + this.packet.getPacketNumber() + " " + (Object)((Object)this.packet.getType()) + " " + " " + this.getClientName(this.packet.getSourceId()) + " to " + this.getClientName(this.packet.getDestinationId()));
        String original = "";
        if (this.packet.getOriginalPacketNumber() == this.packet.getPacketNumber()) {
            original = " (Orig #" + this.packet.getOriginalPacketNumber() + ")";
        }
        this.topLabel.setText(this.packet.toString() + original);
        JTree newTree = (JTree)pane.getViewport().getComponent(0);
        this.getTree().setModel(newTree.getModel());
    }

    private void initialize() {
        this.setSize(new Dimension(590, 429));
        this.setContentPane(this.getMainPane());
        this.setTitle("Packet Viewer");
        FrameUtilities.centerFrameFullScreenHeight(this);
        FrameUtilities.setFramePosition(this, FrameUtilities.HorizontalPosition.RIGHT, FrameUtilities.VerticalPosition.CENTER);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PacketViewerFrame.this.closeWindow();
            }
        });
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        inContest.addProfileListener(new ProfileListenerImplementation());
    }

    public String getPluginTitle() {
        return "Packet Viewer Frame";
    }

    protected void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.add((Component)this.getButtonPane(), "South");
            this.mainPane.add((Component)this.getTopPane(), "North");
            this.mainPane.add((Component)this.getScrollPane(), "Center");
        }
        return this.mainPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new FlowLayout());
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setMnemonic(67);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PacketViewerFrame.this.closeWindow();
                }
            });
        }
        return this.closeButton;
    }

    private JPanel getTopPane() {
        if (this.topPane == null) {
            this.topLabel = new JLabel();
            this.topLabel.setText("JLabel");
            this.topPane = new JPanel();
            this.topPane.setLayout(new GridBagLayout());
            this.topPane.add((Component)this.topLabel, new GridBagConstraints());
        }
        return this.topPane;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getTree());
        }
        return this.scrollPane;
    }

    private JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree();
        }
        return this.tree;
    }

    protected class ProfileListenerImplementation
    implements IProfileListener {
        protected ProfileListenerImplementation() {
        }

        public void profileAdded(ProfileEvent event) {
        }

        public void profileChanged(ProfileEvent event) {
        }

        public void profileRemoved(ProfileEvent event) {
        }

        public void profileRefreshAll(ProfileEvent profileEvent) {
            PacketViewerFrame.this.closeWindow();
        }
    }
}

