/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import com.ibm.webrunner.j2mclb.util.Sorter;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.core.security.FileSecurity;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PacketExplorerPane
extends JPanePlugin {
    private static final long serialVersionUID = -5943773283797591796L;
    private JPanel centerPane = null;
    private JPanel southPane = null;
    private MCLB packetListBox = null;
    private JLabel dirLabel = null;
    private JTextField dirNameTextField = null;
    private JButton refreshButton = null;
    private JPanel northPane = null;
    private JLabel messageLabel = null;
    private IInternalContest contest;
    private IInternalController controller;
    private String contestPassword = null;
    private IStorage storage;

    public PacketExplorerPane() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(453, 262));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getSouthPane(), "South");
        this.add((Component)this.getNorthPane(), "North");
        this.showMessage(Utilities.getCurrentDirectory());
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)((Object)this.getPacketListBox()), "Center");
        }
        return this.centerPane;
    }

    private JPanel getSouthPane() {
        if (this.southPane == null) {
            this.dirLabel = new JLabel();
            this.dirLabel.setText("Directory");
            this.southPane = new JPanel();
            this.southPane.setPreferredSize(new Dimension(45, 45));
            this.southPane.add((Component)this.dirLabel, null);
            this.southPane.add((Component)this.getDirNameTextField(), null);
            this.southPane.add((Component)this.getRefreshButton(), null);
        }
        return this.southPane;
    }

    private MCLB getPacketListBox() {
        if (this.packetListBox == null) {
            this.packetListBox = new MCLB();
            Object[] cols = new Object[]{"Type", "Time", "From", "To", "Contains"};
            this.packetListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            this.setColumnSorter(this.packetListBox, 0, sorter, 1);
            this.setColumnSorter(this.packetListBox, 1, numericStringSorter, 2);
            this.setColumnSorter(this.packetListBox, 2, sorter, 3);
            this.setColumnSorter(this.packetListBox, 3, sorter, 4);
            this.setColumnSorter(this.packetListBox, 4, sorter, 5);
            this.packetListBox.autoSizeAllColumns();
            Object var1_1 = null;
        }
        return this.packetListBox;
    }

    private JTextField getDirNameTextField() {
        if (this.dirNameTextField == null) {
            this.dirNameTextField = new JTextField();
            this.dirNameTextField.setPreferredSize(new Dimension(200, 20));
            this.dirNameTextField.setText("packets");
        }
        return this.dirNameTextField;
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setText("Refresh");
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PacketExplorerPane.this.refreshDir();
                }
            });
        }
        return this.refreshButton;
    }

    protected Packet fetchPC2Packet(File file) throws Exception {
        Serializable obj = this.storage.load(file.getCanonicalPath());
        if (obj instanceof Packet) {
            return (Packet)obj;
        }
        throw new Exception("Not a packet: " + file.getName() + " is " + obj.getClass().toString());
    }

    protected void refreshDir() {
        String dirname = this.getDirNameTextField().getText().trim();
        this.packetListBox.removeAllRows();
        if (dirname.length() < 1) {
            this.showMessage("Enter a directory name");
            return;
        }
        File dir = new File(dirname);
        if (!dir.isDirectory()) {
            this.showMessage(dirname + " is not a directory.");
            return;
        }
        if (this.contestPassword == null) {
            String password = JOptionPane.showInputDialog(this, "Enter Contest Password", "Password entry", 3);
            try {
                FileSecurity fileSecurity = new FileSecurity("db.1");
                fileSecurity.verifyPassword(password.toCharArray());
                this.contestPassword = password;
            }
            catch (FileSecurityException e) {
                JOptionPane.showMessageDialog(this, "Password did not match " + e.getMessage());
                return;
            }
        }
        this.showMessage("Reading files from " + dirname);
        Object[] filenames = dir.list();
        Arrays.sort(filenames);
        this.showMessage("Found " + filenames.length + " files in " + dirname);
        int packetsFound = 0;
        try {
            for (int i = 0; i < filenames.length; ++i) {
                String packetFilename = dirname + File.separator + (String)filenames[i];
                File packfile = new File(packetFilename);
                if (!packfile.isFile()) continue;
                System.out.println(packetFilename);
                Packet packet = null;
                try {
                    packet = this.fetchPC2Packet(packfile);
                }
                catch (Exception e) {
                    System.out.println(packfile.getName() + " " + e.getMessage());
                }
                if (packet == null) continue;
                this.addPacketToList(packet);
                ++packetsFound;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showMessage("Found " + packetsFound + " packets in '" + dirname + "' (" + filenames.length + " files)");
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PacketExplorerPane.this.messageLabel.setText(string);
            }
        });
    }

    private void addPacketToList(final Packet packet) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Clarification clarification;
                Object[] objArray = new Object[PacketExplorerPane.this.packetListBox.getColumnCount()];
                Object content = packet.getContent();
                long elapsed = 0L;
                Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
                if (run != null) {
                    elapsed = run.getElapsedMins();
                }
                if ((clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION")) != null) {
                    elapsed = clarification.getElapsedMins();
                }
                System.out.println(packet);
                objArray[0] = packet.getType().toString();
                objArray[1] = new Long(elapsed).toString();
                objArray[2] = PacketExplorerPane.this.getClientName(packet.getSourceId());
                objArray[3] = PacketExplorerPane.this.getClientName(packet.getDestinationId());
                if (content instanceof Properties) {
                    Properties props = (Properties)content;
                    String msg = "";
                    Enumeration<Object> enumeration = props.keys();
                    while (enumeration.hasMoreElements()) {
                        String element = (String)enumeration.nextElement();
                        msg = msg + element + " ";
                    }
                    objArray[4] = "Properties: " + msg;
                } else {
                    objArray[4] = content.getClass().getName();
                }
                PacketExplorerPane.this.packetListBox.addRow(objArray, packet);
                PacketExplorerPane.this.packetListBox.autoSizeAllColumns();
            }
        });
    }

    protected Object getClientName(ClientId clientId) {
        if (clientId == null) {
            return "<null>";
        }
        if (clientId.getClientType().equals((Object)ClientType.Type.SERVER)) {
            if (clientId.equals(PacketFactory.ALL_SERVERS)) {
                return "All Servers";
            }
            return "Site " + clientId.getSiteNumber();
        }
        return clientId.getName();
    }

    private JPanel getNorthPane() {
        if (this.northPane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("_");
            this.messageLabel.setHorizontalAlignment(0);
            this.northPane = new JPanel();
            this.northPane.setLayout(new BorderLayout());
            this.northPane.setPreferredSize(new Dimension(35, 35));
            this.northPane.add((Component)this.messageLabel, "Center");
        }
        return this.northPane;
    }

    private void setColumnSorter(MCLB listBox, int columnNumber, HeapSorter sorter, int sortRank) {
        listBox.getColumnInfo(columnNumber).setSorter((Sorter)sorter);
        listBox.getColumnInfo(columnNumber).getSorter().setSortOrder(sortRank);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.setVisible(true);
    }

    public String getPluginTitle() {
        return "Packet Explorer";
    }
}

