/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.report.LoginReport;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LoginsPane
extends JPanePlugin {
    private static final long serialVersionUID = -3609625972816987570L;
    private JPanel loginButtonPane = null;
    private MCLB loginListBox = null;
    private JButton logoffButton = null;
    private PermissionList permissionList = new PermissionList();
    private JPanel messagePanel = null;
    private JLabel messageLabel = null;
    private JButton reportButton = null;

    public LoginsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(536, 217));
        this.add((Component)this.getLoginButtonPanel(), "South");
        this.add((Component)((Object)this.getLoginListBox()), "Center");
    }

    public String getPluginTitle() {
        return "Logins Panel";
    }

    private JPanel getLoginButtonPanel() {
        if (this.loginButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            flowLayout.setVgap(5);
            this.loginButtonPane = new JPanel();
            this.loginButtonPane.setLayout(flowLayout);
            this.loginButtonPane.setPreferredSize(new Dimension(35, 35));
            this.loginButtonPane.add((Component)this.getLogoffButton(), null);
            this.loginButtonPane.add((Component)this.getReportButton(), null);
        }
        return this.loginButtonPane;
    }

    private MCLB getLoginListBox() {
        if (this.loginListBox == null) {
            this.loginListBox = new MCLB();
            this.loginListBox.add(this.getMessagePanel(), "North");
            Object[] cols = new Object[]{"Site", "Type", "Number", "Connection Id", "Since"};
            this.loginListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            this.loginListBox.setColumnSorter(0, sorter, 1);
            this.loginListBox.setColumnSorter(1, sorter, 2);
            this.loginListBox.setColumnSorter(2, numericStringSorter, 3);
            this.loginListBox.setColumnSorter(3, sorter, 4);
            this.loginListBox.setColumnSorter(4, sorter, 5);
            this.loginListBox.autoSizeAllColumns();
        }
        return this.loginListBox;
    }

    private Object[] buildLoginRow(ClientId clientId, ConnectionHandlerID connectionHandlerID) {
        Object[] obj = new Object[this.loginListBox.getColumnCount()];
        obj[0] = "Site " + clientId.getSiteNumber();
        obj[1] = clientId.getClientType().toString().toLowerCase();
        obj[2] = "" + clientId.getClientNumber();
        obj[3] = connectionHandlerID != null ? connectionHandlerID.toString() : "Undefined";
        obj[4] = new Date().toString();
        return obj;
    }

    private ClientId[] getAllLoggedInUsers() {
        Vector<ClientId> clientList = new Vector<ClientId>();
        for (ClientType.Type ctype : ClientType.Type.values()) {
            ClientId[] users;
            for (ClientId clientId : users = this.getContest().getAllLoggedInClients(ctype)) {
                clientList.addElement(clientId);
            }
        }
        if (clientList.size() == 0) {
            return new ClientId[0];
        }
        ClientId[] clients = clientList.toArray(new ClientId[clientList.size()]);
        return clients;
    }

    private void reloadListBox() {
        ClientId[] clientList;
        this.loginListBox.removeAllRows();
        for (ClientId clientId : clientList = this.getAllLoggedInUsers()) {
            ConnectionHandlerID connectionHandlerID = this.getContest().getConnectionHandleID(clientId);
            this.updateLoginList(clientId, connectionHandlerID);
        }
    }

    private void updateLoginRow(ClientId clientId, ConnectionHandlerID connectionHandlerID) {
        int row = this.loginListBox.getIndexByKey(clientId);
        if (row == -1) {
            Object[] objects = this.buildLoginRow(clientId, connectionHandlerID);
            this.loginListBox.addRow(objects, clientId);
        } else {
            Object[] objects = this.buildLoginRow(clientId, connectionHandlerID);
            this.loginListBox.replaceRow(objects, row);
        }
        this.loginListBox.autoSizeAllColumns();
    }

    private void removeLoginRow(ClientId clientId, ConnectionHandlerID connectionHandlerID) {
        int row = this.loginListBox.getIndexByKey(clientId);
        if (row != -1) {
            this.loginListBox.removeRow(row);
        }
        this.loginListBox.autoSizeAllColumns();
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addLoginListener(new LoginListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LoginsPane.this.reloadListBox();
                LoginsPane.this.updateGUIperPermissions();
            }
        });
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void updateGUIperPermissions() {
        this.logoffButton.setVisible(this.isAllowed(Permission.Type.FORCE_LOGOFF_CLIENT));
        this.reportButton.setVisible(this.isAllowed(Permission.Type.FORCE_LOGOFF_CLIENT));
    }

    protected void undoEdit() {
        this.reloadListBox();
    }

    public void updateLoginList(final ClientId clientId, final ConnectionHandlerID connectionHandlerID) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LoginsPane.this.updateLoginRow(clientId, connectionHandlerID);
            }
        });
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private JButton getLogoffButton() {
        if (this.logoffButton == null) {
            this.logoffButton = new JButton();
            this.logoffButton.setText("Logoff");
            this.logoffButton.setMnemonic(76);
            this.logoffButton.setToolTipText("Logoff the selected user");
            this.logoffButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LoginsPane.this.logoffSelectedClient();
                }
            });
        }
        return this.logoffButton;
    }

    protected void logoffSelectedClient() {
        int selected = this.getLoginListBox().getSelectedIndex();
        if (selected == -1) {
            this.showMessage("Please Select Client to logoff");
        }
        ClientId clientId = (ClientId)this.getLoginListBox().getKeys()[selected];
        ConnectionHandlerID connectionHandlerID = this.getContest().getConnectionHandleID(clientId);
        this.getController().getLog().info("Send Force logoff " + clientId + " " + connectionHandlerID);
        this.getController().logoffUser(clientId);
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.setPreferredSize(new Dimension(25, 25));
            this.messagePanel.add((Component)this.messageLabel, "Center");
        }
        return this.messagePanel;
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LoginsPane.this.messageLabel.setText(message);
            }
        });
    }

    private JButton getReportButton() {
        if (this.reportButton == null) {
            this.reportButton = new JButton();
            this.reportButton.setText("Report");
            this.reportButton.setMnemonic(82);
            this.reportButton.setToolTipText("Show Logins Report");
            this.reportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Utilities.viewReport(new LoginReport(), "Logins Report", LoginsPane.this.getContest(), LoginsPane.this.getController());
                }
            });
        }
        return this.reportButton;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (LoginsPane.this.getContest().getClientId().equals(account.getClientId())) {
                LoginsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LoginsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                if (!LoginsPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                LoginsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LoginsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            LoginsPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LoginsPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    public class LoginListenerImplementation
    implements ILoginListener {
        public void loginAdded(LoginEvent event) {
            LoginsPane.this.updateLoginList(event.getClientId(), event.getConnectionHandlerID());
        }

        public void loginRemoved(final LoginEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LoginsPane.this.removeLoginRow(event.getClientId(), event.getConnectionHandlerID());
                }
            });
        }

        public void loginDenied(LoginEvent event) {
        }

        public void loginRefreshAll(LoginEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LoginsPane.this.reloadListBox();
                }
            });
        }
    }
}

