/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.LogWindow;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class LoginFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -6389607881992853161L;
    private IInternalContest contest;
    private IInternalController controller;
    private JPanel centerPane = null;
    private JPasswordField passwordTextField = null;
    private JTextField loginTextField = null;
    private JLabel nameTitleLabel = null;
    private JLabel versionTitleLabel = null;
    private JLabel mainTitleTopLabel = null;
    private JLabel passwordTitleLabel = null;
    private JButton loginButton = null;
    private JButton exitButton = null;
    private JLabel messageLabel = null;
    private JLabel mainTitleBottomLabel = null;
    private LogWindow logWindow = null;
    private JPanel mainPanel;
    private JPanel westPanel;
    private JLabel logoCSUS = null;
    private JPanel bottomPanel = null;
    private JLabel logoICPC = null;
    private JPanel northPanel = null;
    private JLabel spacerLabel = null;
    private Boolean bAlreadyLoggingIn = false;

    public LoginFrame() {
        this.initialize();
        this.overRideLookAndFeel();
        FrameUtilities.centerFrame(this);
    }

    private void initialize() {
        this.setSize(new Dimension(628, 430));
        this.setPreferredSize(new Dimension(628, 430));
        this.setMinimumSize(new Dimension(628, 430));
        this.setBackground(new Color(253, 255, 255));
        this.setDefaultCloseOperation(0);
        this.setTitle("PC^2 Login");
        this.setContentPane(this.getMainPanel());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LoginFrame.this.promptBeforeExit();
            }
        });
        VersionInfo versionInfo = new VersionInfo();
        this.versionTitleLabel.setText("PC^2 version " + versionInfo.getVersionNumber() + " " + versionInfo.getBuildNumber());
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getPasswordTitleLabel(), "Center");
            this.mainPanel.add((Component)this.getWestPanel(), "West");
            this.mainPanel.add((Component)this.getBottomPanel(), "South");
            this.mainPanel.add((Component)this.getNorthPanel(), "North");
        }
        return this.mainPanel;
    }

    private JPanel getWestPanel() {
        if (this.westPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setVgap(30);
            flowLayout.setHgap(5);
            this.westPanel = new JPanel();
            this.westPanel.setLayout(flowLayout);
            this.westPanel.setMinimumSize(new Dimension(130, 132));
            this.westPanel.setPreferredSize(new Dimension(140, 132));
            this.westPanel.setBackground(Color.white);
            this.westPanel.add((Component)this.getLogoCSUS(), null);
        }
        return this.westPanel;
    }

    private JPanel getPasswordTitleLabel() {
        if (this.centerPane == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.insets = new Insets(3, 66, 2, 54);
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 5;
            gridBagConstraints7.ipadx = 360;
            gridBagConstraints7.ipady = 26;
            gridBagConstraints7.gridwidth = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(7, 52, 3, 130);
            gridBagConstraints6.gridy = 4;
            gridBagConstraints6.ipadx = 40;
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(7, 32, 3, 76);
            gridBagConstraints5.gridy = 4;
            gridBagConstraints5.ipadx = 30;
            gridBagConstraints5.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(12, 32, 1, 51);
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.ipadx = 62;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(2, 99, 11, 75);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 6;
            gridBagConstraints3.ipadx = 158;
            gridBagConstraints3.ipady = 7;
            gridBagConstraints3.gridwidth = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(23, 32, 0, 87);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.ipadx = 39;
            gridBagConstraints2.ipady = -1;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.ipadx = 362;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(1, 32, 12, 82);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.ipadx = 364;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(1, 32, 7, 80);
            this.messageLabel = new JLabel();
            this.messageLabel.setForeground(Color.red);
            this.messageLabel.setText("");
            this.messageLabel.setFont(new Font("Dialog", 1, 14));
            this.messageLabel.setHorizontalAlignment(0);
            this.passwordTitleLabel = new JLabel();
            this.passwordTitleLabel.setText("Password");
            this.versionTitleLabel = new JLabel();
            this.versionTitleLabel.setHorizontalAlignment(4);
            this.versionTitleLabel.setText("Version XX. XX YYYY vv 22");
            this.nameTitleLabel = new JLabel();
            this.nameTitleLabel.setText("Name");
            this.nameTitleLabel.setPreferredSize(new Dimension(45, 16));
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new GridBagLayout());
            this.centerPane.setBackground(Color.white);
            this.centerPane.add((Component)this.getPasswordTextField(), gridBagConstraints);
            this.centerPane.add((Component)this.getLoginTextField(), gridBagConstraints1);
            this.centerPane.add((Component)this.nameTitleLabel, gridBagConstraints2);
            this.centerPane.add((Component)this.versionTitleLabel, gridBagConstraints3);
            this.centerPane.add((Component)this.passwordTitleLabel, gridBagConstraints4);
            this.centerPane.add((Component)this.getLoginButton(), gridBagConstraints5);
            this.centerPane.add((Component)this.getExitButton(), gridBagConstraints6);
            this.centerPane.add((Component)this.messageLabel, gridBagConstraints7);
        }
        return this.centerPane;
    }

    private JPasswordField getPasswordTextField() {
        if (this.passwordTextField == null) {
            this.passwordTextField = new JPasswordField();
            this.passwordTextField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 && LoginFrame.this.getLoginButton().isEnabled()) {
                        LoginFrame.this.attemptToLogin();
                    }
                }
            });
        }
        return this.passwordTextField;
    }

    private JTextField getLoginTextField() {
        if (this.loginTextField == null) {
            this.loginTextField = new JTextField();
            this.loginTextField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        LoginFrame.this.passwordTextField.requestFocus();
                    }
                }
            });
        }
        return this.loginTextField;
    }

    private JButton getLoginButton() {
        if (this.loginButton == null) {
            this.loginButton = new JButton();
            this.loginButton.setMnemonic(76);
            this.loginButton.setText("Login");
            this.loginButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LoginFrame.this.messageLabel.setText("Logging in");
                    LoginFrame.this.attemptToLogin();
                }
            });
        }
        return this.loginButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptToLogin() {
        this.setStatusMessage("");
        if (this.getLoginName() == null || this.getLoginName().length() < 1) {
            this.setStatusMessage("Please enter a login");
        } else {
            if (this.getLoginName().toLowerCase().startsWith("log")) {
                this.logWindow.setVisible(true);
                return;
            }
            Boolean bl = this.bAlreadyLoggingIn;
            synchronized (bl) {
                if (this.bAlreadyLoggingIn.booleanValue()) {
                    return;
                }
                this.bAlreadyLoggingIn = true;
            }
            try {
                this.setStatusMessage("Logging in...");
                FrameUtilities.waitCursor(this);
                this.controller.login(this.getLoginName(), this.getPassword());
            }
            catch (Exception e) {
                this.setStatusMessage(e.getMessage());
                StaticLog.info("Login not successful: " + e.getMessage());
                System.err.println("Login not successful: " + e.getMessage());
                this.bAlreadyLoggingIn = false;
            }
        }
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setMnemonic(88);
            this.exitButton.setText("Exit");
            this.exitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LoginFrame.this.promptBeforeExit();
                }
            });
        }
        return this.exitButton;
    }

    protected void promptBeforeExit() {
        this.setStatusMessage("");
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    private JLabel getLogoCSUS() {
        if (this.logoCSUS == null) {
            this.logoCSUS = new JLabel();
            ImageIcon image = this.loadImageIconFromFile("images/csus_logo.png");
            this.logoCSUS.setIcon(image);
            this.logoCSUS.setBounds(new Rectangle(-11, 48, 137, 127));
        }
        return this.logoCSUS;
    }

    private ImageIcon loadImageIconFromFile(String inFileName) {
        File imgFile = new File(inFileName);
        ImageIcon icon = null;
        URL iconURL = this.getClass().getResource("/" + inFileName);
        if (iconURL == null && imgFile.exists()) {
            try {
                iconURL = imgFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                iconURL = null;
                StaticLog.log("LoginFrame.loadImageIconFromFile(" + inFileName + ")", e);
            }
        }
        if (iconURL != null) {
            if (this.verifyImage(inFileName, iconURL)) {
                icon = new ImageIcon(iconURL);
            } else {
                StaticLog.warning(inFileName + "(" + iconURL.toString() + ") checksum failed");
            }
        }
        return icon;
    }

    private boolean verifyImage(String inFileName, URL url) {
        byte[] csusChecksum = new byte[]{-78, -82, -33, 125, 3, 20, 3, -51, 53, -82, -66, -19, -96, 82, 39, -92, 16, 52, 17, 127};
        byte[] icpcChecksum = new byte[]{-9, -91, 66, 44, 57, 117, 47, 58, 103, -17, 31, 53, 10, 6, 100, 68, 0, 127, -103, -58};
        byte[] csusChecksum2 = new byte[]{98, 105, -19, -31, -71, -121, 109, -34, 64, 83, -78, -31, 49, -57, 57, 8, 35, -79, 13, -49};
        byte[] icpcChecksum2 = new byte[]{70, -55, 53, -41, 127, 102, 30, 95, -55, -13, 11, -11, -31, -103, -107, -31, 119, 25, -98, 14};
        byte[] csusChecksum3 = new byte[]{-46, -84, -66, 55, 82, -78, 124, 88, 68, -83, -128, -110, -19, -26, 92, -3, 76, -26, 21, 30};
        byte[] icpcChecksum3 = new byte[]{41, 72, 104, 75, 73, 55, 55, 93, 32, 35, -6, -12, -96, -23, -3, -17, -119, 26, 81, -2};
        byte[] icpcChecksum4 = new byte[]{35, 40, -57, -30, -7, 121, 59, 25, 3, 26, -82, -75, -65, 123, 54, -57, 39, 36, -3, 107};
        try {
            int i;
            byte[] verifyChecksum;
            int matchedBytes = 0;
            InputStream is = url.openStream();
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.reset();
            byte[] b = new byte[1024];
            while (is.read(b) > 0) {
                md.update(b);
            }
            byte[] digested = md.digest();
            if (inFileName.equals("images/csus_logo.png")) {
                switch (digested[0]) {
                    case 98: {
                        verifyChecksum = csusChecksum2;
                        break;
                    }
                    case -46: {
                        verifyChecksum = csusChecksum3;
                        break;
                    }
                    default: {
                        verifyChecksum = csusChecksum;
                        break;
                    }
                }
            } else {
                switch (digested[0]) {
                    case 70: {
                        verifyChecksum = icpcChecksum2;
                        break;
                    }
                    case 41: {
                        verifyChecksum = icpcChecksum3;
                        break;
                    }
                    case 35: {
                        verifyChecksum = icpcChecksum4;
                        break;
                    }
                    default: {
                        verifyChecksum = icpcChecksum;
                    }
                }
            }
            if (Utilities.isDebugMode()) {
                System.out.println();
                System.out.println(inFileName);
                System.out.print("byte[] ChecksumX = {");
                for (i = 0; i < digested.length; ++i) {
                    System.out.print(digested[i]);
                    if (i >= digested.length - 1) continue;
                    System.out.print(", ");
                }
                System.out.println("};");
            }
            for (i = 0; i < digested.length && digested[i] == verifyChecksum[i]; ++i) {
                ++matchedBytes;
            }
            return matchedBytes == verifyChecksum.length;
        }
        catch (IOException e) {
            StaticLog.log("verifyImage(" + inFileName + ")", e);
        }
        catch (NoSuchAlgorithmException e) {
            StaticLog.log("verifyImage(" + inFileName + ")", e);
        }
        return false;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.logoICPC = new JLabel();
            ImageIcon image = this.loadImageIconFromFile("images/icpc_banner.png");
            this.logoICPC.setIcon(image);
            this.bottomPanel = new JPanel();
            this.bottomPanel.setBackground(Color.white);
            this.bottomPanel.add((Component)this.logoICPC, null);
        }
        return this.bottomPanel;
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.spacerLabel = new JLabel();
            this.spacerLabel.setText(" ");
            this.northPanel = new JPanel();
            this.northPanel.setLayout(new BorderLayout());
            this.northPanel.setBackground(Color.white);
            this.mainTitleBottomLabel = new JLabel();
            this.mainTitleBottomLabel.setHorizontalAlignment(0);
            this.mainTitleBottomLabel.setHorizontalTextPosition(0);
            this.mainTitleBottomLabel.setText("Programming Contest Control System");
            this.mainTitleBottomLabel.setBackground(Color.white);
            this.mainTitleBottomLabel.setFont(new Font("Dialog", 1, 26));
            this.mainTitleTopLabel = new JLabel();
            this.mainTitleTopLabel.setFont(new Font("Dialog", 1, 22));
            this.mainTitleTopLabel.setText("California State University, Sacramento");
            this.mainTitleTopLabel.setHorizontalAlignment(0);
            this.northPanel.add((Component)this.mainTitleTopLabel, "Center");
            this.northPanel.add((Component)this.mainTitleBottomLabel, "South");
            this.northPanel.add((Component)this.spacerLabel, "North");
        }
        return this.northPanel;
    }

    public static void main(String[] args) {
        new LoginFrame().setVisible(true);
    }

    public void setStatusMessage(final String messageString) {
        Runnable messageRunnable = new Runnable(){

            public void run() {
                LoginFrame.this.messageLabel.setText(messageString);
            }
        };
        SwingUtilities.invokeLater(messageRunnable);
        FrameUtilities.regularCursor(this);
    }

    private String getLoginName() {
        return this.loginTextField.getText();
    }

    private String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.logWindow = new LogWindow();
        this.logWindow.setContestAndController(this.contest, this.controller);
        this.contest.addLoginListener(new LoginListenerImplementation());
        this.setVisible(true);
    }

    public String getPluginTitle() {
        return "Login";
    }

    public void disableLoginButton() {
        this.getLoginButton().setEnabled(false);
    }

    public class LoginListenerImplementation
    implements ILoginListener {
        public void loginAdded(LoginEvent event) {
        }

        public void loginRemoved(LoginEvent event) {
        }

        public void loginDenied(LoginEvent event) {
            LoginFrame.this.setStatusMessage(event.getMessage());
            LoginFrame.this.bAlreadyLoggingIn = false;
        }

        public void loginRefreshAll(LoginEvent event) {
        }
    }
}

