/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.LoadContest;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LoadContestPane
extends JPanePlugin {
    private static final long serialVersionUID = 264134440705823081L;
    private JPanel mainPane = null;
    private JButton addButton = null;
    private JPanel mainPanel = null;
    private JPanel contestInfoPane = null;
    private JScrollPane scrollPane = null;
    private JTextArea contestInfoTextArea = null;
    private JLabel filenameTitleLabel = null;
    private JButton loadFilename = null;
    private String lastDirectory = ".";
    private JLabel filenameLabel = null;
    private LoadContest loadContest = new LoadContest();
    private static final String SEPARATOR = System.getProperty("line.separator");

    public LoadContestPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(562, 241));
        this.add((Component)this.getMainPanel(), "North");
        this.add((Component)this.getContestInfoPane(), "Center");
    }

    public String getPluginTitle() {
        return "Load Plugin Pane";
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.filenameLabel = new JLabel();
            this.filenameLabel.setBounds(new Rectangle(109, 28, 346, 26));
            this.filenameLabel.setText("");
            this.filenameTitleLabel = new JLabel();
            this.filenameTitleLabel.setBounds(new Rectangle(11, 28, 85, 26));
            this.filenameTitleLabel.setHorizontalAlignment(4);
            this.filenameTitleLabel.setText("File name");
            this.mainPane = new JPanel();
            this.mainPane.setLayout(null);
            this.mainPane.add((Component)this.getAddButton(), null);
            this.mainPane.add((Component)this.filenameTitleLabel, null);
            this.mainPane.add((Component)this.getLoadFilename(), null);
            this.mainPane.add((Component)this.filenameLabel, null);
        }
        return this.mainPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setBounds(new Rectangle(226, 71, 114, 30));
            this.addButton.setToolTipText("Add files contents into contest data");
            this.addButton.setEnabled(false);
            this.addButton.setText("Add");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LoadContestPane.this.loadContestFromFile(LoadContestPane.this.filenameLabel.getText(), LoadContestPane.this.getContest());
                }
            });
        }
        return this.addButton;
    }

    protected void loadContestFromFile(String filename, IInternalContest existingContest) {
        FrameUtilities.waitCursor(this);
        this.getContestInfoTextArea().setText("Loading " + filename + "...");
        if (!new File(filename).exists()) {
            FrameUtilities.regularCursor(this);
            this.getContestInfoTextArea().setText("File does not exist " + filename);
            JOptionPane.showMessageDialog(this, "File does not exist " + filename);
            return;
        }
        Date startTime = new Date();
        try {
            IInternalContest contest = this.loadContest.loadContest(filename, null);
            String info = "runs " + contest.getRuns().length + "\n" + "teams " + contest.getAccounts(ClientType.Type.TEAM).size() + "\n" + "probs " + contest.getProblems().length + "\n" + "langs " + contest.getLanguages().length + "\n" + "judgements " + contest.getJudgements().length + "\n";
            if (existingContest != null) {
                info = "Will load " + SEPARATOR + info;
            }
            String summaryText = this.getSiteSummary(contest);
            info = info + summaryText;
            this.getContestInfoTextArea().setText(info);
            if (existingContest != null) {
                contest = this.loadContest.loadContest(filename, existingContest);
                existingContest.storeConfiguration(this.getController().getLog());
                this.getContestInfoTextArea().append("Contest information added");
                this.getAddButton().setEnabled(false);
            }
            long seconds = new Date().getTime() - startTime.getTime();
            this.getContestInfoTextArea().append(SEPARATOR + "Load time " + seconds / 1000L + " seconds.");
        }
        catch (Exception e) {
            this.getContestInfoTextArea().setText(this.getStackTraceString(e));
        }
        FrameUtilities.regularCursor(this);
    }

    private String getSiteSummary(IInternalContest contest) {
        String summary = "";
        int maxSiteNumber = 0;
        for (Run run : contest.getRuns()) {
            if (run.getSiteNumber() <= maxSiteNumber) continue;
            maxSiteNumber = run.getSiteNumber();
        }
        if (maxSiteNumber > 0) {
            int[] siteRunCount = new int[maxSiteNumber];
            for (Run run : contest.getRuns()) {
                int n = run.getSiteNumber() - 1;
                siteRunCount[n] = siteRunCount[n] + 1;
            }
            for (int siteNumber = 0; siteNumber < maxSiteNumber; ++siteNumber) {
                summary = summary + "Site " + (siteNumber + 1) + " " + siteRunCount[siteNumber] + " runs." + SEPARATOR;
            }
        } else {
            summary = "No sites exist" + SEPARATOR;
        }
        return summary;
    }

    String getStackTraceString(Throwable throwable) {
        StackTraceElement[] elements;
        String line = "Exception " + SEPARATOR + throwable.getClass().getName() + ": " + throwable.getMessage() + SEPARATOR;
        for (StackTraceElement stackTraceElement : elements = throwable.getStackTrace()) {
            String sourceName = "(Unknown Source)";
            if (stackTraceElement.getFileName() != null) {
                sourceName = "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")";
            }
            line = line + "|" + "    at " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + " " + sourceName + SEPARATOR;
        }
        return line;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setPreferredSize(new Dimension(120, 120));
            this.mainPanel.add((Component)this.getMainPane(), "Center");
        }
        return this.mainPanel;
    }

    private JPanel getContestInfoPane() {
        if (this.contestInfoPane == null) {
            this.contestInfoPane = new JPanel();
            this.contestInfoPane.setLayout(new BorderLayout());
            this.contestInfoPane.setBorder(BorderFactory.createTitledBorder(null, "Contest Information", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.contestInfoPane.add((Component)this.getScrollPane(), "Center");
        }
        return this.contestInfoPane;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getContestInfoTextArea());
        }
        return this.scrollPane;
    }

    private JTextArea getContestInfoTextArea() {
        if (this.contestInfoTextArea == null) {
            this.contestInfoTextArea = new JTextArea();
        }
        return this.contestInfoTextArea;
    }

    private JButton getLoadFilename() {
        if (this.loadFilename == null) {
            this.loadFilename = new JButton();
            this.loadFilename.setBounds(new Rectangle(464, 26, 61, 30));
            this.loadFilename.setToolTipText("Load Contest Data File Name");
            this.loadFilename.setText("...");
            this.loadFilename.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean pickedFile = LoadContestPane.this.selectFile(LoadContestPane.this.filenameLabel);
                    LoadContestPane.this.loadContestFromFile(LoadContestPane.this.filenameLabel.getText(), null);
                    LoadContestPane.this.getAddButton().setEnabled(pickedFile);
                }
            });
        }
        return this.loadFilename;
    }

    private boolean selectFile(JLabel label) {
        boolean result = false;
        String oldFile = label.getToolTipText();
        String startDir = oldFile != null && oldFile.equalsIgnoreCase("") ? this.lastDirectory : oldFile;
        JFileChooser chooser = new JFileChooser(startDir);
        try {
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.lastDirectory = chooser.getCurrentDirectory().toString();
                label.setText(chooser.getSelectedFile().getCanonicalFile().toString());
                result = true;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error loading file " + e.getMessage());
            result = false;
        }
        chooser = null;
        return result;
    }
}

