/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IJudgementListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementEvent;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.EditJudgementFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JudgementsPanel
extends JPanePlugin {
    private static final long serialVersionUID = 36368747620026978L;
    private MCLB judgementListBox = null;
    private JPanel buttonsPane = null;
    private JButton addButton = null;
    private JPanel statusPanel = null;
    private JButton editButton = null;
    private EditJudgementFrame editJudgementFrame = null;
    private PermissionList permissionList = new PermissionList();

    public JudgementsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(584, 211));
        this.add((Component)this.getButtonsPane(), "South");
        this.add((Component)((Object)this.getJudgementListBox()), "Center");
        this.editJudgementFrame = new EditJudgementFrame();
    }

    public String getPluginTitle() {
        return "Judgements Panel";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addJudgementListener(new JudgementListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getEditJudgementFrame().setContestAndController(inContest, inController);
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JudgementsPanel.this.updateGUIperPermissions();
                JudgementsPanel.this.reloadJudgementList();
            }
        });
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.addButton.setVisible(this.isAllowed(Permission.Type.ADD_JUDGEMENTS));
        this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_JUDGEMENTS));
    }

    protected void reloadJudgementList() {
        this.getJudgementListBox().removeAllRows();
        for (Judgement judgement : this.getContest().getJudgements()) {
            this.updateJudgementRow(judgement);
        }
    }

    private MCLB getJudgementListBox() {
        if (this.judgementListBox == null) {
            this.judgementListBox = new MCLB();
            this.judgementListBox.add(this.getStatusPanel(), "North");
            Object[] cols = new Object[]{"Judgement"};
            this.judgementListBox.addColumns(cols);
        }
        return this.judgementListBox;
    }

    private JPanel getButtonsPane() {
        if (this.buttonsPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonsPane = new JPanel();
            this.buttonsPane.setLayout(flowLayout);
            this.buttonsPane.add((Component)this.getAddButton(), null);
            this.buttonsPane.add((Component)this.getEditButton(), null);
        }
        return this.buttonsPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JudgementsPanel.this.addJudgement();
                }
            });
        }
        return this.addButton;
    }

    protected void addJudgement() {
        this.editJudgementFrame.setJudgement(null);
        this.editJudgementFrame.setDeleteCheckBoxEnabled(true);
        this.editJudgementFrame.setVisible(true);
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.setPreferredSize(new Dimension(20, 20));
        }
        return this.statusPanel;
    }

    private void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private void updateJudgementRow(final Judgement judgement) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objects = JudgementsPanel.this.buildJudgementRow(judgement);
                int rowNumber = JudgementsPanel.this.judgementListBox.getIndexByKey(judgement.getElementId());
                if (rowNumber == -1) {
                    JudgementsPanel.this.judgementListBox.addRow(objects, judgement.getElementId());
                } else {
                    JudgementsPanel.this.judgementListBox.replaceRow(objects, rowNumber);
                }
                JudgementsPanel.this.judgementListBox.autoSizeAllColumns();
            }
        });
    }

    private Object[] buildJudgementRow(Judgement judgement) {
        try {
            int cols = this.judgementListBox.getColumnCount();
            Object[] s = new String[cols];
            s[0] = judgement.toString();
            if (!judgement.isActive()) {
                s[0] = "[HIDDEN] " + judgement.toString();
            }
            return s;
        }
        catch (Exception exception) {
            StaticLog.getLog().log(Log.INFO, "Exception in buildJudgementRow()", exception);
            return null;
        }
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setMnemonic(69);
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JudgementsPanel.this.editSelectedJudgement();
                }
            });
        }
        return this.editButton;
    }

    int numberOfRuns(Judgement judgement) {
        int count = 0;
        ElementId elementId = judgement.getElementId();
        for (Run run : this.getContest().getRuns()) {
            if (run.isDeleted() || !run.isJudged() || !run.getJudgementRecord().getJudgementId().equals(elementId)) continue;
            ++count;
        }
        return count;
    }

    protected void editSelectedJudgement() {
        int selectedIndex = this.judgementListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a judgement to edit");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.judgementListBox.getKeys()[selectedIndex];
            Judgement judgementToEdit = this.getContest().getJudgement(elementId);
            if (this.isYesJudgement(judgementToEdit)) {
                this.editJudgementFrame.setDeleteCheckBoxEnabled(false);
            } else {
                this.editJudgementFrame.setDeleteCheckBoxEnabled(true);
            }
            int numberRuns = this.numberOfRuns(judgementToEdit);
            if (numberRuns > 0) {
                JOptionPane.showMessageDialog(this, "There are " + numberRuns + " runs which will be changed if this judgement is changed", "Runs may be changed", 2);
            }
            this.editJudgementFrame.setJudgement(judgementToEdit);
            this.editJudgementFrame.setVisible(true);
        }
        catch (Exception e) {
            this.getController().getLog().log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit judgement, check log");
        }
    }

    private boolean isYesJudgement(Judgement judgementToEdit) {
        return this.getContest().getJudgements()[0].equals(judgementToEdit);
    }

    protected EditJudgementFrame getEditJudgementFrame() {
        if (this.editJudgementFrame == null) {
            this.editJudgementFrame = new EditJudgementFrame();
        }
        return this.editJudgementFrame;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (JudgementsPanel.this.getContest().getClientId().equals(account.getClientId())) {
                JudgementsPanel.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JudgementsPanel.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                if (!JudgementsPanel.this.getContest().getClientId().equals(account.getClientId())) continue;
                JudgementsPanel.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JudgementsPanel.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            JudgementsPanel.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JudgementsPanel.this.updateGUIperPermissions();
                }
            });
        }
    }

    private class JudgementListenerImplementation
    implements IJudgementListener {
        private JudgementListenerImplementation() {
        }

        public void judgementAdded(JudgementEvent event) {
            JudgementsPanel.this.reloadJudgementList();
        }

        public void judgementChanged(JudgementEvent event) {
            JudgementsPanel.this.reloadJudgementList();
        }

        public void judgementRemoved(JudgementEvent event) {
            JudgementsPanel.this.reloadJudgementList();
        }

        public void judgementRefreshAll(JudgementEvent judgementEvent) {
            JudgementsPanel.this.reloadJudgementList();
        }
    }
}

