/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import edu.csus.ecs.pc2.ui.ReportPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class JPanePlugin
extends JPanel
implements UIPlugin {
    private static final long serialVersionUID = 3600350449535614012L;
    private IInternalController controller;
    private IInternalContest contest;
    private JFrame parentFrame = null;

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.controller = inController;
        this.contest = inContest;
    }

    public abstract String getPluginTitle();

    public IInternalController getController() {
        return this.controller;
    }

    public void setController(IInternalController controller) {
        this.controller = controller;
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    public void setContest(IInternalContest contest) {
        this.contest = contest;
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void createAndViewReportFile(IReport report, Filter filter, Log log) throws IOException {
        ReportPane reportPane = new ReportPane();
        reportPane.setContestAndController(this.contest, this.controller);
        String filename = reportPane.getFileName(report, "txt");
        File reportDirectoryFile = new File(reportPane.getReportDirectory());
        if (reportDirectoryFile.exists()) {
            if (reportDirectoryFile.isDirectory()) {
                filename = reportDirectoryFile.getCanonicalPath() + File.separator + filename;
            }
        } else if (reportDirectoryFile.mkdirs()) {
            filename = reportDirectoryFile.getCanonicalPath() + File.separator + filename;
        }
        reportPane.createReportFile(report, filename, filter);
        String title = report.getReportTitle();
        MultipleFileViewer multipleFileViewer = new MultipleFileViewer(log);
        multipleFileViewer.addFilePane(title, filename);
        multipleFileViewer.setTitle("PC^2 Report (Build " + new VersionInfo().getBuildNumber() + ")");
        FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
        multipleFileViewer.setVisible(true);
    }

    public void logException(String message, Exception ex) {
        this.controller.getLog().log(Log.WARNING, message, ex);
    }

    public PermissionList getPermissionList() {
        ClientId id = this.getContest().getClientId();
        Account account = this.getContest().getAccount(id);
        PermissionList list = null;
        list = account == null ? new PermissionGroup().getPermissionList(id.getClientType()) : account.getPermissionList();
        return list;
    }
}

