/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.ui.CheckBoxListCellRenderer;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCheckBoxJList
extends JList {
    private static final long serialVersionUID = 6660805620712546373L;

    public JCheckBoxJList() {
        this.constructorCommon();
    }

    public JCheckBoxJList(ListModel dataModel) {
        super(dataModel);
        this.constructorCommon();
    }

    public JCheckBoxJList(Object[] listData) {
        super(listData);
        this.constructorCommon();
    }

    public JCheckBoxJList(Vector<?> listData) {
        super(listData);
        this.constructorCommon();
    }

    private void constructorCommon() {
        CheckBoxListCellRenderer renderer = new CheckBoxListCellRenderer();
        this.setCellRenderer(renderer);
        this.setSelectionMode(0);
        CheckBoxListener lst = new CheckBoxListener(this);
        this.addMouseListener(lst);
        this.addKeyListener(lst);
    }

    @Override
    public void setSelectedIndices(int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            JCheckBox checkBox = (JCheckBox)this.getModel().getElementAt(indices[i]);
            checkBox.setSelected(true);
        }
    }

    @Override
    public int[] getSelectedIndices() {
        HashSet<Integer> selectedIndicesSet = this.getSelectedIndicesSet();
        int[] indices = new int[selectedIndicesSet.size()];
        Object[] intArray = selectedIndicesSet.toArray(new Integer[selectedIndicesSet.size()]);
        Arrays.sort(intArray);
        for (int i = 0; i < intArray.length; ++i) {
            indices[i] = (Integer)intArray[i];
        }
        return indices;
    }

    @Override
    public Object[] getSelectedValues() {
        HashSet<Integer> selectedIndicesSet = this.getSelectedIndicesSet();
        Object[] values = new Object[selectedIndicesSet.size()];
        Object[] intArray = selectedIndicesSet.toArray(new Integer[selectedIndicesSet.size()]);
        Arrays.sort(intArray);
        for (int i = 0; i < intArray.length; ++i) {
            values[i] = this.getModel().getElementAt((Integer)intArray[i]);
        }
        return values;
    }

    public HashSet<Integer> getSelectedIndicesSet() {
        HashSet<Integer> selectedIndicesSet = new HashSet<Integer>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            JCheckBox checkBox = (JCheckBox)this.getModel().getElementAt(i);
            if (!checkBox.isSelected()) continue;
            selectedIndicesSet.add(i);
        }
        return selectedIndicesSet;
    }

    class CheckBoxListener
    implements MouseListener,
    KeyListener {
        private JCheckBoxJList jCheckBoxJList;

        public CheckBoxListener(JCheckBoxJList list) {
            this.jCheckBoxJList = list;
        }

        public void mouseClicked(MouseEvent e) {
            this.processAction();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this.processAction();
            } else if (e.getKeyCode() == 65 && e.isControlDown()) {
                this.selectDeselectAll();
            } else if (e.getKeyCode() == 73 && e.isControlDown()) {
                this.invertSelection();
            }
        }

        private void selectDeselectAll() {
            if (JCheckBoxJList.this.getModel().getSize() < 1) {
                return;
            }
            JCheckBox checkBox = (JCheckBox)this.jCheckBoxJList.getModel().getElementAt(0);
            boolean opposite = !checkBox.isSelected();
            for (int i = 0; i < JCheckBoxJList.this.getModel().getSize(); ++i) {
                checkBox = (JCheckBox)this.jCheckBoxJList.getModel().getElementAt(i);
                checkBox.setSelected(opposite);
            }
            JCheckBoxJList.this.repaint();
            this.jCheckBoxJList.firePropertyChange("change", false, true);
        }

        private void invertSelection() {
            if (JCheckBoxJList.this.getModel().getSize() < 1) {
                return;
            }
            JCheckBox checkBox = null;
            for (int i = 0; i < JCheckBoxJList.this.getModel().getSize(); ++i) {
                checkBox.setSelected(!(checkBox = (JCheckBox)this.jCheckBoxJList.getModel().getElementAt(i)).isSelected());
            }
            JCheckBoxJList.this.repaint();
            this.jCheckBoxJList.firePropertyChange("change", false, true);
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        void processAction() {
            JCheckBox checkBox;
            int index = JCheckBoxJList.this.getSelectedIndex();
            if (index < 0) {
                return;
            }
            checkBox.setSelected(!(checkBox = (JCheckBox)this.jCheckBoxJList.getModel().getElementAt(index)).isSelected());
            JCheckBoxJList.this.repaint();
            this.jCheckBoxJList.firePropertyChange("change", false, true);
        }
    }
}

