/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.imports.ICPCImportData;
import edu.csus.ecs.pc2.core.imports.LoadICPCData;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.GroupEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IGroupListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.ICPCAccountFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.TabFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ICPCPane
extends JPanePlugin {
    private static final long serialVersionUID = 5514087353704960972L;
    private JButton changeDisplayFormatButton = null;
    private JButton importAccountsButton = null;
    private ICPCAccountFrame icpcAccountFrame = null;
    private ICPCImportData importData;
    private String lastDir;
    private Log log;
    private JButton importSitesButton = null;
    private PermissionList permissionList = new PermissionList();

    public ICPCPane() {
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(50);
        this.setLayout(flowLayout);
        this.setSize(new Dimension(448, 207));
        this.add((Component)this.getImportSitesButton(), null);
        this.add((Component)this.getImportAccountsButton(), null);
        this.add((Component)this.getChangeDisplayFormatButton(), null);
    }

    public String getPluginTitle() {
        return "ICPC Data Pane";
    }

    private JButton getImportAccountsButton() {
        if (this.importAccountsButton == null) {
            this.importAccountsButton = new JButton();
            this.importAccountsButton.setText("Import Accounts");
            this.importAccountsButton.setPreferredSize(new Dimension(150, 26));
            this.importAccountsButton.setMnemonic(65);
            this.importAccountsButton.setEnabled(false);
            this.importAccountsButton.setToolTipText("Import PC^2 ICPC contest initialization data (PC2_Team.tab)");
            this.importAccountsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ICPCPane.this.loadPC2Team();
                }
            });
        }
        return this.importAccountsButton;
    }

    private ICPCAccountFrame getICPCAccountFrame() {
        if (this.icpcAccountFrame == null) {
            this.icpcAccountFrame = new ICPCAccountFrame();
        }
        return this.icpcAccountFrame;
    }

    protected void loadPC2Site() {
        block13: {
            try {
                JFileChooser chooser = new JFileChooser(this.lastDir);
                chooser.setDialogTitle("Select PC2_Site.tab");
                chooser.setFileFilter(new TabFileFilter());
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal != 0) break block13;
                File newFile = chooser.getSelectedFile().getCanonicalFile();
                boolean newFileProblem = true;
                if (newFile.exists() && newFile.isFile() && newFile.canRead()) {
                    this.lastDir = chooser.getCurrentDirectory().toString();
                    ICPCImportData importSiteData = LoadICPCData.loadSites(this.lastDir, this.getContest().getSites());
                    newFileProblem = false;
                    Group[] importedGroups = importSiteData.getGroups();
                    Group[] modelGroups = this.getContest().getGroups();
                    String contestTitle = importSiteData.getContestTitle();
                    if (contestTitle != null && contestTitle.trim().length() > 0) {
                        ContestInformation ci = this.getContest().getContestInformation();
                        ci.setContestTitle(contestTitle);
                        this.getController().updateContestInformation(ci);
                    }
                    if (importedGroups != null && importedGroups.length > 0) {
                        if (modelGroups == null || modelGroups.length == 0) {
                            for (Group group : importedGroups) {
                                this.getController().addNewGroup(group);
                            }
                        } else {
                            HashMap<String, Group> groupMap = new HashMap<String, Group>();
                            for (Group group : modelGroups) {
                                groupMap.put(group.getDisplayName(), group);
                                groupMap.put(Integer.toString(group.getGroupId()), group);
                            }
                            for (Group group : importedGroups) {
                                if (groupMap.containsKey(Integer.toString(group.getGroupId()))) {
                                    this.mergeGroups((Group)groupMap.get(Integer.toString(group.getGroupId())), group);
                                    continue;
                                }
                                if (groupMap.containsKey(group.getDisplayName())) {
                                    this.mergeGroups((Group)groupMap.get(group.getDisplayName()), group);
                                    continue;
                                }
                                this.getController().addNewGroup(group);
                            }
                        }
                    }
                }
                if (newFileProblem) {
                    this.log.warning("Problem reading PC2_Contest.tab " + newFile.getCanonicalPath() + "");
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Could not open file " + newFile, "Warning", 2);
                }
            }
            catch (Exception e) {
                this.log.log(Log.WARNING, "loadPC2Site exception ", e);
            }
        }
    }

    protected void loadPC2Team() {
        try {
            JFileChooser chooser = new JFileChooser(this.lastDir);
            chooser.setDialogTitle("Select PC2_Team.tab");
            chooser.setFileFilter(new TabFileFilter());
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File newFile = chooser.getSelectedFile().getCanonicalFile();
                boolean newFileProblem = true;
                if (newFile.exists() && newFile.isFile() && newFile.canRead()) {
                    this.lastDir = chooser.getCurrentDirectory().toString();
                    Vector<Account> accountVector = this.getContest().getAccounts(ClientType.Type.TEAM);
                    Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
                    this.importData = LoadICPCData.loadAccounts(this.lastDir, this.getContest().getGroups(), accounts);
                    newFileProblem = false;
                    this.changeDisplayFormat();
                }
                if (newFileProblem) {
                    this.log.warning("Problem reading _PC2_Team.tab " + newFile.getCanonicalPath() + "");
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Could not open file " + newFile, "Warning", 2);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception ", e);
        }
    }

    private JButton getChangeDisplayFormatButton() {
        if (this.changeDisplayFormatButton == null) {
            this.changeDisplayFormatButton = new JButton();
            this.changeDisplayFormatButton.setText("Change Display Format");
            this.changeDisplayFormatButton.setToolTipText("Change Name Display Choice");
            this.changeDisplayFormatButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ICPCPane.this.changeDisplayFormat();
                }
            });
        }
        return this.changeDisplayFormatButton;
    }

    protected void changeDisplayFormat() {
        boolean gotData = false;
        try {
            Vector<Account> teams = this.getContest().getAccounts(ClientType.Type.TEAM);
            for (Account account : teams) {
                if (account == null || account.getLongSchoolName() == null || this.isEmpty(account.getLongSchoolName())) continue;
                gotData = true;
                break;
            }
        }
        catch (Exception e) {
            this.log.throwing("ICPCPane", "changeDisplayFormat", e);
        }
        if (this.importData == null && !gotData) {
            JOptionPane.showMessageDialog(this, "Please 'Import Accounts' icpc account data first.", "Error", 0);
            return;
        }
        if (this.importData != null && this.importData.getAccounts() != null) {
            this.getICPCAccountFrame().setICPCAccounts(this.importData.getAccounts());
        }
        this.getICPCAccountFrame().setContestAndController(this.getContest(), this.getController());
        this.getICPCAccountFrame().setVisible(true);
    }

    private boolean isEmpty(String longSchoolName) {
        return longSchoolName == null || longSchoolName.trim().length() == 0;
    }

    private void mergeGroups(Group dstGroup, Group srcGroup) {
        if (dstGroup.isSameAs(srcGroup)) {
            return;
        }
        dstGroup.setDisplayName(srcGroup.getDisplayName());
        dstGroup.setGroupId(srcGroup.getGroupId());
        if (srcGroup.getSite() != null) {
            dstGroup.setSite(srcGroup.getSite());
        }
        this.getController().updateGroup(dstGroup);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addGroupListener(new GroupListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ICPCPane.this.getImportAccountsButton().setEnabled(ICPCPane.this.getContest().getGroups() != null);
                ICPCPane.this.updateGUIperPermissions();
            }
        });
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.changeDisplayFormatButton.setEnabled(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
        this.importSitesButton.setEnabled(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
        this.importAccountsButton.setEnabled(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
    }

    private JButton getImportSitesButton() {
        if (this.importSitesButton == null) {
            this.importSitesButton = new JButton();
            this.importSitesButton.setPreferredSize(new Dimension(150, 26));
            this.importSitesButton.setMnemonic(83);
            this.importSitesButton.setText("Import Sites");
            this.importSitesButton.setActionCommand("Import Sites");
            this.importSitesButton.setToolTipText("Import PC^2 ICPC contest initialization data (PC2_Site.tab)");
            this.importSitesButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ICPCPane.this.loadPC2Site();
                }
            });
        }
        return this.importSitesButton;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (ICPCPane.this.getContest().getClientId().equals(account.getClientId())) {
                ICPCPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ICPCPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                if (!ICPCPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                ICPCPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ICPCPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            ICPCPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ICPCPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    public class GroupListenerImplementation
    implements IGroupListener {
        public void groupAdded(GroupEvent event) {
            ICPCPane.this.getImportAccountsButton().setEnabled(ICPCPane.this.getContest().getGroups() != null);
        }

        public void groupChanged(GroupEvent event) {
            ICPCPane.this.getImportAccountsButton().setEnabled(ICPCPane.this.getContest().getGroups() != null);
        }

        public void groupRemoved(GroupEvent event) {
        }

        public void groupRefreshAll(GroupEvent groupEvent) {
            ICPCPane.this.getImportAccountsButton().setEnabled(ICPCPane.this.getContest().getGroups() != null);
        }
    }
}

