/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.imports.ICPCAccount;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.DisplayNameFormatterPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ICPCAccountPane
extends JPanePlugin {
    private static final long serialVersionUID = -94109299290020550L;
    private DisplayNameFormatterPane displayNameFormatterPane = null;
    private MCLB accountListBox = null;
    private JPanel buttonPanel = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private ICPCAccount[] icpcAccounts;
    private String displayChoice = "SHORTSCHOOLNAME";
    private Vector<Account> updatedAccountVector = new Vector();
    private JCheckBox showAllCheckBox = null;

    public ICPCAccountPane() {
        this.initialize();
    }

    private String getSiteTitle(String string) {
        return "Site " + string;
    }

    private String getTeamDisplayName(Account account) {
        if (account != null) {
            return account.getDisplayName();
        }
        return "Invalid Account";
    }

    private Object[] buildAccountRow(Account account, String newDisplayName) {
        try {
            int cols = this.accountListBox.getColumnCount();
            Object[] s = new String[cols];
            ClientId clientId = account.getClientId();
            s[0] = this.getSiteTitle("" + account.getSiteNumber());
            s[1] = clientId.getClientType().toString().toLowerCase();
            s[2] = "" + clientId.getClientNumber();
            s[3] = this.getTeamDisplayName(account);
            s[4] = newDisplayName;
            return s;
        }
        catch (Exception exception) {
            this.getController().getLog().log(Log.INFO, "Exception in buildAccountRow()", exception);
            return null;
        }
    }

    protected void changeDisplayName(String string) {
        if (string != null && string.length() > 0) {
            this.updatedAccountVector.clear();
            this.getAccountListBox().removeAllRows();
            Hashtable<ClientId, ICPCAccount> icpcAccountsHash = new Hashtable<ClientId, ICPCAccount>();
            for (ICPCAccount account : this.icpcAccounts) {
                if (account.getClientId() == null) continue;
                icpcAccountsHash.put(account.getClientId(), account);
            }
            for (Account account : this.getContest().getAccounts(ClientType.Type.TEAM)) {
                String newDisplayName = "";
                ICPCAccount icpcAccount = (ICPCAccount)icpcAccountsHash.get(account.getClientId());
                if (string.equalsIgnoreCase(DisplayNameFormatterPane.DisplayNameChoice.TEAMNAME.toString())) {
                    newDisplayName = icpcAccount == null ? account.getExternalName() : icpcAccount.getExternalName();
                } else if (string.equalsIgnoreCase(DisplayNameFormatterPane.DisplayNameChoice.SCHOOLNAME.toString())) {
                    newDisplayName = icpcAccount == null ? account.getLongSchoolName() : icpcAccount.getLongSchoolName();
                } else if (string.equalsIgnoreCase(DisplayNameFormatterPane.DisplayNameChoice.SHORTSCHOOLNAME.toString())) {
                    newDisplayName = icpcAccount == null ? account.getShortSchoolName() : icpcAccount.getShortSchoolName();
                } else if (string.equalsIgnoreCase(DisplayNameFormatterPane.DisplayNameChoice.TEAMANDSHORTSCHOOLNAME.toString())) {
                    String externalName = "";
                    String shortSchoolName = "";
                    if (icpcAccount == null) {
                        externalName = account.getExternalName();
                        shortSchoolName = account.getShortSchoolName();
                    } else {
                        externalName = icpcAccount.getExternalName();
                        shortSchoolName = icpcAccount.getShortSchoolName();
                    }
                    if (externalName.equals("") && shortSchoolName.equals("")) continue;
                    newDisplayName = externalName + " (" + shortSchoolName + ")";
                } else {
                    this.getController().getLog().info("Unknown display name choice " + string);
                    break;
                }
                if (newDisplayName.equals("")) continue;
                this.updateDisplayName(account, icpcAccount, newDisplayName);
            }
            if (this.updatedAccountVector.size() > 0) {
                this.cancelButton.setText("Cancel");
            } else {
                this.cancelButton.setText("Close");
            }
            this.getUpdateButton().setEnabled(this.updatedAccountVector.size() > 0);
            this.getAccountListBox().autoSizeAllColumns();
        }
    }

    private void updateDisplayName(Account account2, ICPCAccount icpcAccount, String newDisplayName) {
        if (this.showAllCheckBox.isSelected() || !account2.getDisplayName().equals(newDisplayName)) {
            Account account = new Account(account2.getClientId(), account2.getPassword(), account2.getClientId().getSiteNumber());
            account.clearListAndLoadPermissions(account2.getPermissionList());
            account.setGroupId(account2.getGroupId());
            account.setAliasName(new String(account2.getAliasName()));
            account.setDisplayName(new String(account2.getDisplayName()));
            account.setExternalId(new String(account2.getExternalId()));
            account.setExternalName(new String(account2.getExternalName()));
            account.setLongSchoolName(new String(account2.getLongSchoolName()));
            account.setShortSchoolName(new String(account2.getShortSchoolName()));
            if (account.isSameAs(account2)) {
                if (icpcAccount != null) {
                    account.setExternalId(icpcAccount.getExternalId());
                    account.setExternalName(icpcAccount.getExternalName());
                    account.setLongSchoolName(icpcAccount.getLongSchoolName());
                    account.setShortSchoolName(icpcAccount.getShortSchoolName());
                    account.setGroupId(icpcAccount.getGroupId());
                }
                String oldDisplayName = account.getDisplayName();
                account.setDisplayName(newDisplayName);
                if (!newDisplayName.equals(oldDisplayName)) {
                    this.updatedAccountVector.add(account);
                }
                this.getAccountListBox().addRow(this.buildAccountRow(account2, newDisplayName));
            } else {
                this.getController().getLog().info("clone failed isSameAs test " + account + " vs " + account2);
            }
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(600, 1500));
        this.setPreferredSize(new Dimension(600, 1500));
        this.add((Component)this.getDisplayNameFormatterPane(), "North");
        this.add((Component)((Object)this.getAccountListBox()), "Center");
    }

    public String getPluginTitle() {
        return "ICPC Account Pane";
    }

    private DisplayNameFormatterPane getDisplayNameFormatterPane() {
        if (this.displayNameFormatterPane == null) {
            this.displayNameFormatterPane = new DisplayNameFormatterPane();
            this.displayNameFormatterPane.addPropertyChangeListener("displayChoice", new PropertyChangeListenerImplementation());
            this.displayChoice = this.displayNameFormatterPane.getCurrentSelection().toString();
        }
        return this.displayNameFormatterPane;
    }

    private MCLB getAccountListBox() {
        if (this.accountListBox == null) {
            this.accountListBox = new MCLB();
            this.accountListBox.add(this.getButtonPanel(), "South");
            Object[] cols = new Object[]{"Site", "Type", "Account Id", "Old Display Name", "New Display Name"};
            this.accountListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            this.accountListBox.setColumnSorter(0, sorter, 3);
            this.accountListBox.setColumnSorter(1, sorter, 2);
            this.accountListBox.setColumnSorter(2, numericStringSorter, 1);
            this.accountListBox.setColumnSorter(3, sorter, 4);
            this.accountListBox.setColumnSorter(4, sorter, 5);
            cols = null;
            this.accountListBox.autoSizeAllColumns();
        }
        return this.accountListBox;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getUpdateButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
            this.buttonPanel.add((Component)this.getShowAllCheckBox(), null);
        }
        return this.buttonPanel;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ICPCAccountPane.this.handleUpdateButton();
                }
            });
        }
        return this.updateButton;
    }

    protected void handleUpdateButton() {
        Account[] accounts;
        if (this.updatedAccountVector.size() > 0 && (accounts = this.updatedAccountVector.toArray(new Account[this.updatedAccountVector.size()])) != null) {
            this.getController().updateAccounts(accounts);
        }
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ICPCAccountPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ICPCAccountPane.this.getParentFrame() != null) {
                    ICPCAccountPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            ICPCAccountPane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.addWindowCloserListener();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.changeDisplayName(this.displayChoice);
    }

    protected void handleCancelButton() {
        if (this.updatedAccountVector.size() > 0) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Accounts modified, save changes?", "Confirm Choice");
            if (result == 0) {
                this.handleUpdateButton();
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    public void setIcpcAccounts(ICPCAccount[] icpcAccounts) {
        this.icpcAccounts = icpcAccounts;
    }

    private JCheckBox getShowAllCheckBox() {
        if (this.showAllCheckBox == null) {
            this.showAllCheckBox = new JCheckBox();
            this.showAllCheckBox.setText("Included unchanged accounts");
            this.showAllCheckBox.setPreferredSize(new Dimension(250, 24));
            this.showAllCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ICPCAccountPane.this.changeDisplayName(ICPCAccountPane.this.displayChoice);
                }
            });
        }
        return this.showAllCheckBox;
    }

    public class PropertyChangeListenerImplementation
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() != null && !evt.getNewValue().equals(evt.getOldValue())) {
                ICPCAccountPane.this.displayChoice = (String)evt.getNewValue();
                ICPCAccountPane.this.changeDisplayName(ICPCAccountPane.this.displayChoice);
            }
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
            ICPCAccountPane.this.changeDisplayName(ICPCAccountPane.this.displayChoice);
        }

        public void accountModified(AccountEvent event) {
            ICPCAccountPane.this.changeDisplayName(ICPCAccountPane.this.displayChoice);
        }

        public void accountsAdded(AccountEvent accountEvent) {
            ICPCAccountPane.this.changeDisplayName(ICPCAccountPane.this.displayChoice);
        }

        public void accountsModified(AccountEvent accountEvent) {
            ICPCAccountPane.this.changeDisplayName(ICPCAccountPane.this.displayChoice);
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            ICPCAccountPane.this.changeDisplayName(ICPCAccountPane.this.displayChoice);
        }
    }
}

