/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.GroupEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IGroupListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.EditGroupFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GroupsPane
extends JPanePlugin {
    private static final long serialVersionUID = -5837850150714301616L;
    private JPanel groupButtonPane = null;
    private MCLB groupListBox = null;
    private JButton addButton = null;
    private JButton editButton = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private EditGroupFrame editGroupFrame = null;
    private Log log;
    private PermissionList permissionList = new PermissionList();

    public GroupsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(564, 229));
        this.add((Component)((Object)this.getGroupListBox()), "Center");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getGroupButtonPane(), "South");
        this.editGroupFrame = new EditGroupFrame();
    }

    public String getPluginTitle() {
        return "Groups Pane";
    }

    private JPanel getGroupButtonPane() {
        if (this.groupButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.groupButtonPane = new JPanel();
            this.groupButtonPane.setLayout(flowLayout);
            this.groupButtonPane.setPreferredSize(new Dimension(35, 35));
            this.groupButtonPane.add((Component)this.getAddButton(), null);
            this.groupButtonPane.add((Component)this.getEditButton(), null);
        }
        return this.groupButtonPane;
    }

    private MCLB getGroupListBox() {
        if (this.groupListBox == null) {
            this.groupListBox = new MCLB();
            Object[] cols = new Object[]{"Id", "Display Name", "PC^2 Site", "External Id", "On Scoreboard"};
            this.groupListBox.addColumns(cols);
            this.groupListBox.autoSizeAllColumns();
        }
        return this.groupListBox;
    }

    public void updateGroupRow(final Group group) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int rowNumber = GroupsPane.this.groupListBox.getIndexByKey(group.getElementId());
                if (rowNumber == -1) {
                    rowNumber = GroupsPane.this.groupListBox.getRowCount() + 1;
                    Object[] objects = GroupsPane.this.buildGroupRow(group, rowNumber);
                    GroupsPane.this.groupListBox.addRow(objects, group.getElementId());
                } else {
                    Object[] objects = GroupsPane.this.buildGroupRow(group, rowNumber);
                    GroupsPane.this.groupListBox.replaceRow(objects, rowNumber);
                }
                GroupsPane.this.groupListBox.autoSizeAllColumns();
                GroupsPane.this.getEditButton().setEnabled(GroupsPane.this.groupListBox.getRowCount() > 0);
            }
        });
    }

    protected Object[] buildGroupRow(Group group, int rowNumber) {
        int numberColumns = this.groupListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = "" + rowNumber;
        c[1] = group.toString();
        c[2] = group.getSite() == null ? "<NONE SELECTED>" : this.getContest().getSite(group.getSite().getSiteNumber()).toString();
        c[3] = Integer.valueOf(group.getGroupId()).toString();
        c[4] = Boolean.toString(group.isDisplayOnScoreboard());
        return c;
    }

    private void reloadListBox() {
        this.groupListBox.removeAllRows();
        Group[] groups = this.getContest().getGroups();
        int rowNumber = 1;
        for (Group group : groups) {
            this.addGroupRow(group, rowNumber);
            ++rowNumber;
        }
        this.getEditButton().setEnabled(this.groupListBox.getRowCount() > 0);
    }

    private void addGroupRow(Group group, int rowNumber) {
        Object[] objects = this.buildGroupRow(group, rowNumber);
        this.groupListBox.addRow(objects, group.getElementId());
        this.groupListBox.autoSizeAllColumns();
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.editGroupFrame.setContestAndController(inContest, inController);
        this.getContest().addGroupListener(new GroupListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.initializePermissions();
        this.log = this.getController().getLog();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GroupsPane.this.updateGUIperPermissions();
                GroupsPane.this.reloadListBox();
            }
        });
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.addButton.setVisible(this.isAllowed(Permission.Type.ADD_GROUPS));
        this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_GROUPS));
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setToolTipText("Add a group");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GroupsPane.this.addNewGroup();
                }
            });
        }
        return this.addButton;
    }

    protected void addNewGroup() {
        this.editGroupFrame.setGroup();
        this.editGroupFrame.setVisible(true);
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setToolTipText("Edit selected group");
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GroupsPane.this.editSelectedGroup();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedGroup() {
        int selectedIndex = this.groupListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a group to edit");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.groupListBox.getKeys()[selectedIndex];
            Group groupToEdit = this.getContest().getGroup(elementId);
            this.editGroupFrame.setGroup(groupToEdit, selectedIndex + 1);
            this.editGroupFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit group, check log");
        }
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(GroupsPane.this.getParentFrame(), string, "Warning", 2);
            }
        });
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (GroupsPane.this.getContest().getClientId().equals(account.getClientId())) {
                GroupsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GroupsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                if (!GroupsPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                GroupsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GroupsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            GroupsPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GroupsPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    public class GroupListenerImplementation
    implements IGroupListener {
        public void groupAdded(GroupEvent event) {
            GroupsPane.this.updateGroupRow(event.getGroup());
        }

        public void groupChanged(GroupEvent event) {
            GroupsPane.this.updateGroupRow(event.getGroup());
        }

        public void groupRemoved(GroupEvent event) {
        }

        public void groupRefreshAll(GroupEvent groupEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GroupsPane.this.reloadListBox();
                }
            });
        }
    }
}

