/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GroupPane
extends JPanePlugin {
    private static final long serialVersionUID = 6229906311932197623L;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JTextField displayNameTextField = null;
    private JLabel jLabel4 = null;
    private JTextField externalIdTextField = null;
    private static final String NONE_SELECTED = "NONE SELECTED";
    private Group group = null;
    private boolean populatingGUI = true;
    private JComboBox siteComboBox = null;
    private JCheckBox displayOnScoreboardCheckbox = null;

    public GroupPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(517, 197));
        this.add((Component)this.getJPanel(), "Center");
        this.add((Component)this.getButtonPane(), "South");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.addWindowCloserListener();
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GroupPane.this.getParentFrame() != null) {
                    GroupPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            GroupPane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    public String getPluginTitle() {
        return "Edit Group Pane";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GroupPane.this.addGroup();
                }
            });
        }
        return this.addButton;
    }

    protected void addGroup() {
        if (!this.validateGroupFields()) {
            return;
        }
        Group newGroup = null;
        try {
            newGroup = this.getGroupFromFields(null);
        }
        catch (InvalidFieldValue e) {
            StaticLog.log("Error getGroupFromFields", e);
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        this.getController().addNewGroup(newGroup);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private Group getGroupFromFields(Group checkGroup) throws InvalidFieldValue {
        if (checkGroup == null) {
            checkGroup = new Group(this.getDisplayNameTextField().getText());
        } else {
            checkGroup.setDisplayName(this.getDisplayNameTextField().getText());
        }
        checkGroup.setDisplayName(this.displayNameTextField.getText());
        if (this.getSiteComboBox().getSelectedIndex() > 0) {
            Site site = (Site)this.getSiteComboBox().getSelectedItem();
            checkGroup.setSite(site.getElementId());
        } else {
            checkGroup.setSite(null);
        }
        if (this.getExternalidTextField().getText().length() > 0) {
            checkGroup.setGroupId(Integer.parseInt(this.externalIdTextField.getText()));
        }
        checkGroup.setDisplayOnScoreboard(this.getDisplayOnScoreboardCheckbox().isSelected());
        return checkGroup;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GroupPane.this.updateGroup();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateGroup() {
        if (!this.validateGroupFields()) {
            return;
        }
        Group newGroup = null;
        try {
            newGroup = this.getGroupFromFields(this.group);
        }
        catch (InvalidFieldValue e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        this.getController().updateGroup(newGroup);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private boolean validateGroupFields() {
        if (this.getDisplayNameTextField().getText().trim().length() < 1) {
            JOptionPane.showMessageDialog(this, "Enter a group display name");
            return false;
        }
        return true;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GroupPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Group modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addGroup();
                } else {
                    this.updateGroup();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(new Rectangle(18, 125, 182, 20));
            this.jLabel4.setName("ExternalIdLabel");
            this.jLabel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel4.setHorizontalAlignment(4);
            this.jLabel4.setText("External Id");
            this.jLabel4.setForeground(new Color(0, 0, 0));
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(new Rectangle(18, 16, 182, 20));
            this.jLabel1.setName("DisplayNameLabel");
            this.jLabel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel1.setHorizontalAlignment(4);
            this.jLabel1.setText("Display Name");
            this.jLabel1.setForeground(Color.black);
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(18, 52, 182, 20));
            this.jLabel.setName("PC2SiteLabel");
            this.jLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel.setHorizontalAlignment(4);
            this.jLabel.setText("PC^2 Site");
            this.jLabel.setForeground(Color.black);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.setName("advancedEdit");
            this.jPanel.add((Component)this.jLabel, this.jLabel.getName());
            this.jPanel.add((Component)this.jLabel1, this.jLabel1.getName());
            this.jPanel.add((Component)this.getDisplayNameTextField(), this.getDisplayNameTextField().getName());
            this.jPanel.add((Component)this.jLabel4, this.jLabel4.getName());
            this.jPanel.add((Component)this.getExternalidTextField(), this.getExternalidTextField().getName());
            this.jPanel.add((Component)this.getSiteComboBox(), null);
            this.jPanel.add((Component)this.getDisplayOnScoreboardCheckbox(), null);
        }
        return this.jPanel;
    }

    private JTextField getDisplayNameTextField() {
        if (this.displayNameTextField == null) {
            this.displayNameTextField = new JTextField();
            this.displayNameTextField.setBounds(new Rectangle(213, 16, 263, 20));
            this.displayNameTextField.setToolTipText("Name to display to users");
            this.displayNameTextField.setName("displayNameTextField");
            this.displayNameTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    GroupPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNameTextField;
    }

    private JTextField getExternalidTextField() {
        if (this.externalIdTextField == null) {
            this.externalIdTextField = new JTextField();
            this.externalIdTextField.setBounds(new Rectangle(213, 125, 76, 20));
            this.externalIdTextField.setToolTipText("");
            this.externalIdTextField.setName("externalIdTextField");
            this.externalIdTextField.setDocument(new IntegerDocument());
            this.externalIdTextField.setDocument(new IntegerDocument());
            this.externalIdTextField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    GroupPane.this.enableUpdateButton();
                }
            });
        }
        return this.externalIdTextField;
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.group != null) {
            try {
                Group changedGroup = this.getGroupFromFields(null);
                if (!this.group.isSameAs(changedGroup)) {
                    enableButton = true;
                }
            }
            catch (InvalidFieldValue e) {
                this.getController().getLog().log(Log.DEBUG, "Input Group (but not saving) ", e);
                enableButton = true;
            }
        } else if (this.getAddButton().isVisible()) {
            enableButton = true;
        }
        this.enableUpdateButtons(enableButton);
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(final Group group) {
        this.group = group;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GroupPane.this.populateGUI(group);
                GroupPane.this.enableUpdateButtons(false);
            }
        });
    }

    private void populateSiteCombo(int siteNumber) {
        int siteIndex = 0;
        this.getSiteComboBox().removeAllItems();
        this.getSiteComboBox().addItem(NONE_SELECTED);
        int i = 1;
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        for (Site site : sites) {
            this.getSiteComboBox().addItem(site);
            if (siteNumber == site.getSiteNumber()) {
                siteIndex = i;
            }
            ++i;
        }
        this.getSiteComboBox().setSelectedIndex(siteIndex);
    }

    private void populateGUI(Group group2) {
        this.populatingGUI = true;
        if (group2 != null) {
            this.getDisplayNameTextField().setText(group2.getDisplayName());
            this.getExternalidTextField().setText(String.valueOf(group2.getGroupId()));
            this.getDisplayOnScoreboardCheckbox().setSelected(group2.isDisplayOnScoreboard());
            int siteNumber = 0;
            if (group2.getSite() != null) {
                siteNumber = group2.getSite().getSiteNumber();
            }
            this.populateSiteCombo(siteNumber);
            this.getAddButton().setVisible(false);
            this.getUpdateButton().setVisible(true);
        } else {
            this.getDisplayNameTextField().setText("");
            this.getExternalidTextField().setText("");
            this.getDisplayOnScoreboardCheckbox().setSelected(true);
            this.populateSiteCombo(0);
            this.getAddButton().setVisible(true);
            this.getUpdateButton().setVisible(false);
        }
        this.populatingGUI = false;
    }

    protected void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        this.addButton.setEnabled(editedText);
        this.updateButton.setEnabled(editedText);
    }

    private JComboBox getSiteComboBox() {
        if (this.siteComboBox == null) {
            this.siteComboBox = new JComboBox();
            this.siteComboBox.setBounds(new Rectangle(213, 50, 247, 25));
            this.siteComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GroupPane.this.enableUpdateButton();
                }
            });
        }
        return this.siteComboBox;
    }

    private JCheckBox getDisplayOnScoreboardCheckbox() {
        if (this.displayOnScoreboardCheckbox == null) {
            this.displayOnScoreboardCheckbox = new JCheckBox();
            this.displayOnScoreboardCheckbox.setBounds(new Rectangle(18, 88, 182, 21));
            this.displayOnScoreboardCheckbox.setHorizontalTextPosition(10);
            this.displayOnScoreboardCheckbox.setHorizontalAlignment(4);
            this.displayOnScoreboardCheckbox.setText("Display on Scoreboard?");
            this.displayOnScoreboardCheckbox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GroupPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayOnScoreboardCheckbox;
    }
}

