/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.FinalizeReport;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FinalizePane
extends JPanePlugin {
    private static final long serialVersionUID = 3089291613784484371L;
    private JPanel buttonPane = null;
    private JButton updateButton = null;
    private JButton finalizeButton = null;
    private JPanel centerPane = null;
    private JLabel goldLabel = null;
    private JLabel silverLabel = null;
    private JLabel bronzeLabel = null;
    private JLabel certifierLabel = null;
    private JTextField goldRankTextField = null;
    private JTextField silverRankTextField = null;
    private JTextField bronzeRankTextField = null;
    private JTextField commentTextField = null;
    private JLabel certificationCommentLabel = null;
    private JButton reportButton = null;

    public FinalizePane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(457, 239));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getCenterPane(), "Center");
    }

    public String getPluginTitle() {
        return "Profile Status Pane";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getFinalizeButton(), null);
            this.buttonPane.add((Component)this.getReportButton(), null);
        }
        return this.buttonPane;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FinalizePane.this.reloadFrame();
            }
        });
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
    }

    protected FinalizeData getFromFields() {
        FinalizeData data = new FinalizeData();
        data.setGoldRank(this.getIntegerValue(this.getGoldRankTextField()));
        data.setSilverRank(this.getIntegerValue(this.getSilverRankTextField()));
        data.setBronzeRank(this.getIntegerValue(this.getBronzeRankTextField()));
        data.setComment("" + this.getCommentTextField().getText());
        return data;
    }

    private int getIntegerValue(JTextField textField) {
        String s = "0" + textField.getText();
        return Integer.parseInt(s);
    }

    private void populateDefaults() {
        this.getGoldRankTextField().setText("4");
        this.getSilverRankTextField().setText("8");
        this.getBronzeRankTextField().setText("12");
    }

    protected void reloadFrame() {
        FinalizeData data = this.getContest().getFinalizeData();
        if (data != null) {
            this.getGoldRankTextField().setText(Integer.toString(data.getGoldRank()));
            this.getSilverRankTextField().setText(Integer.toString(data.getSilverRank()));
            this.getBronzeRankTextField().setText(Integer.toString(data.getBronzeRank()));
            this.getCommentTextField().setText(data.getComment());
            if (data.isCertified()) {
                this.certificationCommentLabel.setText("Contest Certified");
                this.certificationCommentLabel.setToolTipText("Certified at: " + data.getCertificationDate());
            }
        } else {
            this.certificationCommentLabel.setText("Contest not certified");
            this.certificationCommentLabel.setToolTipText("");
            this.populateDefaults();
        }
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setMnemonic(85);
            this.updateButton.setToolTipText("Update data do not finalize");
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FinalizePane.this.updateFinalizeData();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateFinalizeData() {
        FinalizeData data = this.getFromFields();
        FinalizeData contestFinalizedata = this.getContest().getFinalizeData();
        if (contestFinalizedata != null) {
            data.setCertified(contestFinalizedata.isCertified());
        }
        this.getController().updateFinalizeData(data);
    }

    private JButton getFinalizeButton() {
        if (this.finalizeButton == null) {
            this.finalizeButton = new JButton();
            this.finalizeButton.setText("Finalize");
            this.finalizeButton.setMnemonic(90);
            this.finalizeButton.setToolTipText("Certify Contest Results");
            this.finalizeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FinalizePane.this.finalizeData();
                }
            });
        }
        return this.finalizeButton;
    }

    protected void finalizeData() {
        FinalizeData data = this.getFromFields();
        try {
            this.validateData(data);
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        data.setCertified(true);
        this.getController().updateFinalizeData(data);
    }

    private void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private void validateData(FinalizeData data) throws InvalidFieldValue {
        if (data.getGoldRank() == 0) {
            throw new InvalidFieldValue("Gold rank must be greater than zero");
        }
        if (data.getSilverRank() <= data.getGoldRank()) {
            throw new InvalidFieldValue("Silver rank must be greater than gold rank.");
        }
        if (data.getBronzeRank() <= data.getSilverRank()) {
            throw new InvalidFieldValue("Bronze rank must be greater than silver rank.");
        }
        if (data.getComment().trim().length() < 1) {
            throw new InvalidFieldValue("Missing comment, enter a comment");
        }
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.certificationCommentLabel = new JLabel();
            this.certificationCommentLabel.setBounds(new Rectangle(30, 19, 402, 26));
            this.certificationCommentLabel.setFont(new Font("Dialog", 1, 14));
            this.certificationCommentLabel.setHorizontalAlignment(0);
            this.certificationCommentLabel.setText("Contest Not Certified");
            this.certifierLabel = new JLabel();
            this.certifierLabel.setBounds(new Rectangle(53, 171, 125, 22));
            this.certifierLabel.setText("Who certifies");
            this.certifierLabel.setHorizontalAlignment(4);
            this.bronzeLabel = new JLabel();
            this.bronzeLabel.setBounds(new Rectangle(53, 134, 125, 22));
            this.bronzeLabel.setText("Last Bronze Rank");
            this.bronzeLabel.setHorizontalAlignment(4);
            this.silverLabel = new JLabel();
            this.silverLabel.setBounds(new Rectangle(53, 97, 125, 22));
            this.silverLabel.setText("Last Silver Rank");
            this.silverLabel.setHorizontalAlignment(4);
            this.goldLabel = new JLabel();
            this.goldLabel.setBounds(new Rectangle(53, 60, 125, 22));
            this.goldLabel.setHorizontalAlignment(4);
            this.goldLabel.setText("Last Gold Rank");
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.add((Component)this.goldLabel, null);
            this.centerPane.add((Component)this.silverLabel, null);
            this.centerPane.add((Component)this.bronzeLabel, null);
            this.centerPane.add((Component)this.certifierLabel, null);
            this.centerPane.add((Component)this.getGoldRankTextField(), null);
            this.centerPane.add((Component)this.getSilverRankTextField(), null);
            this.centerPane.add((Component)this.getBronzeRankTextField(), null);
            this.centerPane.add((Component)this.getCommentTextField(), null);
            this.centerPane.add((Component)this.certificationCommentLabel, null);
        }
        return this.centerPane;
    }

    private JTextField getGoldRankTextField() {
        if (this.goldRankTextField == null) {
            this.goldRankTextField = new JTextField();
            this.goldRankTextField.setBounds(new Rectangle(196, 61, 40, 20));
            this.goldRankTextField.setDocument(new IntegerDocument());
        }
        return this.goldRankTextField;
    }

    private JTextField getSilverRankTextField() {
        if (this.silverRankTextField == null) {
            this.silverRankTextField = new JTextField();
            this.silverRankTextField.setBounds(new Rectangle(196, 98, 40, 20));
            this.silverRankTextField.setDocument(new IntegerDocument());
        }
        return this.silverRankTextField;
    }

    private JTextField getBronzeRankTextField() {
        if (this.bronzeRankTextField == null) {
            this.bronzeRankTextField = new JTextField();
            this.bronzeRankTextField.setBounds(new Rectangle(196, 135, 40, 20));
            this.goldRankTextField.setDocument(new IntegerDocument());
        }
        return this.bronzeRankTextField;
    }

    private JTextField getCommentTextField() {
        if (this.commentTextField == null) {
            this.commentTextField = new JTextField();
            this.commentTextField.setBounds(new Rectangle(196, 172, 207, 20));
        }
        return this.commentTextField;
    }

    private JButton getReportButton() {
        if (this.reportButton == null) {
            this.reportButton = new JButton();
            this.reportButton.setText("Report");
            this.reportButton.setMnemonic(82);
            this.reportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Utilities.viewReport(new FinalizeReport(), "Finalize Report", FinalizePane.this.getContest(), FinalizePane.this.getController());
                }
            });
        }
        return this.reportButton;
    }

    public class ContestInformationListenerImplementation
    implements IContestInformationListener {
        public void contestInformationAdded(ContestInformationEvent event) {
        }

        public void contestInformationChanged(ContestInformationEvent event) {
        }

        public void contestInformationRemoved(ContestInformationEvent event) {
        }

        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
        }

        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FinalizePane.this.reloadFrame();
                }
            });
        }
    }
}

