/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.RunPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class EditRunFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 6716035052687410328L;
    private IInternalContest contest;
    private IInternalController controller;
    private RunPane runPane = null;
    private Run run = null;

    public EditRunFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(549, 329));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getRunPane());
        this.setTitle("New Run");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EditRunFrame.this.getRunPane().handleCancelButton();
            }
        });
        FrameUtilities.centerFrame(this);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getRunPane().setContestAndController(this.contest, this.controller);
        this.getRunPane().setParentFrame(this);
        this.contest.addRunListener(new RunListenerImplementation());
    }

    public void setRun(Run theRun) {
        if (theRun == null) {
            this.setTitle("Add New Run");
        } else {
            this.setTitle("Edit Run " + theRun.getNumber() + " (Site " + theRun.getSiteNumber() + ")");
            this.run = theRun;
            this.controller.checkOutRun(theRun, true, false);
        }
        this.getRunPane().setRun(theRun);
    }

    public String getPluginTitle() {
        return "Edit Run Frame";
    }

    private RunPane getRunPane() {
        if (this.runPane == null) {
            this.runPane = new RunPane();
        }
        return this.runPane;
    }

    public class RunListenerImplementation
    implements IRunListener {
        public void runAdded(RunEvent event) {
        }

        public void refreshRuns(RunEvent event) {
        }

        public void runChanged(RunEvent event) {
            if (EditRunFrame.this.run != null && event.getRun().getElementId().equals(EditRunFrame.this.run.getElementId())) {
                if (event.getAction().equals((Object)RunEvent.Action.RUN_NOT_AVAILABLE)) {
                    EditRunFrame.this.getRunPane().showMessage("Run " + EditRunFrame.this.run.getNumber() + " not available ");
                } else {
                    EditRunFrame.this.getRunPane().setRunAndFiles(event.getRun(), event.getRunFiles());
                }
            }
        }

        public void runRemoved(RunEvent event) {
        }
    }
}

