/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JudgementPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class EditJudgementFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -6248957592340866836L;
    private IInternalContest contest;
    private IInternalController controller;
    private JudgementPane judgementPane = null;

    public EditJudgementFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(431, 176));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getJudgementPane());
        this.setTitle("Edit Judgement");
        FrameUtilities.centerFrame(this);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getJudgementPane().setParentFrame(this);
        this.getJudgementPane().setContestAndController(this.contest, this.controller);
    }

    public void setJudgement(Judgement judgement) {
        if (judgement == null) {
            this.setTitle("Add New Judgement");
        } else {
            this.setTitle("Edit Judgement " + judgement.getDisplayName());
        }
        this.getJudgementPane().setJudgement(judgement);
    }

    public String getPluginTitle() {
        return "Edit Judgement Frame";
    }

    private JudgementPane getJudgementPane() {
        if (this.judgementPane == null) {
            this.judgementPane = new JudgementPane();
        }
        return this.judgementPane;
    }

    public void setDeleteCheckBoxEnabled(boolean enabled) {
        this.getJudgementPane().setDeleteCheckBoxEnabled(enabled);
    }
}

