/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.DisplayTeamName;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.FilterReport;
import edu.csus.ecs.pc2.ui.EditFilterPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class EditFilterFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 6498270977601785261L;
    private JPanel mainPane = null;
    private JPanel buttonPane = null;
    private JButton applyButton = null;
    private JButton closeButton = null;
    private EditFilterPane editFilterPane = null;
    private Filter filter = new Filter();
    private IInternalContest contest;
    private IInternalController controller;
    private Runnable refreshCallback = null;
    private JButton okButton = null;
    private JButton reportButton = null;

    public EditFilterFrame() {
        this.initialize();
    }

    public EditFilterFrame(Filter filter, String title, Runnable refreshCallback) {
        this.initialize();
        this.filter = filter;
        this.setTitle(title);
        this.refreshCallback = refreshCallback;
    }

    private void initialize() {
        this.setSize(new Dimension(784, 313));
        this.setTitle("Edit Filter");
        this.setContentPane(this.getMainPane());
        FrameUtilities.centerFrame(this);
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.add((Component)this.getButtonPane(), "South");
            this.mainPane.add((Component)this.getEditFilterPane(), "Center");
        }
        return this.mainPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getOkButton(), null);
            this.buttonPane.add((Component)this.getApplyButton(), null);
            this.buttonPane.add((Component)this.getReportButton(), null);
            this.buttonPane.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton();
            this.applyButton.setText("Apply");
            this.applyButton.setToolTipText("Apply this filter to listbox");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditFilterFrame.this.updateFilter(EditFilterFrame.this.editFilterPane.getFilter());
                }
            });
        }
        return this.applyButton;
    }

    protected void updateFilter(Filter filter2) {
        if (this.refreshCallback != null) {
            this.refreshCallback.run();
        } else {
            System.err.println("Warning: no callback set, no refresh of list based on this filter");
        }
    }

    protected void dumpFilter(Filter filter2) {
        try {
            System.out.println("dumpFilter " + filter2);
            System.out.flush();
            FilterReport filterReport = new FilterReport();
            filterReport.setContestAndController(this.contest, this.controller);
            PrintWriter printWriter = new PrintWriter(System.out);
            filterReport.writeReportDetailed(printWriter, filter2);
            printWriter.flush();
            printWriter = null;
            System.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setToolTipText("Close this window");
            this.closeButton.setMnemonic(67);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditFilterFrame.this.checkForChangesAndExit();
                }
            });
        }
        return this.closeButton;
    }

    protected void checkForChangesAndExit() {
        this.setVisible(false);
    }

    private EditFilterPane getEditFilterPane() {
        if (this.editFilterPane == null) {
            this.editFilterPane = new EditFilterPane();
            this.editFilterPane.setParentFrame(this);
        }
        return this.editFilterPane;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.editFilterPane.setContestAndController(inContest, inController);
        this.editFilterPane.setFilter(this.filter);
        this.getReportButton().setVisible(Utilities.isDebugMode());
    }

    public String getPluginTitle() {
        return "Edit Filter Frame";
    }

    public void setRefreshCallback(Runnable refreshCallback) {
        this.refreshCallback = refreshCallback;
    }

    public void setFilter(Filter filter2) {
        this.getEditFilterPane().setFilter(filter2);
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditFilterFrame.this.updateFilter(EditFilterFrame.this.editFilterPane.getFilter());
                    EditFilterFrame.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    public void addList(EditFilterPane.ListNames listName) {
        this.editFilterPane.addList(listName);
    }

    public void setDisplayTeamName(DisplayTeamName displayTeamName) {
        this.editFilterPane.setDisplayTeamName(displayTeamName);
    }

    public void setFilteringClarifications(boolean filteringClarifications) {
        this.editFilterPane.setFilteringClarifications(filteringClarifications);
    }

    private JButton getReportButton() {
        if (this.reportButton == null) {
            this.reportButton = new JButton();
            this.reportButton.setText("Report");
            this.reportButton.setMnemonic(82);
            this.reportButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditFilterFrame.this.showReport();
                }
            });
        }
        return this.reportButton;
    }

    protected void showReport() {
        FilterReport report = new FilterReport();
        report.setFilter(this.getEditFilterPane().getFilter());
        Utilities.viewReport(report, "Edit Filter Report", this.contest, this.controller);
    }
}

