/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.ContestTimePane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class EditContestTimeFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 3570106747020180994L;
    private IInternalContest contest;
    private IInternalController controller;
    private ContestTimePane contestTimePane = null;

    public EditContestTimeFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(549, 278));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getContestTimePane());
        this.setTitle("New Contest Time");
        FrameUtilities.centerFrame(this);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getContestTimePane().setContestAndController(this.contest, this.controller);
        this.getContestTimePane().setParentFrame(this);
    }

    public void setContestTime(ContestTime contestTime) {
        if (contestTime == null) {
            this.setTitle("Add New Contest Time");
        } else {
            this.setTitle("Edit Contest Time for Site " + contestTime.getSiteNumber());
        }
        this.getContestTimePane().setContestTime(contestTime);
    }

    public String getPluginTitle() {
        return "Edit ContestTime Frame";
    }

    private ContestTimePane getContestTimePane() {
        if (this.contestTimePane == null) {
            this.contestTimePane = new ContestTimePane();
        }
        return this.contestTimePane;
    }
}

