/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ContestTimePane
extends JPanePlugin {
    private static final long serialVersionUID = -1060536964672397704L;
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private ContestTime contestTime = null;
    private boolean populatingGUI = true;
    private JPanel centerPane = null;
    private JLabel remaingingTimeLabel = null;
    private JTextField remainingTimeTextBox = null;
    private JLabel elapsedTimeLabel = null;
    private JTextField elapsedTimeTextBox = null;
    private JLabel contestLengthLabel = null;
    private JTextField contestLengthTextBox = null;
    private JCheckBox stopAtEndofContestCheckBox = null;

    public ContestTimePane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(418, 243));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getCenterPane(), "Center");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.addWindowCloserListener();
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ContestTimePane.this.getParentFrame() != null) {
                    ContestTimePane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            ContestTimePane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    public String getPluginTitle() {
        return "Edit ContestTime Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.contestTime != null) {
            try {
                ContestTime changedContestTime = this.getContestTimeFromFields(null);
                enableButton |= this.contestTime.isHaltContestAtTimeZero() == changedContestTime.isHaltContestAtTimeZero();
                enableButton |= this.contestTime.getElapsedTimeStr().equals(changedContestTime.getElapsedTimeStr());
                enableButton |= this.contestTime.getContestLengthStr().equals(changedContestTime.getContestLengthStr());
                enableButton |= this.contestTime.getRemainingTimeStr().equals(changedContestTime.getRemainingTimeStr());
            }
            catch (InvalidFieldValue e) {
                StaticLog.getLog().log(Log.DEBUG, "Input ContestTime (but not saving) ", e);
                enableButton = true;
            }
        }
        this.enableUpdateButtons(enableButton);
    }

    public ContestTime getContestTimeFromFields(ContestTime checkContestTime) throws InvalidFieldValue {
        long secs = this.stringToLongSecs(this.getElapsedTimeTextBox().getText());
        if (secs == -1L) {
            throw new InvalidFieldValue("Invalid elapsed time");
        }
        long elapsedTime = secs;
        secs = this.stringToLongSecs(this.getRemainingTimeTextBox().getText());
        if (secs == -1L) {
            throw new InvalidFieldValue("Invalid remaining time");
        }
        long remainingTime = secs;
        secs = this.stringToLongSecs(this.getContestLengthTextBox().getText());
        if (secs == -1L) {
            throw new InvalidFieldValue("Invalid contest length");
        }
        long contestLength = secs;
        long actualRemaining = contestLength - elapsedTime;
        if (actualRemaining != remainingTime) {
            throw new InvalidFieldValue("Invalid contest times, set remaining to " + ContestTime.formatTime(actualRemaining));
        }
        if (checkContestTime == null) {
            checkContestTime = new ContestTime(0);
        }
        checkContestTime.setContestLengthSecs(contestLength);
        checkContestTime.setRemainingSecs(remainingTime);
        return checkContestTime;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestTimePane.this.updateContestTime();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateContestTime() {
        if (!this.validateContestTimeFields()) {
            return;
        }
        ContestTime newContestTime = null;
        try {
            newContestTime = this.getContestTimeFromFields(this.contestTime);
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        this.getController().updateContestTime(newContestTime);
        this.cancelButton.setText("Close");
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private boolean validateContestTimeFields() {
        long secs = this.stringToLongSecs(this.getElapsedTimeTextBox().getText());
        if (secs == -1L) {
            this.showMessage("Invalid elapsed time");
            return false;
        }
        secs = this.stringToLongSecs(this.getRemainingTimeTextBox().getText());
        if (secs == -1L) {
            this.showMessage("Invalid remaining time");
            return false;
        }
        secs = this.stringToLongSecs(this.getContestLengthTextBox().getText());
        if (secs == -1L) {
            this.showMessage("Invalid contest length");
            return false;
        }
        return true;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestTimePane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "ContestTime modified, save changes?", "Confirm Choice");
            if (result == 0) {
                this.updateContestTime();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    public ContestTime getContestTime() {
        return this.contestTime;
    }

    public void setContestTime(final ContestTime contestTime) {
        this.contestTime = contestTime;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ContestTimePane.this.populateGUI(contestTime);
                ContestTimePane.this.enableUpdateButtons(false);
                ContestTimePane.this.showMessage("");
            }
        });
    }

    private void populateGUI(ContestTime inContestTime) {
        this.populatingGUI = true;
        this.getRemainingTimeTextBox().setText(inContestTime.getRemainingTimeStr());
        this.getElapsedTimeTextBox().setText(inContestTime.getElapsedTimeStr());
        this.getContestLengthTextBox().setText(inContestTime.getContestLengthStr());
        this.getUpdateButton().setVisible(true);
        this.enableUpdateButtons(false);
        this.populatingGUI = false;
    }

    protected void enableUpdateButtons(boolean fieldsChanged) {
        if (fieldsChanged) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        this.updateButton.setEnabled(fieldsChanged);
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ContestTimePane.this.messageLabel.setText(message);
            }
        });
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.contestLengthLabel = new JLabel();
            this.contestLengthLabel.setBounds(new Rectangle(60, 103, 110, 23));
            this.contestLengthLabel.setHorizontalAlignment(4);
            this.contestLengthLabel.setText("Contest Length");
            this.elapsedTimeLabel = new JLabel();
            this.elapsedTimeLabel.setBounds(new Rectangle(60, 60, 110, 23));
            this.elapsedTimeLabel.setHorizontalAlignment(4);
            this.elapsedTimeLabel.setText("Elapsed Time");
            this.remaingingTimeLabel = new JLabel();
            this.remaingingTimeLabel.setBounds(new Rectangle(60, 17, 110, 23));
            this.remaingingTimeLabel.setHorizontalAlignment(4);
            this.remaingingTimeLabel.setText("Remaining Time");
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.add((Component)this.remaingingTimeLabel, null);
            this.centerPane.add((Component)this.getRemainingTimeTextBox(), null);
            this.centerPane.add((Component)this.elapsedTimeLabel, null);
            this.centerPane.add((Component)this.getElapsedTimeTextBox(), null);
            this.centerPane.add((Component)this.contestLengthLabel, null);
            this.centerPane.add((Component)this.getContestLengthTextBox(), null);
            this.centerPane.add((Component)this.getStopAtEndofContestCheckBox(), null);
        }
        return this.centerPane;
    }

    private JTextField getRemainingTimeTextBox() {
        if (this.remainingTimeTextBox == null) {
            this.remainingTimeTextBox = new JTextField();
            this.remainingTimeTextBox.setBounds(new Rectangle(191, 14, 115, 29));
            this.remainingTimeTextBox.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ContestTimePane.this.enableUpdateButton();
                }
            });
        }
        return this.remainingTimeTextBox;
    }

    private JTextField getElapsedTimeTextBox() {
        if (this.elapsedTimeTextBox == null) {
            this.elapsedTimeTextBox = new JTextField();
            this.elapsedTimeTextBox.setBounds(new Rectangle(191, 57, 115, 29));
            this.elapsedTimeTextBox.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ContestTimePane.this.enableUpdateButton();
                }
            });
        }
        return this.elapsedTimeTextBox;
    }

    private JTextField getContestLengthTextBox() {
        if (this.contestLengthTextBox == null) {
            this.contestLengthTextBox = new JTextField();
            this.contestLengthTextBox.setBounds(new Rectangle(191, 100, 115, 29));
            this.contestLengthTextBox.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    ContestTimePane.this.enableUpdateButton();
                }
            });
        }
        return this.contestLengthTextBox;
    }

    private JCheckBox getStopAtEndofContestCheckBox() {
        if (this.stopAtEndofContestCheckBox == null) {
            this.stopAtEndofContestCheckBox = new JCheckBox();
            this.stopAtEndofContestCheckBox.setBounds(new Rectangle(194, 143, 202, 21));
            this.stopAtEndofContestCheckBox.setText("Stop Clock at end of contest");
            this.stopAtEndofContestCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ContestTimePane.this.enableUpdateButton();
                }
            });
        }
        return this.stopAtEndofContestCheckBox;
    }

    public long stringToLongSecs(String s) {
        if (s == null || s.trim().length() == 0) {
            return -1L;
        }
        String[] fields = s.split(":");
        long hh = 0L;
        long mm = 0L;
        long ss = 0L;
        switch (fields.length) {
            case 3: {
                hh = this.stringToLong(fields[0]);
                mm = this.stringToLong(fields[1]);
                ss = this.stringToLong(fields[2]);
                break;
            }
            case 2: {
                mm = this.stringToLong(fields[0]);
                ss = this.stringToLong(fields[1]);
                break;
            }
            case 1: {
                ss = this.stringToLong(fields[0]);
                break;
            }
        }
        long totsecs = 0L;
        if (hh != -1L) {
            totsecs = hh;
        }
        if (mm != -1L) {
            totsecs = totsecs * 60L + mm;
        }
        if (ss != -1L) {
            totsecs = totsecs * 60L + ss;
        }
        if (hh == -1L || mm == -1L || ss == -1L) {
            return -1L;
        }
        return totsecs;
    }

    private long stringToLong(String s1) {
        if (s1 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s1);
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

