/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.ui.ContestClockDisplay;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ContestClockPane
extends JPanePlugin {
    private static final long serialVersionUID = -5750318173412410396L;
    private JPanel buttonPane = null;
    private JPanel messagePane = null;
    private JPanel centerPane = null;
    private JLabel siteNameLabel = null;
    private JLabel clockLabel = null;
    private JLabel messageLabel = null;
    private JComboBox siteSelectComboBox = null;
    private Log log;
    private int currentSiteNumber;
    private ContestClockDisplay contestClockDisplay = null;

    public ContestClockPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(446, 221));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getCenterPane(), "Center");
    }

    public String getPluginTitle() {
        return "Contest Clock Pane";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.add((Component)this.getSiteSelectComboBox(), null);
        }
        return this.buttonPane;
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("JLabel");
            this.messagePane = new JPanel();
            this.messagePane.add((Component)this.messageLabel, null);
        }
        return this.messagePane;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            this.clockLabel = new JLabel();
            this.clockLabel.setText("XX:XX:XX");
            this.clockLabel.setFont(new Font("Dialog", 1, 72));
            this.clockLabel.setHorizontalAlignment(0);
            this.siteNameLabel = new JLabel();
            this.siteNameLabel.setText("Site XXX YYYY ZZZZ");
            this.siteNameLabel.setFont(new Font("Dialog", 1, 24));
            this.siteNameLabel.setHorizontalAlignment(0);
            this.centerPane = new JPanel();
            this.centerPane.setLayout(gridLayout);
            this.centerPane.add((Component)this.clockLabel, null);
            this.centerPane.add((Component)this.siteNameLabel, null);
        }
        return this.centerPane;
    }

    private JComboBox getSiteSelectComboBox() {
        if (this.siteSelectComboBox == null) {
            this.siteSelectComboBox = new JComboBox();
            this.siteSelectComboBox.setPreferredSize(new Dimension(300, 25));
            this.siteSelectComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ContestClockPane.this.updateSiteLabelAndTime();
                }
            });
        }
        return this.siteSelectComboBox;
    }

    protected void updateSiteLabelAndTime() {
        int pickedSiteNumber = this.getSiteSelectComboBox().getSelectedIndex();
        this.showMessage("");
        if (pickedSiteNumber > -1) {
            ContestTime contestTime = this.getContest().getContestTime(++pickedSiteNumber);
            if (contestTime != null) {
                this.updateSiteLabelAndTime(pickedSiteNumber);
            } else {
                this.showMessage("Site " + pickedSiteNumber + " time not available");
            }
        }
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        boolean isTeam = this.getContest().getClientId().getClientType().equals((Object)ClientType.Type.TEAM);
        this.contestClockDisplay = new ContestClockDisplay(this.log, this.getContest().getContestTime(), this.getContest().getSiteNumber(), isTeam, null);
        this.contestClockDisplay.setContestAndController(inContest, inController);
        this.showMessage("");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ContestClockPane.this.populateGUI();
            }
        });
    }

    private void populateGUI() {
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        this.getSiteSelectComboBox().removeAllItems();
        for (Site site : sites) {
            this.getSiteSelectComboBox().addItem("Site " + site.getSiteNumber());
        }
        this.getSiteSelectComboBox().setSelectedIndex(this.getContest().getSiteNumber() - 1);
        int siteNumber = this.getContest().getSiteNumber();
        this.updateSiteLabelAndTime(siteNumber);
    }

    private void updateSiteLabelAndTime(int siteNumber) {
        this.siteNameLabel.setText("Site " + siteNumber);
        if (this.currentSiteNumber == 0) {
            this.contestClockDisplay.addLabeltoUpdateList(this.clockLabel, ContestClockDisplay.DisplayTimes.REMAINING_TIME, siteNumber);
            this.currentSiteNumber = siteNumber;
        } else if (siteNumber != this.currentSiteNumber) {
            this.contestClockDisplay.removeLabelFromUpdateList(this.clockLabel, this.currentSiteNumber);
            this.contestClockDisplay.addLabeltoUpdateList(this.clockLabel, ContestClockDisplay.DisplayTimes.REMAINING_TIME, siteNumber);
            this.currentSiteNumber = siteNumber;
        }
        ContestTime contestTime = this.getContest().getContestTime(this.currentSiteNumber);
        if (contestTime != null) {
            this.contestClockDisplay.fireClockStateChange(contestTime);
        }
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ContestClockPane.this.messageLabel.setText(string);
                ContestClockPane.this.messageLabel.setToolTipText(string);
            }
        });
    }

    public void hideButtonPane() {
        this.getButtonPane().setVisible(false);
    }

    public void setClientFrame(JFrame frame) {
        this.contestClockDisplay.setClientFrame(frame);
    }
}

