/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.HeapSorter;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ConnectionEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IConnectionListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ConnectionsPane
extends JPanePlugin {
    private static final long serialVersionUID = -5590899142044283529L;
    private JPanel loginButtonPane = null;
    private MCLB connectionsListBox = null;
    private JButton disconnectButton = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private Log log = null;
    private PermissionList permissionList = new PermissionList();

    public ConnectionsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(536, 217));
        this.add((Component)this.getConnectionButtonPanel(), "South");
        this.add((Component)((Object)this.getConnectionsListBox()), "Center");
        this.add((Component)this.getMessagePane(), "North");
    }

    public String getPluginTitle() {
        return "Connections Panel";
    }

    private JPanel getConnectionButtonPanel() {
        if (this.loginButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            flowLayout.setVgap(5);
            this.loginButtonPane = new JPanel();
            this.loginButtonPane.setLayout(flowLayout);
            this.loginButtonPane.setPreferredSize(new Dimension(35, 35));
            this.loginButtonPane.add((Component)this.getDisconnectButton(), null);
        }
        return this.loginButtonPane;
    }

    private MCLB getConnectionsListBox() {
        if (this.connectionsListBox == null) {
            this.connectionsListBox = new MCLB();
            this.connectionsListBox.setMultipleSelections(true);
            Object[] cols = new Object[]{"Connection"};
            this.connectionsListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            this.connectionsListBox.setColumnSorter(0, sorter, 1);
            this.connectionsListBox.autoSizeAllColumns();
        }
        return this.connectionsListBox;
    }

    private Object[] buildConnectionRow(ConnectionHandlerID connectionHandlerID) {
        Object[] obj = new Object[this.connectionsListBox.getColumnCount()];
        obj[0] = connectionHandlerID.toString();
        return obj;
    }

    private void reloadListBox() {
        ConnectionHandlerID[] connectionHandlerIDs;
        this.connectionsListBox.removeAllRows();
        for (ConnectionHandlerID connectionHandlerID : connectionHandlerIDs = this.getContest().getConnectionHandleIDs()) {
            this.updateConnectionRow(connectionHandlerID);
        }
    }

    private void updateConnectionRow(final ConnectionHandlerID connectionHandlerID) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row = ConnectionsPane.this.connectionsListBox.getIndexByKey(connectionHandlerID);
                if (row == -1) {
                    Object[] objects = ConnectionsPane.this.buildConnectionRow(connectionHandlerID);
                    ConnectionsPane.this.connectionsListBox.addRow(objects, connectionHandlerID);
                } else {
                    Object[] objects = ConnectionsPane.this.buildConnectionRow(connectionHandlerID);
                    ConnectionsPane.this.connectionsListBox.replaceRow(objects, row);
                }
                ConnectionsPane.this.connectionsListBox.autoSizeAllColumns();
            }
        });
    }

    private void removeConnectionRow(final ConnectionHandlerID connectionHandlerID) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row = ConnectionsPane.this.connectionsListBox.getIndexByKey(connectionHandlerID);
                if (row != -1) {
                    ConnectionsPane.this.connectionsListBox.removeRow(row);
                }
                ConnectionsPane.this.connectionsListBox.autoSizeAllColumns();
            }
        });
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.connectionsListBox.setVisible(this.isAllowed(Permission.Type.FORCE_LOGOFF_CLIENT));
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addConnectionListener(new ConnectionListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.log = this.getController().getLog();
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectionsPane.this.updateGUIperPermissions();
                ConnectionsPane.this.reloadListBox();
            }
        });
    }

    protected void undoEdit() {
        this.reloadListBox();
    }

    private JButton getDisconnectButton() {
        if (this.disconnectButton == null) {
            this.disconnectButton = new JButton();
            this.disconnectButton.setText("Disconnect");
            this.disconnectButton.setToolTipText("Disconnect the selected connection");
            this.disconnectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConnectionsPane.this.logoffConnection();
                }
            });
        }
        return this.disconnectButton;
    }

    protected void logoffConnection() {
        int[] selectedIndex = this.connectionsListBox.getSelectedIndexes();
        if (selectedIndex.length == 0) {
            this.showMessage("Please select a connection");
            return;
        }
        int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Disconnect " + selectedIndex.length + " connections?", "Confirm Disconnect");
        if (result == 0) {
            for (int i : selectedIndex) {
                ConnectionHandlerID connectionHandlerID = (ConnectionHandlerID)this.connectionsListBox.getKeys()[i];
                if (connectionHandlerID == null) continue;
                try {
                    this.getController().forceConnectionDrop(connectionHandlerID);
                }
                catch (Exception e) {
                    this.log.log(Log.WARNING, "Unable to disconnect connection " + connectionHandlerID, e);
                    this.showMessage("Connection may not be dropped: " + connectionHandlerID + " check log");
                }
            }
        }
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectionsPane.this.messageLabel.setText(string);
            }
        });
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.setText("");
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (ConnectionsPane.this.getContest().getClientId().equals(account.getClientId())) {
                ConnectionsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ConnectionsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                if (!ConnectionsPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                ConnectionsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ConnectionsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            ConnectionsPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConnectionsPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    public class ConnectionListenerImplementation
    implements IConnectionListener {
        public void connectionEstablished(ConnectionEvent event) {
            ConnectionsPane.this.updateConnectionRow(event.getConnectionHandlerID());
        }

        public void connectionDropped(ConnectionEvent event) {
            ConnectionsPane.this.removeConnectionRow(event.getConnectionHandlerID());
        }

        public void connectionRefreshAll(ConnectionEvent connectionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConnectionsPane.this.reloadListBox();
                }
            });
        }
    }
}

