/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class ChangePasswordPane
extends JPanePlugin {
    private static final long serialVersionUID = 8687088072866264762L;
    private JPanel buttonPane = null;
    private JButton cancelButton = null;
    private JPanel mainPane = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private JLabel currentPasswordLabel = null;
    private JPasswordField currentPasswordField = null;
    private JLabel newPasswordLabel = null;
    private JPasswordField newPasswordField = null;
    private JLabel confirmPasswordLabel = null;
    private JPasswordField confirmPasswordField = null;
    private JPanel eastPanel = null;
    private JButton okButton = null;

    public ChangePasswordPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(595, 240));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMainPane(), "Center");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getEastPanel(), "East");
    }

    public String getPluginTitle() {
        return "Change Password UI";
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(50);
            this.buttonPane = new JPanel();
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getOkButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setPreferredSize(new Dimension(100, 26));
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChangePasswordPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    private void handleCancelButton() {
        this.clear();
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.setRows(3);
            gridLayout2.setHgap(10);
            gridLayout2.setVgap(15);
            gridLayout2.setColumns(2);
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(3);
            gridLayout1.setVgap(15);
            gridLayout1.setColumns(2);
            gridLayout1.setHgap(5);
            this.confirmPasswordLabel = new JLabel();
            this.confirmPasswordLabel.setText("Confirm New Password:");
            this.confirmPasswordLabel.setHorizontalAlignment(11);
            this.newPasswordLabel = new JLabel();
            this.newPasswordLabel.setText("New Password:");
            this.newPasswordLabel.setHorizontalAlignment(11);
            this.currentPasswordLabel = new JLabel();
            this.currentPasswordLabel.setText("Current Password:");
            this.currentPasswordLabel.setHorizontalAlignment(11);
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(3);
            gridLayout.setHgap(5);
            gridLayout.setVgap(20);
            gridLayout.setColumns(2);
            this.mainPane = new JPanel();
            this.mainPane.setLayout(gridLayout2);
            this.mainPane.add((Component)this.currentPasswordLabel, null);
            this.mainPane.add((Component)this.getCurrentPasswordField(), null);
            this.mainPane.add((Component)this.newPasswordLabel, null);
            this.mainPane.add((Component)this.getNewPasswordField(), null);
            this.mainPane.add((Component)this.confirmPasswordLabel, null);
            this.mainPane.add((Component)this.getConfirmPasswordField(), null);
        }
        return this.mainPane;
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(30, 30));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPasswordField getCurrentPasswordField() {
        if (this.currentPasswordField == null) {
            this.currentPasswordField = new JPasswordField();
            this.currentPasswordField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ChangePasswordPane.this.enableOk();
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ChangePasswordPane.this.newPasswordField.requestFocus();
                    }
                }
            });
        }
        return this.currentPasswordField;
    }

    protected void enableOk() {
        this.getOkButton().setEnabled(!this.isEmpty(this.getCurrentPasswordField()) || !this.isEmpty(this.getNewPasswordField()) || !this.isEmpty(this.getConfirmPasswordField()));
    }

    private boolean isEmpty(JPasswordField field) {
        return field.getPassword().length == 0;
    }

    private JPasswordField getNewPasswordField() {
        if (this.newPasswordField == null) {
            this.newPasswordField = new JPasswordField();
            this.newPasswordField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ChangePasswordPane.this.enableOk();
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ChangePasswordPane.this.confirmPasswordField.requestFocus();
                    }
                }
            });
        }
        return this.newPasswordField;
    }

    private JPasswordField getConfirmPasswordField() {
        if (this.confirmPasswordField == null) {
            this.confirmPasswordField = new JPasswordField();
            this.confirmPasswordField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    ChangePasswordPane.this.enableOk();
                    if (e.getKeyCode() == 10 && ChangePasswordPane.this.getOkButton().isEnabled()) {
                        ChangePasswordPane.this.handleOkButton();
                    }
                }
            });
        }
        return this.confirmPasswordField;
    }

    private JPanel getEastPanel() {
        if (this.eastPanel == null) {
            this.eastPanel = new JPanel();
        }
        return this.eastPanel;
    }

    public void clear() {
        this.getCurrentPasswordField().setText("");
        this.getNewPasswordField().setText("");
        this.getConfirmPasswordField().setText("");
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.setEnabled(false);
            this.okButton.setPreferredSize(new Dimension(100, 26));
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChangePasswordPane.this.handleOkButton();
                }
            });
        }
        return this.okButton;
    }

    protected void handleOkButton() {
        if (this.isEmpty(this.getCurrentPasswordField())) {
            FrameUtilities.showMessage(this.getParentFrame(), "Password cannot be set", "You must supply your current password.");
            return;
        }
        if (!Utilities.isEquals(this.getNewPasswordField().getPassword(), this.getConfirmPasswordField().getPassword())) {
            FrameUtilities.showMessage(this.getParentFrame(), "Password cannot be set", "Passwords do not match.");
            return;
        }
        if (this.isEmpty(this.getNewPasswordField()) || this.isEmpty(this.getConfirmPasswordField())) {
            FrameUtilities.showMessage(this.getParentFrame(), "Password cannot be set", "Passwords cannot be blank.");
            return;
        }
        this.getController().requestChangePassword(String.valueOf(this.getCurrentPasswordField().getPassword()), String.valueOf(this.getNewPasswordField().getPassword()));
        this.handleCancelButton();
    }
}

