/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.BalloonSettingsEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.EditBalloonSettingsFrame;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BalloonSettingsPane
extends JPanePlugin {
    private static final long serialVersionUID = -7483784815760107250L;
    private JPanel balloonSettingsButtonPane = null;
    private MCLB balloonSettingsListBox = null;
    private JButton addButton = null;
    private JButton editButton = null;
    private JPanel messagePanel = null;
    private JLabel messageLabel = null;
    private Log log = null;
    private EditBalloonSettingsFrame editBalloonSettingsFrame = null;
    private JButton copyButton = null;
    private PermissionList permissionList = new PermissionList();

    public BalloonSettingsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(564, 229));
        this.add((Component)this.getMessagePanel(), "North");
        this.add((Component)((Object)this.getBalloonSettingsListBox()), "Center");
        this.add((Component)this.getBalloonSettingsButtonPane(), "South");
        this.editBalloonSettingsFrame = new EditBalloonSettingsFrame();
    }

    public String getPluginTitle() {
        return "BalloonSettingss Pane";
    }

    private JPanel getBalloonSettingsButtonPane() {
        if (this.balloonSettingsButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.balloonSettingsButtonPane = new JPanel();
            this.balloonSettingsButtonPane.setLayout(flowLayout);
            this.balloonSettingsButtonPane.setPreferredSize(new Dimension(35, 35));
            this.balloonSettingsButtonPane.add((Component)this.getAddButton(), null);
            this.balloonSettingsButtonPane.add((Component)this.getCopyButton(), null);
            this.balloonSettingsButtonPane.add((Component)this.getEditButton(), null);
        }
        return this.balloonSettingsButtonPane;
    }

    private MCLB getBalloonSettingsListBox() {
        if (this.balloonSettingsListBox == null) {
            this.balloonSettingsListBox = new MCLB();
            Object[] cols = new Object[]{"Site", "Print", "E-mail", "Printer", "Send To", "Mail Server", "Balloon Client"};
            this.balloonSettingsListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            this.balloonSettingsListBox.setColumnSorter(0, sorter, 1);
            this.balloonSettingsListBox.setColumnSorter(1, sorter, 2);
            this.balloonSettingsListBox.setColumnSorter(2, sorter, 3);
            this.balloonSettingsListBox.setColumnSorter(3, sorter, 4);
            this.balloonSettingsListBox.setColumnSorter(4, sorter, 4);
            this.balloonSettingsListBox.setColumnSorter(5, sorter, 6);
            this.balloonSettingsListBox.setColumnSorter(6, sorter, 7);
            this.balloonSettingsListBox.autoSizeAllColumns();
        }
        return this.balloonSettingsListBox;
    }

    public void updateBalloonSettingRow(final BalloonSettings balloonSettings) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objects = BalloonSettingsPane.this.buildBalloonSettingsRow(balloonSettings);
                int rowNumber = BalloonSettingsPane.this.balloonSettingsListBox.getIndexByKey(balloonSettings.getElementId());
                if (rowNumber == -1) {
                    BalloonSettingsPane.this.balloonSettingsListBox.addRow(objects, balloonSettings.getElementId());
                } else {
                    BalloonSettingsPane.this.balloonSettingsListBox.replaceRow(objects, rowNumber);
                }
                BalloonSettingsPane.this.balloonSettingsListBox.autoSizeAllColumns();
                BalloonSettingsPane.this.balloonSettingsListBox.sort();
            }
        });
    }

    private String yesNoString(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    protected Object[] buildBalloonSettingsRow(BalloonSettings balloonSettings) {
        int numberColumns = this.balloonSettingsListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = "Site " + balloonSettings.getSiteNumber();
        c[1] = this.yesNoString(balloonSettings.isPrintBalloons());
        c[2] = this.yesNoString(balloonSettings.isEmailBalloons());
        c[3] = balloonSettings.getPrintDevice();
        c[4] = balloonSettings.getEmailContact();
        c[5] = balloonSettings.getMailServer();
        c[6] = balloonSettings.getBalloonClient().toString();
        return c;
    }

    private void reloadListBox() {
        BalloonSettings[] balloonSettingsArray;
        this.balloonSettingsListBox.removeAllRows();
        for (BalloonSettings balloonSettings : balloonSettingsArray = this.getContest().getBalloonSettings()) {
            this.addBalloonSettingsRow(balloonSettings);
        }
    }

    private void addBalloonSettingsRow(BalloonSettings balloonSettings) {
        Object[] objects = this.buildBalloonSettingsRow(balloonSettings);
        this.balloonSettingsListBox.addRow(objects, balloonSettings.getElementId());
        this.balloonSettingsListBox.autoSizeAllColumns();
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.editBalloonSettingsFrame.setContestAndController(inContest, inController);
        this.getContest().addBalloonSettingsListener(new BalloonSettingsListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BalloonSettingsPane.this.updateGUIperPermissions();
                BalloonSettingsPane.this.reloadListBox();
            }
        });
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.addButton.setVisible(this.isAllowed(Permission.Type.ADD_NOTIFICATIONS));
        this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_NOTIFICATIONS));
        this.copyButton.setVisible(this.isAllowed(Permission.Type.EDIT_NOTIFICATIONS));
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setToolTipText("Add new notification settings for a site");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingsPane.this.addBalloonSettings();
                }
            });
        }
        return this.addButton;
    }

    public boolean isAllowed(Account account, Permission.Type perm) {
        if (account == null) {
            return false;
        }
        return account.getPermissionList().isAllowed(perm);
    }

    protected void addBalloonSettings() {
        Account[] accountArray;
        Vector<Account> accounts = this.getContest().getAccounts(ClientType.Type.SCOREBOARD);
        accounts.addAll(this.getContest().getAccounts(ClientType.Type.ADMINISTRATOR));
        accounts.addAll(this.getContest().getAccounts(ClientType.Type.JUDGE));
        accounts.addAll(this.getContest().getAccounts(ClientType.Type.SPECTATOR));
        boolean clientFound = false;
        for (Account account : accountArray = accounts.toArray(new Account[accounts.size()])) {
            if (!account.isAllowed(Permission.Type.BALLOON_EMAIL) && !account.isAllowed(Permission.Type.BALLOON_PRINT)) continue;
            clientFound = true;
            break;
        }
        if (clientFound) {
            this.editBalloonSettingsFrame.setBalloonSettings(null);
            this.editBalloonSettingsFrame.setVisible(true);
        } else {
            FrameUtilities.showMessage(this.getParentFrame(), "ERROR", "No accounts have permission to send a notification, have you created a scoreboard account?");
        }
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setToolTipText("Edit existing site settings");
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingsPane.this.editSelectedBalloonSettings();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedBalloonSettings() {
        int selectedIndex = this.balloonSettingsListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a notification setting to edit");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.balloonSettingsListBox.getKeys()[selectedIndex];
            BalloonSettings balloonSettingsToEdit = this.getContest().getBalloonSettings(elementId);
            this.editBalloonSettingsFrame.setBalloonSettings(balloonSettingsToEdit);
            this.editBalloonSettingsFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit notification settings, check log");
        }
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.setPreferredSize(new Dimension(25, 25));
            this.messagePanel.add((Component)this.messageLabel, "Center");
        }
        return this.messagePanel;
    }

    private void showMessage(final String string) {
        if (string.trim().length() == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(BalloonSettingsPane.this.getParentFrame(), string, "Warning", 2);
            }
        });
    }

    private JButton getCopyButton() {
        if (this.copyButton == null) {
            this.copyButton = new JButton();
            this.copyButton.setText("Copy");
            this.copyButton.setToolTipText("Copy settings from an existing site to a new site");
            this.copyButton.setActionCommand("Copy");
            this.copyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingsPane.this.copySelectedBalloonSettings();
                }
            });
        }
        return this.copyButton;
    }

    protected void copySelectedBalloonSettings() {
        int siteCount;
        int rowCount = this.balloonSettingsListBox.getRowCount();
        if (rowCount == (siteCount = this.getContest().getSites().length)) {
            this.showMessage("No available destination sites, please use edit instead.");
            return;
        }
        int selectedIndex = this.balloonSettingsListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a balloonSettings to copy");
            return;
        }
        try {
            this.balloonSettingsListBox.deselectAllRows();
            ElementId elementId = (ElementId)this.balloonSettingsListBox.getKeys()[selectedIndex];
            BalloonSettings sourceBalloonSettings = this.getContest().getBalloonSettings(elementId);
            Site newSite = this.promptForSite(sourceBalloonSettings.getSiteNumber());
            if (newSite == null) {
                this.showMessage("Copy Aborted.");
            } else {
                BalloonSettings balloonSettingsToEdit = sourceBalloonSettings.copy(newSite);
                this.getController().updateBalloonSettings(balloonSettingsToEdit);
                this.editBalloonSettingsFrame.setBalloonSettings(balloonSettingsToEdit);
                this.editBalloonSettingsFrame.setVisible(true);
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to clone notification settings, check log");
        }
    }

    private Site promptForSite(int siteNumber) {
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        Vector<Site> dest = new Vector<Site>();
        for (Site site : sites) {
            if (this.getContest().getBalloonSettings(site.getSiteNumber()) != null) continue;
            dest.add(site);
        }
        Site s = (Site)JOptionPane.showInputDialog(this, "Copying from site " + siteNumber + " to:\n", "Copy Destination Dialog", 3, null, dest.toArray(new Site[dest.size()]), null);
        return s;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
        }

        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (BalloonSettingsPane.this.getContest().getClientId().equals(account.getClientId())) {
                BalloonSettingsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BalloonSettingsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                if (!BalloonSettingsPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                BalloonSettingsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BalloonSettingsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            BalloonSettingsPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BalloonSettingsPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    private class BalloonSettingsListenerImplementation
    implements IBalloonSettingsListener {
        private BalloonSettingsListenerImplementation() {
        }

        public void balloonSettingsAdded(final BalloonSettingsEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BalloonSettingsPane.this.updateBalloonSettingRow(event.getBalloonSettings());
                }
            });
        }

        public void balloonSettingsChanged(final BalloonSettingsEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BalloonSettingsPane.this.updateBalloonSettingRow(event.getBalloonSettings());
                }
            });
        }

        public void balloonSettingsRemoved(BalloonSettingsEvent event) {
            BalloonSettingsPane.this.log.info("debug BalloonSettings REMOVED  " + event.getBalloonSettings());
        }

        public void balloonSettingsRefreshAll(BalloonSettingsEvent balloonSettingsEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BalloonSettingsPane.this.reloadListBox();
                }
            });
        }
    }
}

