/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IPropertyUpdater;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.PropertiesEditFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class BalloonSettingPane
extends JPanePlugin {
    private static final long serialVersionUID = -1060536964672397704L;
    private Site noneSelected = new Site("Select Site", 0);
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private BalloonSettings balloonSettings = null;
    private Log log = null;
    private boolean populatingGUI = true;
    private JPanel centerPane = null;
    private JCheckBox sendEmailNotificationsCheckBox = null;
    private JCheckBox printNotificationsCheckBox = null;
    private JLabel mailContactLabel = null;
    private JLabel jLabel = null;
    private JTextField emailContactTextBox = null;
    private JTextField emailServerTextBox = null;
    private JCheckBox postScriptEnabledCheckBox = null;
    private JTextField printDeviceTextBox = null;
    private JLabel printDeviceLabel = null;
    private JLabel siteLabel = null;
    private MCLB colorListBox = null;
    private JComboBox siteComboBox = null;
    private IInternalContest contest;
    private JLabel balloonClientLabel = null;
    private JComboBox balloonClientComboBox = null;
    private JButton advancedMailButton = null;
    private Properties savedMailProperties = null;
    private Properties changedMailProperties = null;
    private PropertiesEditFrame propertiesEditFrame;
    private JPanel westPanel = null;

    public BalloonSettingPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(610, 400));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getCenterPane(), "Center");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.contest = inContest;
        this.setMailProperties(null);
        this.log = this.getController().getLog();
        this.addWindowCloserListener();
    }

    public String getPluginTitle() {
        return "Edit BalloonSettings Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingPane.this.addBalloonSettings();
                }
            });
        }
        return this.addButton;
    }

    protected void addBalloonSettings() {
        if (!this.validateBalloonSettingsFields()) {
            return;
        }
        BalloonSettings newBalloonSettings = null;
        try {
            newBalloonSettings = this.getBalloonSettingsFromFields(null);
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        this.getController().addNewBalloonSettings(newBalloonSettings);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.dismissPropertiesEditFrame();
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BalloonSettingPane.this.getParentFrame() != null) {
                    BalloonSettingPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            BalloonSettingPane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    protected void enableUpdateButtons(boolean fieldsChanged) {
        if (fieldsChanged) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        if (this.getUpdateButton().isVisible()) {
            this.getUpdateButton().setEnabled(fieldsChanged);
        } else {
            this.getAddButton().setEnabled(fieldsChanged);
        }
    }

    public BalloonSettings getBalloonSettingsFromFields(BalloonSettings checkBalloonSettings) throws InvalidFieldValue {
        if (checkBalloonSettings == null) {
            if (this.getSiteComboBox().getSelectedIndex() == 0) {
                new InvalidFieldValue("Invalid site selected.");
            }
            Site site = (Site)this.getSiteComboBox().getSelectedItem();
            checkBalloonSettings = new BalloonSettings(site.getDisplayName(), site.getSiteNumber());
        }
        if (this.getBalloonClientComboBox().getSelectedIndex() == 0) {
            new InvalidFieldValue("Invalid notification user selected.");
        } else {
            checkBalloonSettings.setBalloonClient((ClientId)this.getBalloonClientComboBox().getSelectedItem());
        }
        checkBalloonSettings.setPrintBalloons(this.getPrintNotificationsCheckBox().isSelected());
        checkBalloonSettings.setEmailBalloons(this.getSendEmailNotificationsCheckBox().isSelected());
        if (checkBalloonSettings.isPrintBalloons()) {
            checkBalloonSettings.setPostscriptCapable(this.getPostScriptEnabledCheckBox().isSelected());
            checkBalloonSettings.setPrintDevice(this.getPrintDeviceTextBox().getText());
        }
        if (checkBalloonSettings.isEmailBalloons()) {
            checkBalloonSettings.setEmailContact(this.getEmailContactTextBox().getText());
            checkBalloonSettings.setMailServer(this.getEmailServerTextBox().getText());
        }
        for (int row = 0; row < this.getColorListBox().getRowCount(); ++row) {
            Object[] colValues = this.getColorListBox().getRow(row);
            try {
                Problem problem = (Problem)colValues[0];
                JTextField textField = (JTextField)colValues[1];
                String color = textField.getText();
                checkBalloonSettings.addColor(problem, color);
                continue;
            }
            catch (Exception e) {
                this.log.log(Log.WARNING, "Exception logged ", e);
            }
        }
        checkBalloonSettings.setMailProperties(this.changedMailProperties);
        return checkBalloonSettings;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingPane.this.updateBalloonSettings();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateBalloonSettings() {
        if (!this.validateBalloonSettingsFields()) {
            return;
        }
        BalloonSettings newBalloonSettings = null;
        try {
            newBalloonSettings = this.getBalloonSettingsFromFields(this.balloonSettings);
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        this.getController().updateBalloonSettings(newBalloonSettings);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.dismissPropertiesEditFrame();
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private boolean validateBalloonSettingsFields() {
        if (this.getSiteComboBox().getSelectedIndex() < 1) {
            this.showMessage("You must specify a site number");
            return false;
        }
        if (this.getBalloonClientComboBox().getSelectedIndex() < 1) {
            this.showMessage("You must specify a notification Client");
            return false;
        }
        if (this.getPrintNotificationsCheckBox().isSelected() && this.getPrintDeviceTextBox().getText().length() < 1) {
            this.showMessage("You must specify a print device");
            return false;
        }
        if (this.getSendEmailNotificationsCheckBox().isSelected()) {
            if (this.getEmailContactTextBox().getText().length() < 1) {
                this.showMessage("You must specify an email address/contact");
                return false;
            }
            if (this.getEmailServerTextBox().getText().length() < 1) {
                this.showMessage("You must specify a SMTP (e-mail) server");
                return false;
            }
        }
        return true;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Notification Settings modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isVisible()) {
                    this.addBalloonSettings();
                } else {
                    this.updateBalloonSettings();
                }
                this.dismissPropertiesEditFrame();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1) {
                this.dismissPropertiesEditFrame();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            }
        } else {
            this.dismissPropertiesEditFrame();
            if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        }
    }

    public BalloonSettings getBalloonSettings() {
        return this.balloonSettings;
    }

    public void setBalloonSettings(BalloonSettings inBalloonSettings) {
        this.balloonSettings = inBalloonSettings;
        this.savedMailProperties = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BalloonSettingPane.this.populateGUI(BalloonSettingPane.this.balloonSettings);
                BalloonSettingPane.this.setMailProperties(BalloonSettingPane.this.balloonSettings);
                BalloonSettingPane.this.enableUpdateButtons(false);
                BalloonSettingPane.this.showMessage("");
            }
        });
    }

    private void setMailProperties(BalloonSettings settings) {
        if (settings != null) {
            this.savedMailProperties = settings.getMailProperties();
        }
        if (this.savedMailProperties == null) {
            this.savedMailProperties = BalloonSettings.getDefaultMailProperties();
        }
        this.changedMailProperties = (Properties)this.savedMailProperties.clone();
    }

    private void populateGUI(BalloonSettings inBalloonSettings) {
        this.populatingGUI = true;
        if (inBalloonSettings == null) {
            this.getSendEmailNotificationsCheckBox().setSelected(false);
            this.getPrintNotificationsCheckBox().setSelected(false);
            this.getEmailContactTextBox().setText("");
            this.getEmailServerTextBox().setText("");
            this.getPrintDeviceTextBox().setText("");
            this.getPostScriptEnabledCheckBox().setSelected(false);
            this.getAddButton().setVisible(true);
            this.getAddButton().setEnabled(true);
            this.getUpdateButton().setVisible(false);
            this.populateSiteJCombo(0);
            this.populateBalloonClientCombo(null);
            this.getSiteComboBox().setEnabled(true);
        } else {
            this.populateSiteJCombo(this.balloonSettings.getSiteNumber());
            this.populateBalloonClientCombo(this.balloonSettings.getBalloonClient());
            this.getSiteComboBox().setEnabled(false);
            this.getSendEmailNotificationsCheckBox().setSelected(inBalloonSettings.isEmailBalloons());
            this.getPrintNotificationsCheckBox().setSelected(inBalloonSettings.isPrintBalloons());
            this.getEmailContactTextBox().setText(inBalloonSettings.getEmailContact());
            this.getEmailServerTextBox().setText(inBalloonSettings.getMailServer());
            this.getPrintDeviceTextBox().setText(inBalloonSettings.getPrintDevice());
            this.getPostScriptEnabledCheckBox().setSelected(inBalloonSettings.isPostscriptCapable());
            this.getAddButton().setVisible(false);
            this.getUpdateButton().setVisible(true);
        }
        this.setBalloonColors(inBalloonSettings);
        this.populatingGUI = false;
        this.enableButtons();
    }

    private void populateBalloonClientCombo(ClientId balloonClient) {
        Vector<Account> accounts = this.getContest().getAccounts(ClientType.Type.SCOREBOARD);
        accounts.addAll(this.getContest().getAccounts(ClientType.Type.ADMINISTRATOR));
        accounts.addAll(this.getContest().getAccounts(ClientType.Type.JUDGE));
        accounts.addAll(this.getContest().getAccounts(ClientType.Type.SPECTATOR));
        this.getBalloonClientComboBox().removeAllItems();
        this.getBalloonClientComboBox().addItem("Select User");
        if (accounts.size() > 0) {
            Account[] accountArray = accounts.toArray(new Account[accounts.size()]);
            Arrays.sort(accountArray, new AccountComparator());
            int found = 0;
            int count = 0;
            for (Account account : accountArray) {
                if (!account.isAllowed(Permission.Type.BALLOON_EMAIL) && !account.isAllowed(Permission.Type.BALLOON_PRINT)) continue;
                this.getBalloonClientComboBox().addItem(account.getClientId());
                ++count;
                if (balloonClient == null || !account.getClientId().equals(balloonClient)) continue;
                found = count;
            }
            if (balloonClient == null) {
                this.getBalloonClientComboBox().setSelectedIndex(0);
            } else {
                this.getBalloonClientComboBox().setSelectedIndex(found);
            }
        }
    }

    private void populateSiteJCombo(int siteNumber) {
        int siteIndex = 0;
        this.getSiteComboBox().removeAllItems();
        this.getSiteComboBox().addItem(this.noneSelected);
        int i = 1;
        Site[] sites = this.getContest().getSites();
        Arrays.sort(sites, new SiteComparatorBySiteNumber());
        for (Site site : sites) {
            if (siteNumber == 0 && this.contest.getBalloonSettings(site.getSiteNumber()) != null) continue;
            this.getSiteComboBox().addItem(site);
            if (siteNumber == site.getSiteNumber()) {
                siteIndex = i;
            }
            ++i;
        }
        this.getSiteComboBox().setSelectedIndex(siteIndex);
    }

    private void setBalloonColors(BalloonSettings inBalloonSettings) {
        this.getColorListBox().removeAllRows();
        for (Problem problem : this.getContest().getProblems()) {
            Object[] row = new Object[2];
            row[0] = problem;
            String color = "";
            if (inBalloonSettings != null) {
                color = inBalloonSettings.getColor(problem);
            }
            JTextField editField = new JTextField(color);
            editField.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    BalloonSettingPane.this.enableButtons();
                    BalloonSettingPane.this.getColorListBox().autoSizeAllColumns();
                }
            });
            editField.setMargin(new Insets(0, 1, 0, 0));
            row[1] = editField;
            this.getColorListBox().addRow(row);
        }
        this.getColorListBox().autoSizeAllColumns();
    }

    public void showMessage(final String message) {
        if (message.trim().length() == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(BalloonSettingPane.this.getParentFrame(), message, "Warning", 2);
            }
        });
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.balloonClientLabel = new JLabel();
            this.balloonClientLabel.setText("Balloon Client");
            this.balloonClientLabel.setBounds(new Rectangle(11, 280, 100, 16));
            this.siteLabel = new JLabel();
            this.siteLabel.setText("Site");
            this.siteLabel.setBounds(new Rectangle(14, 21, 48, 16));
            this.printDeviceLabel = new JLabel();
            this.printDeviceLabel.setText("Print Device");
            this.printDeviceLabel.setBounds(new Rectangle(41, 217, 112, 21));
            this.jLabel = new JLabel();
            this.jLabel.setText("EMail Server");
            this.jLabel.setBounds(new Rectangle(42, 114, 112, 21));
            this.mailContactLabel = new JLabel();
            this.mailContactLabel.setText("EMail Contact");
            this.mailContactLabel.setBounds(new Rectangle(41, 79, 112, 21));
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)this.getWestPanel(), "West");
            this.centerPane.add((Component)((Object)this.getColorListBox()), "Center");
        }
        return this.centerPane;
    }

    private JCheckBox getSendEmailNotificationsCheckBox() {
        if (this.sendEmailNotificationsCheckBox == null) {
            this.sendEmailNotificationsCheckBox = new JCheckBox();
            this.sendEmailNotificationsCheckBox.setText("Send Email Notifications");
            this.sendEmailNotificationsCheckBox.setBounds(new Rectangle(14, 47, 185, 21));
            this.sendEmailNotificationsCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingPane.this.enableButtons();
                }
            });
        }
        return this.sendEmailNotificationsCheckBox;
    }

    private void dismissPropertiesEditFrame() {
        if (this.propertiesEditFrame != null) {
            this.propertiesEditFrame.setVisible(false);
            this.propertiesEditFrame = null;
        }
    }

    protected void enableButtons() {
        if (this.populatingGUI) {
            return;
        }
        this.getEmailContactTextBox().setEnabled(this.getSendEmailNotificationsCheckBox().isSelected());
        this.getEmailServerTextBox().setEnabled(this.getSendEmailNotificationsCheckBox().isSelected());
        this.getPrintDeviceTextBox().setEnabled(this.getPrintNotificationsCheckBox().isSelected());
        this.getPostScriptEnabledCheckBox().setEnabled(this.getPrintNotificationsCheckBox().isSelected());
        boolean enableButton = false;
        if (this.balloonSettings != null) {
            try {
                BalloonSettings changedBalloonSettings = this.getBalloonSettingsFromFields(null);
                if (!this.balloonSettings.isSameAs(changedBalloonSettings)) {
                    enableButton = true;
                }
            }
            catch (InvalidFieldValue e) {
                StaticLog.getLog().log(Log.DEBUG, "Input Balloon Setting (but not saving) ", e);
                enableButton = true;
            }
        } else if (this.getAddButton().isVisible()) {
            if (this.getSiteComboBox().getSelectedIndex() > 0 || this.getBalloonClientComboBox().getSelectedIndex() > 0) {
                enableButton = true;
            }
            if (this.getPrintNotificationsCheckBox().isSelected() || this.getSendEmailNotificationsCheckBox().isSelected()) {
                enableButton = true;
            }
            for (int i = 0; i < this.getColorListBox().getRowCount(); ++i) {
                Object[] o = this.getColorListBox().getRow(i);
                JTextField colorTextField = (JTextField)o[1];
                String color = colorTextField.getText().trim();
                if (color.length() <= 0) continue;
                enableButton = true;
                break;
            }
        }
        this.enableUpdateButtons(enableButton);
    }

    private JCheckBox getPrintNotificationsCheckBox() {
        if (this.printNotificationsCheckBox == null) {
            this.printNotificationsCheckBox = new JCheckBox();
            this.printNotificationsCheckBox.setText("Print Notifications");
            this.printNotificationsCheckBox.setBounds(new Rectangle(13, 187, 162, 24));
            this.printNotificationsCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingPane.this.enableButtons();
                }
            });
        }
        return this.printNotificationsCheckBox;
    }

    private JTextField getEmailContactTextBox() {
        if (this.emailContactTextBox == null) {
            this.emailContactTextBox = new JTextField();
            this.emailContactTextBox.setBounds(new Rectangle(172, 79, 179, 21));
            this.emailContactTextBox.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    BalloonSettingPane.this.enableButtons();
                }
            });
        }
        return this.emailContactTextBox;
    }

    private JTextField getEmailServerTextBox() {
        if (this.emailServerTextBox == null) {
            this.emailServerTextBox = new JTextField();
            this.emailServerTextBox.setBounds(new Rectangle(172, 114, 179, 21));
            this.emailServerTextBox.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    BalloonSettingPane.this.changedMailProperties.put("mail.host", BalloonSettingPane.this.getEmailServerTextBox().getText());
                    BalloonSettingPane.this.enableButtons();
                }
            });
        }
        return this.emailServerTextBox;
    }

    private JCheckBox getPostScriptEnabledCheckBox() {
        if (this.postScriptEnabledCheckBox == null) {
            this.postScriptEnabledCheckBox = new JCheckBox();
            this.postScriptEnabledCheckBox.setText("PostScript enabled printer");
            this.postScriptEnabledCheckBox.setBounds(new Rectangle(39, 243, 212, 24));
            this.postScriptEnabledCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingPane.this.enableButtons();
                }
            });
        }
        return this.postScriptEnabledCheckBox;
    }

    private JTextField getPrintDeviceTextBox() {
        if (this.printDeviceTextBox == null) {
            this.printDeviceTextBox = new JTextField();
            this.printDeviceTextBox.setBounds(new Rectangle(171, 217, 179, 21));
            this.printDeviceTextBox.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    BalloonSettingPane.this.enableButtons();
                }
            });
        }
        return this.printDeviceTextBox;
    }

    private MCLB getColorListBox() {
        if (this.colorListBox == null) {
            this.colorListBox = new MCLB();
            Object[] cols = new String[]{"Problem", "Color"};
            this.colorListBox.addColumns(cols);
            this.colorListBox.autoSizeAllColumns();
        }
        return this.colorListBox;
    }

    private JComboBox getSiteComboBox() {
        if (this.siteComboBox == null) {
            this.siteComboBox = new JComboBox();
            this.siteComboBox.setBounds(new Rectangle(85, 17, 254, 25));
            this.siteComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingPane.this.enableButtons();
                }
            });
        }
        return this.siteComboBox;
    }

    private JComboBox getBalloonClientComboBox() {
        if (this.balloonClientComboBox == null) {
            this.balloonClientComboBox = new JComboBox();
            this.balloonClientComboBox.setBounds(new Rectangle(131, 280, 204, 25));
            this.balloonClientComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingPane.this.showMessage("");
                    BalloonSettingPane.this.enableButtons();
                }
            });
        }
        return this.balloonClientComboBox;
    }

    private JButton getAdvancedMailButton() {
        if (this.advancedMailButton == null) {
            this.advancedMailButton = new JButton();
            this.advancedMailButton.setToolTipText("Advanced Mail Server Settings");
            this.advancedMailButton.setFont(new Font("Dialog", 1, 12));
            this.advancedMailButton.setBounds(new Rectangle(52, 151, 263, 25));
            this.advancedMailButton.setText("EMail Server Advanced Settings");
            this.advancedMailButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BalloonSettingPane.this.showMailPropertiesEditor();
                }
            });
        }
        return this.advancedMailButton;
    }

    protected void showMailPropertiesEditor() {
        if (this.propertiesEditFrame == null) {
            this.propertiesEditFrame = new PropertiesEditFrame();
        }
        this.propertiesEditFrame.setTitle("Edit Advanced Mail Properties");
        this.propertiesEditFrame.setProperties(this.changedMailProperties, new UpdateMailProperties());
        this.propertiesEditFrame.setSize(350, 315);
        this.propertiesEditFrame.setVisible(true);
    }

    private JPanel getWestPanel() {
        if (this.westPanel == null) {
            this.westPanel = new JPanel();
            this.westPanel.setLayout(null);
            this.westPanel.setPreferredSize(new Dimension(370, 341));
            this.westPanel.add((Component)this.siteLabel, null);
            this.westPanel.add((Component)this.getSiteComboBox(), null);
            this.westPanel.add((Component)this.getSendEmailNotificationsCheckBox(), null);
            this.westPanel.add((Component)this.mailContactLabel, null);
            this.westPanel.add((Component)this.getEmailContactTextBox(), null);
            this.westPanel.add((Component)this.jLabel, null);
            this.westPanel.add((Component)this.getEmailServerTextBox(), null);
            this.westPanel.add((Component)this.getAdvancedMailButton(), null);
            this.westPanel.add((Component)this.getPrintNotificationsCheckBox(), null);
            this.westPanel.add((Component)this.printDeviceLabel, null);
            this.westPanel.add((Component)this.getPrintDeviceTextBox(), null);
            this.westPanel.add((Component)this.getPostScriptEnabledCheckBox(), null);
            this.westPanel.add((Component)this.balloonClientLabel, null);
            this.westPanel.add((Component)this.getBalloonClientComboBox(), null);
        }
        return this.westPanel;
    }

    protected class UpdateMailProperties
    implements IPropertyUpdater {
        protected UpdateMailProperties() {
        }

        public void updateProperties(Properties properties) {
            BalloonSettingPane.this.changedMailProperties = properties;
            BalloonSettingPane.this.getEmailServerTextBox().setText(properties.getProperty("mail.host"));
            BalloonSettingPane.this.enableButtons();
        }
    }
}

