/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountNameComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientSettingsEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IClientSettingsListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.EditAutoJudgeSettingFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoJudgesPane
extends JPanePlugin {
    private static final long serialVersionUID = 36368747620026978L;
    private MCLB autoJudgeListBox = null;
    private JPanel buttonsPane = null;
    private JPanel statusPanel = null;
    private JLabel messageLabel = null;
    private JButton editButton = null;
    private EditAutoJudgeSettingFrame editAutoJudgeSettingFrame = new EditAutoJudgeSettingFrame();
    private Log log;
    private PermissionList permissionList = new PermissionList();

    public AutoJudgesPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(584, 211));
        this.add((Component)this.getButtonsPane(), "South");
        this.add((Component)((Object)this.getAutoJudgeListBox()), "Center");
    }

    @Override
    public String getPluginTitle() {
        return "Auto Judge List Panel";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.editAutoJudgeSettingFrame.setContestAndController(inContest, inController);
        this.getContest().addClientSettingsListener(new ClientSettingsListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AutoJudgesPane.this.updateGUIperPermissions();
                AutoJudgesPane.this.reloadAutoJudgeList();
            }
        });
        this.showMessage("");
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_AJ_SETTINGS));
    }

    protected void reloadAutoJudgeList() {
        this.getAutoJudgeListBox().removeAllRows();
        for (Account account : this.getContest().getAccounts(ClientType.Type.JUDGE)) {
            ClientSettings clientSettings = this.getContest().getClientSettings(account.getClientId());
            if (clientSettings != null) {
                this.updateAutoJudgeRow(clientSettings);
                continue;
            }
            this.updateAutoJudgeRow(account.getClientId());
        }
    }

    private MCLB getAutoJudgeListBox() {
        if (this.autoJudgeListBox == null) {
            this.autoJudgeListBox = new MCLB();
            this.autoJudgeListBox.add(this.getStatusPanel(), "North");
            Object[] cols = new Object[]{"Site", "Judge", "On", "Problems"};
            this.autoJudgeListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            HeapSorter accountNameSorter = new HeapSorter();
            accountNameSorter.setComparator((Comparator)new AccountNameComparatorMCLB());
            this.autoJudgeListBox.setColumnSorter(0, numericStringSorter, 1);
            this.autoJudgeListBox.setColumnSorter(1, accountNameSorter, 2);
            this.autoJudgeListBox.setColumnSorter(2, sorter, 3);
            this.autoJudgeListBox.setColumnSorter(3, sorter, 4);
            Object var1_1 = null;
        }
        return this.autoJudgeListBox;
    }

    private JPanel getButtonsPane() {
        if (this.buttonsPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonsPane = new JPanel();
            this.buttonsPane.setLayout(flowLayout);
            this.buttonsPane.add((Component)this.getEditButton(), null);
        }
        return this.buttonsPane;
    }

    protected void addAutoJudgeSetting() {
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.setPreferredSize(new Dimension(20, 20));
            this.statusPanel.add((Component)this.messageLabel, "Center");
        }
        return this.statusPanel;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AutoJudgesPane.this.messageLabel.setText(string);
                AutoJudgesPane.this.messageLabel.setToolTipText(string);
            }
        });
    }

    private void updateAutoJudgeRow(final ClientSettings clientSettings) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objects = AutoJudgesPane.this.buildAutoJudgeRow(clientSettings);
                int rowNumber = AutoJudgesPane.this.autoJudgeListBox.getIndexByKey(clientSettings.getClientId());
                if (rowNumber == -1) {
                    AutoJudgesPane.this.autoJudgeListBox.addRow(objects, clientSettings.getClientId());
                } else {
                    AutoJudgesPane.this.autoJudgeListBox.replaceRow(objects, rowNumber);
                }
                AutoJudgesPane.this.autoJudgeListBox.autoSizeAllColumns();
                AutoJudgesPane.this.autoJudgeListBox.sort();
            }
        });
    }

    private void updateAutoJudgeRow(ClientId clientId2) {
        ClientSettings clientSettings = new ClientSettings(clientId2);
        this.updateAutoJudgeRow(clientSettings);
    }

    private Object[] buildAutoJudgeRow(ClientSettings clientSettings) {
        try {
            int cols = this.autoJudgeListBox.getColumnCount();
            Object[] s = new String[cols];
            s[0] = new Integer(clientSettings.getClientId().getSiteNumber()).toString();
            s[1] = clientSettings.getClientId().getName();
            s[2] = Utilities.yesNoString(clientSettings.isAutoJudging());
            s[3] = this.getProblemlist(clientSettings.getAutoJudgeFilter());
            return s;
        }
        catch (Exception exception) {
            StaticLog.getLog().log(Log.INFO, "Exception in buildRunRow()", exception);
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private String getProblemlist(Filter filter) {
        ElementId[] elementIds = filter.getProblemIdList();
        Vector<String> problemNames = new Vector<String>();
        if (elementIds.length == 0) {
            return "(none selected)";
        }
        for (Problem problem : this.getContest().getProblems()) {
            for (ElementId elementId : elementIds) {
                if (!problem.getElementId().equals(elementId)) continue;
                problemNames.addElement(problem.getDisplayName());
            }
        }
        if (problemNames.size() == 0) {
            return "(none selected)";
        }
        if (problemNames.size() == 1) {
            return (String)problemNames.firstElement();
        }
        return this.joinString(", ", problemNames);
    }

    public String joinString(String delimiter, Vector<String> names) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        for (i = 0; i < names.size() - 1; ++i) {
            stringBuffer.append(names.elementAt(i));
            stringBuffer.append(", ");
        }
        stringBuffer.append(names.elementAt(i));
        return new String(stringBuffer);
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setToolTipText("Edit selected judges Auto Judge settings");
            this.editButton.setEnabled(true);
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AutoJudgesPane.this.editSelectedAutoJudgeRow();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedAutoJudgeRow() {
        int selectedIndex = this.autoJudgeListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a Judge to edit");
            return;
        }
        try {
            ClientId clientId = (ClientId)this.autoJudgeListBox.getKeys()[selectedIndex];
            ClientSettings clientSettings = this.getContest().getClientSettings(clientId);
            if (clientSettings == null) {
                clientSettings = new ClientSettings(clientId);
            }
            this.editAutoJudgeSettingFrame.setClientSetting(clientId, clientSettings);
            this.editAutoJudgeSettingFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit client settings, check log");
        }
    }

    public class ProblemListenerImplementation
    implements IProblemListener {
        public void problemAdded(ProblemEvent event) {
        }

        public void problemChanged(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AutoJudgesPane.this.reloadAutoJudgeList();
                }
            });
        }

        public void problemRemoved(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AutoJudgesPane.this.reloadAutoJudgeList();
                }
            });
        }

        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AutoJudgesPane.this.reloadAutoJudgeList();
                }
            });
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        protected boolean isJudge(ClientId clientId) {
            return clientId.getClientType() == ClientType.Type.JUDGE;
        }

        public void accountAdded(final AccountEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientId clientId = event.getAccount().getClientId();
                    if (AccountListenerImplementation.this.isJudge(clientId)) {
                        AutoJudgesPane.this.updateAutoJudgeRow(clientId);
                    }
                }
            });
        }

        public void accountModified(final AccountEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientId clientId = event.getAccount().getClientId();
                    if (AccountListenerImplementation.this.isJudge(clientId)) {
                        AutoJudgesPane.this.updateAutoJudgeRow(clientId);
                    }
                }
            });
            Account account = event.getAccount();
            if (AutoJudgesPane.this.getContest().getClientId().equals(account.getClientId())) {
                AutoJudgesPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AutoJudgesPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(final AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (Account account : accountEvent.getAccounts()) {
                        ClientId clientId = account.getClientId();
                        if (!AccountListenerImplementation.this.isJudge(clientId)) continue;
                        AutoJudgesPane.this.updateAutoJudgeRow(clientId);
                    }
                }
            });
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                final ClientId clientId = account.getClientId();
                if (this.isJudge(clientId)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AutoJudgesPane.this.updateAutoJudgeRow(clientId);
                        }
                    });
                }
                if (!AutoJudgesPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                AutoJudgesPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AutoJudgesPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            AutoJudgesPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AutoJudgesPane.this.updateGUIperPermissions();
                    AutoJudgesPane.this.reloadAutoJudgeList();
                }
            });
            AutoJudgesPane.this.showMessage("");
        }
    }

    public class ClientSettingsListenerImplementation
    implements IClientSettingsListener {
        public void clientSettingsAdded(ClientSettingsEvent event) {
            this.clientSettingsChanged(event);
        }

        protected boolean isJudge(ClientSettings clientSettings) {
            return clientSettings.getClientId().getClientType() == ClientType.Type.JUDGE;
        }

        public void clientSettingsChanged(final ClientSettingsEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientSettings clientSettings = event.getClientSettings();
                    if (ClientSettingsListenerImplementation.this.isJudge(clientSettings)) {
                        AutoJudgesPane.this.updateAutoJudgeRow(clientSettings);
                    }
                }
            });
        }

        public void clientSettingsRemoved(ClientSettingsEvent event) {
            this.clientSettingsChanged(event);
        }

        public void clientSettingsRefreshAll(ClientSettingsEvent clientSettingsEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AutoJudgesPane.this.updateGUIperPermissions();
                    AutoJudgesPane.this.reloadAutoJudgeList();
                }
            });
        }
    }

    protected class AccountNameComparatorMCLB
    implements Comparator {
        private static final long serialVersionUID = 109218643807182860L;
        private AccountNameComparator accountNameComparator = new AccountNameComparator();

        protected AccountNameComparatorMCLB() {
        }

        public int compare(Object arg0, Object arg1) {
            return this.accountNameComparator.compare((String)arg0, (String)arg1);
        }
    }
}

