/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.event.ListboxEvent;
import com.ibm.webrunner.j2mclb.event.ListboxListener;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AutoJudgeSettingsPane
extends JPanePlugin {
    private static final long serialVersionUID = -4704199226428040796L;
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JLabel titleLabel = null;
    private JPanel centerPanel = null;
    private ClientSettings clientSettings = null;
    private boolean populatingGUI = true;
    private JCheckBox enableAutoJudgingCheckBox = null;
    private MCLB problemListMCLB = null;

    public AutoJudgeSettingsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(449, 278));
        this.add((Component)this.getCenterPanel(), "Center");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
    }

    public String getPluginTitle() {
        return "Edit ClientSettings Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.titleLabel = new JLabel();
            this.titleLabel.setText("Problems available to Auto Judge");
            this.titleLabel.setFont(new Font("Dialog", 1, 16));
            this.titleLabel.setPreferredSize(new Dimension(255, 36));
            this.titleLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.titleLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(30);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AutoJudgeSettingsPane.this.addClientSettings();
                }
            });
        }
        return this.addButton;
    }

    protected void addClientSettings() {
        ClientSettings newClientSettings = null;
        try {
            newClientSettings = this.getClientSettingsFromFields(null);
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        this.getController().addNewClientSettings(newClientSettings);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private ClientSettings getClientSettingsFromFields(ClientSettings checkSettings) throws InvalidFieldValue {
        int[] selectedIndex;
        if (checkSettings == null) {
            checkSettings = new ClientSettings();
        }
        checkSettings.setAutoJudging(this.getEnableAutoJudgingCheckBox().isSelected());
        Filter filter = new Filter();
        for (int row : selectedIndex = this.getProblemListMCLB().getSelectedIndexes()) {
            Problem problem = (Problem)this.getProblemListMCLB().getRowKey(row);
            if (problem == null) continue;
            if (problem.isComputerJudged()) {
                filter.addProblem(problem);
                continue;
            }
            throw new InvalidFieldValue("Problem '" + problem.getDisplayName() + "' can not be auto judged\nOnly computer judged problems can be auto judged.");
        }
        checkSettings.setBalloonList(this.clientSettings.getBalloonList());
        checkSettings.setAutoJudgeFilter(filter);
        return checkSettings;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AutoJudgeSettingsPane.this.updateClientSettings();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateClientSettings() {
        ClientSettings newClientSettings = null;
        try {
            newClientSettings = this.getClientSettingsFromFields(this.clientSettings);
        }
        catch (InvalidFieldValue e) {
            this.showMessage(e.getMessage());
            return;
        }
        this.getController().updateClientSettings(newClientSettings);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AutoJudgeSettingsPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Auto Judge modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addClientSettings();
                } else {
                    this.updateClientSettings();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(0);
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(borderLayout);
            this.centerPanel.setName("advancedEdit");
            this.centerPanel.add((Component)this.getEnableAutoJudgingCheckBox(), "South");
            this.centerPanel.add((Component)((Object)this.getProblemListMCLB()), "Center");
        }
        return this.centerPanel;
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.clientSettings != null) {
            try {
                ClientSettings newClientSettings = this.getClientSettingsFromFields(null);
                enableButton |= !this.enableAutoJudgingCheckBox.isSelected() == this.clientSettings.isAutoJudging();
                enableButton |= !this.getProblemlist(newClientSettings.getAutoJudgeFilter()).equals(this.getProblemlist(this.clientSettings.getAutoJudgeFilter()));
            }
            catch (InvalidFieldValue e) {
                StaticLog.getLog().log(Log.DEBUG, "Input Problem (but not saving) ", e);
                enableButton = true;
            }
        } else if (this.getAddButton().isVisible()) {
            enableButton = true;
        }
        this.enableUpdateButtons(enableButton);
    }

    public ClientSettings getClientSettings() {
        return this.clientSettings;
    }

    public void setClientSettings(final ClientSettings clientSettings) {
        this.clientSettings = clientSettings;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AutoJudgeSettingsPane.this.getParentFrame().setTitle(clientSettings.getClientId() + " (Site " + clientSettings.getSiteNumber() + ") Auto Judge Settings");
                AutoJudgeSettingsPane.this.populateGUI(clientSettings);
                AutoJudgeSettingsPane.this.enableUpdateButtons(false);
            }
        });
    }

    private String getProblemlist(Filter filter) {
        ElementId[] elementIds = filter.getProblemIdList();
        if (elementIds.length == 0) {
            return "(none selected)";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Problem problem : this.getContest().getProblems()) {
            for (ElementId elementId : elementIds) {
                if (!problem.getElementId().equals(elementId)) continue;
                stringBuffer.append(problem.getDisplayName());
                stringBuffer.append(", ");
            }
        }
        if (stringBuffer.length() > 0) {
            return new String(stringBuffer).substring(0, stringBuffer.length() - 2);
        }
        return "(none active selected)";
    }

    private void populateGUI(ClientSettings clientSettings2) {
        this.populatingGUI = true;
        this.getEnableAutoJudgingCheckBox().setSelected(clientSettings2.isAutoJudging());
        Problem[] problems = this.getContest().getProblems();
        this.problemListMCLB.removeAllRows();
        Filter filter = clientSettings2.getAutoJudgeFilter();
        if (filter == null) {
            filter = new Filter();
        }
        int rowNumber = 0;
        for (Problem problem : problems) {
            if (!this.canBeAutoJudged(problem)) continue;
            Object[] row = this.buildProblemRow(problem);
            this.getProblemListMCLB().addRow(row, problem);
            if (filter.isFilteringProblems() && filter.matchesProblem(problem.getElementId())) {
                this.getProblemListMCLB().selectRow(rowNumber);
            }
            ++rowNumber;
        }
        this.getAddButton().setVisible(false);
        this.getUpdateButton().setVisible(true);
        this.getProblemListMCLB().autoSizeAllColumns();
        this.populatingGUI = false;
    }

    private boolean canBeAutoJudged(Problem problem) {
        return problem.isComputerJudged() && problem.isValidatedProblem();
    }

    public String getJudgingTypeName(Problem problem) {
        String judgingTypeName = "Manual";
        if (problem.isComputerJudged()) {
            judgingTypeName = "Computer";
            if (problem.isManualReview()) {
                judgingTypeName = "Computer+Manual";
                if (problem.isPrelimaryNotification()) {
                    judgingTypeName = "Computer+Manual/Notify";
                }
            }
        } else {
            judgingTypeName = problem.isValidatedProblem() ? "Manual w/Val." : "Manual";
        }
        return judgingTypeName;
    }

    private Object[] buildProblemRow(Problem problem) {
        int numberColumns = this.getProblemListMCLB().getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = problem.getDisplayName();
        c[1] = this.getJudgingTypeName(problem);
        return c;
    }

    protected void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        this.addButton.setEnabled(editedText);
        this.updateButton.setEnabled(editedText);
    }

    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private JCheckBox getEnableAutoJudgingCheckBox() {
        if (this.enableAutoJudgingCheckBox == null) {
            this.enableAutoJudgingCheckBox = new JCheckBox();
            this.enableAutoJudgingCheckBox.setText("Enable Auto Judging");
            this.enableAutoJudgingCheckBox.setPreferredSize(new Dimension(140, 30));
            this.enableAutoJudgingCheckBox.setFont(new Font("Dialog", 0, 14));
            this.enableAutoJudgingCheckBox.setHorizontalAlignment(0);
            this.enableAutoJudgingCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AutoJudgeSettingsPane.this.enableUpdateButton();
                }
            });
        }
        return this.enableAutoJudgingCheckBox;
    }

    private MCLB getProblemListMCLB() {
        if (this.problemListMCLB == null) {
            this.problemListMCLB = new MCLB();
            this.problemListMCLB.setMultipleSelections(true);
            this.problemListMCLB.addListboxListener(new ListboxListener(){

                public void rowDeselected(ListboxEvent e) {
                    AutoJudgeSettingsPane.this.enableUpdateButton();
                }

                public void rowSelected(ListboxEvent e) {
                    AutoJudgeSettingsPane.this.enableUpdateButton();
                }
            });
            Object[] cols = new Object[]{"Problem", "Judging Type"};
            this.problemListMCLB.addColumns(cols);
            this.problemListMCLB.autoSizeAllColumns();
        }
        return this.problemListMCLB;
    }
}

