/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.DisplayTeamName;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class AnswerClarificationPane
extends JPanePlugin {
    private static final long serialVersionUID = -4185051421490716684L;
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private Clarification clarification = null;
    private JTabbedPane mainTabbedPane = null;
    private JPanel generalPane = null;
    private Log log = null;
    private boolean populatingGUI = true;
    private PermissionList permissionList = new PermissionList();
    private JCheckBox sendToAllCheckBox = null;
    private JButton defaultAnswerButton = null;
    private JPanel infoPanel = null;
    private JLabel clarificationInfoLabel = null;
    private JPanel problemInfoPane = null;
    private JLabel problemTitleLabel = null;
    private JPanel clarificationPane = null;
    private JPanel questionPane = null;
    private JPanel answerPane = null;
    private JScrollPane answerScrollPane = null;
    private JScrollPane questionScrolPane = null;
    private JTextArea answerTextArea = null;
    private JTextArea questionTextArea = null;
    private JLabel problemNameLabel = null;
    private boolean fetchedFromServer = false;
    private DisplayTeamName displayTeamName = null;
    private String defaultAnswer;

    public AnswerClarificationPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(536, 269));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMainTabbedPane(), "East");
        this.add((Component)this.getGeneralPane(), "Center");
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.displayTeamName = new DisplayTeamName();
        this.displayTeamName.setContestAndController(inContest, inController);
        this.initializePermissions();
        this.updateGUIperPermissions();
    }

    public String getPluginTitle() {
        return "Edit Clarification Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getOkButton(), null);
            this.buttonPane.add((Component)this.getSendToAllCheckBox(), null);
            this.buttonPane.add((Component)this.getDefaultAnswerButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private Clarification getClarificationFromFields() {
        this.clarification.setAnswer(this.getAnswerTextArea().getText());
        this.clarification.setWhoJudgedItId(this.getContest().getClientId());
        this.clarification.setSendToAll(this.getSendToAllCheckBox().isSelected());
        return this.clarification;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Ok");
            this.okButton.setEnabled(false);
            this.okButton.setMnemonic(85);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnswerClarificationPane.this.updateClarification();
                }
            });
        }
        return this.okButton;
    }

    private void cancelClarification() {
        this.enableUpdateButtons(false);
        this.getController().cancelClarification(this.clarification);
    }

    protected void updateClarification() {
        Clarification newClarification = this.getClarificationFromFields();
        this.enableUpdateButtons(false);
        this.getController().submitClarificationAnswer(newClarification);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnswerClarificationPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    public void handleCancelButton() {
        if (this.getOkButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Clarification modified, save changes?", "Confirm Choice");
            if (result == 0) {
                this.updateClarification();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            }
            if (result == 1) {
                this.cancelClarification();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            }
        } else {
            if (this.fetchedFromServer) {
                this.cancelClarification();
            }
            if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        }
    }

    public Clarification getClarification() {
        return this.clarification;
    }

    public void setClarification(Clarification inClarification, boolean checkedOut) {
        ContestInformation contestInformation = this.getContest().getContestInformation();
        this.displayTeamName.setTeamDisplayMask(contestInformation.getTeamDisplayMode());
        this.clarification = inClarification;
        this.fetchedFromServer = checkedOut;
        if (checkedOut) {
            this.showMessage("");
            FrameUtilities.regularCursor(this);
        } else {
            this.showMessage("Waiting for clarification...");
            FrameUtilities.waitCursor(this);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnswerClarificationPane.this.populateGUI(AnswerClarificationPane.this.clarification);
                AnswerClarificationPane.this.enableUpdateButtons(false);
            }
        });
    }

    private void populateGUI(Clarification theClarification) {
        this.populatingGUI = true;
        if (theClarification != null) {
            this.getOkButton().setVisible(true);
            String teamName = this.getTeamDisplayName(theClarification.getSubmitter());
            this.clarificationInfoLabel.setText("Clarification " + theClarification.getNumber() + " (Site " + theClarification.getSiteNumber() + ") from " + teamName);
            this.problemNameLabel.setText(this.getContest().getProblem(this.clarification.getProblemId()).toString());
            this.getQuestionTextArea().setText(this.clarification.getQuestion());
        } else {
            this.getOkButton().setVisible(false);
            this.clarificationInfoLabel.setText("Could not get clarification");
            this.problemNameLabel.setText("");
        }
        this.getAnswerTextArea().setText("");
        this.getSendToAllCheckBox().setSelected(false);
        this.populatingGUI = false;
    }

    protected void regularCursor() {
        FrameUtilities.regularCursor(this);
    }

    protected void enableUpdateButtons(boolean editedText) {
        if (this.fetchedFromServer) {
            if (editedText) {
                this.cancelButton.setText("Cancel");
            } else {
                this.cancelButton.setText("Close");
            }
            this.okButton.setEnabled(editedText);
            this.defaultAnswerButton.setEnabled(true);
            this.getAnswerTextArea().setEnabled(true);
        } else {
            this.okButton.setEnabled(editedText);
            this.defaultAnswerButton.setEnabled(false);
            this.getAnswerTextArea().setEnabled(false);
        }
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.clarification != null) {
            enableButton |= this.answerTextArea.getText().trim().length() > 0;
        }
        this.enableUpdateButtons(enableButton);
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
        }
        return this.mainTabbedPane;
    }

    private JPanel getGeneralPane() {
        if (this.generalPane == null) {
            this.generalPane = new JPanel();
            this.generalPane.setLayout(new BorderLayout());
            this.generalPane.add((Component)this.getInfoPanel(), "North");
            this.generalPane.add((Component)this.getClarificationPane(), "Center");
        }
        return this.generalPane;
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnswerClarificationPane.this.messageLabel.setText(message);
            }
        });
    }

    private String getTeamDisplayName(ClientId clientId) {
        if (this.isJudge() && this.isTeam(clientId)) {
            return this.displayTeamName.getDisplayName(clientId);
        }
        return clientId.getName();
    }

    protected void extractClarification() {
        this.showMessage("Would have extracted clarification");
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private boolean isTeam(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.TEAM);
    }

    private boolean isJudge(ClientId clientId) {
        return clientId == null || clientId.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    private boolean isJudge() {
        return this.isJudge(this.getContest().getClientId());
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.okButton.setEnabled(this.isAllowed(Permission.Type.ANSWER_CLARIFICATION));
        this.defaultAnswerButton.setEnabled(this.isAllowed(Permission.Type.ANSWER_CLARIFICATION));
    }

    private JCheckBox getSendToAllCheckBox() {
        if (this.sendToAllCheckBox == null) {
            this.sendToAllCheckBox = new JCheckBox();
            this.sendToAllCheckBox.setText("Send to ALL teams");
            this.sendToAllCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnswerClarificationPane.this.enableUpdateButton();
                }
            });
        }
        return this.sendToAllCheckBox;
    }

    private JButton getDefaultAnswerButton() {
        if (this.defaultAnswerButton == null) {
            this.defaultAnswerButton = new JButton();
            this.defaultAnswerButton.setText("Default Answer");
            this.defaultAnswerButton.setToolTipText(this.getDefaultAnswerText());
            this.defaultAnswerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AnswerClarificationPane.this.answerTextArea.setText(AnswerClarificationPane.this.defaultAnswerButton.getToolTipText());
                    AnswerClarificationPane.this.updateClarification();
                }
            });
        }
        return this.defaultAnswerButton;
    }

    private String getDefaultAnswerText() {
        return this.defaultAnswer;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.clarificationInfoLabel = new JLabel();
            this.clarificationInfoLabel.setFont(new Font("Dialog", 1, 14));
            this.clarificationInfoLabel.setText("Clar Info");
            this.clarificationInfoLabel.setHorizontalAlignment(0);
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new BorderLayout());
            this.infoPanel.setPreferredSize(new Dimension(108, 60));
            this.infoPanel.add((Component)this.clarificationInfoLabel, "Center");
            this.infoPanel.add((Component)this.getProblemInfoPane(), "South");
        }
        return this.infoPanel;
    }

    private JPanel getProblemInfoPane() {
        if (this.problemInfoPane == null) {
            this.problemNameLabel = new JLabel();
            this.problemNameLabel.setText("");
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            gridLayout.setHgap(12);
            this.problemTitleLabel = new JLabel();
            this.problemTitleLabel.setText("Problem");
            this.problemTitleLabel.setHorizontalAlignment(4);
            this.problemInfoPane = new JPanel();
            this.problemInfoPane.setPreferredSize(new Dimension(108, 22));
            this.problemInfoPane.setLayout(gridLayout);
            this.problemInfoPane.add((Component)this.problemTitleLabel, null);
            this.problemInfoPane.add((Component)this.problemNameLabel, null);
        }
        return this.problemInfoPane;
    }

    private JPanel getClarificationPane() {
        if (this.clarificationPane == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(2);
            gridLayout1.setColumns(1);
            this.clarificationPane = new JPanel();
            this.clarificationPane.setLayout(gridLayout1);
            this.clarificationPane.add((Component)this.getQuestionPane(), null);
            this.clarificationPane.add((Component)this.getAnswerPane(), null);
        }
        return this.clarificationPane;
    }

    private JPanel getQuestionPane() {
        if (this.questionPane == null) {
            this.questionPane = new JPanel();
            this.questionPane.setLayout(new BorderLayout());
            this.questionPane.setBorder(BorderFactory.createTitledBorder(null, "Question", 0, 0, null, null));
            this.questionPane.add((Component)this.getQuestionScrolPane(), "Center");
        }
        return this.questionPane;
    }

    private JPanel getAnswerPane() {
        if (this.answerPane == null) {
            this.answerPane = new JPanel();
            this.answerPane.setLayout(new BorderLayout());
            this.answerPane.setBorder(BorderFactory.createTitledBorder(null, "Answer", 0, 0, null, null));
            this.answerPane.add((Component)this.getAnswerScrollPane(), "Center");
        }
        return this.answerPane;
    }

    private JScrollPane getAnswerScrollPane() {
        if (this.answerScrollPane == null) {
            this.answerScrollPane = new JScrollPane();
            this.answerScrollPane.setViewportView(this.getAnswerTextArea());
        }
        return this.answerScrollPane;
    }

    private JScrollPane getQuestionScrolPane() {
        if (this.questionScrolPane == null) {
            this.questionScrolPane = new JScrollPane();
            this.questionScrolPane.setViewportView(this.getQuestionTextArea());
        }
        return this.questionScrolPane;
    }

    private JTextArea getAnswerTextArea() {
        if (this.answerTextArea == null) {
            this.answerTextArea = new JTextArea();
            this.answerTextArea.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    AnswerClarificationPane.this.enableUpdateButton();
                }
            });
        }
        return this.answerTextArea;
    }

    private JTextArea getQuestionTextArea() {
        if (this.questionTextArea == null) {
            this.questionTextArea = new JTextArea();
            this.questionTextArea.setEditable(false);
        }
        return this.questionTextArea;
    }

    public void setDefaultAnswerText(String judgesDefaultAnswer) {
        this.defaultAnswer = judgesDefaultAnswer;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnswerClarificationPane.this.updateDefaultAnswerButton();
            }
        });
    }

    private void updateDefaultAnswerButton() {
        this.getDefaultAnswerButton().setToolTipText(this.defaultAnswer);
    }
}

