/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.imports.ExportAccounts;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.FilterReport;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.ui.EditAccountFrame;
import edu.csus.ecs.pc2.ui.EditFilterFrame;
import edu.csus.ecs.pc2.ui.EditFilterPane;
import edu.csus.ecs.pc2.ui.FileNameExtensionFilter;
import edu.csus.ecs.pc2.ui.GenerateAccountsFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.ReviewAccountLoadFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class AccountsPane
extends JPanePlugin {
    private static final String XML_DESCRIPTION = "XML document (*.xml)";
    private static final String CSV_DESCRIPTION = "CSV (comma delimited) (*.csv)";
    private static final String TEXT_DESCRIPTION = "Text (tab delimited) (*.txt,*.tab)";
    private static final long serialVersionUID = 2297963114219167947L;
    private MCLB accountListBox = null;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton editButton = null;
    private JButton filterButton = null;
    private JButton loadButton = null;
    private JPanel messagePanel = null;
    private JLabel messageLabel = null;
    private PermissionList permissionList = new PermissionList();
    private EditAccountFrame editAccountFrame = new EditAccountFrame();
    private GenerateAccountsFrame generateAccountsFrame = new GenerateAccountsFrame();
    private Log log;
    private String lastDir = ".";
    private ReviewAccountLoadFrame reviewAccountLoadFrame;
    private JButton generateAccountsButton = null;
    private JButton saveButton = null;
    private EditFilterFrame editFilterFrame = null;
    private Filter filter = new Filter();
    private String filterFrameTitle = "Account filter";

    public AccountsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(625, 216));
        this.add((Component)this.getMessagePanel(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)((Object)this.getRunsListBox()), "Center");
    }

    public String getPluginTitle() {
        return "Accounts Pane";
    }

    protected Object[] buildAccountRow(Account account) {
        try {
            int cols = this.accountListBox.getColumnCount();
            Object[] s = new String[cols];
            ClientId clientId = account.getClientId();
            s[0] = this.getSiteTitle("" + account.getSiteNumber());
            s[1] = clientId.getClientType().toString().toLowerCase();
            s[2] = "" + clientId.getClientNumber();
            s[3] = this.getTeamDisplayName(account);
            s[4] = this.getGroupName(account);
            s[5] = this.getTeamAlias(account);
            return s;
        }
        catch (Exception exception) {
            StaticLog.getLog().log(Log.INFO, "Exception in buildAccountRow()", exception);
            return null;
        }
    }

    private String getGroupName(Account account) {
        Group group;
        String groupName = "";
        if (account.getGroupId() != null && (group = this.getContest().getGroup(account.getGroupId())) != null) {
            groupName = group.getDisplayName();
        }
        return groupName;
    }

    private String getSiteTitle(String string) {
        return "Site " + string;
    }

    private String getTeamDisplayName(Account account) {
        if (account != null) {
            return account.getDisplayName();
        }
        return "Invalid Account";
    }

    private String getTeamAlias(Account account) {
        String alias;
        if (account != null && (alias = account.getAliasName()) != null) {
            return alias;
        }
        return "";
    }

    private MCLB getRunsListBox() {
        if (this.accountListBox == null) {
            this.accountListBox = new MCLB();
            Object[] cols = new Object[]{"Site", "Type", "Account Id", "Display Name", "Group", "Alias"};
            this.accountListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            this.accountListBox.setColumnSorter(0, sorter, 3);
            this.accountListBox.setColumnSorter(1, sorter, 2);
            this.accountListBox.setColumnSorter(2, numericStringSorter, 1);
            this.accountListBox.setColumnSorter(3, sorter, 4);
            this.accountListBox.setColumnSorter(4, sorter, 5);
            this.accountListBox.setColumnSorter(5, sorter, 6);
            cols = null;
            this.accountListBox.autoSizeAllColumns();
        }
        return this.accountListBox;
    }

    public void updateAccountRow(Account account) {
        this.updateAccountRow(account, true);
    }

    public void updateAccountRow(final Account account, final boolean autoSizeAndSort) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objects = AccountsPane.this.buildAccountRow(account);
                int rowNumber = AccountsPane.this.accountListBox.getIndexByKey(account.getClientId());
                if (rowNumber == -1) {
                    AccountsPane.this.accountListBox.addRow(objects, account.getClientId());
                } else {
                    AccountsPane.this.accountListBox.replaceRow(objects, rowNumber);
                }
                if (autoSizeAndSort) {
                    AccountsPane.this.accountListBox.autoSizeAllColumns();
                    AccountsPane.this.accountListBox.sort();
                }
            }
        });
    }

    private Account[] getAllAccounts() {
        Vector<Account> allAccounts = new Vector<Account>();
        for (ClientType.Type ctype : ClientType.Type.values()) {
            if (this.getContest().getAccounts(ctype).size() <= 0) continue;
            Vector<Account> accounts = this.getContest().getAccounts(ctype);
            allAccounts.addAll(accounts);
        }
        Account[] accountList = allAccounts.toArray(new Account[allAccounts.size()]);
        return accountList;
    }

    public void reloadAccountList() {
        Account[] accounts;
        this.getRunsListBox().removeAllRows();
        for (Account account : accounts = this.getAllAccounts()) {
            if (!this.filter.isFilterOn()) {
                this.updateAccountRow(account, false);
                continue;
            }
            if (!this.filter.matches(account)) continue;
            this.updateAccountRow(account, false);
        }
        if (this.filter.isFilterOn()) {
            this.getFilterButton().setForeground(Color.BLUE);
            this.getFilterButton().setToolTipText("Edit filter - filter ON");
        } else {
            this.getFilterButton().setForeground(Color.BLACK);
            this.getFilterButton().setToolTipText("Edit filter");
        }
        this.getRunsListBox().autoSizeAllColumns();
        this.getRunsListBox().sort();
    }

    protected void dumpFilter(Filter filter2) {
        try {
            System.out.println("dumpFilter " + filter2);
            System.out.flush();
            FilterReport filterReport = new FilterReport();
            filterReport.setContestAndController(this.getContest(), this.getController());
            PrintWriter printWriter = new PrintWriter(System.out);
            filterReport.writeReportDetailed(printWriter, filter2);
            printWriter.flush();
            printWriter = null;
            System.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isAllowed(Permission.Type type) {
        return this.permissionList.isAllowed(type);
    }

    private void initializePermissions() {
        this.permissionList.clearAndLoadPermissions(this.getPermissionList());
    }

    private void updateGUIperPermissions() {
        this.addButton.setVisible(this.isAllowed(Permission.Type.ADD_ACCOUNT));
        this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
        this.loadButton.setVisible(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
        this.saveButton.setVisible(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
        this.generateAccountsButton.setVisible(this.isAllowed(Permission.Type.ADD_ACCOUNT));
        this.getFilterButton().setVisible(true);
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.initializePermissions();
        this.editAccountFrame.setContestAndController(inContest, inController);
        this.generateAccountsFrame.setContestAndController(inContest, inController);
        this.getEditFilterFrame().setContestAndController(inContest, inController);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AccountsPane.this.reloadAccountList();
                AccountsPane.this.updateGUIperPermissions();
            }
        });
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPane = new JPanel();
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getGenerateAccountsButton(), null);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getEditButton(), null);
            this.buttonPane.add((Component)this.getFilterButton(), null);
            this.buttonPane.add((Component)this.getLoadButton(), null);
            this.buttonPane.add((Component)this.getSaveButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.setEnabled(true);
            this.addButton.setToolTipText("Add new account");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountsPane.this.addAccount();
                }
            });
        }
        return this.addButton;
    }

    protected void addAccount() {
        this.editAccountFrame.setAccount(null);
        this.editAccountFrame.setVisible(true);
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setMnemonic(69);
            this.editButton.setToolTipText("Edit account");
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountsPane.this.editSelectedAccount();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedAccount() {
        int selectedIndex = this.accountListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select an account to edit");
            return;
        }
        try {
            ClientId clientId = (ClientId)this.accountListBox.getKeys()[selectedIndex];
            Account accountToEdit = this.getContest().getAccount(clientId);
            this.editAccountFrame.setAccount(accountToEdit);
            this.editAccountFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit account, check log");
        }
    }

    private JButton getFilterButton() {
        if (this.filterButton == null) {
            this.filterButton = new JButton();
            this.filterButton.setText("Filter");
            this.filterButton.setMnemonic(70);
            this.filterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountsPane.this.showFilterAccountsFrame();
                }
            });
        }
        return this.filterButton;
    }

    public EditFilterFrame getEditFilterFrame() {
        if (this.editFilterFrame == null) {
            Runnable callback = new Runnable(){

                public void run() {
                    AccountsPane.this.reloadAccountList();
                }
            };
            this.editFilterFrame = new EditFilterFrame(this.filter, this.filterFrameTitle, callback);
        }
        return this.editFilterFrame;
    }

    protected void showFilterAccountsFrame() {
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.SITES);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.CLIENT_TYPES);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.ALL_ACCOUNTS);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.PERMISSIONS);
        this.getEditFilterFrame().setFilter(this.filter);
        this.getEditFilterFrame().validate();
        this.getEditFilterFrame().setVisible(true);
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("Load");
            this.loadButton.setMnemonic(76);
            this.loadButton.setToolTipText("Load Account Information from file");
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountsPane.this.loadAccountsFromDisk();
                }
            });
        }
        return this.loadButton;
    }

    protected void loadAccountsFromDisk() {
        JFileChooser chooser = new JFileChooser(this.lastDir);
        chooser.setDialogTitle("Open tab-separated accounts file");
        this.showMessage("");
        int returnVal = chooser.showOpenDialog(this);
        String msg = "";
        if (returnVal == 0) {
            this.lastDir = chooser.getCurrentDirectory().toString();
            try {
                File selectedFile = chooser.getSelectedFile().getCanonicalFile();
                if (selectedFile.exists()) {
                    if (selectedFile.isFile()) {
                        if (selectedFile.canRead()) {
                            this.getReviewAccountLoadFrame().setFile(selectedFile.toString());
                            this.getReviewAccountLoadFrame().setVisible(true);
                        } else {
                            msg = "File is not readable (" + selectedFile.toString() + ")";
                            this.log.log(Log.WARNING, msg);
                            this.showMessage(msg, Color.RED);
                        }
                    } else {
                        msg = "Selected file is not a file (" + selectedFile.toString() + ")";
                        this.log.log(Log.WARNING, msg);
                        this.showMessage(msg, Color.RED);
                    }
                } else {
                    msg = "File does not exist (" + selectedFile.toString() + ")";
                    this.log.log(Log.WARNING, msg);
                    this.showMessage(msg, Color.RED);
                }
            }
            catch (IOException e) {
                msg = "Trouble retrieving selected file (" + chooser.getSelectedFile().toString() + ") " + e.toString();
                this.log.log(Log.WARNING, msg, e);
                this.showMessage(msg, Color.RED);
            }
        }
    }

    private ReviewAccountLoadFrame getReviewAccountLoadFrame() {
        if (this.reviewAccountLoadFrame == null) {
            this.reviewAccountLoadFrame = new ReviewAccountLoadFrame();
            this.reviewAccountLoadFrame.setContestAndController(this.getContest(), this.getController());
        }
        return this.reviewAccountLoadFrame;
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.setText("");
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BorderLayout());
            this.messagePanel.setPreferredSize(new Dimension(25, 25));
            this.messagePanel.add((Component)this.messageLabel, "Center");
        }
        return this.messagePanel;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AccountsPane.this.messageLabel.setText(string);
            }
        });
    }

    private void showMessage(final String string, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AccountsPane.this.messageLabel.setText(string);
                AccountsPane.this.messageLabel.setForeground(color);
            }
        });
    }

    private void sortRunsListBox() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AccountsPane.this.getRunsListBox().autoSizeAllColumns();
                AccountsPane.this.getRunsListBox().sort();
            }
        });
    }

    private JButton getGenerateAccountsButton() {
        if (this.generateAccountsButton == null) {
            this.generateAccountsButton = new JButton();
            this.generateAccountsButton.setText("Generate");
            this.generateAccountsButton.setMnemonic(71);
            this.generateAccountsButton.setToolTipText("Generate multiple new accounts");
            this.generateAccountsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountsPane.this.generateAccountsFrame.setVisible(true);
                }
            });
        }
        return this.generateAccountsButton;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setToolTipText("Save Account Information to file");
            this.saveButton.setText("Save");
            this.saveButton.setMnemonic(83);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AccountsPane.this.saveAccountsToDisk();
                }
            });
        }
        return this.saveButton;
    }

    protected void saveAccountsToDisk() {
        JFileChooser chooser = new JFileChooser(this.lastDir);
        chooser.setDialogTitle("Save accounts to file");
        FileNameExtensionFilter filterTAB = new FileNameExtensionFilter(TEXT_DESCRIPTION, "txt", "tab");
        chooser.addChoosableFileFilter(filterTAB);
        FileNameExtensionFilter filterCSV = new FileNameExtensionFilter(CSV_DESCRIPTION, "csv");
        chooser.addChoosableFileFilter(filterCSV);
        FileNameExtensionFilter filterXML = new FileNameExtensionFilter(XML_DESCRIPTION, "xml");
        chooser.addChoosableFileFilter(filterXML);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filterTAB);
        FileFilter selectedFilter = null;
        while (true) {
            this.showMessage("");
            int returnVal = chooser.showSaveDialog(this);
            String msg = "";
            if (returnVal != 0) break;
            this.lastDir = chooser.getCurrentDirectory().toString();
            try {
                int confirmValue;
                File selectedFile = chooser.getSelectedFile().getCanonicalFile();
                chooser.setCurrentDirectory(new File(this.lastDir));
                selectedFilter = chooser.getFileFilter();
                chooser.setFileFilter(selectedFilter);
                Vector<Account> v = this.getContest().getAccounts(ClientType.Type.ALL);
                Object[] a = new Account[v.size()];
                v.copyInto(a);
                int indexOfDot = selectedFile.getName().lastIndexOf(46);
                String ext = "";
                if (indexOfDot > 0 && (ext = selectedFile.getName().substring(indexOfDot + 1)).equalsIgnoreCase(".tab")) {
                    ext = "txt";
                }
                String ext2 = ".na";
                String description = selectedFilter.getDescription();
                if (description.equals(TEXT_DESCRIPTION)) {
                    ext2 = "txt";
                } else if (description.equals(CSV_DESCRIPTION)) {
                    ext2 = "csv";
                } else if (description.equals(XML_DESCRIPTION)) {
                    ext2 = "xml";
                }
                if (!ext.equals(ext2)) {
                    int indexOfParen = description.lastIndexOf(40);
                    String descShort = description.substring(0, indexOfParen - 1);
                    msg = "You selected the file type '" + descShort + "' but the file you selected ends with " + ext + "\n\nContinue to save as a " + descShort + "?";
                    int confirmValue2 = JOptionPane.showConfirmDialog(this, msg);
                    if (confirmValue2 == 1) continue;
                    if (confirmValue2 == 2) break;
                }
                if (selectedFile.exists() && (confirmValue = JOptionPane.showConfirmDialog(this, msg = "The file " + selectedFile.getName() + " already exists. Do You want to replace " + "the existing file?", "File already exists", 0)) == 1) continue;
                ExportAccounts.Formats format = ExportAccounts.Formats.valueOf(ext2.toUpperCase());
                if (ExportAccounts.saveAccounts(format, (Account[])a, this.getContest().getGroups(), selectedFile)) break;
                Exception saveException = ExportAccounts.getException();
                this.log.throwing("ExportAccounts", "saveAccounts()", saveException);
                this.showMessage("Error saving file " + saveException.getMessage() + ", check log for details");
            }
            catch (Exception e) {
                this.log.throwing("AcountsPane", "saveAccountsToDisk()", e);
                this.showMessage("Error: " + e.getMessage() + ", check log for details");
                continue;
            }
            break;
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        public void accountAdded(AccountEvent accountEvent) {
            AccountsPane.this.updateAccountRow(accountEvent.getAccount());
        }

        public void accountModified(AccountEvent accountEvent) {
            AccountsPane.this.updateAccountRow(accountEvent.getAccount());
            Account account = accountEvent.getAccount();
            if (AccountsPane.this.getContest().getClientId().equals(account.getClientId())) {
                AccountsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AccountsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        public void accountsAdded(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                AccountsPane.this.updateAccountRow(account, false);
            }
            AccountsPane.this.sortRunsListBox();
        }

        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            for (Account account : accounts = accountEvent.getAccounts()) {
                AccountsPane.this.updateAccountRow(account, false);
                if (!AccountsPane.this.getContest().getClientId().equals(account.getClientId())) continue;
                AccountsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AccountsPane.this.updateGUIperPermissions();
                    }
                });
            }
            AccountsPane.this.sortRunsListBox();
        }

        public void accountsRefreshAll(AccountEvent accountEvent) {
            AccountsPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AccountsPane.this.reloadAccountList();
                    AccountsPane.this.updateGUIperPermissions();
                }
            });
        }
    }
}

