/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.plugin;

import edu.csus.ecs.pc2.core.Plugin;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.report.BalloonSummaryReport;
import edu.csus.ecs.pc2.core.report.ClarificationsReport;
import edu.csus.ecs.pc2.core.report.ContestAnalysisReport;
import edu.csus.ecs.pc2.core.report.ContestReport;
import edu.csus.ecs.pc2.core.report.ContestSettingsReport;
import edu.csus.ecs.pc2.core.report.EvaluationReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedSummaryReport;
import edu.csus.ecs.pc2.core.report.HTMLReport;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.LanguagesReport;
import edu.csus.ecs.pc2.core.report.ListRunLanguages;
import edu.csus.ecs.pc2.core.report.OldRunsReport;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.core.report.RunsByTeamReport;
import edu.csus.ecs.pc2.core.report.RunsReport;
import edu.csus.ecs.pc2.core.report.SolutionsByProblemReport;
import edu.csus.ecs.pc2.core.report.StandingsReport;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class ContestSummaryReports
extends Plugin {
    private static final long serialVersionUID = -3201034876635916394L;
    private IReport[] listOfReports = null;
    private String reportDirectory = null;
    private Filter filter = new Filter();
    public static final String BEFORE_END_ELAPSED_TIME_MINS = "minsbeforeend";

    public ContestSummaryReports() {
        this.loadDefaultReport();
        this.addProperty(BEFORE_END_ELAPSED_TIME_MINS, new Integer(30));
    }

    private void loadDefaultReport() {
        Vector<IReport> reports = new Vector<IReport>();
        reports.add(new FastestSolvedSummaryReport());
        reports.add(new FastestSolvedReport());
        reports.add(new BalloonSummaryReport());
        reports.add(new ContestReport());
        reports.add(new ContestAnalysisReport());
        reports.add(new SolutionsByProblemReport());
        reports.add(new RunsByTeamReport());
        reports.add(new ListRunLanguages());
        reports.add(new StandingsReport());
        reports.add(new RunsReport());
        reports.add(new ClarificationsReport());
        reports.add(new ProblemsReport());
        reports.add(new LanguagesReport());
        reports.add(new HTMLReport());
        reports.add(new EvaluationReport());
        reports.add(new OldRunsReport());
        reports.add(new ContestSettingsReport());
        this.listOfReports = reports.toArray(new IReport[reports.size()]);
    }

    public String getPluginTitle() {
        return "Save Contest Reports";
    }

    public void dispose() {
    }

    public static String getFileName(IReport selectedReport) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String reportName = selectedReport.getReportTitle();
        while (reportName.indexOf(32) > -1) {
            reportName = reportName.replace(" ", "_");
        }
        return "report." + reportName + "." + simpleDateFormat.format(new Date()) + ".txt";
    }

    public void generateReports() {
        File reportDirectoryFile = new File(this.getReportDirectory());
        reportDirectoryFile.mkdirs();
        for (IReport report : this.listOfReports) {
            String filename = ContestSummaryReports.getFileName(report);
            try {
                report.setContestAndController(this.getContest(), this.getController());
                filename = reportDirectoryFile.getCanonicalPath() + File.separator + filename;
                report.createReportFile(filename, this.filter);
            }
            catch (IOException e) {
                this.logException("Exception printing report to " + filename, e);
            }
        }
    }

    private void logException(String string, Exception e) {
        if (this.getController().getLog() == null) {
            System.err.println(string);
            e.printStackTrace(System.err);
        } else {
            this.getController().getLog().log(Log.WARNING, string, e);
        }
    }

    public String getReportDirectory() {
        if (this.reportDirectory != null) {
            if (new File(this.reportDirectory).isDirectory()) {
                return this.reportDirectory;
            }
            return this.getContest().getProfile().getProfilePath() + File.separator + this.reportDirectory;
        }
        return this.getContest().getProfile().getProfilePath() + File.separator + "reports";
    }

    public void setReportList(IReport[] reports) {
        this.listOfReports = reports;
    }

    public IReport[] getReportList() {
        return this.listOfReports;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean isLateInContest() {
        Integer minutes = (Integer)this.getPluginProperties().get(BEFORE_END_ELAPSED_TIME_MINS);
        long remainingSecs = this.getContest().getContestTime().getRemainingSecs();
        return remainingSecs / 60L < (long)(minutes * 60);
    }
}

