/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import edu.csus.ecs.pc2.core.util.IMemento;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLMemento
implements IMemento {
    private Document factory;
    private Element element;

    private XMLMemento(Document doc, Element el) {
        this.factory = doc;
        this.element = el;
    }

    @Override
    public IMemento createChild(String type) {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    @Override
    public IMemento createChildNode(String type, String value) {
        Element child = this.factory.createElement(type);
        child.appendChild(this.factory.createTextNode(value));
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    @Override
    public IMemento createChild(String type, String id) {
        Element child = this.factory.createElement(type);
        child.setAttribute("IMemento.internal.id", id);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static XMLMemento createReadRoot(InputStream in) {
        int errors = 0;
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            document = parser.parse(new InputSource(in));
            Node node = document.getFirstChild();
            if (node instanceof Element) {
                XMLMemento xMLMemento = new XMLMemento(document, (Element)node);
                return xMLMemento;
            }
        }
        catch (Exception e) {
            ++errors;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                ++errors;
            }
        }
        return null;
    }

    public static XMLMemento createWriteRoot(String type) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    @Override
    public IMemento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        for (int nX = 0; nX < size; ++nX) {
            Element element2;
            Node node = nodes.item(nX);
            if (!(node instanceof Element) || !(element2 = (Element)node).getNodeName().equals(type)) continue;
            return new XMLMemento(this.factory, element2);
        }
        return null;
    }

    @Override
    public IMemento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        for (int nX = 0; nX < size; ++nX) {
            Element element2;
            Node node = nodes.item(nX);
            if (!(node instanceof Element) || !(element2 = (Element)node).getNodeName().equals(type)) continue;
            list.add(element2);
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        for (int x = 0; x < size; ++x) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
        }
        return results;
    }

    public byte[] getContents() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.save(out);
        return out.toByteArray();
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.save(out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public Float getFloat(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Float(strValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getId() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    @Override
    public String getName() {
        return this.element.getNodeName();
    }

    @Override
    public Integer getInteger(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Integer(strValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Long getLong(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Long(strValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Override
    public List<String> getNames() {
        NamedNodeMap map = this.element.getAttributes();
        int size = map.getLength();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            Node node = map.item(i);
            String name = node.getNodeName();
            list.add(name);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMemento loadMemento(String filename) throws IOException {
        int errors = 0;
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(filename));
            XMLMemento xMLMemento = XMLMemento.createReadRoot(in);
            return xMLMemento;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                ++errors;
            }
        }
    }

    private void putElement(Element element2) {
        NamedNodeMap nodeMap = element2.getAttributes();
        int size = nodeMap.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)nodeMap.item(i);
            this.putString(attr.getName(), attr.getValue());
        }
        NodeList nodes = element2.getChildNodes();
        size = nodes.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            XMLMemento child = (XMLMemento)this.createChild(node.getNodeName());
            child.putElement((Element)node);
        }
    }

    @Override
    public void putFloat(String key, float f) {
        this.element.setAttribute(key, String.valueOf(f));
    }

    @Override
    public void putInteger(String key, int n) {
        this.element.setAttribute(key, String.valueOf(n));
    }

    @Override
    public void putLong(String key, long n) {
        this.element.setAttribute(key, Long.toString(n));
    }

    @Override
    public void putMemento(IMemento memento) {
        XMLMemento xmlMemento = (XMLMemento)memento;
        this.putElement(xmlMemento.element);
    }

    @Override
    public void putString(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    public void save(OutputStream os) throws IOException {
        this.save(os, false);
    }

    public void save(OutputStream os, boolean omitXMLDeclaration) throws IOException {
        StreamResult result = new StreamResult(os);
        DOMSource source = new DOMSource(this.factory);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            String yesNoValue = "no";
            if (omitXMLDeclaration) {
                yesNoValue = "yes";
            }
            transformer.setOutputProperty("omit-xml-declaration", yesNoValue);
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public String saveToString(boolean omitXMLDeclaration) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.save(outputStream, omitXMLDeclaration);
        return outputStream.toString();
    }

    public String saveToString() throws IOException {
        return this.saveToString(false);
    }

    public void saveToFile(String filename) throws IOException {
        int errors = 0;
        FileOutputStream w = null;
        try {
            w = new FileOutputStream(filename);
            this.save(w);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception e) {
                    ++errors;
                }
            }
        }
    }

    @Override
    public Boolean getBoolean(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        if ("true".equalsIgnoreCase(strValue)) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.element.setAttribute(key, Boolean.toString(value));
    }

    @Override
    public String getValue() {
        NodeList list = this.element.getChildNodes();
        Node node = list.item(0);
        return node.getNodeValue();
    }
}

