/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import java.util.Vector;

public final class TabSeparatedValueParser {
    private static final char TAB_CHAR = '\t';
    private static final String TAB_STRING = String.valueOf('\t');

    public static String[] parseLine(String line) throws Exception {
        int i;
        String[] array = new String[]{""};
        int field = 1;
        String currentField = "";
        Vector<String> v = new Vector<String>();
        boolean inQuote = false;
        int length = line.length();
        int ignoredTerminatingQuote = 0;
        for (i = 0; i < line.length(); ++i) {
            char current = line.charAt(i);
            if (current == '\"') {
                if (inQuote) {
                    if (i + 1 >= length) {
                        ++ignoredTerminatingQuote;
                        continue;
                    }
                    char next = line.charAt(i + 1);
                    if (next == '\t') {
                        inQuote = false;
                        continue;
                    }
                    if (next == '\"') {
                        currentField = currentField.concat("\"");
                        ++i;
                        continue;
                    }
                    new Exception("found unexpected quote at position " + i + ", but next character '" + String.valueOf(next) + "'");
                    continue;
                }
                inQuote = true;
                continue;
            }
            if (current == '\t') {
                if (inQuote) {
                    currentField = currentField.concat(TAB_STRING);
                    continue;
                }
                v.addElement(currentField);
                ++field;
                currentField = "";
                continue;
            }
            currentField = currentField.concat(new Character(current).toString());
        }
        v.addElement(currentField);
        array = new String[field];
        if (field != v.size()) {
            new Exception("Incorrect number of fields (found " + field + ", but expected " + v.size() + ")");
        }
        for (i = 0; i < v.size(); ++i) {
            Object o = v.elementAt(i);
            array[i] = o != null ? (String)o : "";
        }
        return array;
    }

    public static String toString(String[] array) {
        String s = "";
        for (int i = 0; i < array.length; ++i) {
            String newField = "";
            int start = 0;
            boolean needsQuote = false;
            String field = array[i];
            if (field.indexOf("\"") > -1) {
                needsQuote = true;
                while (field.indexOf("\"", start) > -1) {
                    newField = newField.concat(field.substring(start, field.indexOf("\"", start) + 1) + "\"");
                    start = field.indexOf("\"", start) + 1;
                }
                field = newField + field.substring(start);
            }
            s = field.indexOf(String.valueOf(TAB_STRING)) > -1 || needsQuote ? s.concat("\"" + field + "\",") : s.concat(field + TAB_STRING);
        }
        s = s.substring(0, s.length() - 1);
        return s;
    }

    private TabSeparatedValueParser() {
    }
}

