/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Balloon;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Problem;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class BalloonWriter {
    private Object printingLock = new Object();
    private Log log;
    private static final String NL = System.getProperty("line.separator");
    private String contestTitle = "";

    public BalloonWriter(Log aLog) {
        this.log = aLog;
    }

    private String buildBalloonMessage(Balloon balloon, boolean postscript) {
        String answer = balloon.getAnswer();
        BalloonSettings balloonSettings = balloon.getBalloonSettings();
        StringBuffer message = new StringBuffer("");
        int x = 72;
        int y = 720;
        if (postscript) {
            message.append("%!" + NL + NL);
            message.append("/Time-Roman findfont 18 scalefont setfont" + NL);
        }
        if (answer.equalsIgnoreCase("revoke") || answer.equalsIgnoreCase("take")) {
            message.append(this.print("There has been a change in judgement.", postscript, x, y));
            message.append(NL);
            message.append(this.print("Please ensure " + balloon.getClientId().getName() + " (" + balloon.getClientTitle() + ")", postscript, x, y -= 20));
            message.append(NL);
            message.append(this.print("does not have a " + balloonSettings.getColor(balloon.getProblemId()) + " colored balloon.", postscript, x, y -= 20));
            message.append(NL + NL + NL);
            y -= 60;
        }
        if (!answer.equalsIgnoreCase("test")) {
            y = this.buildBalloonMessageRunInfo(message, balloon, postscript, y);
        }
        y = this.buildBalloonMessageSummary(message, balloon, postscript, y - 20);
        if (postscript) {
            message.append(NL + "showpage" + NL);
        }
        return message.toString();
    }

    private int buildBalloonMessageRunInfo(StringBuffer message, Balloon balloon, boolean postscript, int y) {
        String status = balloon.getAnswer();
        BalloonSettings balloonSettings = balloon.getBalloonSettings();
        try {
            int x = 72;
            if (postscript) {
                message.append("/Time-Roman findfont 18 scalefont setfont" + NL);
            }
            String yesOrNo = "";
            yesOrNo = status.equalsIgnoreCase("yes") ? "YES" : "NO";
            message.append(this.print(yesOrNo + " for " + balloon.getClientId().getName(), postscript, x, y));
            message.append(NL);
            y -= 20;
            if (status.equalsIgnoreCase("yes")) {
                message.append(this.print("Color: " + this.getColor(balloonSettings, balloon.getProblemId()), postscript, x, y));
                message.append(NL);
                y -= 20;
            }
            message.append(this.print("Team: " + balloon.getClientId().getName() + " (" + balloon.getClientTitle() + ")", postscript, x, y));
            message.append(NL);
            message.append(this.print("Site: " + balloon.getClientId().getSiteNumber() + " - " + balloon.getSiteTitle(), postscript, x, y -= 20));
            message.append(NL);
            message.append(this.print("Problem: " + balloon.getProblemTitle(), postscript, x, y -= 20));
            message.append(NL);
            y -= 20;
            if (balloon.getRun() != null) {
                message.append(this.print("Time: " + balloon.getRun().getElapsedMins(), postscript, x, y));
                message.append(NL);
                message.append(this.print("RunID: " + balloon.getRun().getNumber(), postscript, x, y -= 20));
                message.append(NL);
                y -= 20;
            }
            if (this.contestTitle.trim().length() > 0) {
                message.append(this.print("Contest Title: " + this.contestTitle.trim(), postscript, x, y));
                message.append(NL);
                y -= 20;
            }
            message.append(this.print("Current Date: " + new Date().toString(), postscript, x, y));
            message.append(NL);
            y -= 40;
        }
        catch (Exception e) {
            this.log.throwing(this.getClass().getName(), "buildBaloonMesageRunInfo for " + balloon.getRun().getNumber() + " error.", e);
        }
        return y;
    }

    private int buildBalloonMessageSummary(StringBuffer message, Balloon balloon, boolean postscript, int y) {
        String status = balloon.getAnswer();
        BalloonSettings balloonSettings = balloon.getBalloonSettings();
        try {
            int x = 72;
            if (postscript) {
                message.append("/Time-Roman findfont 14 scalefont setfont" + NL);
            }
            StringWriter sw = new StringWriter();
            if (status.equalsIgnoreCase("test")) {
                message.append(this.print("List of balloon colors:", postscript, x, y));
                message.append(NL);
                Problem[] problems = balloon.getProblems();
                for (int j = 0; j < problems.length; ++j) {
                    sw.write(NL);
                    sw.write(this.print("    " + this.getColor(balloonSettings, problems[j]) + " - " + problems[j].getDisplayName(), postscript, x, y -= 32));
                    sw.write(NL);
                }
                message.append(sw.toString());
            } else {
                int count = 0;
                int saveY = y;
                Problem[] problems = balloon.getProblems();
                for (int j = 0; j < problems.length; ++j) {
                    sw.write(NL);
                    sw.write(this.print("    " + this.getColor(balloonSettings, problems[j]) + " - " + problems[j].getDisplayName(), postscript, x, y -= 32));
                    sw.write(NL);
                    ++count;
                }
                if (count == 1) {
                    message.append(NL + NL + NL);
                    message.append(this.print("Team now has " + count + " balloon:", postscript, x, saveY));
                    message.append(NL + sw.toString());
                } else if (count > 1) {
                    message.append(NL + NL + NL);
                    message.append(this.print("Team now has " + count + " balloons:", postscript, x, saveY));
                    message.append(NL + sw.toString());
                } else {
                    message.append(NL + NL + NL);
                    message.append(this.print("This team now has 0 (zero) balloons.", postscript, x, saveY));
                    message.append(NL);
                }
                sw.close();
                sw = null;
            }
        }
        catch (Exception e) {
            this.log.throwing(this.getClass().getName(), "buildBaloonMesageSummary for " + balloon.getRun() + " error collecting list of balloons", e);
        }
        return y;
    }

    private String getColor(BalloonSettings balloonSettings, Problem problem) {
        return this.getColor(balloonSettings, problem.getElementId());
    }

    String getColor(BalloonSettings balloonSettings, ElementId problemId) {
        String color = balloonSettings.getColor(problemId);
        if (color == null || color.trim().equals("")) {
            color = "<undefined>";
        }
        return color;
    }

    private String print(String message, boolean postscript, int x, int y) {
        if (message == null) {
            return null;
        }
        if (postscript) {
            StringWriter psString = new StringWriter(message.length() + 30);
            psString.write(x + " " + y + " moveto" + NL + "(");
            try {
                block6: for (int i = 0; i < message.length(); ++i) {
                    char ch = message.charAt(i);
                    switch (ch) {
                        case '(': {
                            psString.write("\\(");
                            continue block6;
                        }
                        case ')': {
                            psString.write("\\)");
                            continue block6;
                        }
                        default: {
                            psString.write(ch);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.throwing(this.getClass().getName(), "Unable to postscript quote(" + message + ")", e);
                return message;
            }
            psString.write(") show");
            return psString.toString();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBalloon(Balloon balloon) {
        boolean sentBalloon = false;
        BalloonSettings balloonSettings = balloon.getBalloonSettings();
        try {
            this.log.entering(this.getClass().getName(), "sendBalloon", balloon.getAnswer());
            if (balloon.getContestTitle() != null) {
                this.contestTitle = balloon.getContestTitle();
            }
            String message = this.buildBalloonMessage(balloon, false);
            String answer = balloon.getAnswer();
            if (balloonSettings.isEmailBalloons()) {
                if (balloonSettings.getEmailContact() != null && balloonSettings.getEmailContact().trim().length() > 0) {
                    if (balloonSettings.getMailServer() != null && balloonSettings.getMailServer().trim().length() > 0) {
                        String subject = answer.equalsIgnoreCase("yes") ? "YES " + balloon.getClientId().getName() + " (" + balloon.getClientTitle() + ") color " + balloonSettings.getColor(balloon.getProblemId()) : (answer.equalsIgnoreCase("no") ? "NO " + balloon.getClientId().getName() + " (" + balloon.getClientTitle() + ")" + " problem " + balloon.getProblemId() : (answer.equalsIgnoreCase("test") ? "List of Balloon Colors" : "Take away balloon from " + balloon.getClientId().getName() + " color " + balloonSettings.getColor(balloon.getProblemId())));
                        this.sendBalloonByEmail(balloonSettings, subject, message);
                    } else {
                        this.log.info("emailing enabled, but no mailServer set '" + balloonSettings.getMailServer() + "'");
                    }
                } else {
                    this.log.info("emailing enabled, but no emailContest set");
                }
            }
            if (balloonSettings.isPrintBalloons()) {
                if (balloonSettings.getPrintDevice() != null && balloonSettings.getPrintDevice().trim().length() > 0) {
                    if (balloonSettings.isPostscriptCapable()) {
                        message = this.buildBalloonMessage(balloon, true);
                    } else {
                        int lines = 66;
                        if (balloonSettings.getLinesPerPage() > 0) {
                            lines = balloonSettings.getLinesPerPage();
                        }
                        int index = message.indexOf(NL, 0);
                        int count = 0;
                        while (index != -1) {
                            ++count;
                            index = message.indexOf(NL, index + 1);
                        }
                        if (count < lines) {
                            StringWriter sw = new StringWriter(66);
                            for (int i = count; i < lines; ++i) {
                                sw.write(NL);
                            }
                            message = message + sw.toString();
                            sw.close();
                            sw = null;
                        }
                    }
                    if (this.sendBalloonToLocalFile(message, balloonSettings.getPrintDevice().trim())) {
                        sentBalloon = true;
                    }
                } else {
                    this.log.info("printing enabled, but no printDevice set");
                }
            }
            message = null;
        }
        catch (Exception e) {
            this.log.throwing(this.getClass().getName(), "sendBalloon()", e);
        }
        finally {
            if (this.log == null) {
                System.err.println("Log is null");
            }
            if (this.getClass() == null) {
                System.err.println("getClass is null");
            }
            this.log.exiting(this.getClass().getName(), "sendBalloon()", sentBalloon);
        }
        return sentBalloon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBalloonByEmail(BalloonSettings balloonSettings, String subject, String message) {
        boolean success = false;
        try {
            String mailTo = balloonSettings.getEmailContact();
            this.log.entering(this.getClass().getName(), "sendBalloonByEmail() " + mailTo);
            Properties props = balloonSettings.getMailProperties();
            String host = (String)props.get("mail.host");
            String user = (String)props.get("mail.user");
            String passwd = (String)props.get("mail.user.password");
            String method = (String)props.get("mail.transport.protocol");
            String from = (String)props.get(BalloonSettings.MAIL_FROM);
            StringBuffer fromName = new StringBuffer("Balloons");
            if (this.contestTitle.trim().length() > 0) {
                fromName.append(" - " + this.contestTitle.trim());
            }
            InternetAddress fromAddress = new InternetAddress(from, fromName.toString());
            int port = -1;
            try {
                port = Integer.parseInt((String)props.get("mail." + method + ".port"));
            }
            catch (Exception e) {
                this.log.info("Invalid method " + method);
                this.log.throwing("BalloonWriter", "sendBalloonByEmail()", e);
                port = -1;
                props.put("mail.transport.protocol", "");
            }
            Session session = Session.getInstance((Properties)props, null);
            Transport tr = session.getTransport(method);
            tr.addTransportListener((TransportListener)new BalloonTransportListener());
            tr.connect(host, port, user, passwd);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)fromAddress);
            msg.setRecipients(Message.RecipientType.TO, mailTo);
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            msg.addHeader("X-PC2-Version", new VersionInfo().getVersionNumber());
            msg.setText(message);
            msg.saveChanges();
            tr.sendMessage((Message)msg, msg.getAllRecipients());
            tr.close();
            success = true;
        }
        catch (Exception e) {
            this.log.throwing(this.getClass().getName(), "sendBallonBalloonByEmail()", e);
        }
        finally {
            this.log.exiting(this.getClass().getName(), "sendBalloonByEmail()", success);
        }
        return success;
    }

    String[] spliRecipients(String mailTo) {
        String[] results = null;
        if (mailTo != null) {
            int comma = mailTo.indexOf(44);
            if (comma == -1) {
                results = new String[]{mailTo.trim()};
            } else {
                StringTokenizer st = new StringTokenizer(mailTo, ",");
                results = new String[st.countTokens()];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = st.nextToken().trim();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBalloonToLocalFile(String message, String fileName) {
        boolean success = false;
        try {
            this.log.entering(this.getClass().getName(), "sendBalloonToLocalFile", fileName);
            this.log.finest("Obtaining lock to print");
            Object object = this.printingLock;
            synchronized (object) {
                FileOutputStream fout = new FileOutputStream(fileName);
                this.log.finest("Printing");
                PrintWriter pout = new PrintWriter(fout, true);
                pout.print(message);
                pout.close();
            }
            this.log.finest("Printing done, lock released");
            success = true;
        }
        catch (Exception e) {
            this.log.throwing(this.getClass().getName(), "sendBallonBalloonToLocalFile()", e);
        }
        finally {
            this.log.exiting(this.getClass().getName(), "sendBalloontoLocalFile", success);
        }
        return success;
    }

    String printAddressArray(Address[] addresses) {
        String result = "";
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + addresses[i].toString();
            }
        }
        return result;
    }

    String printSubject(Message message, String method) {
        String subject = "unknown";
        if (message != null) {
            try {
                subject = message.getSubject();
            }
            catch (MessagingException e) {
                this.log.throwing("BalloonTransportListener", method, e);
            }
        }
        return subject;
    }

    public class BalloonTransportListener
    implements TransportListener {
        public void messageDelivered(TransportEvent arg0) {
            String subject = BalloonWriter.this.printSubject(arg0.getMessage(), "messageDelivered");
            String sent = BalloonWriter.this.printAddressArray(arg0.getValidSentAddresses());
            BalloonWriter.this.log.info("Balloon " + subject + " delivered to " + sent);
        }

        public void messageNotDelivered(TransportEvent arg0) {
            String subject = BalloonWriter.this.printSubject(arg0.getMessage(), "messageNotDelivered");
            String unSent = BalloonWriter.this.printAddressArray(arg0.getValidUnsentAddresses());
            String invalid = BalloonWriter.this.printAddressArray(arg0.getInvalidAddresses());
            this.logErrors(subject, unSent, invalid);
        }

        public void messagePartiallyDelivered(TransportEvent arg0) {
            String subject = BalloonWriter.this.printSubject(arg0.getMessage(), "messagePartiallyDelivered");
            String sent = BalloonWriter.this.printAddressArray(arg0.getValidSentAddresses());
            String unSent = BalloonWriter.this.printAddressArray(arg0.getValidUnsentAddresses());
            String invalid = BalloonWriter.this.printAddressArray(arg0.getInvalidAddresses());
            if (sent.length() > 0) {
                BalloonWriter.this.log.info("Balloon " + subject + " partially delivered to " + sent);
            }
            this.logErrors(subject, unSent, invalid);
        }

        private void logErrors(String subject, String unSent, String invalid) {
            if (unSent.length() > 0) {
                BalloonWriter.this.log.warning("Balloon " + subject + " trouble with " + invalid + " also NOT delivered to " + unSent);
            } else {
                BalloonWriter.this.log.warning("Balloon " + subject + " trouble with " + invalid);
            }
        }
    }
}

