/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.transport.connection;

import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.core.transport.IBtoA;
import edu.csus.ecs.pc2.core.transport.ITransportManager;
import edu.csus.ecs.pc2.core.transport.ITwoToOne;
import edu.csus.ecs.pc2.core.transport.TransportException;
import edu.csus.ecs.pc2.core.transport.TransportManager;
import edu.csus.ecs.pc2.core.transport.connection.ConnectionManagerEvent;
import edu.csus.ecs.pc2.core.transport.connection.IConnectionManagerListener;
import java.io.Serializable;
import java.util.Vector;

public class ConnectionManager
implements ITransportManager {
    public static final String DEFAULT_PC2_PORT = "50002";
    private TransportManager transportManager = null;
    private Log cmLog = null;
    private Vector<IConnectionManagerListener> connectionListenerList = new Vector();

    public ConnectionManager(Log log) {
        this.cmLog = log;
        this.transportManager = new TransportManager(this.cmLog);
    }

    private void fireConnectionListener(ConnectionManagerEvent connectionManagerEvent) {
        block7: for (int i = 0; i < this.connectionListenerList.size(); ++i) {
            switch (connectionManagerEvent.getAction()) {
                case CONNECTED: {
                    this.connectionListenerList.elementAt(i).connectionEstablished(connectionManagerEvent);
                    continue block7;
                }
                case DISCONNECTED: {
                    this.connectionListenerList.elementAt(i).connectionDropped(connectionManagerEvent);
                    continue block7;
                }
                case RECIEVED_OBJECT: {
                    this.connectionListenerList.elementAt(i).receivedObject(connectionManagerEvent);
                    continue block7;
                }
                case FAILED: {
                    this.connectionListenerList.elementAt(i).connectionFailed(connectionManagerEvent);
                    continue block7;
                }
                case TIMED_OUT: {
                    this.connectionListenerList.elementAt(i).connectionTimedOut(connectionManagerEvent);
                    continue block7;
                }
                default: {
                    this.connectionListenerList.elementAt(i).connectionChanged(connectionManagerEvent);
                }
            }
        }
    }

    public void addConnectionListener(IConnectionManagerListener listener) {
        this.connectionListenerList.addElement(listener);
    }

    public void removeConnectionListener(IConnectionManagerListener listener) {
        this.connectionListenerList.removeElement(listener);
    }

    public void establishConnection(ConnectionHandlerID connectionHandlerID) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.CONNECTED, connectionHandlerID);
        this.fireConnectionListener(connectionManagerEvent);
    }

    public void connectionDropped(ConnectionHandlerID connectionHandlerID) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.DISCONNECTED, connectionHandlerID);
        this.fireConnectionListener(connectionManagerEvent);
    }

    public void connectionTimedOut(ConnectionHandlerID connectionHandlerID) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.DISCONNECTED, connectionHandlerID);
        this.fireConnectionListener(connectionManagerEvent);
    }

    public void connectionFailed(ConnectionHandlerID connectionHandlerID) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.FAILED, connectionHandlerID);
        this.fireConnectionListener(connectionManagerEvent);
    }

    public void receivedObject(ConnectionHandlerID connectionHandlerID, Serializable serializableObject) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.RECIEVED_OBJECT, connectionHandlerID, serializableObject);
        this.fireConnectionListener(connectionManagerEvent);
    }

    public void connectToMyServer() throws TransportException {
        this.transportManager.connectToMyServer();
    }

    public void send(Serializable msgObj) throws TransportException {
        this.transportManager.send(msgObj);
    }

    public ConnectionHandlerID connectToServer(String serverIP, int port) throws TransportException {
        return this.transportManager.connectToServer(serverIP, port);
    }

    public void startClientTransport(String serverIP, int port, IBtoA appCallBack) {
        this.transportManager.startClientTransport(serverIP, port, appCallBack);
    }

    public void shutdownTransport() {
        this.transportManager.shutdownTransport();
    }

    public void setLog(Log log) {
        this.cmLog = log;
        this.transportManager.setLog(log);
    }

    public void accecptConnections(int listeningPort) throws TransportException {
        this.transportManager.accecptConnections(listeningPort);
    }

    public void send(Serializable msgObj, ConnectionHandlerID connectionHandlerID) throws TransportException {
        this.transportManager.send(msgObj, connectionHandlerID);
    }

    public void unregisterConnection(ConnectionHandlerID myConnectionID) {
        this.transportManager.unregisterConnection(myConnectionID);
    }

    public void startServerTransport(ITwoToOne appCallBack) {
        this.transportManager.startServerTransport(appCallBack);
    }
}

