/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.transport;

import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.transport.ConnectionHandler;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerThread;
import edu.csus.ecs.pc2.core.transport.TransportException;
import edu.csus.ecs.pc2.core.transport.TransportManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.crypto.SealedObject;

public class ConnectionHandlerClientThread
extends ConnectionHandlerThread {
    public static final String SVN_ID = "$Id: ConnectionHandlerClientThread.java 2093 2010-06-25 17:31:54Z laned $";
    private TransportManager.tmTypes tmType = null;

    public ConnectionHandlerClientThread(Socket socket, TransportManager tmCallBack, ConnectionHandler chCallBack, TransportManager.tmTypes incomingTmType, Log log) {
        super(socket, tmCallBack, chCallBack);
        chCallBack.setConnectionHandlerClientThread(this);
        this.setTmType(incomingTmType);
        this.setLog(log);
    }

    public void run() {
        try {
            this.setToOtherModule(new ObjectOutputStream(this.getMySocket().getOutputStream()));
            InputStream iss = this.getMySocket().getInputStream();
            this.setFromOtherModule(new ObjectInputStream(iss));
            if (this.getTmType() == TransportManager.tmTypes.SERVER) {
                this.getTmCallBack().registerIncomingConnectionRequest(this.getMyConnectionID(), this);
            }
            this.getTmCallBack().receiveUnencrypted(this.receiveUnencrypted(), this.getMyConnectionID());
            this.sendUnencrypted(this.getTmCallBack().getPublicKeyPacket());
            this.getMyConnectionID().setReadyToCommunicate(true);
            this.setStillListening(true);
            while (this.isStillListening()) {
                SealedObject sealedObject = null;
                try {
                    sealedObject = this.receive();
                    this.getTmCallBack().receive(sealedObject, this.getMyConnectionID());
                }
                catch (TransportException e) {
                    this.getLog().throwing(this.getClass().getName(), "run", e);
                    if (e.getMessage() == null) {
                        this.getLog().throwing(this.getClass().getName(), "run - e.getmessage is null()", e);
                        this.setStillListening(false);
                        continue;
                    }
                    if (!e.getMessage().equalsIgnoreCase("connection reset")) continue;
                    this.setStillListening(false);
                }
            }
        }
        catch (SocketException e) {
            this.getLog().info("Lost connection to this client!");
        }
        catch (TransportException e) {
            this.getLog().throwing(this.getClass().getName(), "run", e);
        }
        catch (IOException e) {
            this.getLog().throwing(this.getClass().getName(), "run", e);
        }
        this.getTmCallBack().connectionDropped(this.getMyConnectionID());
    }

    private TransportManager.tmTypes getTmType() {
        return this.tmType;
    }

    private void setTmType(TransportManager.tmTypes tmType) {
        this.tmType = tmType;
    }
}

