/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.security;

import edu.csus.ecs.pc2.core.security.Permission;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;

public class PermissionList
implements Serializable {
    private static final long serialVersionUID = -4160597559679295578L;
    private Hashtable<Permission.Type, Date> hash = new Hashtable();

    public void addPermission(Permission.Type type) {
        this.hash.put(type, new Date());
    }

    public Date getWhenPermissionAdded(Permission.Type type) {
        if (this.hash.containsKey((Object)type)) {
            return this.hash.get((Object)type);
        }
        return null;
    }

    public void removePermission(Permission.Type type) {
        if (this.hash.containsKey((Object)type)) {
            this.hash.remove((Object)type);
        }
    }

    public boolean isAllowed(Permission.Type type) {
        return this.hash.containsKey((Object)type);
    }

    public void clearAndLoadPermissions(PermissionList permissionList) {
        this.hash = new Hashtable();
        for (Permission.Type type : Permission.Type.values()) {
            if (!permissionList.isAllowed(type)) continue;
            this.addPermission(type);
        }
    }

    public Permission.Type[] getList() {
        return this.hash.keySet().toArray(new Permission.Type[this.hash.keySet().size()]);
    }

    public boolean isSameAs(PermissionList permissionList) {
        if (permissionList.hash.size() != this.hash.size()) {
            return false;
        }
        for (Permission.Type type : Permission.Type.values()) {
            if (this.isAllowed(type) == permissionList.isAllowed(type)) continue;
            return false;
        }
        return true;
    }
}

